/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.datagraph;

import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wmm.datatype.AttributeSearchConditions;
import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.websphere.wmm.datatype.PageControl;
import com.ibm.websphere.wmm.datatype.SearchCondition;
import com.ibm.websphere.wmm.datatype.SearchCriteria;
import com.ibm.websphere.wmm.datatype.SortControl;
import com.ibm.websphere.wmm.datatype.StringIterator;
import com.ibm.websphere.wmm.datatype.StringSet;
import com.ibm.ws.wim.bridge.adapter.WMM2WIMBridgeAdapter;
import com.ibm.ws.wim.bridge.assembler.DataGraphAssembler;
import commonj.sdo.DataObject;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchDataGraphAssembler
extends DataGraphAssembler {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = SearchDataGraphAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private short constructMode = (short)-1;
    private MemberIdentifier mbrId = null;
    private String recursionAttrName = null;
    private StringSet returnAttrNames = null;
    private int maxListSize;
    private short memberType;
    private SearchCriteria searchCriteria;
    private int timeOut;
    private int maxResult;
    private SortControl sortControl = null;
    private PageControl pageControl = null;
    private String accountName = null;
    private String realmName = null;

    public static SearchDataGraphAssembler getInstance(short s, short s2, SearchCriteria searchCriteria, SortControl sortControl, PageControl pageControl, StringSet stringSet, int n, int n2) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(mode,type,criteria,sctrl,pctrl,attrs,timeout,maxresult)");
        }
        SearchDataGraphAssembler searchDataGraphAssembler = new SearchDataGraphAssembler();
        searchDataGraphAssembler.initialization();
        if (s == 27) {
            searchDataGraphAssembler.constructMode = (short)27;
            searchDataGraphAssembler.memberType = s2;
            searchDataGraphAssembler.searchCriteria = searchCriteria;
            searchDataGraphAssembler.returnAttrNames = stringSet;
            searchDataGraphAssembler.timeOut = n;
            searchDataGraphAssembler.maxResult = n2;
            searchDataGraphAssembler.sortControl = sortControl;
            searchDataGraphAssembler.pageControl = pageControl;
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(mode,type,criteria,sctrl,pctrl,attrs,timeout,maxresult)");
        }
        return searchDataGraphAssembler;
    }

    public static SearchDataGraphAssembler getInstance(short s, String string, String string2, StringSet stringSet) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance (mode, accountName, realmName, attributeNames)");
        }
        SearchDataGraphAssembler searchDataGraphAssembler = new SearchDataGraphAssembler();
        if (s != 17) {
            String string3 = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, "getInstance (mode, accountName, realmName, attributeNames)");
        }
        searchDataGraphAssembler.constructMode = (short)17;
        searchDataGraphAssembler.initialization();
        searchDataGraphAssembler.accountName = string;
        searchDataGraphAssembler.returnAttrNames = stringSet;
        searchDataGraphAssembler.realmName = string2;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance (mode, accountName, realmName, attributeNames)");
        }
        return searchDataGraphAssembler;
    }

    public static SearchDataGraphAssembler getInstance(short s, PageControl pageControl) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(mode,pageCtrl)");
        }
        SearchDataGraphAssembler searchDataGraphAssembler = new SearchDataGraphAssembler();
        searchDataGraphAssembler.initialization();
        if (s == 28) {
            searchDataGraphAssembler.constructMode = (short)28;
            searchDataGraphAssembler.pageControl = pageControl;
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(mode,pageCtrl)");
        }
        return searchDataGraphAssembler;
    }

    public static SearchDataGraphAssembler getInstance(short s, MemberIdentifier memberIdentifier, String string, StringSet stringSet, int n) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(memberId, recursionAttrName, returnAttrNames, maxListSize)");
        }
        SearchDataGraphAssembler searchDataGraphAssembler = new SearchDataGraphAssembler();
        searchDataGraphAssembler.initialization();
        if (s == 16) {
            searchDataGraphAssembler.constructMode = (short)16;
            searchDataGraphAssembler.mbrId = memberIdentifier;
            searchDataGraphAssembler.recursionAttrName = string;
            searchDataGraphAssembler.returnAttrNames = stringSet;
            searchDataGraphAssembler.maxListSize = n;
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(memberId, recursionAttrName, returnAttrNames, maxListSize)");
        }
        return searchDataGraphAssembler;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assemble()");
        }
        switch (this.constructMode) {
            case 16: {
                this.getMembersRecusively(this.mbrId, this.recursionAttrName, this.returnAttrNames, this.maxListSize);
                break;
            }
            case 27: {
                this.search(this.memberType, this.searchCriteria, this.sortControl, this.pageControl, this.returnAttrNames, this.timeOut, this.maxResult);
                break;
            }
            case 28: {
                this.searchAgain(this.pageControl);
                break;
            }
            case 17: {
                this.getPersonByAccountName();
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "assemble()");
        }
        return this.result;
    }

    private void getPersonByAccountName() {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getPersonByAccountName");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        this.addRealmContext(dataObject, this.realmName);
        this.addSearchControlForPrincipalName(dataObject, this.accountName, this.returnAttrNames);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getPersonByAccountName");
        }
    }

    private void searchAgain(PageControl pageControl) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "searchAgain(pCtrl)");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        if (pageControl != null) {
            this.addPageControl(dataObject, pageControl);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "searchAgain(pCtrl)");
        }
    }

    private void search(short s, SearchCriteria searchCriteria, SortControl sortControl, PageControl pageControl, StringSet stringSet, int n, int n2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "search(memberType, searchCriteria, sCtrl, pCtrl, returnAttrNames, timeOut, maxResult)");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
        dataObject2.setInt("timeLimit", n);
        dataObject2.setInt("countLimit", n2);
        this.addEntityTypesFilter(dataObject2, new short[]{s});
        if (stringSet == null) {
            dataObject2.getList("properties").add("*");
            dataObject2.getList("properties").add("createTimestamp");
            dataObject2.getList("properties").add("modifyTimestamp");
        } else {
            StringIterator stringIterator = stringSet.iterator();
            while (stringIterator.hasNext()) {
                String string = stringIterator.next();
                dataObject2.getList("properties").add(WMM2WIMBridgeAdapter.singleton().getWIMPropName(string));
            }
        }
        this.applySearchCriteria(dataObject2, searchCriteria);
        if (sortControl != null) {
            this.addSortControl(dataObject, sortControl);
        }
        if (pageControl != null) {
            this.addPageControl(dataObject, pageControl);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "search(memberType, searchCriteria, sCtrl, pCtrl, returnAttrNames, timeOut, maxResult)");
        }
    }

    private void addPageControl(DataObject dataObject, PageControl pageControl) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addPageControl(root, ctrl)");
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PageControl");
        int n = pageControl.getPageSize();
        byte[] byArray = pageControl.getCookie();
        dataObject2.setInt("size", n);
        if (byArray != null) {
            dataObject2.setBytes("cookie", byArray);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addPageControl(root, ctrl)");
        }
    }

    private void applySearchCriteria(DataObject dataObject, SearchCriteria searchCriteria) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "applySearchCriteria(sCtrl,searchCriteria)");
        }
        if (dataObject != null && searchCriteria != null) {
            Object object;
            String string;
            Object object2;
            StringSet stringSet = searchCriteria.getSearchBases();
            if (stringSet != null) {
                object2 = stringSet.iterator();
                while (object2.hasNext()) {
                    string = object2.next();
                    dataObject.getList("searchBases").add(string);
                    trcLogger.logp(Level.FINER, CLASSNAME, "applySearchCriteria(sCtrl,searchCriteria)", "add search base [" + string + "]");
                }
            }
            object2 = searchCriteria.getSearchAttributes();
            string = null;
            if (object2 != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    String string2 = object.next();
                    String string3 = WMM2WIMBridgeAdapter.singleton().getWIMPropName(string2);
                    AttributeSearchConditions attributeSearchConditions = searchCriteria.getAttributeSearchConditions(string2);
                    String string4 = this.generateAttrSearchExp(string3, attributeSearchConditions);
                    if (string == null) {
                        string = string4;
                        continue;
                    }
                    string = string + " and " + string4;
                }
                if (string != null) {
                    string = "( " + string + " )";
                }
            }
            object = dataObject.getString("expression");
            string = (String)object + " and " + string;
            dataObject.setString("expression", string);
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "applySearchCriteria(sCtrl,searchCriteria)", "set search expression [" + string + "]");
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "applySearchCriteria(sCtrl,searchCriteria)");
        }
    }

    private String generateAttrSearchExp(String string, AttributeSearchConditions attributeSearchConditions) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "generateAttrSearchExp(attrName,asCond)");
        }
        String string2 = null;
        if (attributeSearchConditions.size() == 1) {
            Object object = attributeSearchConditions.removeLastElement();
            if (!(object instanceof SearchCondition)) {
                throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("1 element left in the stack, but it is not SearchCondition. "), CLASSNAME, "generateAttrSearchExp(attrName,asCond)");
            }
            string2 = "(" + string + this.getSearchConditionExp((SearchCondition)object) + ")";
        } else {
            Object object = attributeSearchConditions.removeLastElement();
            if (!(object instanceof Short)) {
                throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("logic operator expected. [ " + attributeSearchConditions + "]"), CLASSNAME, "generateAttrSearchExp(attrName,asCond)");
            }
            Object object2 = attributeSearchConditions.removeLastElement();
            if (object2 instanceof Short) {
                throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("search condition expected. [ " + attributeSearchConditions + "]"), CLASSNAME, "generateAttrSearchExp(attrName,asCond)");
            }
            String string3 = "(" + string + this.getSearchConditionExp((SearchCondition)object2) + ")";
            string2 = attributeSearchConditions.size() >= 1 ? (((Short)object).shortValue() == AttributeSearchConditions.OPERATOR_AND.shortValue() ? string3 + " and " + this.generateAttrSearchExp(string, attributeSearchConditions) : string3 + " or " + this.generateAttrSearchExp(string, attributeSearchConditions)) : string3;
        }
        if (string2 != null) {
            string2 = "(" + string2 + ")";
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "generateAttrSearchExp(attrName,asCond)", string2);
        }
        return string2;
    }

    private boolean containAdditionalBracket(String string) {
        boolean bl = false;
        if (string != null && string.startsWith("((") && string.endsWith("))")) {
            bl = true;
        }
        return bl;
    }

    private String getSearchConditionExp(SearchCondition searchCondition) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getSearchConditionExp(condition)");
        }
        String string = null;
        short s = searchCondition.getComparisonOperator();
        string = this.getOperator(s);
        Object object = searchCondition.getValue();
        if (object != null) {
            if (object instanceof String) {
                string = string + "'" + object + "'";
            } else if (object instanceof Timestamp) {
                string = string + "'" + WMM2WIMBridgeAdapter.singleton().getPropertyValue("DateTime", object) + "'";
            } else if (object instanceof MemberIdentifier) {
                MemberIdentifier memberIdentifier = (MemberIdentifier)object;
                String string2 = memberIdentifier.getMemberDN();
                if (string2 == null) {
                    throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("provide the memberDN in the MemberIdentifier object of the attribute. "), CLASSNAME, "getSearchConditionExp(condition)");
                }
                string = string + "'" + string2 + "'";
            } else {
                string = string + object;
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getSearchConditionExp(condition)", string);
        }
        return string;
    }

    private String getOperator(short s) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getOperator(operator)", "" + s);
        }
        String string = null;
        switch (s) {
            case 0: {
                string = "=";
                break;
            }
            case 4: {
                string = ">=";
                break;
            }
            case 2: {
                string = ">";
                break;
            }
            case 5: {
                string = "<=";
                break;
            }
            case 6: {
                string = "=";
                break;
            }
            case 3: {
                string = "<";
                break;
            }
            case 1: {
                string = "<>";
                break;
            }
            case 7: {
                string = " is not null ";
                break;
            }
            default: {
                throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("invalid operator [" + s + "]"), CLASSNAME, "getOperator(operator)");
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getOperator(operator)", string);
        }
        return string;
    }

    private void getMembersRecusively(MemberIdentifier memberIdentifier, String string, StringSet stringSet, int n) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getMembersRecusively(mbrId, recursionAttrName, returnAttrNames, maxListSize)");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getMembersRecusively(mbrId, recursionAttrName, returnAttrNames, maxListSize)");
        }
    }
}

