/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.datagraph;

import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wmm.datatype.Member;
import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.websphere.wmm.datatype.MemberIdentifierIterator;
import com.ibm.websphere.wmm.datatype.MemberIdentifierSet;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.bridge.adapter.WMM2WIMBridgeAdapter;
import com.ibm.ws.wim.bridge.assembler.DataGraphAssembler;
import com.ibm.ws.wim.bridge.util.EntityTypeResolver;
import commonj.sdo.DataObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateDataGraphAssembler
extends DataGraphAssembler {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = UpdateDataGraphAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private short constructMode = (short)-1;
    private MemberIdentifier groupId = null;
    private MemberIdentifier memberId = null;
    private MemberIdentifier parentId = null;
    private MemberIdentifierSet memberIds = null;
    private short assignMode = (short)-1;
    private Member member = null;
    private String newRDNvalue = null;

    public static UpdateDataGraphAssembler getInstance(short s, MemberIdentifier memberIdentifier, MemberIdentifierSet memberIdentifierSet, short s2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(mode,groupId,memberIds,assignMode)");
        }
        UpdateDataGraphAssembler updateDataGraphAssembler = new UpdateDataGraphAssembler();
        if (s != 0) {
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("mode [" + s + "] not support (assignMembersToGroup). "), CLASSNAME, "getInstance(mode,groupId,memberIds,assignMode)");
        }
        updateDataGraphAssembler.constructMode = 0;
        updateDataGraphAssembler.initialization();
        updateDataGraphAssembler.groupId = memberIdentifier;
        updateDataGraphAssembler.memberIds = memberIdentifierSet;
        updateDataGraphAssembler.assignMode = s2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(mode,groupId,memberIds,assignMode)");
        }
        return updateDataGraphAssembler;
    }

    public static UpdateDataGraphAssembler getInstance(short s, MemberIdentifier memberIdentifier, MemberIdentifierSet memberIdentifierSet) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(mode,groupId,memberIds)");
        }
        UpdateDataGraphAssembler updateDataGraphAssembler = new UpdateDataGraphAssembler();
        if (s != 221) {
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("mode [" + s + "] not support (unassignMembersFromGroup). "), CLASSNAME, "getInstance(mode,groupId,memberIds)");
        }
        updateDataGraphAssembler.constructMode = (short)221;
        updateDataGraphAssembler.initialization();
        updateDataGraphAssembler.groupId = memberIdentifier;
        updateDataGraphAssembler.memberIds = memberIdentifierSet;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(mode,groupId,memberIds)");
        }
        return updateDataGraphAssembler;
    }

    public static UpdateDataGraphAssembler getInstance(short s, MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(mode,mbrIds,mbrId2)");
        }
        UpdateDataGraphAssembler updateDataGraphAssembler = new UpdateDataGraphAssembler();
        updateDataGraphAssembler.initialization();
        if (s == 1) {
            updateDataGraphAssembler.constructMode = 1;
            updateDataGraphAssembler.groupId = memberIdentifier;
            updateDataGraphAssembler.memberId = memberIdentifier2;
        }
        if (s == 19) {
            updateDataGraphAssembler.constructMode = (short)19;
            updateDataGraphAssembler.memberId = memberIdentifier;
            updateDataGraphAssembler.parentId = memberIdentifier2;
        } else if (s == 22) {
            updateDataGraphAssembler.constructMode = (short)22;
            updateDataGraphAssembler.groupId = memberIdentifier;
            updateDataGraphAssembler.memberId = memberIdentifier2;
        } else {
            trcLogger.logp(Level.FINER, CLASSNAME, "getInstance(mode,mbrIds,mbrId2)", "method [" + s + "] is not supported. ");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(mode,mbrIds,mbrId2)");
        }
        return updateDataGraphAssembler;
    }

    public static UpdateDataGraphAssembler getInstance(Member member) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(Member mbr)");
        }
        UpdateDataGraphAssembler updateDataGraphAssembler = new UpdateDataGraphAssembler();
        updateDataGraphAssembler.constructMode = (short)23;
        updateDataGraphAssembler.initialization();
        updateDataGraphAssembler.member = member;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(Member mbr)");
        }
        return updateDataGraphAssembler;
    }

    public static UpdateDataGraphAssembler getInstance(MemberIdentifier memberIdentifier, String string) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "renameMember(mbrId, newRDNvalue)");
        }
        UpdateDataGraphAssembler updateDataGraphAssembler = new UpdateDataGraphAssembler();
        updateDataGraphAssembler.initialization();
        updateDataGraphAssembler.constructMode = (short)21;
        updateDataGraphAssembler.memberId = memberIdentifier;
        updateDataGraphAssembler.newRDNvalue = string;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "renameMember(mbrId, newRDNvalue)");
        }
        return updateDataGraphAssembler;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assemble()");
        }
        switch (this.constructMode) {
            case 0: {
                this.assignMembersToGroup(this.groupId, this.memberIds, this.assignMode);
                break;
            }
            case 1: {
                this.assignMemberToGroup(this.groupId, this.memberId, this.assignMode);
                break;
            }
            case 23: {
                this.updateMember(this.member);
                break;
            }
            case 19: {
                this.moveMember(this.memberId, this.parentId);
                break;
            }
            case 22: {
                this.unassignMemberFromGroup(this.groupId, this.memberId);
                break;
            }
            case 221: {
                this.unassignMembersFromGroup(this.groupId, this.memberIds);
                break;
            }
            case 21: {
                this.renameMember(this.memberId, this.newRDNvalue);
                break;
            }
            default: {
                throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("constructmode [" + this.constructMode + "] not support. "), CLASSNAME, "assemble()");
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "assemble()");
        }
        return this.result;
    }

    private void moveMember(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "moveMember(mbrId,parentId)");
        }
        if (this.memberId != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            this.addEntity(dataObject, this.memberId);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "moveMember(mbrId,parentId)");
        }
    }

    private void renameMember(MemberIdentifier memberIdentifier, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "renameMember(mbrId,newRdnValue)");
        }
        if (this.memberId != null && this.newRDNvalue != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            short s = this.memberId.getIdentifierType();
            String string2 = EntityTypeResolver.getWimEntityType(s);
            DataObject dataObject2 = this.addEntity(dataObject, string2, this.memberId);
            List list = ConfigManager.singleton().getRDNProperties(string2);
            if (list.size() > 0) {
                String string3 = (String)list.get(0);
                dataObject2.set(string3, (Object)this.newRDNvalue);
            } else {
                trcLogger.logp(Level.FINER, CLASSNAME, "renameMember(mbrId,newRdnValue)", "Can not find rdn, rdnMap doesn't have map for entity type [" + string2 + "].");
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "renameMember(mbrId,newRdnValue)");
        }
    }

    private void assignMembersToGroup(MemberIdentifier memberIdentifier, MemberIdentifierSet memberIdentifierSet, short s) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assignMembersToGroup(groupId,memberIds,mode)");
        }
        if (memberIdentifier != null && memberIdentifierSet != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            DataObject dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "Group");
            DataObject dataObject3 = dataObject2.createDataObject("identifier");
            dataObject3.setString("uniqueId", memberIdentifier.getMemberUniqueId());
            dataObject3.setString("uniqueName", memberIdentifier.getMemberDN());
            MemberIdentifierIterator memberIdentifierIterator = memberIdentifierSet.iterator();
            while (memberIdentifierIterator.hasNext()) {
                MemberIdentifier memberIdentifier2 = memberIdentifierIterator.next();
                dataObject3 = dataObject2.createDataObject("members").createDataObject("identifier");
                dataObject3.setString("uniqueId", memberIdentifier2.getMemberUniqueId());
                dataObject3.setString("uniqueName", memberIdentifier2.getMemberDN());
            }
            if (s != 0) {
                this.addGroupMemberControlForAssign(dataObject, s);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assignMembersToGroup(groupId,memberIds,mode)");
        }
    }

    private void assignMemberToGroup(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2, short s) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assignMemberToGroup()");
        }
        if (memberIdentifier != null && memberIdentifier2 != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            DataObject dataObject2 = this.addEntity(dataObject, "Group", memberIdentifier);
            this.addMembers(dataObject2, memberIdentifier2);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assignMemberToGroup()");
        }
    }

    private void unassignMemberFromGroup(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "unassignMemberFromGroup()");
        }
        if (memberIdentifier != null && memberIdentifier2 != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            DataObject dataObject2 = this.addEntity(dataObject, "Group", memberIdentifier);
            this.addMembers(dataObject2, memberIdentifier2);
            DataObject dataObject3 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMemberControl");
            dataObject3.setInt("modifyMode", 3);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "unassignMemberFromGroup()");
        }
    }

    private void unassignMembersFromGroup(MemberIdentifier memberIdentifier, MemberIdentifierSet memberIdentifierSet) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "unassignMembersFromGroup(grpid, mbrids)");
        }
        if (memberIdentifier != null && memberIdentifierSet != null) {
            MemberIdentifier memberIdentifier2;
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            DataObject dataObject2 = this.addEntity(dataObject, "Group", this.groupId);
            MemberIdentifierIterator memberIdentifierIterator = memberIdentifierSet.iterator();
            while (memberIdentifierIterator.hasNext()) {
                memberIdentifier2 = memberIdentifierIterator.next();
                this.addMember(dataObject2, memberIdentifier2);
            }
            memberIdentifier2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMemberControl");
            memberIdentifier2.setInt("modifyMode", 3);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "unassignMembersFromGroup(grpid, mbrids)");
        }
    }

    private void updateMember(Member member) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateMember(member)");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        WMM2WIMBridgeAdapter.singleton().addEntityDataObject(dataObject, member);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updateMember(member)");
        }
    }
}

