/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.object;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wmm.datatype.AttributeDefinition;
import com.ibm.websphere.wmm.datatype.AttributeDefinitionFactory;
import com.ibm.ws.wim.bridge.assembler.AssemblerImpl;
import com.ibm.ws.wim.bridge.assembler.object.MemberListAssembler;
import commonj.sdo.DataObject;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AttributeDefinitionAssembler
extends AssemblerImpl {
    private static final String CLASSNAME = MemberListAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private DataObject object = null;

    public static AttributeDefinitionAssembler getInstance(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(DataObject object)");
        }
        AttributeDefinitionAssembler attributeDefinitionAssembler = new AttributeDefinitionAssembler();
        attributeDefinitionAssembler.object = dataObject;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(DataObject object)", attributeDefinitionAssembler);
        }
        return attributeDefinitionAssembler;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assemble()");
        }
        AttributeDefinition attributeDefinition = null;
        if (this.object != null) {
            attributeDefinition = AttributeDefinitionFactory.getInstance();
            String string = this.object.getString("propertyName");
            attributeDefinition.setName(string);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string2 = this.object.getString("dataType");
            if (string2 != null) {
                hashMap.put("datatype", string2.toUpperCase());
            }
            if (this.object.getBoolean("multiValued")) {
                hashMap.put("multiValued", "1");
            } else {
                hashMap.put("multiValued", "0");
            }
            attributeDefinition.setMetaData(hashMap);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assemble()", attributeDefinition);
        }
        return attributeDefinition;
    }
}

