/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.object;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wmm.datatype.Attribute;
import com.ibm.websphere.wmm.datatype.Attributes;
import com.ibm.websphere.wmm.datatype.Member;
import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.ws.wim.PropertyManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.bridge.adapter.WMM2WIMBridgeAdapter;
import com.ibm.ws.wim.bridge.assembler.AssemblerImpl;
import com.ibm.ws.wim.bridge.assembler.DataObjectAssembler;
import com.ibm.ws.wim.bridge.assembler.object.MemberIdentifierAssembler;
import com.ibm.ws.wim.bridge.util.EntityTypeResolver;
import com.ibm.ws.wmm.datatype.impl.AttributeFactory;
import com.ibm.ws.wmm.datatype.impl.AttributesFactory;
import com.ibm.ws.wmm.datatype.impl.MemberFactory;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.EProperty;

public class MemberAssembler
extends AssemblerImpl {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = MemberAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private DataObject entity = null;

    public static MemberAssembler getInstance(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(DataObject entity)", dataObject);
        }
        MemberAssembler memberAssembler = new MemberAssembler();
        memberAssembler.entity = dataObject;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(DataObject entity)", memberAssembler);
        }
        return memberAssembler;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assemble()", this.entity);
        }
        Member member = null;
        if (this.entity != null) {
            Object object;
            Object object2;
            String string;
            DataObject dataObject = this.entity.getDataObject("identifier");
            String string2 = dataObject.getString("uniqueName");
            String string3 = SchemaManager.singleton().getQualifiedTypeName(this.entity.getType());
            short s = EntityTypeResolver.getWmmEntityType(string3, string2);
            Set set = PropertyManager.singleton().getReferencePropertyNameSet(string3);
            member = MemberFactory.getInstance(s);
            DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberIdentifierAssembler.getInstance(dataObject));
            MemberIdentifier memberIdentifier = (MemberIdentifier)dataObjectAssembler.assemble();
            member.setMemberIdentifier(memberIdentifier);
            DataObject dataObject2 = this.entity.getDataObject("parent");
            if (dataObject2 != null) {
                dataObject = this.entity.getDataObject("parent").getDataObject("identifier");
                dataObjectAssembler = new DataObjectAssembler(MemberIdentifierAssembler.getInstance(dataObject));
                memberIdentifier = (MemberIdentifier)dataObjectAssembler.assemble();
                member.setParentMemberIdentifier(memberIdentifier);
            }
            EDataObject eDataObject = (EDataObject)this.entity;
            List list = eDataObject.getInstanceProperties();
            Attributes attributes2 = AttributesFactory.getInstance();
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Object object3;
                    String string4;
                    Iterator iterator = list.get(i);
                    if (!(iterator instanceof EProperty) || !this.entity.isSet(string = (string4 = (EProperty)iterator).getName())) continue;
                    object2 = string4.getContainingType().getName();
                    object = AttributeFactory.getInstance(WMM2WIMBridgeAdapter.singleton().getWMMAttrName(string));
                    if (string4.isMany()) {
                        object3 = this.entity.getList(string);
                        if (object3.size() > 0) {
                            object.setValues(this.getWmmAttributeValueList((String)object2, (List)object3));
                        }
                    } else if ("Base64Binary".equals(object2) && string.equals("password")) {
                        object.setValue(new String((byte[])this.entity.get(string)));
                    } else {
                        object3 = this.entity.get(string);
                        object.setValue(WMM2WIMBridgeAdapter.singleton().getAttributeValue((String)object2, object3));
                    }
                    attributes2.addAttribute((Attribute)object);
                }
            }
            if (set != null) {
                String string5 = "IdentifierType";
                for (String string4 : set) {
                    string = SchemaManager.singleton().getProperty(string3, string4);
                    if (string == null || !this.entity.isSet((Property)string)) continue;
                    object2 = AttributeFactory.getInstance(WMM2WIMBridgeAdapter.singleton().getWMMAttrName(string4));
                    if (string.isMany()) {
                        object = this.entity.getList((Property)string);
                        if (object.size() > 0) {
                            object2.setValues(this.getWmmAttributeValueList(string5, (List)object));
                        }
                    } else {
                        object = this.entity.get((Property)string);
                        object2.setValue(WMM2WIMBridgeAdapter.singleton().getAttributeValue(string5, object));
                    }
                    attributes2.addAttribute((Attribute)object2);
                }
            }
            member.setAttributes(attributes2);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assemble()");
        }
        return member;
    }

    private List getWmmAttributeValueList(String string, List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(WMM2WIMBridgeAdapter.singleton().getAttributeValue(string, list.get(i)));
        }
        return arrayList;
    }

    public boolean validate() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validate()");
        }
        boolean bl = false;
        if (this.entity != null) {
            DataObject dataObject = this.entity.getDataObject("identifier");
            if (dataObject == null) {
                trcLogger.logp(Level.FINER, CLASSNAME, "validate()", "identifier can not be found. ");
                bl = false;
            } else {
                String string = dataObject.getString("uniqueId");
                String string2 = dataObject.getString("uniqueName");
                if (!(string != null && string.trim().length() != 0 || string2 != null && string2.trim().length() != 0)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "validate()", "invalid identifier found [uniqueId = " + string + ", uniqueName = " + string2 + "]. ");
                    bl = false;
                } else {
                    bl = true;
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validate()", new Boolean(bl));
        }
        return bl;
    }
}

