/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.object;

import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.ws.wim.bridge.assembler.AssemblerImpl;
import com.ibm.ws.wmm.datatype.impl.MemberIdentifierFactory;
import commonj.sdo.DataObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemberIdentifierAssembler
extends AssemblerImpl {
    private static final String CLASSNAME = MemberIdentifierAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private DataObject identifier = null;

    public static MemberIdentifierAssembler getInstance(DataObject dataObject) throws WIMException {
        Object object;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(DataObject identifier)");
        }
        if (dataObject != null && !((String)(object = dataObject.getType().getName())).equals("IdentifierType")) {
            trcLogger.logp(Level.FINER, CLASSNAME, "getInstance(DataObject identifier)", "The specified data object [" + (String)object + "] is not identifier. ");
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("none identifier data type is specified. "), CLASSNAME, "getInstance(DataObject identifier)");
        }
        object = new MemberIdentifierAssembler();
        ((MemberIdentifierAssembler)object).identifier = dataObject;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(DataObject identifier)");
        }
        return object;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assemble()", this.identifier);
        }
        MemberIdentifier memberIdentifier = null;
        if (this.identifier != null) {
            String string = this.identifier.getString("uniqueId");
            String string2 = this.identifier.getString("uniqueName");
            memberIdentifier = MemberIdentifierFactory.getInstance(string2, string);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assemble()", memberIdentifier);
        }
        return memberIdentifier;
    }

    public boolean validate() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validate()");
        }
        boolean bl = false;
        if (this.identifier != null) {
            String string = this.identifier.getString("uniqueId");
            String string2 = this.identifier.getString("uniqueName");
            bl = string != null && string.trim().length() != 0 || string2 != null && string2.trim().length() != 0;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validate()", new Boolean(bl));
        }
        return bl;
    }
}

