/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.object;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.websphere.wmm.datatype.MemberIdentifierList;
import com.ibm.websphere.wmm.datatype.MemberIdentifierListFactory;
import com.ibm.ws.wim.bridge.assembler.AssemblerImpl;
import com.ibm.ws.wim.bridge.assembler.DataObjectAssembler;
import com.ibm.ws.wim.bridge.assembler.object.MemberIdentifierAssembler;
import com.ibm.ws.wim.bridge.util.EntityTypeResolver;
import commonj.sdo.DataObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemberIdentifierListAssembler
extends AssemblerImpl {
    private static final String CLASSNAME = MemberIdentifierListAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private List entities = null;

    public static MemberIdentifierListAssembler getInstance(List list) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(List entities)", list);
        }
        MemberIdentifierListAssembler memberIdentifierListAssembler = new MemberIdentifierListAssembler();
        memberIdentifierListAssembler.entities = list;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(List entities)", memberIdentifierListAssembler);
        }
        return memberIdentifierListAssembler;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assemble()");
        }
        MemberIdentifierList memberIdentifierList = null;
        if (this.entities != null) {
            memberIdentifierList = MemberIdentifierListFactory.getInstance();
            for (int i = 0; i < this.entities.size(); ++i) {
                DataObject dataObject = (DataObject)this.entities.get(i);
                DataObject dataObject2 = dataObject.getDataObject("identifier");
                if (dataObject2 == null) continue;
                String string = dataObject2.getString("uniqueName");
                String string2 = dataObject.getType().getName();
                short s = EntityTypeResolver.getWmmEntityType(string2, string);
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberIdentifierAssembler.getInstance(dataObject2));
                MemberIdentifier memberIdentifier = (MemberIdentifier)dataObjectAssembler.assemble();
                memberIdentifierList.add(memberIdentifier);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assemble()", memberIdentifierList);
        }
        return memberIdentifierList;
    }
}

