/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.object;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.websphere.wmm.datatype.MemberIdentifierSet;
import com.ibm.ws.wim.bridge.assembler.AssemblerImpl;
import com.ibm.ws.wim.bridge.assembler.DataObjectAssembler;
import com.ibm.ws.wim.bridge.assembler.object.MemberIdentifierAssembler;
import com.ibm.ws.wim.bridge.util.EntityTypeResolver;
import com.ibm.ws.wmm.datatype.impl.MemberIdentifierSetFactory;
import commonj.sdo.DataObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemberIdentifierSetAssembler
extends AssemblerImpl {
    private static final String CLASSNAME = MemberIdentifierSetAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private List entities = null;
    private short[] filter = null;

    public static MemberIdentifierSetAssembler getInstance(List list) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(List entities)", list);
        }
        MemberIdentifierSetAssembler memberIdentifierSetAssembler = new MemberIdentifierSetAssembler();
        memberIdentifierSetAssembler.entities = list;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(List entities)", memberIdentifierSetAssembler);
        }
        return memberIdentifierSetAssembler;
    }

    public static MemberIdentifierSetAssembler getInstance(List list, short[] sArray) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(List entities, short[] filter)", list);
        }
        MemberIdentifierSetAssembler memberIdentifierSetAssembler = new MemberIdentifierSetAssembler();
        memberIdentifierSetAssembler.entities = list;
        memberIdentifierSetAssembler.filter = sArray;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(List entities, short[] filter)", memberIdentifierSetAssembler);
        }
        return memberIdentifierSetAssembler;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assemble()");
        }
        MemberIdentifierSet memberIdentifierSet = null;
        if (this.entities != null) {
            memberIdentifierSet = MemberIdentifierSetFactory.getInstance();
            for (int i = 0; i < this.entities.size(); ++i) {
                Object object;
                DataObject dataObject = (DataObject)this.entities.get(i);
                DataObject dataObject2 = dataObject.getDataObject("identifier");
                if (dataObject2 == null) continue;
                String string = dataObject2.getString("uniqueName");
                if (this.filter != null) {
                    object = dataObject.getType().getName();
                    short s = EntityTypeResolver.getWmmEntityType((String)object, string);
                    boolean bl = true;
                    for (int j = 0; j < this.filter.length; ++j) {
                        if (this.filter[j] != s) continue;
                        bl = false;
                        break;
                    }
                    if (bl) continue;
                }
                object = new DataObjectAssembler(MemberIdentifierAssembler.getInstance(dataObject2));
                MemberIdentifier memberIdentifier = (MemberIdentifier)object.assemble();
                memberIdentifierSet.add(memberIdentifier);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assemble()", memberIdentifierSet);
        }
        return memberIdentifierSet;
    }
}

