/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.object;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wmm.datatype.Member;
import com.ibm.websphere.wmm.datatype.MemberList;
import com.ibm.ws.wim.bridge.assembler.AssemblerImpl;
import com.ibm.ws.wim.bridge.assembler.DataObjectAssembler;
import com.ibm.ws.wim.bridge.assembler.object.MemberAssembler;
import com.ibm.ws.wmm.datatype.impl.MemberListFactory;
import commonj.sdo.DataObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemberListAssembler
extends AssemblerImpl {
    private static final String CLASSNAME = MemberListAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private DataObject root = null;

    public static MemberListAssembler getInstance(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(DataObject root)");
        }
        MemberListAssembler memberListAssembler = new MemberListAssembler();
        memberListAssembler.root = dataObject;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(DataObject root)", memberListAssembler);
        }
        return memberListAssembler;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assemble()");
        }
        MemberList memberList = null;
        if (this.root != null) {
            memberList = MemberListFactory.getInstance();
            List list = this.root.getList("entities");
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject = (DataObject)list.get(i);
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberAssembler.getInstance(dataObject));
                Member member = (Member)dataObjectAssembler.assemble();
                memberList.add(member);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assemble()", memberList);
        }
        return memberList;
    }
}

