/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.object;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wmm.datatype.Member;
import com.ibm.websphere.wmm.datatype.MemberSet;
import com.ibm.websphere.wmm.datatype.MemberSetFactory;
import com.ibm.ws.wim.bridge.assembler.AssemblerImpl;
import com.ibm.ws.wim.bridge.assembler.DataObjectAssembler;
import com.ibm.ws.wim.bridge.assembler.object.MemberAssembler;
import commonj.sdo.DataObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemberSetAssembler
extends AssemblerImpl {
    private static final String CLASSNAME = MemberSetAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private DataObject root = null;
    private String memberSetType = null;

    public static MemberSetAssembler getInstance(DataObject dataObject, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(DataObject root, String type)");
        }
        MemberSetAssembler memberSetAssembler = new MemberSetAssembler();
        memberSetAssembler.root = dataObject;
        memberSetAssembler.memberSetType = string;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(DataObject root, String type)", memberSetAssembler);
        }
        return memberSetAssembler;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assemble()");
        }
        MemberSet memberSet = null;
        if (this.root != null) {
            memberSet = MemberSetFactory.getInstance();
            List list = this.root.getList(this.memberSetType);
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject = (DataObject)list.get(i);
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberAssembler.getInstance(dataObject));
                Member member = (Member)dataObjectAssembler.assemble();
                memberSet.add(member);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assemble()", memberSet);
        }
        return memberSet;
    }
}

