/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.object;

import com.ibm.websphere.wim.exception.SearchControlException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wmm.datatype.AttributeSearchConditions;
import com.ibm.websphere.wmm.datatype.SearchCondition;
import com.ibm.websphere.wmm.datatype.SearchCriteria;
import com.ibm.ws.wim.bridge.assembler.AssemblerImpl;
import com.ibm.ws.wim.bridge.xpath.Interpreter;
import com.ibm.ws.wim.xpath.ParseException;
import com.ibm.ws.wim.xpath.TokenMgrError;
import com.ibm.ws.wim.xpath.WIMXPathInterpreter;
import com.ibm.ws.wim.xpath.mapping.datatype.PropertyNode;
import com.ibm.ws.wim.xpath.mapping.datatype.XPathNode;
import com.ibm.ws.wmm.datatype.impl.AttributeSearchConditionsFactory;
import com.ibm.ws.wmm.datatype.impl.SearchConditionFactory;
import com.ibm.ws.wmm.datatype.impl.SearchCriteriaFactory;
import java.io.StringReader;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchCriteriaAssembler
extends AssemblerImpl {
    private static final String CLASSNAME = SearchCriteriaAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private String sExp = null;

    public static SearchCriteriaAssembler getInstance(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(searchExp)");
        }
        SearchCriteriaAssembler searchCriteriaAssembler = new SearchCriteriaAssembler();
        searchCriteriaAssembler.sExp = string;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(searchExp)");
        }
        return searchCriteriaAssembler;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assemble()");
        }
        SearchCriteria searchCriteria = SearchCriteriaFactory.getInstance();
        WIMXPathInterpreter wIMXPathInterpreter = new WIMXPathInterpreter(new StringReader(this.sExp));
        XPathNode xPathNode = null;
        try {
            xPathNode = wIMXPathInterpreter.parse(null);
        }
        catch (ParseException parseException) {
            throw new WIMApplicationException(parseException);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(this.sExp), CLASSNAME, "assemble()", (Throwable)tokenMgrError);
        }
        Interpreter interpreter = new Interpreter(xPathNode);
        Map map = interpreter.run();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "assemble()", "generated sCondsMap ->" + map);
        }
        for (String string : map.keySet()) {
            AttributeSearchConditions attributeSearchConditions = AttributeSearchConditionsFactory.getInstance(string);
            Vector vector = (Vector)map.get(string);
            for (int i = 0; i < vector.size(); ++i) {
                Object object;
                Object e2 = vector.get(i);
                if (e2 instanceof PropertyNode) {
                    object = (PropertyNode)e2;
                    SearchCondition searchCondition = SearchConditionFactory.getInstance();
                    searchCondition.setComparisonOperator(this.getOperator(((PropertyNode)object).getOperator()));
                    searchCondition.setValue(((PropertyNode)object).getValue());
                    attributeSearchConditions.addSearchCondition(searchCondition);
                    continue;
                }
                if (e2 instanceof String) {
                    object = (String)e2;
                    if (((String)object).equalsIgnoreCase("and")) {
                        attributeSearchConditions.addLogicalOperator(AttributeSearchConditions.OPERATOR_AND);
                        continue;
                    }
                    attributeSearchConditions.addLogicalOperator(AttributeSearchConditions.OPERATOR_OR);
                    continue;
                }
                throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("invalid instance found. "), CLASSNAME, "assemble()");
            }
            searchCriteria.addAttributeSearchConditions(attributeSearchConditions);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assemble()", searchCriteria);
        }
        return searchCriteria;
    }

    private short getOperator(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getOperator(operator)", "" + string);
        }
        int n = -1;
        if (string.equals("=")) {
            n = 0;
        } else if (string.equals(">=")) {
            n = 4;
        } else if (string.equals(">")) {
            n = 2;
        } else if (string.equals("<=")) {
            n = 5;
        } else if (string.equals("<")) {
            n = 3;
        } else if (string.equals("!=")) {
            n = 1;
        } else {
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("can not convert xpath operator [" + string + "]"), CLASSNAME, "getOperator(operator)");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getOperator(operator)", "" + n);
        }
        return (short)n;
    }
}

