/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.object;

import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wmm.datatype.MemberList;
import com.ibm.websphere.wmm.datatype.SearchResponseControl;
import com.ibm.websphere.wmm.datatype.SearchResponseControlFactory;
import com.ibm.ws.wim.bridge.assembler.AssemblerImpl;
import com.ibm.ws.wim.bridge.assembler.DataObjectAssembler;
import com.ibm.ws.wim.bridge.assembler.object.MemberListAssembler;
import com.ibm.ws.wim.util.ControlsHelper;
import commonj.sdo.DataObject;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchResponseControlAssembler
extends AssemblerImpl {
    private static final String CLASSNAME = SearchResponseControlAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private DataObject root = null;
    private byte[] cookie = null;
    private boolean sorted;

    public static SearchResponseControlAssembler getInstance(DataObject dataObject, boolean bl) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInstance(DataObject root)");
        }
        SearchResponseControlAssembler searchResponseControlAssembler = new SearchResponseControlAssembler();
        searchResponseControlAssembler.root = dataObject;
        searchResponseControlAssembler.sorted = bl;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInstance(DataObject root)", searchResponseControlAssembler);
        }
        return searchResponseControlAssembler;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assemble()");
        }
        SearchResponseControl searchResponseControl = null;
        if (this.root != null) {
            searchResponseControl = SearchResponseControlFactory.getInstance();
            Map map = ControlsHelper.getControlMap(this.root.getDataGraph());
            DataObject dataObject = (DataObject)map.get("ResponseControl");
            if (dataObject == null) {
                throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("Response control can not be found. "), CLASSNAME, "assemble()");
            }
            this.cookie = dataObject.getBytes("cookie");
            searchResponseControl.setCookie(this.cookie);
            DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberListAssembler.getInstance(this.root));
            MemberList memberList = (MemberList)dataObjectAssembler.assemble();
            searchResponseControl.setMemberList(memberList);
            searchResponseControl.setSorted(this.sorted);
            searchResponseControl.setTotalNumberOfResults(memberList.size());
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assemble()", searchResponseControl);
        }
        return searchResponseControl;
    }
}

