/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.model;

import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.bridge.model.Group;
import com.ibm.ws.wim.bridge.model.Member;
import com.ibm.ws.wim.bridge.model.Organization;
import com.ibm.ws.wim.bridge.model.Person;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Model {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = Model.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static Model instance = null;
    private static Member root = null;
    static final String margin = " ";

    private Model() {
        root = new Organization();
        root.setId("9f9624c0-de99-11d9-97d7-834842b1cd88");
        root.setDn("o=default organization");
        Organization organization = new Organization();
        organization.setId("9f9624c0-de99-11d9-97d7-834842b1cd81");
        organization.setDn("o=orgA,o=default organization");
        root.getChildren().add(organization);
        organization.setParent(root);
        Organization organization2 = new Organization();
        organization2.setId("9f9624c1-de99-11d9-97d7-834842b1cd81");
        organization2.setDn("o=orgB,o=orgA,o=default organization");
        organization.getChildren().add(organization2);
        organization2.setParent(organization);
        Organization organization3 = new Organization();
        organization3.setId("9f9624c2-de99-11d9-97d7-834842b1cd81");
        organization3.setDn("o=orgC,o=orgA,o=default organization");
        organization.getChildren().add(organization3);
        organization3.setParent(organization);
        Organization organization4 = new Organization();
        organization4.setId("9f9624c3-de99-11d9-97d7-834842b1cd81");
        organization4.setDn("o=orgD,o=orgB,o=orgA,o=default organization");
        organization2.getChildren().add(organization4);
        organization4.setParent(organization2);
        Person person = new Person();
        person.setId("9f9624c4-de99-12d9-97d7-834842b1cd81");
        person.setDn("uid=perA,o=orgA,o=default organization");
        person.setParent(organization);
        organization.getChildren().add(person);
        Person person2 = new Person();
        person2.setId("9f9624c5-de99-13d9-97d7-834842b1cd81");
        person2.setDn("uid=perB,o=orgB,o=orgA,o=default organization");
        person2.setParent(organization2);
        organization2.getChildren().add(person2);
        Person person3 = new Person();
        person3.setId("9f9624c6-de99-14d9-97d7-834842b1cd81");
        person3.setDn("uid=perC,o=orgC,o=orgA,o=default organization");
        person3.setParent(organization3);
        organization3.getChildren().add(person3);
        Person person4 = new Person();
        person4.setId("9f9624c7-de99-15d9-97d7-834842b1cd81");
        person4.setDn("uid=perD,o=orgD,o=orgB,o=orgA,o=default organization");
        person4.setParent(organization4);
        organization4.getChildren().add(person4);
        Group group = new Group();
        group.setId("9f9624c4-de99-21d9-97d7-834842b1cd81");
        group.setDn("cn=grpA,o=orgA,o=default organization");
        group.setParent(organization);
        organization.getChildren().add(group);
        Group group2 = new Group();
        group2.setId("9f9624c5-de99-31d9-97d7-834842b1cd81");
        group2.setDn("cn=grpB,o=orgB,o=orgA,o=default organization");
        group2.setParent(organization2);
        organization2.getChildren().add(group2);
        Group group3 = new Group();
        group3.setId("9f9624c6-de99-41d9-97d7-834842b1cd81");
        group3.setDn("cn=grpC,o=orgC,o=orgA,o=default organization");
        group3.setParent(organization3);
        organization3.getChildren().add(group3);
        Group group4 = new Group();
        group4.setId("9f9624c7-de99-51d9-97d7-834842b1cd81");
        group4.setDn("cn=grpD,o=orgD,o=orgB,o=orgA,o=default organization");
        group4.setParent(organization4);
        organization4.getChildren().add(group4);
        group.getGroupChildren().add(person);
        group.getGroupChildren().add(group2);
        group.getGroupChildren().add(group3);
        group2.getGroupChildren().add(person2);
        group2.getGroupChildren().add(group4);
        group3.getGroupChildren().add(person3);
        group4.getGroupChildren().add(person4);
        group2.getParentGroups().add(group);
        group3.getParentGroups().add(group);
        group3.getParentGroups().add(group2);
        person.getParentGroups().add(group);
        person2.getParentGroups().add(group2);
        person3.getParentGroups().add(group3);
        person4.getParentGroups().add(group4);
    }

    public static Model singleton() {
        if (instance == null) {
            instance = new Model();
            instance.print();
        }
        return instance;
    }

    public void reset() {
        instance = null;
    }

    public Member getRoot() {
        return root;
    }

    public Member getMember(Member member, String string, String string2) {
        Member member2;
        block2: {
            Organization organization;
            Object e2;
            block1: {
                member2 = null;
                if (!member.get(string).equals(string2)) break block1;
                member2 = member;
                break block2;
            }
            Set set = member.getChildren();
            if (set == null) break block2;
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && (member2 = this.getMember((Member)(e2 = iterator.next()), string, string2)) == null && (!(e2 instanceof Organization) || (member2 = this.getMember(organization = (Organization)e2, string, string2)) == null)) {
            }
        }
        return member2;
    }

    public void removeMember(Member member, Member member2) {
        Set set;
        Set set2;
        Set set3 = member.getChildren();
        if (set3 != null) {
            set3.remove(member2);
        }
        if ((set2 = member.getGroupChildren()) != null) {
            set2.remove(member2);
        }
        if ((set = member.getParentGroups()) != null) {
            set.remove(member2);
        }
        if (set3 != null) {
            for (Member member3 : set3) {
                this.removeMember(member3, member2);
            }
        }
    }

    public void print() {
        trcLogger.log(Level.FINER, "------------------------------------------------------------------");
        trcLogger.log(Level.FINER, "SPI Bridge Data Model: ");
        trcLogger.log(Level.FINER, "------------------------------------------------------------------");
        this.printModel(root, 0);
        trcLogger.log(Level.FINER, "------------------------------------------------------------------");
    }

    private void printModel(Member member, int n) {
        if (member != null) {
            Object object;
            Object object2;
            trcLogger.log(Level.FINER, this.getMargin(n) + member);
            trcLogger.log(Level.FINER, this.getMargin(n) + "parent: " + member.getParent());
            Set set = member.getGroupChildren();
            if (set == null) {
                trcLogger.log(Level.FINER, this.getMargin(n) + "groupChildren: [null]");
            } else {
                trcLogger.log(Level.FINER, this.getMargin(n) + "groupChildren: [" + set.size() + "]");
                object2 = set.iterator();
                while (object2.hasNext()) {
                    trcLogger.log(Level.FINER, this.getMargin(n) + "               " + (Member)object2.next());
                }
            }
            object2 = member.getParentGroups();
            if (object2 == null) {
                trcLogger.log(Level.FINER, this.getMargin(n) + "parentGroups: [null]");
            } else {
                trcLogger.log(Level.FINER, this.getMargin(n) + "parentGroups: [" + object2.size() + "]");
                object = object2.iterator();
                while (object.hasNext()) {
                    trcLogger.log(Level.FINER, this.getMargin(n) + "              " + (Member)object.next());
                }
            }
            object = member.getProperties();
            if (object == null) {
                trcLogger.log(Level.FINER, this.getMargin(n) + "properties: [null]");
            } else {
                trcLogger.log(Level.FINER, this.getMargin(n) + "properties: [" + object.size() + "]");
                for (Object object3 : object.keySet()) {
                    trcLogger.log(Level.FINER, this.getMargin(n) + "            [name = " + (String)object3 + ", value = " + object.get(object3) + "]");
                }
            }
            Set set2 = member.getChildren();
            if (set2 == null) {
                trcLogger.log(Level.FINER, this.getMargin(n) + "children: [null]");
            } else {
                Object object3;
                trcLogger.log(Level.FINER, this.getMargin(n) + "children: [" + set2.size() + "]");
                object3 = set2.iterator();
                while (object3.hasNext()) {
                    this.printModel((Member)object3.next(), n + 1);
                }
            }
        }
    }

    private String getMargin(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + margin;
        }
        string = string + n + ": ";
        return string;
    }

    private void logp(String string, String string2, String string3) {
        trcLogger.log(Level.FINER, string + margin + string2 + margin + string3);
    }

    private void entering(String string, String string2) {
        this.entering(string, string2, "");
    }

    private void entering(String string, String string2, String string3) {
        trcLogger.log(Level.FINER, string + ">" + string2 + " ENTRY " + string3);
    }

    private void existing(String string, String string2) {
        this.existing(string, string2, "");
    }

    private void existing(String string, String string2, String string3) {
        trcLogger.log(Level.FINER, string + "<" + string2 + " RETURN " + string3);
    }
}

