/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.util;

import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EntityTypeResolver {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = EntityTypeResolver.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public static String getWimEntityType(short s) {
        String string = "getWimEntityType(" + s + ")";
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, string);
        }
        String string2 = null;
        switch (s) {
            case 0: {
                string2 = "PersonAccount";
                break;
            }
            case 1: {
                string2 = "Group";
                break;
            }
            case 2: {
                string2 = "OrgContainer";
                break;
            }
            case 3: {
                string2 = "OrgContainer";
                break;
            }
            default: {
                string2 = "PersonAccount";
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, string, string2);
        }
        return string2;
    }

    public static short getWmmEntityType(String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getWmmEntityType(entityType)", string);
        }
        int n = 0;
        if (string.equals("Person")) {
            n = 0;
        } else if (string.equals("PersonAccount")) {
            n = 0;
        } else if (string.equals("Group")) {
            n = 1;
        } else if (string.equals("OrgContainer")) {
            n = string2 != null && string2.startsWith("o=") ? 2 : 3;
        } else {
            trcLogger.logp(Level.FINER, CLASSNAME, "getWmmEntityType(entityType)", "Can not result entity type [" + string + "]");
            throw new WIMApplicationException("GENERIC", CLASSNAME, "getWmmEntityType(entityType)");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getWmmEntityType(entityType)", "" + n);
        }
        return (short)n;
    }
}

