/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.util;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wmm.datatype.AttributeDefinition;
import com.ibm.websphere.wmm.datatype.GroupScope;
import com.ibm.websphere.wmm.datatype.Member;
import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.websphere.wmm.datatype.MemberIdentifierSet;
import com.ibm.websphere.wmm.datatype.MemberTypeAttributeMap;
import com.ibm.websphere.wmm.datatype.PageControl;
import com.ibm.websphere.wmm.datatype.SearchCriteria;
import com.ibm.websphere.wmm.datatype.SortControl;
import com.ibm.websphere.wmm.datatype.StringSet;
import com.ibm.ws.wim.bridge.assembler.DataGraphAssembler;
import com.ibm.ws.wim.bridge.assembler.datagraph.CreateDataGraphAssembler;
import com.ibm.ws.wim.bridge.assembler.datagraph.DeleteDataGraphAssembler;
import com.ibm.ws.wim.bridge.assembler.datagraph.GetDataGraphAssembler;
import com.ibm.ws.wim.bridge.assembler.datagraph.LoginDataGraphAssembler;
import com.ibm.ws.wim.bridge.assembler.datagraph.SearchDataGraphAssembler;
import com.ibm.ws.wim.bridge.assembler.datagraph.UpdateDataGraphAssembler;
import commonj.sdo.DataGraph;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParameterHandler {
    private static final String CLASSNAME = ParameterHandler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public static DataGraph isMemberInGroup(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2, GroupScope groupScope) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isMemberInGroup(grpId, mbrId, scope)");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)18, memberIdentifier, memberIdentifier2, groupScope));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "isMemberInGroup(grpId, mbrId, scope)");
        }
        return dataGraph;
    }

    public static DataGraph createMember(Member member) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createMember(mbr)");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(CreateDataGraphAssembler.getInstance(member));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createMember(mbr)");
        }
        return dataGraph;
    }

    public static DataGraph getMemberIdentifier(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getMemberIdentifier(externalDn)");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)14, string));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getMemberIdentifier(externalDn)");
        }
        return dataGraph;
    }

    public static DataGraph createAttributeDefinition(AttributeDefinition attributeDefinition, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createAttributeDefintion(attributeDefinition, path)");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(CreateDataGraphAssembler.getInstance(attributeDefinition, string));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createAttributeDefintion(attributeDefinition, path)");
        }
        return dataGraph;
    }

    public static DataGraph getExternalDn(MemberIdentifier memberIdentifier) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getExternalDn(mbrId)");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)8, memberIdentifier));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getExternalDn(mbrId)");
        }
        return dataGraph;
    }

    public static DataGraph getAttributeDatatypes(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getAttributeDatatypes(path)", "(" + string + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)24, string));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getAttributeDatatypes(path)", dataGraph);
        }
        return dataGraph;
    }

    public static DataGraph getLookasideAttributeDatatypes() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getLookasideAttributeDatatypes()");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)26));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getLookasideAttributeDatatypes()");
        }
        return dataGraph;
    }

    public static DataGraph createLookasideAttributeDefinition(AttributeDefinition attributeDefinition) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createLookasideAttributeDefintion(attributeDefinition )");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(CreateDataGraphAssembler.getInstance((short)3, attributeDefinition));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createLookasideAttributeDefintion(attributeDefinition )", dataGraph);
        }
        return dataGraph;
    }

    public static DataGraph getAttributeDefinition(String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getAttributeDefintion(attributeName, path)");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)6, string, string2));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getAttributeDefintion(attributeName, path)");
        }
        return dataGraph;
    }

    public static DataGraph getAttributeDefinitions(short s, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getAttributeDefintions(memberType, path)");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)7, s, string));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getAttributeDefintions(memberType, path)");
        }
        return dataGraph;
    }

    public static DataGraph getAncestorIdentifiers(MemberIdentifier memberIdentifier, short s) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getAncestorIdentifier(mbr)", "(" + memberIdentifier + ", " + s + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)5, memberIdentifier, s));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getAncestorIdentifier(mbr)");
        }
        return dataGraph;
    }

    public static DataGraph getDescendants(MemberIdentifier memberIdentifier, short s) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getDescendant(mbrid, scope)", "(" + memberIdentifier + ", " + s + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)25, memberIdentifier, s));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getDescendant(mbrid, scope)");
        }
        return dataGraph;
    }

    public static DataGraph getMember(MemberIdentifier memberIdentifier, StringSet stringSet) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getMember(mbrid, attributeNames)", "(" + memberIdentifier + ", " + stringSet + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)13, memberIdentifier, stringSet));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getMember(mbrid, attributeNames)");
        }
        return dataGraph;
    }

    public static DataGraph getPersonByAccountName(String string, String string2, StringSet stringSet) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getPersonByAccountName(accountName, realmName, attributeNames)", WIMTraceHelper.printObjectArray(new Object[]{string, string2, stringSet}));
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(SearchDataGraphAssembler.getInstance((short)17, string, string2, stringSet));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getPersonByAccountName(accountName, realmName, attributeNames)");
        }
        return dataGraph;
    }

    public static DataGraph getGroupIdentifiersForMember(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2, GroupScope groupScope) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getGroupIdentifiersForMember(mmeberId, baseMemberId, scope)", "(" + memberIdentifier + ", " + memberIdentifier2 + ", " + groupScope + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)9, memberIdentifier, memberIdentifier2, groupScope));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getGroupIdentifiersForMember(mmeberId, baseMemberId, scope)");
        }
        return dataGraph;
    }

    public static DataGraph getGroupMemberIdentifiers(MemberIdentifier memberIdentifier, GroupScope groupScope, short[] sArray) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getGroupMemberIdentifiers(grpId, scope)", "(" + memberIdentifier + ", " + groupScope + ", " + sArray + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)10, memberIdentifier, groupScope, sArray));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getGroupMemberIdentifiers(grpId, scope)");
        }
        return dataGraph;
    }

    public static DataGraph getGroupMembers(MemberIdentifier memberIdentifier, GroupScope groupScope, MemberTypeAttributeMap memberTypeAttributeMap) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getGroupMembers(grpId, scope, returnedMemberTypeAndAttributes)", "(" + memberIdentifier + ", " + groupScope + ", " + memberTypeAttributeMap + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)11, memberIdentifier, groupScope, memberTypeAttributeMap));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getGroupMembers(grpId, scope, returnedMemberTypeAndAttributes)");
        }
        return dataGraph;
    }

    public static DataGraph getGroupMembers(MemberIdentifier memberIdentifier, GroupScope groupScope, MemberIdentifierSet memberIdentifierSet, MemberTypeAttributeMap memberTypeAttributeMap) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getGroupMembers(grpId, scope, baseMemberIds, returnedMemberTypeAndAttributes)", "(" + memberIdentifier + ", " + groupScope + ", " + memberIdentifierSet + ", " + memberTypeAttributeMap + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)11, memberIdentifier, groupScope, memberIdentifierSet, memberTypeAttributeMap));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getGroupMembers(grpId, scope, baseMemberIds, returnedMemberTypeAndAttributes)");
        }
        return dataGraph;
    }

    public static DataGraph getGroupsForMember(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2, GroupScope groupScope, StringSet stringSet) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getGroupsForMember(mbrId, baseMbrId, scope, attributeNames)", "(" + memberIdentifier + ", " + memberIdentifier2 + ", " + groupScope + ", " + stringSet + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)12, memberIdentifier, memberIdentifier2, groupScope, stringSet));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getGroupsForMember(mbrId, baseMbrId, scope, attributeNames)");
        }
        return dataGraph;
    }

    public static DataGraph getGroupsForMember(MemberIdentifier memberIdentifier, GroupScope groupScope, MemberIdentifierSet memberIdentifierSet, StringSet stringSet) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getGroupsForMember(mbrId, baseMbrId, scope, attributeNames)", "(" + memberIdentifier + ", " + groupScope + ", " + memberIdentifierSet + ", " + stringSet + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)12, memberIdentifier, groupScope, memberIdentifierSet, stringSet));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getGroupsForMember(mbrId, baseMbrId, scope, attributeNames)");
        }
        return dataGraph;
    }

    public static DataGraph getMembers(short s, MemberIdentifierSet memberIdentifierSet, StringSet stringSet, SortControl sortControl) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getMembers(memberType, memberIds, attributeNames, sortControl)", "(" + s + ", " + memberIdentifierSet + ", " + stringSet + ", " + sortControl + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(GetDataGraphAssembler.getInstance((short)15, s, memberIdentifierSet, stringSet, sortControl));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getMembers(memberType, memberIds, attributeNames, sortControl)");
        }
        return dataGraph;
    }

    public static DataGraph getMembersRecursively(MemberIdentifier memberIdentifier, String string, StringSet stringSet, int n) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getMembersRecursively(memberId, recursionAttrName, returnAttrNames, maxListSize)");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(SearchDataGraphAssembler.getInstance((short)16, memberIdentifier, string, stringSet, n));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getMembersRecursively(memberId, recursionAttrName, returnAttrNames, maxListSize)");
        }
        return dataGraph;
    }

    public static DataGraph assignMembersToGroup(MemberIdentifier memberIdentifier, MemberIdentifierSet memberIdentifierSet, short s) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "assignMembersToGroup(groupid, memberids, mode)");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(UpdateDataGraphAssembler.getInstance((short)0, memberIdentifier, memberIdentifierSet, s));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "assignMembersToGroup(groupid, memberids, mode)", dataGraph);
        }
        return dataGraph;
    }

    public static DataGraph unassignMembersFromGroup(MemberIdentifier memberIdentifier, MemberIdentifierSet memberIdentifierSet) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "unassignMembersFromGroup(groupid, memberids)", "(" + memberIdentifier + ", " + memberIdentifierSet + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(UpdateDataGraphAssembler.getInstance((short)221, memberIdentifier, memberIdentifierSet));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "unassignMembersFromGroup(groupid, memberids)", dataGraph);
        }
        return dataGraph;
    }

    public static DataGraph assignMemberToGroup(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "assignMemberToGroup(grpId, mbrId)");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(UpdateDataGraphAssembler.getInstance((short)1, memberIdentifier, memberIdentifier2));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "assignMemberToGroup(grpId, mbrId)");
        }
        return dataGraph;
    }

    public static DataGraph unassignMemberFromGroup(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "unassignMemberFromGroup(grpId, mbrId)");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(UpdateDataGraphAssembler.getInstance((short)22, memberIdentifier, memberIdentifier2));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "unassignMemberFromGroup(grpId, mbrId)", dataGraph);
        }
        return dataGraph;
    }

    public static DataGraph moveMember(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "moveMember( mbrid, parentId)", "(" + memberIdentifier + ", " + memberIdentifier2 + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(UpdateDataGraphAssembler.getInstance((short)19, memberIdentifier, memberIdentifier2));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "moveMember( mbrid, parentId)", dataGraph);
        }
        return dataGraph;
    }

    public static DataGraph updateMember(Member member) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "updateMember(member)", "(" + member + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(UpdateDataGraphAssembler.getInstance(member));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "updateMember(member)", dataGraph);
        }
        return dataGraph;
    }

    public static DataGraph removeMember(MemberIdentifier memberIdentifier, boolean bl) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "remove(memberId, removeDescendants)", "(" + memberIdentifier + ", " + bl + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(DeleteDataGraphAssembler.getInstance(memberIdentifier, bl));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "remove(memberId, removeDescendants)");
        }
        return dataGraph;
    }

    public static DataGraph renameMember(MemberIdentifier memberIdentifier, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "renameMember(memberId, newMemberRDNvalue)", "(" + memberIdentifier + ", " + string + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(UpdateDataGraphAssembler.getInstance(memberIdentifier, string));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "renameMember(memberId, newMemberRDNvalue)");
        }
        return dataGraph;
    }

    public static DataGraph search(short s, SearchCriteria searchCriteria, StringSet stringSet, int n, int n2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "search( memberType, searchCriteria, resultAttributes, searchTimeOut, maxSearchResults )");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(SearchDataGraphAssembler.getInstance((short)27, s, searchCriteria, null, null, stringSet, n, n2));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "search( memberType, searchCriteria, resultAttributes, searchTimeOut, maxSearchResults )");
        }
        return dataGraph;
    }

    public static DataGraph searchAgain(PageControl pageControl) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "searchAgain( pageCtrl )");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(SearchDataGraphAssembler.getInstance((short)27, pageControl));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "searchAgain( pageCtrl )");
        }
        return dataGraph;
    }

    public static DataGraph search(short s, SearchCriteria searchCriteria, SortControl sortControl, PageControl pageControl, StringSet stringSet, int n, int n2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "search( memberType, searchCriteria, sortControl, pageControl, resultAttributes, timeOut, maxResults )");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(SearchDataGraphAssembler.getInstance((short)27, s, searchCriteria, sortControl, pageControl, stringSet, n, n2));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "search( memberType, searchCriteria, sortControl, pageControl, resultAttributes, timeOut, maxResults )");
        }
        return dataGraph;
    }

    public static DataGraph checkPassword(String string, String string2, StringSet stringSet, StringSet stringSet2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getLoginDataGraph( userSecurityName, password, searchBases, requestedAttributes )");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(LoginDataGraphAssembler.getInstance(string, string2, stringSet, stringSet2));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getLoginDataGraph( userSecurityName, password, searchBases, requestedAttributes )");
        }
        return dataGraph;
    }

    public static DataGraph mapCertificate(X509Certificate[] x509CertificateArray, StringSet stringSet) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getLoginDataGraph( userSecurityName, password, searchBases, requestedAttributes )", "(" + x509CertificateArray + ", " + stringSet + ")");
        }
        DataGraphAssembler dataGraphAssembler = new DataGraphAssembler(LoginDataGraphAssembler.getInstance(x509CertificateArray, stringSet));
        DataGraph dataGraph = (DataGraph)dataGraphAssembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getLoginDataGraph( userSecurityName, password, searchBases, requestedAttributes )");
        }
        return dataGraph;
    }
}

