/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.util;

import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wmm.configuration.ProfileRepository;
import com.ibm.ws.wim.bridge.wmm.configuration.ProfileRepositoryImpl;
import commonj.sdo.DataObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WMMConfigSimulator {
    private static final String CLASSNAME = WMMConfigSimulator.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final String PROP_ADAPTER_VERSION = "adapterVersion";
    private static final String PROP_VENDOR = "vendor";
    private static final String PROP_SPEC_VERSION = "specVersion";
    private static final String PROP_SUPPORT_TRANSACTION = "supportTransaction";
    private static final String PROP_CONFIG_FILE = "configurationFile";
    private static final String PROP_ADMIN_ID = "adminId";
    private static final String PROP_ADMIN_PASSWORD = "adminPassword";
    private static final String PROP_GENERATE_EXT_ID = "generateExtId";
    private static Map wmmReposCfgSet = new HashMap();

    public static ProfileRepository getWmmProfileRepositoryConfiguration(DataObject dataObject) {
        ProfileRepository profileRepository;
        String string;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getWmmProfileRepositoryConfiguration(configNode)");
        }
        if (!wmmReposCfgSet.containsKey(string = dataObject.getString("id"))) {
            profileRepository = new ProfileRepositoryImpl();
            profileRepository.setRepositoryUUID(string);
            profileRepository.setAdapterClassName(dataObject.getString("WMMAdapterClassName"));
            List list = dataObject.getList("CustomProperties");
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    DataObject dataObject2 = (DataObject)list.get(i);
                    String string2 = dataObject2.getString("name");
                    String string3 = dataObject2.getString("value");
                    if (trcLogger.isLoggable(Level.FINER)) {
                        trcLogger.logp(Level.FINER, CLASSNAME, "getWmmProfileRepositoryConfiguration(configNode)", "add property [" + string2 + ", " + string3 + "]");
                    }
                    profileRepository.setProperty(string2, string3);
                    if (string2.equals(PROP_ADAPTER_VERSION)) {
                        profileRepository.setAdapterVersion(string3);
                        continue;
                    }
                    if (string2.equals(PROP_ADMIN_ID)) {
                        profileRepository.setAdminId(string3);
                        continue;
                    }
                    if (string2.equals(PROP_ADMIN_PASSWORD)) {
                        profileRepository.setAdminPassword(string3);
                        continue;
                    }
                    if (string2.equals(PROP_CONFIG_FILE)) {
                        profileRepository.setConfigurationFile(string3);
                        continue;
                    }
                    if (string2.equals(PROP_GENERATE_EXT_ID)) {
                        profileRepository.setGenerateExtId(new Boolean(string3));
                        continue;
                    }
                    if (string2.equals(PROP_SPEC_VERSION)) {
                        profileRepository.setSpecVersion(string3);
                        continue;
                    }
                    if (!string2.equals(PROP_VENDOR)) continue;
                    profileRepository.setVendor(string3);
                }
            }
            wmmReposCfgSet.put(string, profileRepository);
        }
        profileRepository = (ProfileRepository)wmmReposCfgSet.get(string);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getWmmProfileRepositoryConfiguration(configNode)", profileRepository);
        }
        return profileRepository;
    }

    private static List getConfigList(DataObject dataObject, String string) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getConfigList(configNode, elementName)", "(" + string + ")");
        }
        List list = null;
        DataObject dataObject2 = dataObject.getDataObject(string);
        if (dataObject2 != null) {
            list = dataObject2.getList("entityTypeName");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getConfigList(configNode, elementName)", list);
        }
        return list;
    }
}

