/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.xpath;

import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.xpath.mapping.datatype.LogicalNode;
import com.ibm.ws.wim.xpath.mapping.datatype.ParenthesisNode;
import com.ibm.ws.wim.xpath.mapping.datatype.PropertyNode;
import com.ibm.ws.wim.xpath.mapping.datatype.XPathNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Interpreter {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = Interpreter.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private final String AND = "AND";
    private final String OR = "OR";
    private XPathNode node = null;

    public Interpreter(XPathNode xPathNode) {
        this.node = xPathNode;
    }

    public Map run() throws WIMException {
        HashMap hashMap = new HashMap();
        this.interprete(this.node, hashMap);
        return hashMap;
    }

    private void interprete(XPathNode xPathNode, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.entering(CLASSNAME, "interprete(inputNode,sCriteria)");
        }
        if (xPathNode == null) {
            if (bl) {
                trcLogger.logp(Level.FINER, CLASSNAME, "interprete(inputNode,sCriteria)", "inputNode==null.");
            }
        } else if (xPathNode instanceof ParenthesisNode) {
            this.interprete((XPathNode)((ParenthesisNode)xPathNode).getChild(), map);
        } else if (xPathNode instanceof PropertyNode) {
            PropertyNode propertyNode;
            String string;
            if (bl) {
                trcLogger.logp(Level.FINER, CLASSNAME, "interprete(inputNode,sCriteria)", "inputNode is PropertyNode.");
            }
            if (!map.containsKey(string = (propertyNode = (PropertyNode)xPathNode).getName())) {
                Vector<PropertyNode> vector = new Vector<PropertyNode>();
                vector.add(propertyNode);
                map.put(string, vector);
            } else {
                Vector vector = (Vector)map.get(string);
                vector.add(propertyNode);
                map.put(string, vector);
            }
        } else if (xPathNode instanceof LogicalNode) {
            if (bl) {
                trcLogger.logp(Level.FINER, CLASSNAME, "interprete(inputNode,sCriteria)", "inputNode is LogicNode.");
            }
            LogicalNode logicalNode = (LogicalNode)xPathNode;
            String string = logicalNode.getOperator();
            Set set = this.getProperties((XPathNode)logicalNode.getLeftChild());
            Set set2 = this.getProperties((XPathNode)logicalNode.getRightChild());
            if (set == null || set2 == null) {
                throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("retrieved properties set is null for eith lChild or rChild."), CLASSNAME, "interprete(inputNode,sCriteria)");
            }
            HashSet hashSet = new HashSet(set);
            if (string.equalsIgnoreCase("AND")) {
                set.retainAll(set2);
                if (set.isEmpty()) {
                    this.interprete((XPathNode)logicalNode.getLeftChild(), map);
                    this.interprete((XPathNode)logicalNode.getRightChild(), map);
                } else {
                    if (set.size() > 1 || hashSet.size() > 1) {
                        throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("invalid search expression [expression for one properties should be grouped together in order to convert to WMM search criteria. ]."), CLASSNAME, "interprete(inputNode,sCriteria)");
                    }
                    this.interprete((XPathNode)logicalNode.getLeftChild(), map);
                    this.interprete((XPathNode)logicalNode.getRightChild(), map);
                    String string2 = (String)set.iterator().next();
                    if (!map.containsKey(string2)) {
                        Vector<String> vector = new Vector<String>();
                        vector.add("AND");
                        map.put(string2, vector);
                    } else {
                        Vector vector = (Vector)map.get(string2);
                        vector.add("AND");
                        map.put(string2, vector);
                    }
                }
            } else {
                if (set.size() != 1 || set2.size() != 1) {
                    throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("invalid search expression [multiple attribute search expression for left or right child of 'OR' operator. ]."), CLASSNAME, "interprete(inputNode,sCriteria)");
                }
                set.retainAll(set2);
                if (set.isEmpty()) {
                    throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("invalid search expression [different property search expression for 'OR' children]."), CLASSNAME, "interprete(inputNode,sCriteria)");
                }
                this.interprete((XPathNode)logicalNode.getLeftChild(), map);
                this.interprete((XPathNode)logicalNode.getRightChild(), map);
                String string3 = (String)set.iterator().next();
                if (!map.containsKey(string3)) {
                    Vector<String> vector = new Vector<String>();
                    vector.add("OR");
                    map.put(string3, vector);
                } else {
                    Vector vector = (Vector)map.get(string3);
                    vector.add("OR");
                    map.put(string3, vector);
                }
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "interprete(inputNode,sCriteria)");
        }
    }

    private int getPropertiesCount(XPathNode xPathNode) {
        int n = 0;
        Set set = this.getProperties(xPathNode);
        if (set != null) {
            n = set.size();
        }
        return n;
    }

    private Set getProperties(XPathNode xPathNode) {
        HashSet<String> hashSet = null;
        if (xPathNode == null) {
            hashSet = null;
        } else if (xPathNode instanceof ParenthesisNode) {
            hashSet = this.getProperties((XPathNode)((ParenthesisNode)xPathNode).getChild());
        } else if (xPathNode instanceof PropertyNode) {
            hashSet = new HashSet<String>();
            hashSet.add(((PropertyNode)xPathNode).getName());
        } else if (xPathNode instanceof LogicalNode) {
            hashSet = new HashSet();
            hashSet.addAll(this.getProperties((XPathNode)((LogicalNode)xPathNode).getLeftChild()));
            hashSet.addAll(this.getProperties((XPathNode)((LogicalNode)xPathNode).getRightChild()));
        }
        return hashSet;
    }
}

