/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.wim.exception.InitializationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.security.authz.Entitlement;
import com.ibm.websphere.wim.util.SDOUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.management.DynamicReloadManager;
import com.ibm.ws.wim.security.authz.ProfileSecurityManager;
import com.ibm.ws.wim.util.DataGraphHelper;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;

public class ConfigSessionManager {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = ConfigSessionManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static ConfigSessionManager singleton = null;
    private static ConfigManager configManager = null;
    private static String wimConfigXMLFilePath = null;
    private static String configPathInCell = null;
    private static String configXMLFileRelativePath = "wim/config/wimconfig.xml";
    private static Map configDOCache = Collections.synchronizedMap(new HashMap());
    private static Map configContextCache = Collections.synchronizedMap(new HashMap());
    private static Map configWorkspaceCache = Collections.synchronizedMap(new HashMap());

    private ConfigSessionManager() throws WIMException {
        configManager = ConfigManager.singleton();
        wimConfigXMLFilePath = configManager.getWIMConfigXMLFilePath();
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "<init>", "wimConfigXMLFilePath=" + wimConfigXMLFilePath + ", configXMLFileRelativePath=" + configXMLFileRelativePath);
        }
    }

    public static synchronized ConfigSessionManager singleton() throws WIMException {
        if (singleton == null) {
            singleton = new ConfigSessionManager();
        }
        return singleton;
    }

    public synchronized void resetConfig(String string) throws Exception {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "resetConfig", "sessionId=" + string);
        }
        this.clearCaches(string);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "resetConfig");
        }
    }

    private DataGraph loadLatestConfigFromXML(String string) throws WIMException {
        EDataGraph eDataGraph = null;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "loadLatestConfigFromXML", "xmlFilePath=" + string);
        }
        long l = System.currentTimeMillis();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            HashMap hashMap = new HashMap();
            eDataGraph = SDOUtil.loadDataGraph((InputStream)fileInputStream, hashMap);
            if (trcLogger.isLoggable(Level.FINER)) {
                long l2 = System.currentTimeMillis();
                trcLogger.logp(Level.FINER, CLASSNAME, "loadLatestConfigFromXML", "Loaded from " + string + " (" + (l2 - l) + " milliseconds)");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InitializationException("WIM_CONFIG_XML_FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "loadLatestConfigFromXML", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new InitializationException("INVALID_WIM_CONFIG_XML_FILE", WIMMessageHelper.generateMsgParms(string, iOException.getMessage()), CLASSNAME, "loadLatestConfigFromXML", (Throwable)iOException);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "loadLatestConfigFromXML");
        }
        return eDataGraph;
    }

    private void clearCaches(String string) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "clearCaches", "sessionId=" + string);
        }
        configDOCache.remove(string);
        configContextCache.remove(string);
        configWorkspaceCache.remove(string);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "clearCaches");
        }
    }

    private void validateWorkspace(String string, String string2) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateWorkspace", "sessionId=" + string2);
        }
        boolean bl = true;
        WorkSpace workSpace = (WorkSpace)configWorkspaceCache.get(string2);
        if (workSpace != null) {
            try {
                workSpace.checkValid();
            }
            catch (Exception exception) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "validateWorkspace", "invalid workspace for sessionId=" + string2 + ", method=" + string);
                }
                bl = false;
                this.clearCaches(string2);
            }
            RepositoryContext repositoryContext = (RepositoryContext)configContextCache.get(string2);
            if (repositoryContext != null) {
                repositoryContext.getAllList(false);
                if (repositoryContext.isExtracted(configXMLFileRelativePath)) {
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.logp(Level.FINE, CLASSNAME, "validateWorkspace", "Config is still extracted for sessionId=" + string2 + ", method=" + string);
                    }
                } else {
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.logp(Level.FINE, CLASSNAME, "validateWorkspace", "Config is NOT extracted for sessionId=" + string2 + ", method=" + string);
                    }
                    bl = false;
                    this.clearCaches(string2);
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateWorkspace", "valid=" + bl);
        }
    }

    public synchronized ConfigurationProviderType getConfig(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getConfig", "sessionId=" + string);
        }
        ProfileSecurityManager profileSecurityManager = ProfileSecurityManager.singleton();
        profileSecurityManager.checkPermission_SuperUser(new Entitlement("GET", "CONFIGURATION"));
        this.validateWorkspace("getConfig", string);
        ConfigurationProviderType configurationProviderType = (ConfigurationProviderType)configDOCache.get(string);
        if (configurationProviderType == null) {
            DataGraph dataGraph = this.loadLatestConfigFromXML(wimConfigXMLFilePath);
            if (dataGraph != null) {
                configurationProviderType = (ConfigurationProviderType)dataGraph.getRootObject().getDataObject("configurationProvider");
                configDOCache.put(string, configurationProviderType);
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "getConfig", "new session, added to cache");
                }
            } else if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.logp(Level.FINE, CLASSNAME, "getConfig", "Config XML could not be read.");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getConfig");
        }
        return configurationProviderType;
    }

    public synchronized String saveConfig(String string, boolean bl) throws Exception {
        Object object;
        boolean bl2 = trcLogger.isLoggable(Level.FINER);
        if (bl2) {
            trcLogger.entering(CLASSNAME, "saveConfig(sessionId,validate)", "sessionId=" + string + ", validate=" + bl);
        }
        ProfileSecurityManager profileSecurityManager = ProfileSecurityManager.singleton();
        profileSecurityManager.checkPermission_SuperUser(new Entitlement("UPDATE", "CONFIGURATION"));
        this.validateWorkspace("saveConfig(sessionId,validate)", string);
        String string2 = "CONFIG_SAVED_IN_WORKSPACE";
        DataObject dataObject = (DataObject)this.getConfig(string);
        RepositoryContext repositoryContext = (RepositoryContext)configContextCache.get(string);
        if (configPathInCell == null) {
            configPathInCell = "cells/" + DynamicReloadManager.getCellName() + "/" + "wim" + "/" + "config";
            if (bl2) {
                trcLogger.logp(Level.FINER, CLASSNAME, "saveConfig(sessionId,validate)", "configPathInCell=" + configPathInCell);
            }
        }
        if (repositoryContext == null) {
            if (bl2) {
                trcLogger.logp(Level.FINER, CLASSNAME, "saveConfig(sessionId,validate)", "context is null, load the file in workspace and get the context");
            }
            object = WorkSpaceManagerFactory.getManager().getWorkSpace(string);
            repositoryContext = object.findContext(configPathInCell);
            if (bl2) {
                trcLogger.logp(Level.FINER, CLASSNAME, "saveConfig(sessionId,validate)", "contextPath=" + repositoryContext.getPath());
            }
            if (repositoryContext.isAvailable(configXMLFileRelativePath)) {
                if (bl2) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "saveConfig(sessionId,validate)", "config file " + configXMLFileRelativePath + " is available");
                }
            } else {
                throw new WIMException("WIM_CONFIG_XML_FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(configXMLFileRelativePath), CLASSNAME, "saveConfig(sessionId,validate)");
            }
            repositoryContext.extract(configXMLFileRelativePath, false);
            configContextCache.put(string, repositoryContext);
            configWorkspaceCache.put(string, object);
        }
        if (repositoryContext != null && dataObject != null) {
            try {
                configManager.encodePasswords(dataObject);
                SDOUtils.validateDataObject(dataObject);
            }
            catch (WIMException wIMException) {
                if (!bl) {
                    string2 = "CONFIG_NOT_COMPLETE";
                    if (bl2) {
                        trcLogger.logp(Level.FINER, CLASSNAME, "saveConfig(sessionId,validate)", "config file is not valid: " + wIMException.getMessage());
                    }
                }
                throw wIMException;
            }
            object = repositoryContext.getPath() + File.separator + configXMLFileRelativePath;
            if (bl2) {
                trcLogger.logp(Level.FINER, CLASSNAME, "saveConfig(sessionId,validate)", "saving the config file " + (String)object);
            }
            DataGraphHelper.saveDataGraph(dataObject.getDataGraph(), (String)object);
            repositoryContext.notifyChanged(1, configXMLFileRelativePath);
            if (bl2) {
                List list = repositoryContext.getModifiedList(true);
                if (list.size() > 0) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        trcLogger.logp(Level.FINER, CLASSNAME, "saveConfig(sessionId,validate)", "Status changed for file " + iterator.next().toString());
                    }
                } else {
                    trcLogger.logp(Level.FINER, CLASSNAME, "saveConfig(sessionId,validate)", "No Resources are modified.");
                }
            }
        }
        this.validateAndClearCaches();
        if (bl2) {
            trcLogger.exiting(CLASSNAME, "saveConfig(sessionId,validate)", "retKey=" + string2 + ", updated=" + (dataObject != null));
        }
        return string2;
    }

    private void validateAndClearCaches() {
        trcLogger.entering(CLASSNAME, "validateAndClearCaches");
        trcLogger.logp(Level.FINEST, CLASSNAME, "validateAndClearCaches", "configWorkspaceCache = " + configWorkspaceCache);
        trcLogger.logp(Level.FINEST, CLASSNAME, "validateAndClearCaches", "Number of active sessions = " + configWorkspaceCache.size());
        for (String string : new HashSet(configWorkspaceCache.keySet())) {
            this.validateWorkspace("validateAndClearCaches", string);
        }
        trcLogger.exiting(CLASSNAME, "validateAndClearCaches");
    }
}

