/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.wim.ConfigUIConstants;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.security.util.WSEncoderDecoder;
import com.ibm.ws.wim.config.ConfigSessionManager;
import com.ibm.ws.wim.configmodel.AttributesCacheType;
import com.ibm.ws.wim.configmodel.CacheConfigurationType;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.ContextPoolType;
import com.ibm.ws.wim.configmodel.DatabaseRepositoryType;
import com.ibm.ws.wim.configmodel.EntryMappingRepositoryType;
import com.ibm.ws.wim.configmodel.FileRepositoryType;
import com.ibm.ws.wim.configmodel.LdapRepositoryType;
import com.ibm.ws.wim.configmodel.ParticipatingBaseEntriesType;
import com.ibm.ws.wim.configmodel.ProfileRepositoryType;
import com.ibm.ws.wim.configmodel.PropertyExtensionRepositoryType;
import com.ibm.ws.wim.configmodel.RealmConfigurationType;
import com.ibm.ws.wim.configmodel.RealmType;
import com.ibm.ws.wim.configmodel.RepositoryType;
import com.ibm.ws.wim.configmodel.SearchResultsCacheType;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigUtils
implements ConfigUIConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = ConfigUtils.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public static ConfigurationProviderType getConfigProvider(String string) throws WIMException {
        return ConfigSessionManager.singleton().getConfig(string);
    }

    public static String saveConfig(String string) throws WIMException {
        try {
            return ConfigSessionManager.singleton().saveConfig(string, false);
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMException(exception.getLocalizedMessage(), exception);
        }
    }

    public static void resetConfig(String string) throws WIMException {
        try {
            ConfigSessionManager.singleton().resetConfig(string);
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMException(exception.getLocalizedMessage(), exception);
        }
    }

    public static List getProfileRepositories(ConfigurationProviderType configurationProviderType) {
        ArrayList<RepositoryType> arrayList = new ArrayList<RepositoryType>();
        List list = configurationProviderType.getRepositories();
        for (int i = 0; i < list.size(); ++i) {
            RepositoryType repositoryType = (RepositoryType)list.get(i);
            if (repositoryType instanceof PropertyExtensionRepositoryType || repositoryType instanceof EntryMappingRepositoryType) continue;
            arrayList.add(repositoryType);
        }
        return arrayList;
    }

    public static List getProfileRepositories(String string) throws WIMException {
        return ConfigUtils.getProfileRepositories(ConfigUtils.getConfigProvider(string));
    }

    public static RepositoryType getRepositoryById(ConfigurationProviderType configurationProviderType, String string, boolean bl) throws WIMException {
        String string2 = "getRepositoryById";
        RepositoryType repositoryType = null;
        List list = configurationProviderType.getRepositories();
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            RepositoryType repositoryType2 = (RepositoryType)list.get(i);
            if (!repositoryType2.getId().equals(string)) continue;
            repositoryType = repositoryType2;
            break;
        }
        if (repositoryType == null && bl) {
            throw new WIMConfigurationException("INVALID_REPOSITORY_ID", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2);
        }
        return repositoryType;
    }

    public static RepositoryType getRepositoryById(ConfigurationProviderType configurationProviderType, String string) throws WIMException {
        return ConfigUtils.getRepositoryById(configurationProviderType, string, true);
    }

    public static RepositoryType getRepositoryByIdIncludeLAandFED(String string, String string2) throws WIMException {
        ConfigurationProviderType configurationProviderType = ConfigUtils.getConfigProvider(string);
        RepositoryType repositoryType = null;
        if ("FED".equals(string2)) {
            repositoryType = configurationProviderType.getEntryMappingRepository();
            if (repositoryType == null) {
                throw new WIMConfigurationException("INVALID_REPOSITORY_ID", WIMMessageHelper.generateMsgParms(string2), Level.FINE, CLASSNAME, "getRepositoryByIdIncludeLAandFED");
            }
        } else if ("LA".equals(string2)) {
            repositoryType = configurationProviderType.getPropertyExtensionRepository();
            if (repositoryType == null) {
                throw new WIMConfigurationException("INVALID_REPOSITORY_ID", WIMMessageHelper.generateMsgParms(string2), Level.FINE, CLASSNAME, "getRepositoryByIdIncludeLAandFED");
            }
        } else {
            repositoryType = ConfigUtils.getRepositoryById(string, string2);
        }
        return repositoryType;
    }

    public static RepositoryType getRepositoryById(String string, String string2, boolean bl) throws WIMException {
        return ConfigUtils.getRepositoryById(ConfigUtils.getConfigProvider(string), string2, bl);
    }

    public static RepositoryType getRepositoryById(String string, String string2) throws WIMException {
        return ConfigUtils.getRepositoryById(ConfigUtils.getConfigProvider(string), string2, true);
    }

    public static RepositoryType validateAndGetRepository(ConfigurationProviderType configurationProviderType, String string, String string2) throws WIMException {
        String string3;
        String string4 = "validateAndGetRepository";
        RepositoryType repositoryType = ConfigUtils.getRepositoryById(configurationProviderType, string);
        if (string2 != null && !(string3 = ((DataObject)repositoryType).getType().getName()).equals(string2)) {
            throw new WIMConfigurationException("INVALID_REPOSITORY_ID", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string4);
        }
        return repositoryType;
    }

    public static RepositoryType validateAndGetRepository(String string, String string2, String string3) throws WIMException {
        return ConfigUtils.validateAndGetRepository(ConfigUtils.getConfigProvider(string), string2, string3);
    }

    public static void checkForValidRepositoryById(String string, String string2) throws WIMException {
        String string3 = "checkForValidRepositoryById";
        RepositoryType repositoryType = ConfigUtils.getRepositoryById(string, string2, false);
        if (repositoryType != null) {
            throw new WIMConfigurationException("REPOSITORY_ID_ALREADY_EXISTS", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, string3);
        }
        for (int i = 0; i < RESERVED_REPOSITORY_IDS.length; ++i) {
            if (!RESERVED_REPOSITORY_IDS[i].equals(string2)) continue;
            throw new WIMConfigurationException("REPOSITORY_ID_RESERVED", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, string3);
        }
    }

    public static Object getParamValue(Map map, Map map2, String string, boolean bl) {
        Object v = map.get(string);
        if (!bl && v == null) {
            v = map2.get(string);
        }
        return v;
    }

    public static void setCommonRepositoryProperties(ProfileRepositoryType profileRepositoryType, Map map, Map map2, boolean bl) throws WIMException {
        Object object = ConfigUtils.getParamValue(map, map2, "adapterClassName", bl);
        if (object != null) {
            profileRepositoryType.setAdapterClassName((String)object);
        }
        if ((object = ConfigUtils.getParamValue(map, map2, "supportPaging", bl)) != null) {
            profileRepositoryType.setSupportPaging((Boolean)object);
        }
        if ((object = ConfigUtils.getParamValue(map, map2, "supportSorting", bl)) != null) {
            profileRepositoryType.setSupportSorting((Boolean)object);
        }
        if ((object = ConfigUtils.getParamValue(map, map2, "supportTransactions", bl)) != null) {
            profileRepositoryType.setSupportTransactions((Boolean)object);
        }
        if ((object = ConfigUtils.getParamValue(map, map2, "isExtIdUnique", bl)) != null) {
            profileRepositoryType.setIsExtIdUnique((Boolean)object);
        }
        if ((object = ConfigUtils.getParamValue(map, map2, "supportExternalName", bl)) != null) {
            profileRepositoryType.setSupportExternalName((Boolean)object);
        }
        if ((object = ConfigUtils.getParamValue(map, map2, "supportAsyncMode", bl)) != null) {
            profileRepositoryType.setSupportAsyncMode((Boolean)object);
        }
    }

    public static RealmConfigurationType getOrCreateRealmConfig(String string) throws Exception {
        ConfigurationProviderType configurationProviderType = ConfigUtils.getConfigProvider(string);
        RealmConfigurationType realmConfigurationType = configurationProviderType.getRealmConfiguration();
        if (realmConfigurationType == null) {
            realmConfigurationType = configurationProviderType.createRealmConfiguration();
        }
        return realmConfigurationType;
    }

    public static ContextPoolType getOrCreateContextPool(LdapRepositoryType ldapRepositoryType) throws WIMException {
        ContextPoolType contextPoolType = ldapRepositoryType.getContextPool();
        if (contextPoolType == null) {
            contextPoolType = ldapRepositoryType.createContextPool();
        }
        return contextPoolType;
    }

    public static CacheConfigurationType getOrCreateCacheConfiguration(LdapRepositoryType ldapRepositoryType) throws WIMException {
        CacheConfigurationType cacheConfigurationType = ldapRepositoryType.getCacheConfiguration();
        if (cacheConfigurationType == null) {
            cacheConfigurationType = ldapRepositoryType.createCacheConfiguration();
        }
        return cacheConfigurationType;
    }

    public static AttributesCacheType getOrCreateAttributesCache(LdapRepositoryType ldapRepositoryType) throws WIMException {
        CacheConfigurationType cacheConfigurationType = ConfigUtils.getOrCreateCacheConfiguration(ldapRepositoryType);
        AttributesCacheType attributesCacheType = cacheConfigurationType.getAttributesCache();
        if (attributesCacheType == null) {
            attributesCacheType = cacheConfigurationType.createAttributesCache();
        }
        return attributesCacheType;
    }

    public static SearchResultsCacheType getOrCreateSearchResultsCache(LdapRepositoryType ldapRepositoryType) throws WIMException {
        CacheConfigurationType cacheConfigurationType = ConfigUtils.getOrCreateCacheConfiguration(ldapRepositoryType);
        SearchResultsCacheType searchResultsCacheType = cacheConfigurationType.getSearchResultsCache();
        if (searchResultsCacheType == null) {
            searchResultsCacheType = cacheConfigurationType.createSearchResultsCache();
        }
        return searchResultsCacheType;
    }

    public static RealmConfigurationType getRealmConfig(String string) throws WIMException {
        String string2 = "getRealmConfig";
        ConfigurationProviderType configurationProviderType = ConfigSessionManager.singleton().getConfig(string);
        RealmConfigurationType realmConfigurationType = configurationProviderType.getRealmConfiguration();
        if (realmConfigurationType == null) {
            throw new WIMConfigurationException("MISSING_REALM_CONFIGURATION", Level.SEVERE, CLASSNAME, string2);
        }
        return realmConfigurationType;
    }

    public static RealmType getRealm(String string, RealmConfigurationType realmConfigurationType, boolean bl) throws WIMException {
        String string2 = "getRealm";
        RealmType realmType = null;
        List list = realmConfigurationType.getRealms();
        for (int i = 0; i < list.size(); ++i) {
            RealmType realmType2 = (RealmType)list.get(i);
            if (!string.equals(realmType2.getName())) continue;
            realmType = realmType2;
            break;
        }
        if (realmType == null && bl) {
            throw new WIMConfigurationException("INVALID_REALM_NAME", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2);
        }
        return realmType;
    }

    public static RealmType getRealm(String string, RealmConfigurationType realmConfigurationType) throws WIMException {
        return ConfigUtils.getRealm(string, realmConfigurationType, true);
    }

    public static ParticipatingBaseEntriesType getBaseEntryInRealm(String string, RealmType realmType) throws WIMException {
        String string2 = "getBaseEntryInRealm";
        ParticipatingBaseEntriesType participatingBaseEntriesType = null;
        List list = realmType.getParticipatingBaseEntries();
        for (int i = 0; i < list.size(); ++i) {
            ParticipatingBaseEntriesType participatingBaseEntriesType2 = (ParticipatingBaseEntriesType)list.get(i);
            if (!string.equals(participatingBaseEntriesType2.getName())) continue;
            participatingBaseEntriesType = participatingBaseEntriesType2;
            break;
        }
        if (participatingBaseEntriesType == null) {
            throw new WIMConfigurationException("BASE_ENTRY_NOT_FOUND_IN_REALM", WIMMessageHelper.generateMsgParms(string, realmType.getName()), Level.SEVERE, CLASSNAME, string2);
        }
        return participatingBaseEntriesType;
    }

    public static List convertEList(List list) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        return arrayList;
    }

    public static List convertArrayToList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public static void addOrRemovePresentList(String string, List list, List list2) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.logp(Level.FINER, CLASSNAME, "addOrRemovePresentList", "elementName=" + string + ", valueList=" + list);
            trcLogger.logp(Level.FINER, CLASSNAME, "addOrRemovePresentList", "presentList=" + list2);
        }
        if (list != null) {
            if (list.size() == 0) {
                trcLogger.logp(Level.FINER, CLASSNAME, "addOrRemovePresentList", "deleting all values.");
                list2.clear();
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    String string2 = (String)list.get(i);
                    if (list2.contains(string2)) continue;
                    trcLogger.logp(Level.FINER, CLASSNAME, "addOrRemovePresentList", "adding " + string2 + " to " + string);
                    list2.add(string2);
                }
            }
        }
    }

    public static boolean buildMapFromOldAndNewValues(Map map, String[] stringArray, DataObject dataObject, Map map2) {
        int n;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (!map2.containsKey(stringArray[n])) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (n = 0; n < stringArray.length; ++n) {
                String string = stringArray[n];
                if (map2.containsKey(string)) {
                    map.put(string, map2.get(string));
                    continue;
                }
                if (!dataObject.isSet(string)) continue;
                map.put(string, dataObject.get(string));
            }
        }
        return bl;
    }

    public static String getRepositoryType(RepositoryType repositoryType) {
        if (repositoryType instanceof LdapRepositoryType) {
            return "LdapRepositoryType";
        }
        if (repositoryType instanceof FileRepositoryType) {
            return "FileRepositoryType";
        }
        if (repositoryType instanceof DatabaseRepositoryType) {
            return "DatabaseRepositoryType";
        }
        if (repositoryType instanceof PropertyExtensionRepositoryType) {
            return "propertyExtensionRepository";
        }
        if (repositoryType instanceof EntryMappingRepositoryType) {
            return "entryMappingRepository";
        }
        return repositoryType.getClass().getName();
    }

    protected static String encodePassword(String string) {
        if (string != null && !string.equals("")) {
            WSEncoderDecoder wSEncoderDecoder = new WSEncoderDecoder();
            return wSEncoderDecoder.encode(string);
        }
        return string;
    }
}

