/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.wim.ConfigConstants;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.ws.security.util.WSEncoderDecoder;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.file.was.FileUtils;
import com.ibm.ws.wim.adapter.ldap.LdapConnectionBase;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.config.ValidationHelper;
import com.ibm.ws.wim.configmodel.BaseEntriesType;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.ParticipatingBaseEntriesType;
import com.ibm.ws.wim.configmodel.ProfileRepositoryType;
import com.ibm.ws.wim.configmodel.RealmConfigurationType;
import com.ibm.ws.wim.configmodel.RealmType;
import com.ibm.ws.wim.configmodel.RepositoryType;
import com.ibm.ws.wim.dao.DAOHelper;
import com.sun.jndi.ldap.LdapName;
import commonj.sdo.Property;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.InitialLdapContext;

public class ConfigValidator
implements ConfigConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    private static final String CLASSNAME = ConfigValidator.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static boolean validate = true;
    private static final String WIM_CONFIG_VALIDATION = "wim.config.validation";
    protected static final String[] DB_CONNECTION_PARAMS = new String[]{"dataSourceName", "databaseType", "dbURL", "dbAdminId", "dbAdminPassword", "JDBCDriverClass"};
    protected static final String[] LDAP_CONNECTION_PARAMS = new String[]{"host", "port", "bindDN", "bindPassword", "authentication", "sslEnabled"};

    public static void validateRepositoryParams(String string, String string2, Map map) throws WIMConfigurationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateRepositoryParams", "id=" + string + ", type=" + string2 + ", params=" + WIMTraceHelper.printMapWithoutPassword(map));
        }
        if (!ConfigValidator.validateConfig()) {
            return;
        }
        if (string.contains("<") || string.contains("&") || string.contains(">") || string.contains("\"") || string.contains("'")) {
            throw new WIMConfigurationException("INVALID_REPOSITORY_ID", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "validateRepositoryParams");
        }
        ConfigValidator.validateLoginProperties((List)map.get("loginProperties"));
        String string3 = (String)map.get("adapterClassName");
        if (string3 != null) {
            try {
                Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WIMConfigurationException("MISSING_OR_INVALID_ADAPTER_CLASS_NAME", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, "validateRepositoryParams", (Throwable)classNotFoundException);
            }
        }
        if ("DatabaseRepositoryType".equals(string2) || "propertyExtensionRepository".equals(string2) || "entryMappingRepository".equals(string2)) {
            ConfigValidator.validateDBParams(string, map);
        } else if ("FileRepositoryType".equals(string2)) {
            ConfigValidator.validateFileParams(string, map);
        } else if ("LdapRepositoryType".equals(string2)) {
            ConfigValidator.validateLDAPParams(string, map);
        } else if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "validateRepositoryParams", "No Validation performed for repository type=" + string2);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateRepositoryParams");
        }
    }

    public static void validateDBParams(String string, Map map) throws WIMConfigurationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateDBParams", "id=" + string + ", params=" + WIMTraceHelper.printMapWithoutPassword(map));
        }
        if (!ConfigValidator.validateConfig()) {
            return;
        }
        boolean bl = false;
        String string2 = (String)map.get("databaseType");
        ConfigValidator.validateSupportedDBType(string2);
        String string3 = (String)map.get("dataSourceName");
        String string4 = (String)map.get("dbURL");
        String string5 = (String)map.get("dbAdminId");
        String string6 = (String)map.get("dbAdminPassword");
        String string7 = (String)map.get("JDBCDriverClass");
        if (string2 != null && string3 != null && string4 != null) {
            Object object;
            try {
                if (string6 != null) {
                    object = new WSEncoderDecoder();
                    string6 = ((WSEncoderDecoder)((Object)object)).decode(string6);
                }
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "validateDBParams", "connecting to DB.");
                }
                if ((object = DAOHelper.getNewDAOClass(string2, string3, string4, string5, string6, string7)).dsLookup() != null) {
                    bl = true;
                    trcLogger.logp(Level.FINER, CLASSNAME, "validateDBParams", "the datasource was found: " + string3);
                } else {
                    trcLogger.logp(Level.FINER, CLASSNAME, "validateDBParams", "the datasource was NOT found: " + string3);
                }
                Connection connection = object.getDirectAccessConnection();
                trcLogger.logp(Level.FINER, CLASSNAME, "validateDBParams", "connected to DB using direct connection.");
                try {
                    object.closeConnection(connection);
                }
                catch (Exception exception) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "validateDBParams", "Error closing the DB direct connection:" + exception.getMessage(), exception);
                }
            }
            catch (WIMException wIMException) {
                throw new WIMConfigurationException("REPOSITORY_CONNECTION_FAILED", WIMMessageHelper.generateMsgParms(string4, WIMTraceHelper.printMapWithoutPassword(map)), CLASSNAME, "validateDBParams", (Throwable)wIMException);
            }
            if (!bl && (object = AdminServiceFactory.getAdminService()) != null) {
                trcLogger.logp(Level.FINE, CLASSNAME, "validateDBParams", "DataSource is not found in server mode");
                throw new WIMConfigurationException("REPOSITORY_CONNECTION_FAILED", WIMMessageHelper.generateMsgParms(string4, WIMTraceHelper.printMapWithoutPassword(map)), CLASSNAME, "validateDBParams");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateDBParams");
        }
    }

    public static void validateSupportedDBType(String string) throws WIMConfigurationException {
        if (!ConfigValidator.validateConfig()) {
            return;
        }
        if (string != null) {
            ValidationHelper.validateParam("databaseType", string, CONFIG_DB_SUPPORTED_TYPES);
        }
    }

    public static void validateFileParams(String string, Map map) throws WIMConfigurationException {
        Object object;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateFileParams", "id=" + string + ", params=" + map);
        }
        if (!ConfigValidator.validateConfig()) {
            return;
        }
        String string2 = (String)map.get("messageDigestAlgorithm");
        if (string2 != null) {
            try {
                object = MessageDigest.getInstance(string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new WIMConfigurationException("CONFIG_VALUE_NOT_VALID", WIMMessageHelper.generateMsgParms(string2, "messageDigestAlgorithm", WIMTraceHelper.printObjectArray(CONFIG_SUPPORTED_MDALGORITHMS)), Level.SEVERE, CLASSNAME, "validateFileParams");
            }
        }
        if ((object = (String)map.get("baseDirectory")) != null && ((String)object).trim().length() > 0 && !FileUtils.fileExists((String)object)) {
            throw new WIMConfigurationException("DIRECTORY_NOT_FOUND", WIMMessageHelper.generateMsgParms(object), Level.SEVERE, CLASSNAME, "validateFileParams");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateFileParams");
        }
    }

    public static void validateLDAPParams(String string, Map map) throws WIMConfigurationException {
        Object object;
        Object object2;
        Object object3;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateLDAPParams", "id=" + string + ", params=" + WIMTraceHelper.printMapWithoutPassword(map));
        }
        if (!ConfigValidator.validateConfig()) {
            return;
        }
        String string2 = (String)map.get("ldapServerType");
        ConfigValidator.validateLDAPServerType(string2);
        if (string2 != null) {
            ValidationHelper.validateParam("ldapServerType", string2, CONFIG_LDAP_SUPPORTED_TYPES);
        }
        Context context = null;
        String string3 = null;
        if (ConfigValidator.isParamSet(map, LDAP_CONNECTION_PARAMS)) {
            String string4;
            object3 = new Hashtable<String, String>();
            ((Hashtable)object3).put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            object2 = (String)map.get("host");
            object = (Integer)map.get("port");
            boolean bl = false;
            if (map.get("sslEnabled") != null) {
                bl = (Boolean)map.get("sslEnabled");
            }
            String string5 = null;
            string5 = bl ? "ldaps://" : "ldap://";
            string3 = object != null ? string5 + (String)object2 + ":" + object : string5 + (String)object2;
            ((Hashtable)object3).put("java.naming.provider.url", string3);
            if (bl) {
                string4 = (String)map.get("sslConfiguration");
                if (string4 != null) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "validateLDAPParams", "Use WAS SSL Configuration. sslAlias=" + string4);
                    LdapConnectionBase.setWASSSLAlias(string4, (Hashtable)object3);
                    ((Hashtable)object3).put("java.naming.ldap.factory.socket", "com.ibm.websphere.ssl.protocol.SSLSocketFactory");
                }
                ((Hashtable)object3).put("java.naming.security.protocol", "ssl");
            }
            try {
                int n;
                String string6;
                string4 = (String)map.get("bindDN");
                if (string4 != null && string4.trim().length() > 0) {
                    ((Hashtable)object3).put("java.naming.security.principal", string4);
                    string6 = (String)map.get("bindPassword");
                    if (string6 != null) {
                        if (string6 != null) {
                            WSEncoderDecoder wSEncoderDecoder = new WSEncoderDecoder();
                            string6 = wSEncoderDecoder.decode(string6);
                        }
                        ((Hashtable)object3).put("java.naming.security.credentials", PasswordUtil.getByteArrayPassword(string6));
                    }
                }
                if ((string6 = (String)map.get("authentication")) != null) {
                    ((Hashtable)object3).put("java.naming.security.authentication", string6);
                }
                int n2 = 20;
                if (map.get("connectTimeout") != null && (n = ((Integer)map.get("connectTimeout")).intValue()) > 0) {
                    n2 = n;
                }
                ((Hashtable)object3).put("com.sun.jndi.ldap.connect.timeout", Integer.toString(n2 * 1000));
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "validateLDAPParams", "connecting to LDAP with:" + object3);
                }
                context = new InitialLdapContext((Hashtable<?, ?>)object3, null);
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "validateLDAPParams", "connected to LDAP.");
                }
            }
            catch (Exception exception) {
                throw new WIMConfigurationException("REPOSITORY_CONNECTION_FAILED", WIMMessageHelper.generateMsgParms(string3, WIMTraceHelper.printMapWithoutPassword(map)), CLASSNAME, "validateLDAPParams", (Throwable)exception);
            }
            finally {
                LdapConnectionBase.resetWASSSLAlias();
            }
        }
        object3 = (String)map.get("searchFilter");
        ConfigValidator.validateSearchFilter(context, string, string3, (String)object3);
        object2 = (List)map.get("objectClasses");
        ConfigValidator.validateObjectClasses(context, string, string3, (List)object2);
        object = (List)map.get("nameInRepository");
        ConfigValidator.validateBaseEntryNameInRepository(context, string, string3, (List)object);
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINE, CLASSNAME, "validateLDAPParams", "Error closing the LDAP connection:" + exception.getMessage(), exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateLDAPParams");
        }
    }

    public static void validateLDAPServerType(String string) throws WIMConfigurationException {
        if (!ConfigValidator.validateConfig()) {
            return;
        }
        if (string != null) {
            ValidationHelper.validateParam("ldapServerType", string, CONFIG_LDAP_SUPPORTED_TYPES);
        }
    }

    public static void validateLoginProperties(List list) throws WIMConfigurationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateLoginProperties", "loginProps=" + list);
        }
        if (!ConfigValidator.validateConfig()) {
            return;
        }
        if (list != null && list.size() > 0) {
            SchemaManager schemaManager = null;
            try {
                schemaManager = SchemaManager.singleton();
            }
            catch (WIMException wIMException) {
                throw new WIMConfigurationException(wIMException.getMessageKey(), wIMException.getMessageParams(), CLASSNAME, "validateLoginProperties");
            }
            Set set = schemaManager.getSubEntityTypes("LoginAccount");
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "validateLoginProperties", "LoginAccount subtypes: " + set);
            }
            boolean bl = false;
            for (String string : set) {
                int n;
                List list2 = schemaManager.getProperties(string);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (n = 0; n < list2.size(); ++n) {
                    arrayList.add(((Property)list2.get(n)).getName());
                }
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "validateLoginProperties", "props of " + string + ":" + arrayList);
                }
                if (arrayList.contains("ibmPrimaryEmail")) {
                    arrayList.add("ibm-primaryEmail");
                } else if (arrayList.contains("ibmJobTitle")) {
                    arrayList.add("ibm-jobTitle");
                }
                n = 1;
                for (int i = 0; i < list.size(); ++i) {
                    if (arrayList.contains(list.get(i))) continue;
                    n = 0;
                    break;
                }
                if (n == 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new WIMConfigurationException("INVALID_LOGIN_PROPERTIES", WIMMessageHelper.generateMsgParms(list.toString()), CLASSNAME, "validateLoginProperties");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateLoginProperties");
        }
    }

    public static void validateDeleteIdMgrRealm(ConfigurationProviderType configurationProviderType, String string) throws WIMException {
        String string2 = "validateDeleteIdMgrRealm";
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, string2, "realmName=" + string);
        }
        if (!ConfigValidator.validateConfig()) {
            return;
        }
        RealmConfigurationType realmConfigurationType = ConfigValidator.getRealmConfig(configurationProviderType);
        String string3 = realmConfigurationType.getDefaultRealm();
        if (string.equals(string3)) {
            throw new WIMConfigurationException("CANNOT_DELETE_DEFAULT_REALM", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2);
        }
        ConfigUtils.getRealm(string, realmConfigurationType);
        List list = realmConfigurationType.getRealms();
        if (list.size() == 1) {
            throw new WIMConfigurationException("CANNOT_DELETE_ONLY_REALM", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string2);
        }
    }

    public static void validateAddIdMgrRealmBaseEntry(ConfigurationProviderType configurationProviderType, String string, String string2) throws WIMException {
        String string3 = "validateAddIdMgrRealmBaseEntry";
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, string3, "realmName=" + string + ", baseEntryName=" + string2);
        }
        if (!ConfigValidator.validateConfig()) {
            return;
        }
        if (!ConfigValidator.isDN(string2)) {
            throw new WIMConfigurationException("BASE_ENTRY_MUST_BE_DN", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, string3);
        }
        if (!ConfigValidator.isBaseEntryInRepository(configurationProviderType, string2)) {
            throw new WIMConfigurationException("BASE_ENTRY_CANNOT_BE_ADDED_TO_REALM", WIMMessageHelper.generateMsgParms(string2, string), Level.SEVERE, CLASSNAME, string3);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string3);
        }
    }

    public static void validateDeleteIdMgrRealmBaseEntry(ConfigurationProviderType configurationProviderType, String string, String string2) throws WIMException {
        String string3 = "validateDeleteIdMgrRealmBaseEntry";
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, string3, "realmName=" + string + ", baseEntryName=" + string2);
        }
        if (!ConfigValidator.validateConfig()) {
            return;
        }
        RealmConfigurationType realmConfigurationType = ConfigValidator.getRealmConfig(configurationProviderType);
        String string4 = realmConfigurationType.getDefaultRealm();
        if (string.equals(string4) && ConfigValidator.isLastBaseEntryInRealm(configurationProviderType, string, string2)) {
            throw new WIMConfigurationException("CANNOT_DELETE_ONLY_BASE_ENTRY_IN_REALM", WIMMessageHelper.generateMsgParms(string2, string), Level.SEVERE, CLASSNAME, string3);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string3);
        }
    }

    public static void validateAddIdMgrRepositoryBaseEntry(ConfigurationProviderType configurationProviderType, String string, String string2) throws WIMException {
        String string3 = "validateAddIdMgrRepositoryBaseEntry";
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, string3, "repoId=" + string + ", baseEntryName=" + string2);
        }
        if (!ConfigValidator.validateConfig()) {
            return;
        }
        if (!ConfigValidator.isDN(string2)) {
            throw new WIMConfigurationException("BASE_ENTRY_MUST_BE_DN", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, string3);
        }
        if (ConfigValidator.isBaseEntryInRepository(configurationProviderType, string2)) {
            throw new WIMConfigurationException("BASE_ENTRY_ALREADY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms(string2, string), Level.SEVERE, CLASSNAME, string3);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string3);
        }
    }

    public static void validateDeleteIdMgrRepositoryBaseEntry(ConfigurationProviderType configurationProviderType, String string, String string2) throws WIMException {
        String string3 = "validateDeleteIdMgrRepositoryBaseEntry";
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, string3, "repoId=" + string + ", baseEntryName=" + string2);
        }
        if (!ConfigValidator.validateConfig()) {
            return;
        }
        if (ConfigValidator.isLastBaseEntryInRepository(configurationProviderType, string, string2)) {
            throw new WIMConfigurationException("CANNOT_DELETE_ONLY_BASE_ENTRY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms(string2, string), Level.SEVERE, CLASSNAME, string3);
        }
        if (ConfigValidator.isBaseEntryInRealms(configurationProviderType, string2)) {
            throw new WIMConfigurationException("BASE_ENTRY_STILL_REFERENCED_BY_REALM", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, string3);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string3);
        }
    }

    public static void validateDeleteIdMgrRepository(ConfigurationProviderType configurationProviderType, String string) throws WIMException {
        String string2 = "validateDeleteIdMgrRepository";
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, string2, "repoId=" + string);
        }
        if (!ConfigValidator.validateConfig()) {
            return;
        }
        ProfileRepositoryType profileRepositoryType = (ProfileRepositoryType)ConfigUtils.getRepositoryById(configurationProviderType, string);
        List list = profileRepositoryType.getBaseEntries();
        for (int i = 0; i < list.size(); ++i) {
            BaseEntriesType baseEntriesType = (BaseEntriesType)list.get(i);
            String string3 = baseEntriesType.getName();
            if (!ConfigValidator.isBaseEntryInRealms(configurationProviderType, string3)) continue;
            throw new WIMConfigurationException("DELETE_REPOSITORY_PREREQUISITE_ERROR", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string2);
        }
    }

    public static void validateRepositoriesForGroup(ConfigurationProviderType configurationProviderType, List list) throws WIMException {
        String string = "validateRepositoriesForGroup";
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, string, "reposForGroups=" + list);
        }
        if (list != null && list.size() > 0) {
            int n;
            List list2 = ConfigUtils.getProfileRepositories(configurationProviderType);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < list2.size(); ++n) {
                arrayList.add(((RepositoryType)list2.get(n)).getId());
            }
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, string, "currentRepoIds=" + arrayList);
            }
            for (n = 0; n < list.size(); ++n) {
                String string2 = (String)list.get(n);
                if (arrayList.contains(string2)) continue;
                throw new WIMConfigurationException("INVALID_REPOSITORY_FOR_GROUPS", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, string);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }

    private static boolean isParamSet(Map map, String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!map.containsKey(stringArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean validateConfig() {
        String string = System.getProperty(WIM_CONFIG_VALIDATION);
        if (string != null && !(validate = Boolean.getBoolean(string))) {
            trcLogger.log(Level.FINER, "wim.config.validation=" + string);
            trcLogger.log(Level.FINER, "Virtual member manager CONFIG VALIDATION IS TURNED OFF. **** DO NOT TURN IT OFF ****");
        }
        return validate;
    }

    private static void validateSearchFilter(DirContext dirContext, String string, String string2, String string3) throws WIMConfigurationException {
        if (string3 != null && string3.trim().length() > 0) {
            if (dirContext == null) {
                throw new WIMConfigurationException("MISSING_OR_INVALID_CONNECTION_DATA", WIMMessageHelper.generateMsgParms(string2 == null ? string : string2), CLASSNAME, "validateSearchFilter");
            }
            try {
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(0);
                dirContext.search("", string3, searchControls);
            }
            catch (InvalidSearchFilterException invalidSearchFilterException) {
                throw new WIMConfigurationException("INVALID_SEARCH_FILTER", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, "validateSearchFilter", (Throwable)invalidSearchFilterException);
            }
            catch (NamingException namingException) {
                trcLogger.logp(Level.FINE, CLASSNAME, "validateSearchFilter", "invalid search filter: " + string3, namingException);
            }
        }
    }

    private static void validateObjectClasses(DirContext dirContext, String string, String string2, List list) throws WIMConfigurationException {
        if (list != null && list.size() > 0) {
            if (dirContext == null) {
                throw new WIMConfigurationException("MISSING_OR_INVALID_CONNECTION_DATA", WIMMessageHelper.generateMsgParms(string2 == null ? string : string2), CLASSNAME, "validateObjectClasses");
            }
            String string3 = null;
            try {
                DirContext dirContext2 = dirContext.getSchema("");
                trcLogger.logp(Level.FINER, CLASSNAME, "validateObjectClasses", "getSchema=" + dirContext2);
                for (int i = 0; i < list.size(); ++i) {
                    string3 = (String)list.get(i);
                    String string4 = "ClassDefinition/" + string3;
                    trcLogger.logp(Level.FINER, CLASSNAME, "validateObjectClasses", "checking object class=" + string4);
                    dirContext2.getAttributes(string4);
                }
            }
            catch (NamingException namingException) {
                if (string3 != null) {
                    throw new WIMConfigurationException("INVALID_OBJECT_CLASSES", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, "validateObjectClasses", (Throwable)namingException);
                }
                throw new WIMConfigurationException("INVALID_OBJECT_CLASSES", WIMMessageHelper.generateMsgParms(list), CLASSNAME, "validateObjectClasses", (Throwable)namingException);
            }
        }
    }

    private static void validateBaseEntryNameInRepository(DirContext dirContext, String string, String string2, List list) throws WIMConfigurationException {
        if (list != null && list.size() > 0) {
            if (dirContext == null) {
                throw new WIMConfigurationException("MISSING_OR_INVALID_CONNECTION_DATA", WIMMessageHelper.generateMsgParms(string2 == null ? string : string2), CLASSNAME, "validateBaseEntryNameInRepository");
            }
            String string3 = null;
            try {
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(0);
                for (int i = 0; i < list.size(); ++i) {
                    string3 = (String)list.get(i);
                    trcLogger.logp(Level.FINER, CLASSNAME, "validateBaseEntryNameInRepository", "validating nameInRepository " + string3);
                    dirContext.search((Name)new LdapName(string3), "(objectclass=*)", searchControls);
                }
            }
            catch (NamingException namingException) {
                if (string3 != null) {
                    throw new WIMConfigurationException("INVALID_BASE_ENTRY_NAME_IN_REPOSITORY", WIMMessageHelper.generateMsgParms(string3, namingException.getMessage()), CLASSNAME, "validateBaseEntryNameInRepository", (Throwable)namingException);
                }
                throw new WIMConfigurationException("INVALID_BASE_ENTRY_NAME_IN_REPOSITORY", WIMMessageHelper.generateMsgParms(list, namingException.getMessage()), CLASSNAME, "validateBaseEntryNameInRepository", (Throwable)namingException);
            }
        }
    }

    private static boolean isStringEqual(String string, String string2) {
        boolean bl = false;
        if (string == null && string2 == null) {
            bl = true;
        } else if (string != null && string2 != null) {
            bl = string.equalsIgnoreCase(string2);
        }
        return bl;
    }

    private static boolean isLastBaseEntryInRepository(ConfigurationProviderType configurationProviderType, String string, String string2) throws WIMException {
        boolean bl = false;
        ProfileRepositoryType profileRepositoryType = (ProfileRepositoryType)ConfigUtils.getRepositoryById(configurationProviderType, string);
        List list = profileRepositoryType.getBaseEntries();
        if (list.size() == 1 && ConfigValidator.isStringEqual(string2, ((BaseEntriesType)list.get(0)).getName())) {
            bl = true;
        }
        return bl;
    }

    private static boolean isLastBaseEntryInRealm(ConfigurationProviderType configurationProviderType, String string, String string2) throws WIMException {
        boolean bl = false;
        RealmConfigurationType realmConfigurationType = ConfigValidator.getRealmConfig(configurationProviderType);
        RealmType realmType = ConfigUtils.getRealm(string, realmConfigurationType);
        List list = realmType.getParticipatingBaseEntries();
        if (list.size() == 1 && ConfigValidator.isStringEqual(string2, ((ParticipatingBaseEntriesType)list.get(0)).getName())) {
            bl = true;
        }
        return bl;
    }

    private static boolean isBaseEntryInRealms(ConfigurationProviderType configurationProviderType, String string) throws WIMException {
        boolean bl = false;
        RealmConfigurationType realmConfigurationType = ConfigValidator.getRealmConfig(configurationProviderType);
        List list = realmConfigurationType.getRealms();
        for (int i = 0; i < list.size(); ++i) {
            RealmType realmType = (RealmType)list.get(i);
            List list2 = realmType.getParticipatingBaseEntries();
            for (int j = 0; j < list2.size(); ++j) {
                ParticipatingBaseEntriesType participatingBaseEntriesType = (ParticipatingBaseEntriesType)list2.get(j);
                if (!ConfigValidator.isStringEqual(string, participatingBaseEntriesType.getName())) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        return bl;
    }

    public static boolean isBaseEntryInRepository(ConfigurationProviderType configurationProviderType, String string) throws WIMException {
        boolean bl = false;
        List list = ConfigUtils.getProfileRepositories(configurationProviderType);
        block0: for (int i = 0; i < list.size(); ++i) {
            ProfileRepositoryType profileRepositoryType = (ProfileRepositoryType)list.get(i);
            List list2 = profileRepositoryType.getBaseEntries();
            for (int j = 0; j < list2.size(); ++j) {
                BaseEntriesType baseEntriesType = (BaseEntriesType)list2.get(j);
                if (!ConfigValidator.isStringEqual(string, baseEntriesType.getName())) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    private static boolean isDN(String string) {
        boolean bl = false;
        try {
            if (string != null && !string.startsWith(",") && !string.endsWith(",")) {
                new LdapName(string);
                bl = true;
            }
        }
        catch (InvalidNameException invalidNameException) {
            trcLogger.logp(Level.FINER, CLASSNAME, "isDN", "not a DN:" + string, invalidNameException);
        }
        return bl;
    }

    private static RealmConfigurationType getRealmConfig(ConfigurationProviderType configurationProviderType) throws WIMException {
        String string = "getRealmConfig";
        RealmConfigurationType realmConfigurationType = configurationProviderType.getRealmConfiguration();
        if (realmConfigurationType == null) {
            throw new WIMConfigurationException("MISSING_REALM_CONFIGURATION", Level.SEVERE, CLASSNAME, string);
        }
        return realmConfigurationType;
    }
}

