/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.wim.ConfigUIConstants;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.ProfileRepositoryType;
import com.ibm.ws.wim.configmodel.RepositoryType;
import commonj.sdo.DataObject;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CustomRepositoryConfigHelper
implements ConfigUIConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    private static final String CLASSNAME = CustomRepositoryConfigHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public String createIdMgrCustomRepository(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "createIdMgrCustomRepository", "params = " + map);
        }
        String string2 = (String)map.get("id");
        ConfigurationProviderType configurationProviderType = ConfigUtils.getConfigProvider(string);
        RepositoryType repositoryType = ConfigUtils.getRepositoryById(string, string2, false);
        if (repositoryType != null) {
            throw new WIMConfigurationException("REPOSITORY_ID_ALREADY_EXISTS", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "createIdMgrCustomRepository");
        }
        EClass eClass = ConfigManager.singleton().getConfigEClass("ProfileRepositoryType");
        DataObject dataObject = (DataObject)EcoreUtil.create((EClass)eClass);
        dataObject.setString("id", string2);
        configurationProviderType.getRepositories().add(dataObject);
        ProfileRepositoryType profileRepositoryType = (ProfileRepositoryType)ConfigUtils.getRepositoryById(configurationProviderType, string2);
        String string3 = (String)map.get("adapterClassName");
        profileRepositoryType.setAdapterClassName(string3);
        profileRepositoryType.setSupportPaging(false);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "createIdMgrCustomRepository");
        }
        ConfigUtils.saveConfig(string);
        return "MUST_ADD_BASE_ENTRY_TO_REPOSITORY";
    }
}

