/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.wim.ConfigUIConstants;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.config.ConfigValidator;
import com.ibm.ws.wim.config.ValidationHelper;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.DatabaseRepositoryType;
import commonj.sdo.DataObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DatabaseRepositoryConfigHelper
implements ConfigUIConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = DatabaseRepositoryConfigHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static List DBTypes = null;
    private static Map defaultValue = null;

    public String createIdMgrDBRepository(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "createIdMgrDBRepository", "params=" + WIMTraceHelper.printMapWithoutPassword(map));
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("dataSourceName");
        String string4 = (String)map.get("databaseType");
        String string5 = (String)map.get("dbURL");
        String string6 = (String)map.get("dbAdminId");
        String string7 = (String)map.get("dbAdminPassword");
        String string8 = (String)map.get("JDBCDriverClass");
        Integer n = (Integer)map.get("entityRetrievalLimit");
        Integer n2 = (Integer)map.get("saltLength");
        String string9 = (String)map.get("encryptionKey");
        ValidationHelper.validateRequiredDBParameters(map, CLASSNAME, "createIdMgrDBRepository");
        ValidationHelper.validateIntegerInput("saltLength", CLASSNAME, "createIdMgrDBRepository", n2);
        ConfigUtils.checkForValidRepositoryById(string, string2);
        ConfigValidator.validateRepositoryParams(string2, "DatabaseRepositoryType", map);
        ConfigUtils.getRepositoryById(string, string2, false);
        ConfigurationProviderType configurationProviderType = ConfigUtils.getConfigProvider(string);
        EClass eClass = ConfigManager.singleton().getConfigEClass("DatabaseRepositoryType");
        DataObject dataObject = (DataObject)EcoreUtil.create((EClass)eClass);
        dataObject.setString("id", string2);
        configurationProviderType.getRepositories().add(dataObject);
        DatabaseRepositoryType databaseRepositoryType = (DatabaseRepositoryType)ConfigUtils.getRepositoryById(configurationProviderType, string2);
        ConfigUtils.setCommonRepositoryProperties(databaseRepositoryType, map, this.getDefaultValue(), false);
        if (string3 != null) {
            databaseRepositoryType.setDataSourceName(string3);
        }
        if (string4 != null) {
            databaseRepositoryType.setDatabaseType(string4);
        }
        if (string5 != null) {
            databaseRepositoryType.setDbURL(string5);
        }
        if (string6 != null) {
            databaseRepositoryType.setDbAdminId(string6);
        }
        if (string7 != null) {
            databaseRepositoryType.setDbAdminPassword(ConfigUtils.encodePassword(string7));
        }
        if (string8 != null) {
            databaseRepositoryType.setJDBCDriverClass(string8);
        }
        if (n != null) {
            databaseRepositoryType.setEntityRetrievalLimit(n);
        }
        if (n2 != null) {
            databaseRepositoryType.setSaltLength(n2);
        }
        if (string9 != null) {
            databaseRepositoryType.setEncryptionKey(string9);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "createIdMgrDBRepository");
        }
        ConfigUtils.saveConfig(string);
        return "MUST_ADD_BASE_ENTRY_TO_REPOSITORY";
    }

    public String updateIdMgrDBRepository(String string, Map map) throws WIMException {
        HashMap hashMap;
        boolean bl;
        String string2 = (String)map.get("id");
        boolean bl2 = trcLogger.isLoggable(Level.FINER);
        if (bl2) {
            trcLogger.entering(CLASSNAME, "updateIdMgrDBRepository", "params=" + WIMTraceHelper.printMapWithoutPassword(map));
        }
        DatabaseRepositoryType databaseRepositoryType = (DatabaseRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "DatabaseRepositoryType");
        String string3 = (String)map.get("dataSourceName");
        String string4 = (String)map.get("databaseType");
        String string5 = (String)map.get("dbURL");
        String string6 = (String)map.get("dbAdminId");
        String string7 = (String)map.get("dbAdminPassword");
        String string8 = (String)map.get("JDBCDriverClass");
        Integer n = (Integer)map.get("entityRetrievalLimit");
        Integer n2 = (Integer)map.get("saltLength");
        String string9 = (String)map.get("encryptionKey");
        if (n2 != null) {
            ValidationHelper.validateIntegerInput("saltLength", CLASSNAME, "updateIdMgrDBRepository", n2);
        }
        if (string4 != null) {
            ValidationHelper.validateParam("databaseType", string4, CONFIG_DB_SUPPORTED_TYPES);
        }
        if (bl = ConfigUtils.buildMapFromOldAndNewValues(hashMap = new HashMap(), ConfigValidator.DB_CONNECTION_PARAMS, (DataObject)databaseRepositoryType, map)) {
            ConfigValidator.validateDBParams(string2, hashMap);
        }
        if (string3 != null) {
            databaseRepositoryType.setDataSourceName(string3);
        }
        if (string4 != null) {
            databaseRepositoryType.setDatabaseType(string4);
        }
        if (string5 != null) {
            databaseRepositoryType.setDbURL(string5);
        }
        if (string6 != null) {
            databaseRepositoryType.setDbAdminId(string6);
        }
        if (string7 != null) {
            databaseRepositoryType.setDbAdminPassword(ConfigUtils.encodePassword(string7));
        }
        if (string8 != null) {
            databaseRepositoryType.setJDBCDriverClass(string8);
        }
        if (n != null) {
            databaseRepositoryType.setEntityRetrievalLimit(n);
        }
        if (n2 != null) {
            databaseRepositoryType.setSaltLength(n2);
        }
        if (string9 != null) {
            databaseRepositoryType.setEncryptionKey(string9);
        }
        if (bl2) {
            trcLogger.exiting(CLASSNAME, "updateIdMgrDBRepository");
        }
        return ConfigUtils.saveConfig(string);
    }

    public List listIdMgrSupportedDBTypes(String string) throws WIMException {
        if (DBTypes == null) {
            DBTypes = ConfigUtils.convertArrayToList(CONFIG_DB_SUPPORTED_TYPES);
        }
        return DBTypes;
    }

    private Map getDefaultValue() {
        if (defaultValue == null) {
            defaultValue = new HashMap();
            defaultValue.put("adapterClassName", "com.ibm.ws.wim.adapter.db.DBAdapter");
            defaultValue.put("supportPaging", Boolean.valueOf("false"));
            defaultValue.put("supportSorting", Boolean.valueOf("false"));
            defaultValue.put("supportTransactions", Boolean.valueOf("false"));
            defaultValue.put("isExtIdUnique", Boolean.valueOf("true"));
            defaultValue.put("supportExternalName", Boolean.valueOf("false"));
            defaultValue.put("supportExternalName", Boolean.valueOf("false"));
        }
        return defaultValue;
    }
}

