/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.wim.ConfigUIConstants;
import com.ibm.websphere.wim.ServiceProvider;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.ws.security.util.WSEncoderDecoder;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.LdapRepositoryType;
import com.ibm.ws.wim.configmodel.LdapServerConfigurationType;
import com.ibm.ws.wim.configmodel.LdapServersType;
import com.ibm.ws.wim.util.DataGraphHelper;
import commonj.sdo.DataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;

public class DynamicConfigHelper
implements ConfigUIConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = DynamicConfigHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public String updateIdMgrLDAPBindInfo(String string, Map map) throws Exception {
        String string2 = "updateIdMgrLDAPBindInfo";
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, string2, "params=" + WIMTraceHelper.printMapWithoutPassword(map));
        }
        String string3 = (String)map.get("id");
        String string4 = (String)map.get("bindDN");
        String string5 = (String)map.get("bindPassword");
        if (string4 != null && string5 == null) {
            throw new WIMConfigurationException("RELATED_PARAMETERS_NOT_SPECIFIED", WIMMessageHelper.generateMsgParms("bindDN", "bindPassword"), Level.SEVERE, CLASSNAME, string2);
        }
        if (string4 == null && string5 != null) {
            throw new WIMConfigurationException("RELATED_PARAMETERS_NOT_SPECIFIED", WIMMessageHelper.generateMsgParms("bindPassword", "bindDN"), Level.SEVERE, CLASSNAME, string2);
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("DYNA_CONFIG_KEY_REPOS_ID", string3);
        if (string4 != null && string5 != null) {
            hashtable.put("DYNA_CONFIG_KEY_LDAP_BIND_DN", string4);
            hashtable.put("DYNA_CONFIG_KEY_LDAP_BIND_PASSWORD", PasswordUtil.getByteArrayPassword(string5));
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, string2, "getting service provider singleton");
        }
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, string2, "calling dynamicUpdateConfig for " + string3);
        }
        serviceProvider.dynamicUpdateConfig("websphere.usermanager.serviceprovider.update.ldap.bindinfo", hashtable);
        if (string4 != null && string5 != null) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, string2, "getting persisted configuration");
            }
            Properties properties = new Properties();
            properties.setProperty("location", "local");
            ConfigRepository configRepository = null;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, string2, "getting and initializing local ConfigRepository...");
            }
            configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(properties);
            configRepository.initialize(properties);
            String string6 = "cells/" + ConfigManager.singleton().getCellName() + "/" + "wim" + "/" + "config" + "/" + "wimconfig.xml";
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, string2, "extracting config file using uri=" + string6);
            }
            DocumentContentSource documentContentSource = configRepository.extract(string6);
            InputStream inputStream = documentContentSource.getSource();
            HashMap hashMap = new HashMap();
            EDataGraph eDataGraph = SDOUtil.loadDataGraph((InputStream)inputStream, hashMap);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, string2, "config file is loaded");
            }
            ConfigurationProviderType configurationProviderType = null;
            if (eDataGraph == null) {
                throw new WIMConfigurationException("WIM_CONFIG_XML_FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string6), CLASSNAME, string2);
            }
            configurationProviderType = (ConfigurationProviderType)eDataGraph.getRootObject().getDataObject("configurationProvider");
            LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(configurationProviderType, string3, "LdapRepositoryType");
            LdapServerConfigurationType ldapServerConfigurationType = ldapRepositoryType.getLdapServerConfiguration();
            if (ldapServerConfigurationType == null) {
                throw new WIMConfigurationException("MISSING_LDAP_SERVER_CONFIGURATION", WIMMessageHelper.generateMsgParms(string3), Level.SEVERE, CLASSNAME, string2);
            }
            List list = ldapServerConfigurationType.getLdapServers();
            if (list.size() == 0) {
                throw new WIMConfigurationException("MISSING_LDAP_SERVER_CONFIGURATION", WIMMessageHelper.generateMsgParms(string3), Level.SEVERE, CLASSNAME, string2);
            }
            LdapServersType ldapServersType = (LdapServersType)list.get(0);
            if (string4 != null) {
                ldapServersType.setBindDN(string4);
            }
            if (string5 != null) {
                ldapServersType.setBindPassword(this.encodePassword(string5));
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ((EDataGraph)((DataObject)configurationProviderType).getDataGraph()).getDataGraphResource().save((OutputStream)byteArrayOutputStream, null);
            documentContentSource.setSource(new ByteArrayInputStream(DataGraphHelper.insertCopyright(byteArrayOutputStream)));
            configRepository.modify(documentContentSource);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, string2, "config file is updated with new bind info");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string2);
        }
        return "COMMAND_COMPLETED_SUCCESSFULLY";
    }

    private String encodePassword(String string) {
        WSEncoderDecoder wSEncoderDecoder = new WSEncoderDecoder();
        return wSEncoderDecoder.encode(string);
    }
}

