/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.wim.ConfigUIConstants;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.config.ConfigValidator;
import com.ibm.ws.wim.config.ValidationHelper;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.EntryMappingRepositoryType;
import commonj.sdo.DataObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FederationRepositoryConfigHelper
implements ConfigUIConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = FederationRepositoryConfigHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public String setIdMgrFederationRepository(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setIdMgrFederationRepository", "params=" + WIMTraceHelper.printMapWithoutPassword(map));
        }
        String string2 = (String)map.get("dataSourceName");
        String string3 = (String)map.get("databaseType");
        String string4 = (String)map.get("dbURL");
        ConfigurationProviderType configurationProviderType = ConfigUtils.getConfigProvider(string);
        EntryMappingRepositoryType entryMappingRepositoryType = configurationProviderType.getEntryMappingRepository();
        if (entryMappingRepositoryType == null) {
            ValidationHelper.validateRequiredDBParameters(map, CLASSNAME, "setIdMgrFederationRepository");
            ConfigValidator.validateDBParams("FED", map);
            entryMappingRepositoryType = configurationProviderType.createEntryMappingRepository();
            entryMappingRepositoryType.setId("FED");
            entryMappingRepositoryType.setAdapterClassName("com.ibm.ws.wim.federation.FederationAdapter");
        } else {
            HashMap hashMap = new HashMap();
            ConfigUtils.buildMapFromOldAndNewValues(hashMap, ConfigValidator.DB_CONNECTION_PARAMS, (DataObject)entryMappingRepositoryType, map);
            ConfigValidator.validateDBParams("FED", hashMap);
        }
        if (string3 != null) {
            entryMappingRepositoryType.setDatabaseType(string3);
        }
        if (string2 != null) {
            entryMappingRepositoryType.setDataSourceName(string2);
        }
        if (string4 != null) {
            entryMappingRepositoryType.setDbURL(string4);
        }
        if (map.get("dbAdminId") != null) {
            entryMappingRepositoryType.setDbAdminId((String)map.get("dbAdminId"));
        }
        if (map.get("dbAdminPassword") != null) {
            entryMappingRepositoryType.setDbAdminPassword(ConfigUtils.encodePassword((String)map.get("dbAdminPassword")));
        }
        if (map.get("JDBCDriverClass") != null) {
            entryMappingRepositoryType.setJDBCDriverClass((String)map.get("JDBCDriverClass"));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setIdMgrFederationRepository");
        }
        return ConfigUtils.saveConfig(string);
    }
}

