/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.wim.ConfigUIConstants;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.config.ConfigValidator;
import com.ibm.ws.wim.config.ValidationHelper;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.FileRepositoryType;
import com.ibm.ws.wim.configmodel.RepositoryType;
import commonj.sdo.DataObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FileRepositoryConfigHelper
implements ConfigUIConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = FileRepositoryConfigHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static Map defaultValue = null;
    private static List MDAlgos = null;

    public String createIdMgrFileRepository(String string, Map map) throws WIMException {
        RepositoryType repositoryType;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "createIdMgrFileRepository", "params=" + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("messageDigestAlgorithm");
        Integer n = (Integer)map.get("saltLength");
        ValidationHelper.validateIntegerInput("saltLength", CLASSNAME, "createIdMgrFileRepository", n);
        ConfigValidator.validateRepositoryParams(string2, "FileRepositoryType", map);
        ConfigurationProviderType configurationProviderType = ConfigUtils.getConfigProvider(string);
        if (!string2.equals("InternalFileRepository")) {
            ConfigUtils.checkForValidRepositoryById(string, string2);
        } else {
            repositoryType = ConfigUtils.getRepositoryById(string, string2, false);
            if (repositoryType != null) {
                throw new WIMConfigurationException("REPOSITORY_ID_ALREADY_EXISTS", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "createIdMgrFileRepository");
            }
        }
        repositoryType = ConfigManager.singleton().getConfigEClass("FileRepositoryType");
        DataObject dataObject = (DataObject)EcoreUtil.create((EClass)repositoryType);
        dataObject.setString("id", string2);
        configurationProviderType.getRepositories().add(dataObject);
        FileRepositoryType fileRepositoryType = (FileRepositoryType)ConfigUtils.getRepositoryById(configurationProviderType, string2);
        ConfigUtils.setCommonRepositoryProperties(fileRepositoryType, map, this.getDefaultValue(), false);
        if (map.get("baseDirectory") != null) {
            fileRepositoryType.setBaseDirectory((String)map.get("baseDirectory"));
        }
        if (map.get("fileName") != null) {
            fileRepositoryType.setFileName((String)map.get("fileName"));
        }
        if (n != null) {
            fileRepositoryType.setSaltLength(n);
        }
        if (string3 != null) {
            fileRepositoryType.setMessageDigestAlgorithm(string3);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "createIdMgrFileRepository");
        }
        ConfigUtils.saveConfig(string);
        return "MUST_ADD_BASE_ENTRY_TO_REPOSITORY";
    }

    public String updateIdMgrFileRepository(String string, Map map) throws Exception {
        String string2 = (String)map.get("id");
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "updateIdMgrFileRepository", "params=" + map);
        }
        FileRepositoryType fileRepositoryType = (FileRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "FileRepositoryType");
        String string3 = (String)map.get("messageDigestAlgorithm");
        ConfigValidator.validateFileParams(string2, map);
        Integer n = (Integer)map.get("saltLength");
        ValidationHelper.validateIntegerInput("saltLength", CLASSNAME, "updateIdMgrFileRepository", n);
        String string4 = (String)map.get("baseDirectory");
        if (string4 != null) {
            fileRepositoryType.setBaseDirectory(string4.trim());
        }
        if (map.get("fileName") != null) {
            fileRepositoryType.setFileName((String)map.get("fileName"));
        }
        if (n != null) {
            fileRepositoryType.setSaltLength(n);
        }
        if (string3 != null) {
            fileRepositoryType.setMessageDigestAlgorithm(string3);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "updateIdMgrFileRepository");
        }
        return ConfigUtils.saveConfig(string);
    }

    public List listIdMgrSupportedMessageDigestAlgorithms(String string) throws WIMException {
        if (MDAlgos == null) {
            MDAlgos = ConfigUtils.convertArrayToList(CONFIG_SUPPORTED_MDALGORITHMS);
        }
        return MDAlgos;
    }

    private Map getDefaultValue() {
        if (defaultValue == null) {
            defaultValue = new HashMap();
            defaultValue.put("adapterClassName", "com.ibm.ws.wim.adapter.file.was.FileAdapter");
            defaultValue.put("supportPaging", Boolean.valueOf("false"));
            defaultValue.put("supportSorting", Boolean.valueOf("false"));
            defaultValue.put("supportTransactions", Boolean.valueOf("false"));
            defaultValue.put("isExtIdUnique", Boolean.valueOf("true"));
            defaultValue.put("supportExternalName", Boolean.valueOf("false"));
            defaultValue.put("supportExternalName", Boolean.valueOf("false"));
        }
        return defaultValue;
    }
}

