/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.wim.ConfigUIConstants;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.config.ConfigValidator;
import com.ibm.ws.wim.config.LDAPRepositoryConfigHelper;
import com.ibm.ws.wim.config.ValidationHelper;
import com.ibm.ws.wim.configmodel.BaseEntriesType;
import com.ibm.ws.wim.configmodel.ConnectionsType;
import com.ibm.ws.wim.configmodel.CustomPropertiesType;
import com.ibm.ws.wim.configmodel.DatabaseRepositoryType;
import com.ibm.ws.wim.configmodel.EntryMappingRepositoryType;
import com.ibm.ws.wim.configmodel.FileRepositoryType;
import com.ibm.ws.wim.configmodel.LdapRepositoryType;
import com.ibm.ws.wim.configmodel.LdapServerConfigurationType;
import com.ibm.ws.wim.configmodel.LdapServersType;
import com.ibm.ws.wim.configmodel.ProfileRepositoryType;
import com.ibm.ws.wim.configmodel.PropertyExtensionRepositoryType;
import com.ibm.ws.wim.configmodel.RepositoryType;
import com.ibm.ws.wim.util.UniqueNameHelper;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericRepositoryConfigHelper
implements ConfigUIConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = GenericRepositoryConfigHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public String updateIdMgrRepository(String string, Map map) throws WIMException {
        Boolean bl;
        String string2;
        RepositoryType repositoryType;
        boolean bl2 = trcLogger.isLoggable(Level.FINER);
        if (bl2) {
            trcLogger.entering(CLASSNAME, "updateIdMgrRepository", "params = " + map);
        }
        if (!((repositoryType = ConfigUtils.getRepositoryById(string, string2 = (String)map.get("id"))) instanceof ProfileRepositoryType)) {
            String string3 = ConfigUtils.getRepositoryType(repositoryType);
            throw new WIMConfigurationException("CONFIG_NON_PROFILE_REPO_CANNOT_BE_UPDATED", WIMMessageHelper.generateMsgParms(string3), Level.SEVERE, CLASSNAME, "updateIdMgrRepository");
        }
        List list = (List)map.get("loginProperties");
        ValidationHelper.validateStringInputInList("loginProperties", CLASSNAME, "updateIdMgrRepository", list, true);
        ConfigValidator.validateRepositoryParams(string2, ConfigUtils.getRepositoryType(repositoryType), map);
        List list2 = (List)map.get("repositoriesForGroups");
        ConfigValidator.validateRepositoriesForGroup(ConfigUtils.getConfigProvider(string), list2);
        ProfileRepositoryType profileRepositoryType = (ProfileRepositoryType)repositoryType;
        String string4 = (String)map.get("adapterClassName");
        if (string4 != null) {
            profileRepositoryType.setAdapterClassName(string4);
        }
        if ((bl = (Boolean)map.get("supportPaging")) != null) {
            profileRepositoryType.setSupportPaging(bl);
        }
        if ((bl = (Boolean)map.get("supportSorting")) != null) {
            profileRepositoryType.setSupportSorting(bl);
        }
        if ((bl = (Boolean)map.get("supportTransactions")) != null) {
            profileRepositoryType.setSupportTransactions(bl);
        }
        if ((bl = (Boolean)map.get("isExtIdUnique")) != null) {
            profileRepositoryType.setIsExtIdUnique(bl);
        }
        if ((bl = (Boolean)map.get("supportExternalName")) != null) {
            profileRepositoryType.setSupportExternalName(bl);
        }
        if ((bl = (Boolean)map.get("supportAsyncMode")) != null) {
            profileRepositoryType.setSupportAsyncMode(bl);
        }
        if ((bl = (Boolean)map.get("readOnly")) != null) {
            profileRepositoryType.setReadOnly(bl);
        }
        List list3 = (List)map.get("EntityTypesNotAllowCreate");
        List list4 = profileRepositoryType.getEntityTypesNotAllowCreate();
        if (list3 != null) {
            ConfigUtils.addOrRemovePresentList("EntityTypesNotAllowCreate", list3, list4);
        }
        list3 = (List)map.get("EntityTypesNotAllowUpdate");
        list4 = profileRepositoryType.getEntityTypesNotAllowUpdate();
        if (list3 != null) {
            ConfigUtils.addOrRemovePresentList("EntityTypesNotAllowUpdate", list3, list4);
        }
        list3 = (List)map.get("EntityTypesNotAllowRead");
        list4 = profileRepositoryType.getEntityTypesNotAllowRead();
        if (list3 != null) {
            ConfigUtils.addOrRemovePresentList("EntityTypesNotAllowRead", list3, list4);
        }
        list3 = (List)map.get("EntityTypesNotAllowDelete");
        list4 = profileRepositoryType.getEntityTypesNotAllowDelete();
        if (list3 != null) {
            ConfigUtils.addOrRemovePresentList("EntityTypesNotAllowDelete", list3, list4);
        }
        list4 = profileRepositoryType.getRepositoriesForGroups();
        if (list2 != null) {
            ConfigUtils.addOrRemovePresentList("repositoriesForGroups", list2, list4);
        }
        list4 = profileRepositoryType.getLoginProperties();
        if (list != null) {
            ConfigUtils.addOrRemovePresentList("loginProperties", list, list4);
        }
        if (bl2) {
            trcLogger.exiting(CLASSNAME, "updateIdMgrRepository");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String deleteIdMgrRepository(String string, String string2) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deleteIdMgrRepository", "id = " + string2);
        }
        RepositoryType repositoryType = null;
        if ("FED".equals(string2) || "LA".equals(string2)) {
            repositoryType = ConfigUtils.getRepositoryByIdIncludeLAandFED(string, string2);
        } else {
            repositoryType = ConfigUtils.getRepositoryById(string, string2);
            ConfigValidator.validateDeleteIdMgrRepository(ConfigUtils.getConfigProvider(string), string2);
        }
        ((DataObject)repositoryType).delete();
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deleteIdMgrRepository");
        }
        return ConfigUtils.saveConfig(string);
    }

    public Map listIdMgrRepositories(String string) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "listIdMgrRepositories", "sessionId=" + string);
        }
        HashMap hashMap = new HashMap();
        List list = ConfigUtils.getProfileRepositories(string);
        for (int i = 0; i < list.size(); ++i) {
            ProfileRepositoryType profileRepositoryType;
            Object e2 = list.get(i);
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            String string2 = ((RepositoryType)e2).getId();
            if (e2 instanceof FileRepositoryType) {
                hashMap2.put("repositoryType", "File");
                hashMap2.put("host", "LocalHost");
            } else if (e2 instanceof LdapRepositoryType) {
                LdapServersType ldapServersType;
                List list2;
                List list3;
                hashMap2.put("repositoryType", "LDAP");
                profileRepositoryType = (LdapRepositoryType)e2;
                hashMap2.put("specificRepositoryType", profileRepositoryType.getLdapServerType());
                if (profileRepositoryType.getLdapServerConfiguration() != null && (list3 = profileRepositoryType.getLdapServerConfiguration().getLdapServers()).size() > 0 && (list2 = (ldapServersType = (LdapServersType)list3.get(0)).getConnections()).size() > 0) {
                    ConnectionsType connectionsType = (ConnectionsType)list2.get(0);
                    hashMap2.put("host", connectionsType.getHost());
                }
            } else if (e2 instanceof DatabaseRepositoryType) {
                hashMap2.put("repositoryType", "DB");
                profileRepositoryType = (DatabaseRepositoryType)e2;
                hashMap2.put("specificRepositoryType", profileRepositoryType.getDatabaseType());
                hashMap2.put("host", profileRepositoryType.getDataSourceName());
            } else {
                hashMap2.put("repositoryType", "Custom");
            }
            hashMap.put(string2, hashMap2);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "listIdMgrRepositories", "returnMap=" + hashMap);
        }
        return hashMap;
    }

    public Map getIdMgrRepository(String string, String string2) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrRepository", "id = " + string2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        RepositoryType repositoryType = ConfigUtils.getRepositoryByIdIncludeLAandFED(string, string2);
        if (repositoryType == null) {
            throw new WIMConfigurationException("INVALID_REPOSITORY_ID", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "getIdMgrRepository");
        }
        hashMap.put("id", string2);
        if (repositoryType instanceof EntryMappingRepositoryType) {
            this.getFederationRepositoryInfo((EntryMappingRepositoryType)repositoryType, hashMap);
        }
        if (repositoryType instanceof PropertyExtensionRepositoryType) {
            this.getLookAsideRepositoryInfo((PropertyExtensionRepositoryType)repositoryType, hashMap);
        }
        if (repositoryType instanceof LdapRepositoryType) {
            this.getLDAPRepositoryInfo((LdapRepositoryType)repositoryType, hashMap);
        }
        if (repositoryType instanceof FileRepositoryType) {
            this.getFileRepositoryInfo((FileRepositoryType)repositoryType, hashMap);
        }
        if (repositoryType instanceof DatabaseRepositoryType) {
            this.getDatabaseRepositoryInfo((DatabaseRepositoryType)repositoryType, hashMap);
        }
        if (repositoryType instanceof ProfileRepositoryType) {
            this.getProfileRepositoryTypeInfo((ProfileRepositoryType)repositoryType, hashMap);
        }
        return hashMap;
    }

    private void getProfileRepositoryTypeInfo(ProfileRepositoryType profileRepositoryType, Map map) throws WIMException {
        if (profileRepositoryType.getAdapterClassName() != null) {
            map.put("adapterClassName", profileRepositoryType.getAdapterClassName());
        }
        if (profileRepositoryType.isSetSupportPaging()) {
            map.put("supportPaging", profileRepositoryType.isSupportPaging());
        }
        if (profileRepositoryType.isSetSupportSorting()) {
            map.put("supportSorting", profileRepositoryType.isSupportSorting());
        }
        if (profileRepositoryType.isSetSupportTransactions()) {
            map.put("supportTransactions", profileRepositoryType.isSupportTransactions());
        }
        if (profileRepositoryType.isSetIsExtIdUnique()) {
            map.put("isExtIdUnique", profileRepositoryType.isIsExtIdUnique());
        }
        if (profileRepositoryType.isSetSupportExternalName()) {
            map.put("supportExternalName", profileRepositoryType.isSupportExternalName());
        }
        if (profileRepositoryType.isSetSupportAsyncMode()) {
            map.put("supportAsyncMode", profileRepositoryType.isSupportAsyncMode());
        }
        if (profileRepositoryType.isSetReadOnly()) {
            map.put("readOnly", profileRepositoryType.isReadOnly());
        }
        this.addBaseEntryMapInfo(profileRepositoryType, map);
        if (profileRepositoryType.getEntityTypesNotAllowCreateAsArray() != null && profileRepositoryType.getEntityTypesNotAllowCreate().size() != 0) {
            map.put("EntityTypesNotAllowCreate", ConfigUtils.convertEList(profileRepositoryType.getEntityTypesNotAllowCreate()));
        }
        if (profileRepositoryType.getEntityTypesNotAllowUpdate() != null && profileRepositoryType.getEntityTypesNotAllowUpdate().size() != 0) {
            map.put("EntityTypesNotAllowUpdate", ConfigUtils.convertEList(profileRepositoryType.getEntityTypesNotAllowUpdate()));
        }
        if (profileRepositoryType.getEntityTypesNotAllowRead() != null && profileRepositoryType.getEntityTypesNotAllowRead().size() != 0) {
            map.put("EntityTypesNotAllowRead", ConfigUtils.convertEList(profileRepositoryType.getEntityTypesNotAllowRead()));
        }
        if (profileRepositoryType.getEntityTypesNotAllowDelete() != null && profileRepositoryType.getEntityTypesNotAllowDelete().size() != 0) {
            map.put("EntityTypesNotAllowDelete", ConfigUtils.convertEList(profileRepositoryType.getEntityTypesNotAllowDelete()));
        }
        if (profileRepositoryType.getRepositoriesForGroups() != null && profileRepositoryType.getRepositoriesForGroups().size() != 0) {
            map.put("repositoriesForGroups", ConfigUtils.convertEList(profileRepositoryType.getRepositoriesForGroups()));
        }
        if (profileRepositoryType.getLoginProperties() != null && profileRepositoryType.getLoginProperties().size() != 0) {
            map.put("loginProperties", ConfigUtils.convertEList(profileRepositoryType.getLoginProperties()));
        }
        this.addCustomPropertiesInfo(profileRepositoryType, map);
    }

    private void getFederationRepositoryInfo(EntryMappingRepositoryType entryMappingRepositoryType, Map map) {
        String string = entryMappingRepositoryType.getDataSourceName();
        String string2 = entryMappingRepositoryType.getDatabaseType();
        String string3 = entryMappingRepositoryType.getAdapterClassName();
        String string4 = entryMappingRepositoryType.getDbAdminId();
        String string5 = entryMappingRepositoryType.getDbAdminPassword();
        String string6 = entryMappingRepositoryType.getDbURL();
        String string7 = entryMappingRepositoryType.getJDBCDriverClass();
        if (string != null) {
            map.put("dataSourceName", string);
        }
        if (string2 != null) {
            map.put("databaseType", string2);
        }
        if (string3 != null) {
            map.put("adapterClassName", string3);
        }
        if (string4 != null) {
            map.put("dbAdminId", string4);
        }
        if (string5 != null) {
            map.put("dbAdminPassword", string5);
        }
        if (string6 != null) {
            map.put("dbURL", string6);
        }
        if (string7 != null) {
            map.put("JDBCDriverClass", string7);
        }
    }

    private void getLookAsideRepositoryInfo(PropertyExtensionRepositoryType propertyExtensionRepositoryType, Map map) {
        String string = propertyExtensionRepositoryType.getDataSourceName();
        String string2 = propertyExtensionRepositoryType.getDatabaseType();
        String string3 = propertyExtensionRepositoryType.getAdapterClassName();
        Integer n = new Integer(propertyExtensionRepositoryType.getEntityRetrievalLimit());
        String string4 = propertyExtensionRepositoryType.getDbAdminId();
        String string5 = propertyExtensionRepositoryType.getDbAdminPassword();
        String string6 = propertyExtensionRepositoryType.getDbURL();
        String string7 = propertyExtensionRepositoryType.getJDBCDriverClass();
        if (string != null) {
            map.put("dataSourceName", string);
        }
        if (string2 != null) {
            map.put("databaseType", string2);
        }
        if (string3 != null) {
            map.put("adapterClassName", string3);
        }
        if (n != null) {
            map.put("entityRetrievalLimit", n);
        }
        if (string4 != null) {
            map.put("dbAdminId", string4);
        }
        if (string5 != null) {
            map.put("dbAdminPassword", string5);
        }
        if (string6 != null) {
            map.put("dbURL", string6);
        }
        if (string7 != null) {
            map.put("JDBCDriverClass", string7);
        }
    }

    private void getFileRepositoryInfo(FileRepositoryType fileRepositoryType, Map map) {
        Integer n;
        String string = fileRepositoryType.getBaseDirectory();
        if (string != null) {
            map.put("baseDirectory", string);
        }
        if ((string = fileRepositoryType.getFileName()) != null) {
            map.put("fileName", string);
        }
        if ((string = fileRepositoryType.getMessageDigestAlgorithm()) != null) {
            map.put("messageDigestAlgorithm", string);
        }
        if ((n = new Integer(fileRepositoryType.getSaltLength())) != null) {
            map.put("saltLength", n);
        }
    }

    private void getLDAPRepositoryInfo(LdapRepositoryType ldapRepositoryType, Map map) {
        LdapServerConfigurationType ldapServerConfigurationType;
        String string = ldapRepositoryType.getLdapServerType();
        map.put("ldapServerType", string);
        map.put("translateRDN", ldapRepositoryType.isTranslateRDN());
        if (ldapRepositoryType.getCertificateMapMode() != null) {
            map.put("certificateMapMode", ldapRepositoryType.getCertificateMapMode());
        }
        if (ldapRepositoryType.getCertificateFilter() != null) {
            map.put("certificateFilter", ldapRepositoryType.getCertificateFilter());
        }
        if (ldapRepositoryType.getLoginProperties().size() > 0) {
            map.put("loginProperties", ConfigUtils.convertEList(ldapRepositoryType.getLoginProperties()));
        }
        if ((ldapServerConfigurationType = ldapRepositoryType.getLdapServerConfiguration()).isSetSearchTimeLimit()) {
            map.put("searchTimeLimit", new Integer(ldapServerConfigurationType.getSearchTimeLimit()));
        }
        if (ldapServerConfigurationType.isSetSearchCountLimit()) {
            map.put("searchCountLimit", new Integer(ldapServerConfigurationType.getSearchCountLimit()));
        }
        if (ldapServerConfigurationType.isSetSearchPageSize()) {
            map.put("searchPageSize", new Integer(ldapServerConfigurationType.getSearchPageSize()));
        }
        if ((string = ldapServerConfigurationType.getSslConfiguration()) != null) {
            map.put("sslConfiguration", string);
        }
        if (ldapServerConfigurationType.isSetReturnToPrimaryServer()) {
            map.put("returnToPrimaryServer", ldapServerConfigurationType.isReturnToPrimaryServer());
        }
        if (ldapServerConfigurationType.isSetPrimaryServerQueryTimeInterval()) {
            map.put("primaryServerQueryTimeInterval", new Integer(ldapServerConfigurationType.getPrimaryServerQueryTimeInterval()));
        }
    }

    private void getDatabaseRepositoryInfo(DatabaseRepositoryType databaseRepositoryType, Map map) {
        map.put("databaseType", databaseRepositoryType.getDatabaseType());
        if (databaseRepositoryType.getDataSourceName() != null) {
            map.put("dataSourceName", databaseRepositoryType.getDataSourceName());
        }
        if (databaseRepositoryType.getDbURL() != null) {
            map.put("dbURL", databaseRepositoryType.getDbURL());
        }
        if (databaseRepositoryType.getDbAdminId() != null) {
            map.put("dbAdminId", databaseRepositoryType.getDbAdminId());
        }
        if (databaseRepositoryType.getDbAdminPassword() != null) {
            map.put("dbAdminPassword", databaseRepositoryType.getDbAdminPassword());
        }
        if (databaseRepositoryType.getJDBCDriverClass() != null) {
            map.put("JDBCDriverClass", databaseRepositoryType.getJDBCDriverClass());
        }
        if (databaseRepositoryType.isSetEntityRetrievalLimit()) {
            map.put("entityRetrievalLimit", new Integer(databaseRepositoryType.getEntityRetrievalLimit()));
        }
        if (databaseRepositoryType.isSetSaltLength()) {
            map.put("saltLength", new Integer(databaseRepositoryType.getSaltLength()));
        }
        if (databaseRepositoryType.getEncryptionKey() != null) {
            map.put("encryptionKey", databaseRepositoryType.getEncryptionKey());
        }
    }

    private void addBaseEntryMapInfo(ProfileRepositoryType profileRepositoryType, Map map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list = profileRepositoryType.getBaseEntries();
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            BaseEntriesType baseEntriesType = (BaseEntriesType)list.get(i);
            hashMap.put(baseEntriesType.getName(), baseEntriesType.getNameInRepository());
        }
        map.put("baseEntries", hashMap);
    }

    private void addCustomPropertiesInfo(ProfileRepositoryType profileRepositoryType, Map map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list = profileRepositoryType.getCustomProperties();
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            CustomPropertiesType customPropertiesType = (CustomPropertiesType)list.get(i);
            hashMap.put(customPropertiesType.getName(), customPropertiesType.getValue());
        }
        map.put("CustomProperties", hashMap);
    }

    public String addIdMgrRepositoryBaseEntry(String string, Map map) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "addIdMgrRepositoryBaseEntry", "params = " + map);
        }
        String string2 = (String)map.get("id");
        String string3 = UniqueNameHelper.getValidUniqueName((String)map.get("name"));
        String string4 = UniqueNameHelper.getValidUniqueName((String)map.get("nameInRepository"));
        ConfigValidator.validateAddIdMgrRepositoryBaseEntry(ConfigUtils.getConfigProvider(string), string2, string3);
        ProfileRepositoryType profileRepositoryType = (ProfileRepositoryType)ConfigUtils.getRepositoryById(string, string2);
        this.validateNameInRepository(string2, profileRepositoryType, string3, string4);
        if (this.getBaseEntryInRepository(string3, profileRepositoryType) != null) {
            throw new WIMConfigurationException("BASE_ENTRY_ALREADY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms(string3, string2), Level.SEVERE, CLASSNAME, "addIdMgrRepositoryBaseEntry");
        }
        BaseEntriesType baseEntriesType = profileRepositoryType.createBaseEntries();
        baseEntriesType.setName(string3);
        baseEntriesType.setNameInRepository(string4);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "addIdMgrRepositoryBaseEntry");
        }
        return ConfigUtils.saveConfig(string);
    }

    private BaseEntriesType getBaseEntryInRepository(String string, ProfileRepositoryType profileRepositoryType) {
        List list = profileRepositoryType.getBaseEntries();
        BaseEntriesType baseEntriesType = null;
        for (int i = 0; i < list.size(); ++i) {
            BaseEntriesType baseEntriesType2 = (BaseEntriesType)list.get(i);
            String string2 = baseEntriesType2.getName();
            if (!string.equals(string2)) continue;
            baseEntriesType = baseEntriesType2;
            break;
        }
        return baseEntriesType;
    }

    public String updateIdMgrRepositoryBaseEntry(String string, Map map) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "updateIdMgrRepositoryBaseEntry", "params = " + map);
        }
        String string2 = (String)map.get("id");
        String string3 = UniqueNameHelper.getValidUniqueName((String)map.get("name"));
        String string4 = UniqueNameHelper.getValidUniqueName((String)map.get("nameInRepository"));
        ProfileRepositoryType profileRepositoryType = (ProfileRepositoryType)ConfigUtils.getRepositoryById(string, string2);
        BaseEntriesType baseEntriesType = this.getBaseEntryInRepository(string3, profileRepositoryType);
        if (baseEntriesType == null) {
            throw new WIMConfigurationException("BASE_ENTRY_NOT_FOUND_IN_REPOSITORY", WIMMessageHelper.generateMsgParms(string3, string2), Level.SEVERE, CLASSNAME, "updateIdMgrRepositoryBaseEntry");
        }
        this.validateNameInRepository(string2, profileRepositoryType, string3, string4);
        baseEntriesType.setNameInRepository(string4);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "updateIdMgrRepositoryBaseEntry");
        }
        return ConfigUtils.saveConfig(string);
    }

    private void validateNameInRepository(String string, ProfileRepositoryType profileRepositoryType, String string2, String string3) throws WIMConfigurationException {
        String string4 = string3;
        if (string3 == null) {
            string4 = string2;
        }
        if (string4 != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string4);
            if (profileRepositoryType instanceof LdapRepositoryType) {
                Map map = new LDAPRepositoryConfigHelper().getLDAPConnectionData((LdapRepositoryType)profileRepositoryType);
                map.put("nameInRepository", arrayList);
                ConfigValidator.validateRepositoryParams(string, ConfigUtils.getRepositoryType(profileRepositoryType), map);
            }
        }
    }

    public String deleteIdMgrRepositoryBaseEntry(String string, Map map) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deleteIdMgrRepositoryBaseEntry", "params = " + map);
        }
        String string2 = (String)map.get("id");
        String string3 = UniqueNameHelper.getValidUniqueName((String)map.get("name"));
        ProfileRepositoryType profileRepositoryType = (ProfileRepositoryType)ConfigUtils.getRepositoryById(string, string2);
        BaseEntriesType baseEntriesType = this.getBaseEntryInRepository(string3, profileRepositoryType);
        ConfigValidator.validateDeleteIdMgrRepositoryBaseEntry(ConfigUtils.getConfigProvider(string), string2, string3);
        if (baseEntriesType == null) {
            throw new WIMConfigurationException("BASE_ENTRY_NOT_FOUND_IN_REPOSITORY", WIMMessageHelper.generateMsgParms(string3, string2), Level.SEVERE, CLASSNAME, "deleteIdMgrRepositoryBaseEntry");
        }
        ((DataObject)baseEntriesType).delete();
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deleteIdMgrRepositoryBaseEntry");
        }
        return ConfigUtils.saveConfig(string);
    }

    public Map listIdMgrRepositoryBaseEntries(String string, Map map) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "listIdMgrRepositoryBaseEntries", "params = " + map);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = (String)map.get("id");
        ProfileRepositoryType profileRepositoryType = (ProfileRepositoryType)ConfigUtils.getRepositoryById(string, string2);
        List list = profileRepositoryType.getBaseEntries();
        for (int i = 0; i < list.size(); ++i) {
            BaseEntriesType baseEntriesType = (BaseEntriesType)list.get(i);
            String string3 = baseEntriesType.getName();
            String string4 = baseEntriesType.getNameInRepository();
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    public String setIdMgrCustomProperty(String string, Map map) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setIdMgrCustomProperty", "params=" + map);
        }
        String string2 = (String)map.get("name");
        String string3 = (String)map.get("value");
        String string4 = (String)map.get("id");
        ProfileRepositoryType profileRepositoryType = (ProfileRepositoryType)ConfigUtils.getRepositoryById(string, string4);
        List list = profileRepositoryType.getCustomProperties();
        if (string2.equals("")) {
            list.clear();
        } else {
            boolean bl2 = false;
            for (int i = 0; i < list.size(); ++i) {
                CustomPropertiesType customPropertiesType = (CustomPropertiesType)list.get(i);
                String string5 = customPropertiesType.getName();
                if (!string5.equals(string2)) continue;
                bl2 = true;
                if (string3.equals("")) {
                    ((DataObject)customPropertiesType).delete();
                    break;
                }
                customPropertiesType.setValue(string3);
                break;
            }
            if (!bl2 && !string3.equals("")) {
                CustomPropertiesType customPropertiesType = profileRepositoryType.createCustomProperties();
                customPropertiesType.setName(string2);
                customPropertiesType.setValue(string3);
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setIdMgrCustomProperty");
        }
        return ConfigUtils.saveConfig(string);
    }

    public Map listIdMgrCustomProperties(String string, String string2) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "listIdMgrCustomProperties", "id=" + string2);
        }
        ProfileRepositoryType profileRepositoryType = (ProfileRepositoryType)ConfigUtils.getRepositoryById(string, string2);
        List list = profileRepositoryType.getCustomProperties();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            CustomPropertiesType customPropertiesType = (CustomPropertiesType)list.get(i);
            hashMap.put(customPropertiesType.getName(), customPropertiesType.getValue());
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "listIdMgrCustomProperties", "returning=" + hashMap);
        }
        return hashMap;
    }
}

