/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.config.ConfigValidator;
import com.ibm.ws.wim.config.LDAPServerConfigHelper;
import com.ibm.ws.wim.config.SupportedEntityTypeConfigHelper;
import com.ibm.ws.wim.config.ValidationHelper;
import com.ibm.ws.wim.configmodel.AttributeConfigurationType;
import com.ibm.ws.wim.configmodel.AttributeType;
import com.ibm.ws.wim.configmodel.AttributesCacheType;
import com.ibm.ws.wim.configmodel.CacheConfigurationType;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.ConnectionsType;
import com.ibm.ws.wim.configmodel.ContextPoolType;
import com.ibm.ws.wim.configmodel.DynamicMemberAttributesType;
import com.ibm.ws.wim.configmodel.GroupConfigurationType;
import com.ibm.ws.wim.configmodel.LdapEntityTypesType;
import com.ibm.ws.wim.configmodel.LdapRepositoryType;
import com.ibm.ws.wim.configmodel.LdapServerConfigurationType;
import com.ibm.ws.wim.configmodel.LdapServersType;
import com.ibm.ws.wim.configmodel.MemberAttributesType;
import com.ibm.ws.wim.configmodel.MembershipAttributeType;
import com.ibm.ws.wim.configmodel.ProfileRepositoryType;
import com.ibm.ws.wim.configmodel.PropertiesNotSupportedType;
import com.ibm.ws.wim.configmodel.RdnAttributesType;
import com.ibm.ws.wim.configmodel.SearchResultsCacheType;
import com.ibm.ws.wim.configmodel.SupportedEntityTypesType;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class LDAPRepositoryConfigHelper
extends LDAPServerConfigHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = LDAPRepositoryConfigHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static Map defaultValue = null;
    private static List supportedServers = null;

    public String createIdMgrLDAPRepository(String string, Map map) throws WIMException {
        Object object;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "createIdMgrLDAPRepository", "params=" + map);
        }
        String string2 = (String)map.get("id");
        ConfigUtils.checkForValidRepositoryById(string, string2);
        List list = (List)map.get("loginProperties");
        ValidationHelper.validateStringInputInList("loginProperties", CLASSNAME, "createIdMgrLDAPRepository", list, false);
        ConfigValidator.validateRepositoryParams(string2, "LdapRepositoryType", map);
        ConfigurationProviderType configurationProviderType = ConfigUtils.getConfigProvider(string);
        EClass eClass = ConfigManager.singleton().getConfigEClass("LdapRepositoryType");
        DataObject dataObject = (DataObject)EcoreUtil.create((EClass)eClass);
        dataObject.setString("id", string2);
        configurationProviderType.getRepositories().add(dataObject);
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.getRepositoryById(configurationProviderType, string2);
        ConfigUtils.setCommonRepositoryProperties(ldapRepositoryType, map, this.getDefaultValue(), false);
        if (list != null) {
            object = ldapRepositoryType.getLoginProperties();
            ConfigUtils.addOrRemovePresentList("loginProperties", list, (List)object);
        }
        object = (String)ConfigUtils.getParamValue(map, null, "ldapServerType", true);
        ldapRepositoryType.setLdapServerType((String)object);
        Boolean bl2 = (Boolean)ConfigUtils.getParamValue(map, this.getDefaultValue(), "translateRDN", false);
        ldapRepositoryType.setTranslateRDN(bl2);
        String string3 = (String)ConfigUtils.getParamValue(map, this.getDefaultValue(), "certificateMapMode", false);
        if (string3 != null) {
            ldapRepositoryType.setCertificateMapMode(string3);
        }
        if ((string3 = (String)map.get("certificateFilter")) != null) {
            ldapRepositoryType.setCertificateFilter(string3);
        }
        LdapServerConfigurationType ldapServerConfigurationType = ldapRepositoryType.createLdapServerConfiguration();
        this.setLdapServerConfigParams(ldapServerConfigurationType, map);
        Boolean bl3 = (Boolean)map.get("default");
        if (bl3 != null && bl3.booleanValue()) {
            if (((String)object).equals("SECUREWAY") || ((String)object).equals("IDS4") || ((String)object).equals("IDS51") || ((String)object).equals("IDS52") || ((String)object).equals("IDS6") || ((String)object).equals("ZOSDS")) {
                this.setDefaultsForIDS(ldapRepositoryType);
            } else if (((String)object).equals("DOMINO5") || ((String)object).equals("DOMINO6") || ((String)object).equals("DOMINO65")) {
                this.setDefaultsForDomino(ldapRepositoryType, string);
            } else if (((String)object).equals("NDS") || ((String)object).equals("SUNONE")) {
                this.setDefaultsForNDSorSunone(ldapRepositoryType, (String)object);
            } else if (((String)object).equals("AD2000") || ((String)object).equals("AD2003")) {
                this.setDefaultsForActiveDirectory(ldapRepositoryType);
            } else if (((String)object).equals("ADAM")) {
                this.setDefaultsForADAM(ldapRepositoryType);
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "createIdMgrLDAPRepository");
        }
        ConfigUtils.saveConfig(string);
        return "MUST_ADD_BASE_ENTRY_TO_REPOSITORY";
    }

    public String updateIdMgrLDAPRepository(String string, Map map) throws WIMException {
        LdapServerConfigurationType ldapServerConfigurationType;
        String string2;
        Object object;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "updateIdMgrLDAPRepository", "params=" + map);
        }
        String string3 = (String)map.get("id");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string3, "LdapRepositoryType");
        String string4 = (String)ConfigUtils.getParamValue(map, null, "ldapServerType", true);
        List list = (List)map.get("loginProperties");
        ValidationHelper.validateStringInputInList("loginProperties", CLASSNAME, "updateIdMgrLDAPRepository", list, true);
        ConfigValidator.validateRepositoryParams(string3, "LdapRepositoryType", map);
        Map map2 = new HashMap();
        if (map.containsKey("sslConfiguration") || map.containsKey("certificateMapMode") || map.containsKey("certificateFilter")) {
            try {
                map2 = this.getLDAPConnectionData(ldapRepositoryType);
            }
            catch (WIMConfigurationException wIMConfigurationException) {
                // empty catch block
            }
        }
        map2.putAll(map);
        ConfigValidator.validateLDAPParams(string3, map2);
        if (string4 != null) {
            ldapRepositoryType.setLdapServerType(string4);
        }
        ConfigUtils.setCommonRepositoryProperties(ldapRepositoryType, map, null, true);
        if (list != null) {
            object = ldapRepositoryType.getLoginProperties();
            ConfigUtils.addOrRemovePresentList("loginProperties", list, (List)object);
        }
        if ((object = (Boolean)ConfigUtils.getParamValue(map, null, "translateRDN", true)) != null) {
            ldapRepositoryType.setTranslateRDN((Boolean)object);
        }
        if ((string2 = (String)map.get("certificateMapMode")) != null) {
            ldapRepositoryType.setCertificateMapMode(string2);
        }
        if ((string2 = (String)map.get("certificateFilter")) != null) {
            ldapRepositoryType.setCertificateFilter(string2);
        }
        if ((ldapServerConfigurationType = ldapRepositoryType.getLdapServerConfiguration()) == null) {
            ldapServerConfigurationType = ldapRepositoryType.createLdapServerConfiguration();
        }
        this.setLdapServerConfigParams(ldapServerConfigurationType, map);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "updateIdMgrLDAPRepository");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String addIdMgrLDAPEntityType(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "addIdMgrLDAPEntityType", "params=" + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("name");
        String string4 = (String)map.get("searchFilter");
        List list = (List)map.get("objectClasses");
        List list2 = (List)map.get("objectClassesForCreate");
        List list3 = (List)map.get("searchBases");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        LdapEntityTypesType ldapEntityTypesType = this.getEntityType(ldapRepositoryType, string3, false);
        if (ldapEntityTypesType != null) {
            throw new WIMConfigurationException("LDAP_ENTITY_TYPE_ALREADY_EXISTS", WIMMessageHelper.generateMsgParms(string3), Level.SEVERE, CLASSNAME, "addIdMgrLDAPEntityType");
        }
        Map map2 = this.getLDAPConnectionData(ldapRepositoryType);
        if (map2 != null) {
            if (string4 != null) {
                map2.put("searchFilter", string4);
            }
            if (list != null && list.size() > 0) {
                map2.put("objectClasses", list);
            }
            if (list2 != null && list2.size() > 0) {
                map2.put("objectClassesForCreate", list2);
            }
            if (list3 != null && list3.size() > 0) {
                map2.put("searchBases", list3);
            }
            ConfigValidator.validateLDAPParams(string2, map2);
        }
        ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName(string3);
        if (string4 != null) {
            ldapEntityTypesType.setSearchFilter(string4);
        }
        List list4 = ldapEntityTypesType.getObjectClasses();
        if (list != null) {
            ConfigUtils.addOrRemovePresentList("objectClasses", list, list4);
        }
        list4 = ldapEntityTypesType.getObjectClassesForCreate();
        if (list2 != null) {
            ConfigUtils.addOrRemovePresentList("objectClassesForCreate", list2, list4);
        }
        list4 = ldapEntityTypesType.getSearchBases();
        if (list3 != null) {
            ConfigUtils.addOrRemovePresentList("searchBases", list3, list4);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "addIdMgrLDAPEntityType");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String updateIdMgrLDAPEntityType(String string, Map map) throws WIMException {
        Object object;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "updateIdMgrLDAPEntityType", "params=" + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("name");
        String string4 = (String)map.get("searchFilter");
        List list = (List)map.get("objectClasses");
        List list2 = (List)map.get("objectClassesForCreate");
        List list3 = (List)map.get("searchBases");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        LdapEntityTypesType ldapEntityTypesType = this.getEntityType(ldapRepositoryType, string3, true);
        if ((string4 != null || list != null && list.size() > 0 || list2 != null && list2.size() > 0 || list3 != null && list3.size() > 0) && (object = this.getLDAPConnectionData(ldapRepositoryType)) != null) {
            if (string4 != null) {
                object.put("searchFilter", string4);
            }
            if (list != null && list.size() > 0) {
                object.put("objectClasses", list);
            }
            if (list2 != null && list2.size() > 0) {
                object.put("objectClassesForCreate", list2);
            }
            if (list3 != null && list3.size() > 0) {
                object.put("searchBases", list3);
            }
            ConfigValidator.validateLDAPParams(string2, (Map)object);
        }
        if (string4 != null) {
            ldapEntityTypesType.setSearchFilter(string4);
        }
        object = ldapEntityTypesType.getObjectClasses();
        if (list != null) {
            ConfigUtils.addOrRemovePresentList("objectClasses", list, (List)object);
        }
        object = ldapEntityTypesType.getObjectClassesForCreate();
        if (list2 != null) {
            ConfigUtils.addOrRemovePresentList("objectClassesForCreate", list2, (List)object);
        }
        object = ldapEntityTypesType.getSearchBases();
        if (list3 != null) {
            ConfigUtils.addOrRemovePresentList("searchBases", list3, (List)object);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "updateIdMgrLDAPEntityType");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String deleteIdMgrLDAPEntityType(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deleteIdMgrLDAPEntityType", "params=" + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("name");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        LdapEntityTypesType ldapEntityTypesType = this.getEntityType(ldapRepositoryType, string3, true);
        ((DataObject)ldapEntityTypesType).delete();
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deleteIdMgrLDAPEntityType");
        }
        return ConfigUtils.saveConfig(string);
    }

    public List listIdMgrLDAPEntityTypes(String string, String string2) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "listIdMgrLDAPEntityTypes", "id=" + string2);
        }
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        List list = ldapRepositoryType.getLdapEntityTypes();
        Vector<String> vector = new Vector<String>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                LdapEntityTypesType ldapEntityTypesType = (LdapEntityTypesType)list.get(i);
                vector.add(ldapEntityTypesType.getName());
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "listIdMgrLDAPEntityTypes");
        }
        return vector;
    }

    public Map getIdMgrLDAPEntityType(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrLDAPEntityType", "params=" + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("name");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        LdapEntityTypesType ldapEntityTypesType = this.getEntityType(ldapRepositoryType, string3, true);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", string2);
        hashMap.put("name", ldapEntityTypesType.getName());
        hashMap.put("searchFilter", ldapEntityTypesType.getSearchFilter());
        hashMap.put("objectClasses", ConfigUtils.convertEList(ldapEntityTypesType.getObjectClasses()));
        hashMap.put("objectClassesForCreate", ConfigUtils.convertEList(ldapEntityTypesType.getObjectClassesForCreate()));
        hashMap.put("searchBases", ConfigUtils.convertEList(ldapEntityTypesType.getSearchBases()));
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrLDAPEntityType");
        }
        return hashMap;
    }

    public String addIdMgrLDAPEntityTypeRDNAttr(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "addIdMgrLDAPEntityTypeRDNAttr", "params=" + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("entityTypeName");
        String string4 = (String)map.get("name");
        String string5 = (String)map.get("objectClass");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        LdapEntityTypesType ldapEntityTypesType = this.getEntityType(ldapRepositoryType, string3, true);
        RdnAttributesType rdnAttributesType = this.getRDNAttr(ldapEntityTypesType, string4, false);
        if (rdnAttributesType != null) {
            throw new WIMConfigurationException("RDN_ATTR_ALREADY_EXISTS", WIMMessageHelper.generateMsgParms(string4), Level.SEVERE, CLASSNAME, "addIdMgrLDAPEntityTypeRDNAttr");
        }
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName(string4);
        if (string5 != null) {
            rdnAttributesType.setObjectClass(string5);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "addIdMgrLDAPEntityTypeRDNAttr");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String deleteIdMgrLDAPEntityTypeRDNAttr(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deleteIdMgrLDAPEntityTypeRDNAttr", "params=" + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("entityTypeName");
        String string4 = (String)map.get("name");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        LdapEntityTypesType ldapEntityTypesType = this.getEntityType(ldapRepositoryType, string3, true);
        RdnAttributesType rdnAttributesType = this.getRDNAttr(ldapEntityTypesType, string4, true);
        ((DataObject)rdnAttributesType).delete();
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deleteIdMgrLDAPEntityTypeRDNAttr");
        }
        return ConfigUtils.saveConfig(string);
    }

    public Map getIdMgrLDAPEntityTypeRDNAttr(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrLDAPEntityTypeRDNAttr", "params=" + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("entityTypeName");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        LdapEntityTypesType ldapEntityTypesType = this.getEntityType(ldapRepositoryType, string3, true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list = ldapEntityTypesType.getRdnAttributes();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                RdnAttributesType rdnAttributesType = (RdnAttributesType)list.get(i);
                hashMap.put(rdnAttributesType.getName(), rdnAttributesType.getObjectClass());
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrLDAPEntityTypeRDNAttr", " returning " + hashMap);
        }
        return hashMap;
    }

    public String setIdMgrLDAPGroupConfig(String string, Map map) throws WIMException {
        GroupConfigurationType groupConfigurationType;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setIdMgrLDAPGroupConfig", "params=" + map);
        }
        String string2 = (String)map.get("id");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        Boolean bl2 = (Boolean)map.get("updateGroupMembership");
        String string3 = (String)map.get("name");
        String string4 = (String)map.get("scope");
        if (string4 != null) {
            ValidationHelper.validateParam("scope", string4, CONFIG_SCOPES);
        }
        if ((groupConfigurationType = this.getLDAPGroupConfig(ldapRepositoryType, false)) == null) {
            groupConfigurationType = ldapRepositoryType.createGroupConfiguration();
        }
        MembershipAttributeType membershipAttributeType = groupConfigurationType.getMembershipAttribute();
        if (string3 != null) {
            if (string3.trim().equals("")) {
                if (membershipAttributeType != null) {
                    ((DataObject)membershipAttributeType).delete();
                }
            } else {
                if (membershipAttributeType == null) {
                    membershipAttributeType = groupConfigurationType.createMembershipAttribute();
                    membershipAttributeType.setScope("direct");
                }
                membershipAttributeType.setName(string3);
                if (string4 != null) {
                    membershipAttributeType.setScope(string4);
                }
            }
        } else if (string4 != null) {
            if (membershipAttributeType == null) {
                throw new WIMConfigurationException("CONFIG_GROUP_SCOPE_CANNOT_BE_SET", Level.SEVERE, CLASSNAME, "setIdMgrLDAPGroupConfig");
            }
            membershipAttributeType.setScope(string4);
        }
        if (bl2 != null) {
            groupConfigurationType.setUpdateGroupMembership(bl2);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setIdMgrLDAPGroupConfig");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String deleteIdMgrLDAPGroupConfig(String string, String string2) throws WIMException {
        LdapRepositoryType ldapRepositoryType;
        GroupConfigurationType groupConfigurationType;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deleteIdMgrLDAPGroupConfig", "id=" + string2);
        }
        if ((groupConfigurationType = this.getLDAPGroupConfig(ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType"), true)) != null) {
            ((DataObject)groupConfigurationType).delete();
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deleteIdMgrLDAPGroupConfig");
        }
        return ConfigUtils.saveConfig(string);
    }

    public Map getIdMgrLDAPGroupConfig(String string, String string2) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrLDAPGroupConfig", "id=" + string2);
        }
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        HashMap<String, Object> hashMap = null;
        GroupConfigurationType groupConfigurationType = this.getLDAPGroupConfig(ldapRepositoryType, false);
        if (groupConfigurationType != null) {
            MembershipAttributeType membershipAttributeType;
            hashMap = new HashMap<String, Object>();
            if (groupConfigurationType.isSetUpdateGroupMembership()) {
                hashMap.put("updateGroupMembership", groupConfigurationType.isUpdateGroupMembership());
            }
            if ((membershipAttributeType = groupConfigurationType.getMembershipAttribute()) != null) {
                hashMap.put("name", membershipAttributeType.getName());
                if (membershipAttributeType.isSetScope()) {
                    hashMap.put("scope", membershipAttributeType.getScope());
                }
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrLDAPGroupConfig", " returning " + hashMap);
        }
        return hashMap;
    }

    public String addIdMgrLDAPGroupMemberAttr(String string, Map map) throws WIMException {
        LdapRepositoryType ldapRepositoryType;
        GroupConfigurationType groupConfigurationType;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "addIdMgrLDAPGroupMemberAttr", "params=" + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("scope");
        if (string3 != null) {
            ValidationHelper.validateParam("scope", string3, CONFIG_SCOPES);
        }
        if ((groupConfigurationType = this.getLDAPGroupConfig(ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType"), false)) == null) {
            groupConfigurationType = ldapRepositoryType.createGroupConfiguration();
        }
        String string4 = (String)map.get("name");
        String string5 = (String)map.get("objectClass");
        String string6 = (String)map.get("dummyMember");
        MemberAttributesType memberAttributesType = this.getGroupMemberAttr(groupConfigurationType, string4, false);
        if (memberAttributesType != null) {
            throw new WIMConfigurationException("GROUP_MEMBER_ATTR_ALREADY_EXISTS", WIMMessageHelper.generateMsgParms(string4), Level.SEVERE, CLASSNAME, "addIdMgrLDAPGroupMemberAttr");
        }
        memberAttributesType = groupConfigurationType.createMemberAttributes();
        memberAttributesType.setName(string4);
        if (string5 != null) {
            memberAttributesType.setObjectClass(string5);
        }
        if (string3 != null) {
            memberAttributesType.setScope(string3);
        }
        if (string6 != null) {
            memberAttributesType.setDummyMember(string6);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "addIdMgrLDAPGroupMemberAttr");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String updateIdMgrLDAPGroupMemberAttr(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "updateIdMgrLDAPGroupMemberAttr", "params=" + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("scope");
        if (string3 != null) {
            ValidationHelper.validateParam("scope", string3, CONFIG_SCOPES);
        }
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        GroupConfigurationType groupConfigurationType = this.getLDAPGroupConfig(ldapRepositoryType, true);
        String string4 = (String)map.get("name");
        String string5 = (String)map.get("objectClass");
        String string6 = (String)map.get("dummyMember");
        MemberAttributesType memberAttributesType = this.getGroupMemberAttr(groupConfigurationType, string4, true);
        if (string5 != null) {
            memberAttributesType.setObjectClass(string5);
        }
        if (string3 != null) {
            memberAttributesType.setScope(string3);
        }
        if (string6 != null) {
            memberAttributesType.setDummyMember(string6);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "updateIdMgrLDAPGroupMemberAttr");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String deleteIdMgrLDAPGroupMemberAttr(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deleteIdMgrLDAPGroupMemberAttr", "params=" + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("name");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        GroupConfigurationType groupConfigurationType = this.getLDAPGroupConfig(ldapRepositoryType, true);
        MemberAttributesType memberAttributesType = this.getGroupMemberAttr(groupConfigurationType, string3, true);
        ((DataObject)memberAttributesType).delete();
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deleteIdMgrLDAPGroupMemberAttr");
        }
        return ConfigUtils.saveConfig(string);
    }

    public List getIdMgrLDAPGroupMemberAttrs(String string, String string2) throws WIMException {
        List list;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrLDAPGroupMemberAttrs", "id=" + string2);
        }
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        ArrayList arrayList = new ArrayList();
        GroupConfigurationType groupConfigurationType = this.getLDAPGroupConfig(ldapRepositoryType, false);
        if (groupConfigurationType != null && (list = groupConfigurationType.getMemberAttributes()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                MemberAttributesType memberAttributesType = (MemberAttributesType)list.get(i);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("name", memberAttributesType.getName());
                if (memberAttributesType.getObjectClass() != null) {
                    hashMap.put("objectClass", memberAttributesType.getObjectClass());
                }
                if (memberAttributesType.isSetScope()) {
                    hashMap.put("scope", memberAttributesType.getScope());
                }
                if (memberAttributesType.getDummyMember() != null) {
                    hashMap.put("dummyMember", memberAttributesType.getDummyMember());
                }
                arrayList.add(hashMap);
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrLDAPGroupMemberAttrs", " returning " + arrayList);
        }
        return arrayList;
    }

    public String addIdMgrLDAPGroupDynamicMemberAttr(String string, Map map) throws WIMException {
        String string2;
        LdapRepositoryType ldapRepositoryType;
        GroupConfigurationType groupConfigurationType;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "addIdMgrLDAPGroupDynamicMemberAttr", "params=" + map);
        }
        if ((groupConfigurationType = this.getLDAPGroupConfig(ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2 = (String)map.get("id"), "LdapRepositoryType"), false)) == null) {
            groupConfigurationType = ldapRepositoryType.createGroupConfiguration();
        }
        String string3 = (String)map.get("name");
        String string4 = (String)map.get("objectClass");
        DynamicMemberAttributesType dynamicMemberAttributesType = this.getGroupDynamicMemberAttr(groupConfigurationType, string3, false);
        if (dynamicMemberAttributesType != null) {
            throw new WIMConfigurationException("DYMANIC_GROUP_MEMBER_ATTR_ALREADY_EXISTS", WIMMessageHelper.generateMsgParms(string3), Level.SEVERE, CLASSNAME, "addIdMgrLDAPGroupDynamicMemberAttr");
        }
        dynamicMemberAttributesType = groupConfigurationType.createDynamicMemberAttributes();
        dynamicMemberAttributesType.setName(string3);
        dynamicMemberAttributesType.setObjectClass(string4);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "addIdMgrLDAPGroupDynamicMemberAttr");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String updateIdMgrLDAPGroupDynamicMemberAttr(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "updateIdMgrLDAPGroupDynamicMemberAttr", "params=" + map);
        }
        String string2 = (String)map.get("id");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        GroupConfigurationType groupConfigurationType = this.getLDAPGroupConfig(ldapRepositoryType, true);
        String string3 = (String)map.get("name");
        String string4 = (String)map.get("objectClass");
        DynamicMemberAttributesType dynamicMemberAttributesType = this.getGroupDynamicMemberAttr(groupConfigurationType, string3, true);
        dynamicMemberAttributesType.setObjectClass(string4);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "updateIdMgrLDAPGroupDynamicMemberAttr");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String deleteIdMgrLDAPGroupDynamicMemberAttr(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deleteIdMgrLDAPGroupDynamicMemberAttr", "params=" + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("name");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        GroupConfigurationType groupConfigurationType = this.getLDAPGroupConfig(ldapRepositoryType, true);
        DynamicMemberAttributesType dynamicMemberAttributesType = this.getGroupDynamicMemberAttr(groupConfigurationType, string3, true);
        ((DataObject)dynamicMemberAttributesType).delete();
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deleteIdMgrLDAPGroupDynamicMemberAttr");
        }
        return ConfigUtils.saveConfig(string);
    }

    public List getIdMgrLDAPGroupDynamicMemberAttrs(String string, String string2) throws WIMException {
        List list;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrLDAPGroupDynamicMemberAttrs", "id=" + string2);
        }
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        ArrayList arrayList = new ArrayList();
        GroupConfigurationType groupConfigurationType = this.getLDAPGroupConfig(ldapRepositoryType, false);
        if (groupConfigurationType != null && (list = groupConfigurationType.getDynamicMemberAttributes()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                DynamicMemberAttributesType dynamicMemberAttributesType = (DynamicMemberAttributesType)list.get(i);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("name", dynamicMemberAttributesType.getName());
                if (dynamicMemberAttributesType.getObjectClass() != null) {
                    hashMap.put("objectClass", dynamicMemberAttributesType.getObjectClass());
                }
                arrayList.add(hashMap);
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrLDAPGroupDynamicMemberAttrs", " returning " + arrayList);
        }
        return arrayList;
    }

    public String setIdMgrLDAPContextPool(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setIdMgrLDAPContextPool", "Parms: " + map.toString());
        }
        String string2 = (String)map.get("id");
        Boolean bl2 = (Boolean)map.get("enabled");
        Integer n = (Integer)map.get("initPoolSize");
        Integer n2 = (Integer)map.get("maxPoolSize");
        Integer n3 = (Integer)map.get("prefPoolSize");
        Integer n4 = (Integer)map.get("poolTimeOut");
        Integer n5 = (Integer)map.get("poolWaitTime");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        ContextPoolType contextPoolType = ConfigUtils.getOrCreateContextPool(ldapRepositoryType);
        if (bl2 != null) {
            contextPoolType.setEnabled(bl2);
        }
        if (n != null) {
            contextPoolType.setInitPoolSize(n);
        }
        if (n2 != null) {
            contextPoolType.setMaxPoolSize(n2);
        }
        if (n3 != null) {
            contextPoolType.setPrefPoolSize(n3);
        }
        if (n4 != null) {
            contextPoolType.setPoolTimeOut(n4);
        }
        if (n5 != null) {
            contextPoolType.setPoolWaitTime(n5);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setIdMgrLDAPContextPool");
        }
        return ConfigUtils.saveConfig(string);
    }

    public Map getIdMgrLDAPContextPool(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrLDAPContextPool", "Parms: " + map.toString());
        }
        HashMap<String, Comparable<Boolean>> hashMap = new HashMap<String, Comparable<Boolean>>();
        String string2 = (String)map.get("id");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        ContextPoolType contextPoolType = ldapRepositoryType.getContextPool();
        if (contextPoolType != null) {
            hashMap.put("enabled", Boolean.valueOf(contextPoolType.isEnabled()));
            hashMap.put("initPoolSize", new Integer(contextPoolType.getInitPoolSize()));
            hashMap.put("maxPoolSize", new Integer(contextPoolType.getMaxPoolSize()));
            hashMap.put("prefPoolSize", new Integer(contextPoolType.getPrefPoolSize()));
            hashMap.put("poolTimeOut", new Integer(contextPoolType.getPoolTimeOut()));
            hashMap.put("poolWaitTime", new Integer(contextPoolType.getPoolWaitTime()));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrLDAPContextPool", "Result: " + ((Object)hashMap).toString());
        }
        return hashMap;
    }

    public String setIdMgrLDAPAttrCache(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setIdMgrLDAPAttrCache", "Parms: " + map.toString());
        }
        String string2 = (String)map.get("id");
        Boolean bl2 = (Boolean)map.get("enabled");
        Integer n = (Integer)map.get("cacheSize");
        Integer n2 = (Integer)map.get("cacheTimeOut");
        Integer n3 = (Integer)map.get("attributeSizeLimit");
        String string3 = (String)map.get("serverTTLAttribute");
        Boolean bl3 = (Boolean)map.get("cachesDiskOffLoad");
        String string4 = (String)map.get("cacheDistPolicy");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        if (string4 != null) {
            ValidationHelper.validateParam("cacheDistPolicy", string4, CONFIG_CACHE_DIST_POLICIES);
        }
        CacheConfigurationType cacheConfigurationType = ConfigUtils.getOrCreateCacheConfiguration(ldapRepositoryType);
        if (bl3 != null) {
            cacheConfigurationType.setCachesDiskOffLoad(bl3);
        }
        AttributesCacheType attributesCacheType = ConfigUtils.getOrCreateAttributesCache(ldapRepositoryType);
        if (bl2 != null) {
            attributesCacheType.setEnabled(bl2);
        }
        if (n != null) {
            attributesCacheType.setCacheSize(n);
        }
        if (n2 != null) {
            attributesCacheType.setCacheTimeOut(n2);
        }
        if (n3 != null) {
            attributesCacheType.setAttributeSizeLimit(n3);
        }
        if (string3 != null) {
            attributesCacheType.setServerTTLAttribute(string3);
        }
        if (string4 != null) {
            attributesCacheType.setCacheDistPolicy(string4);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setIdMgrLDAPAttrCache");
        }
        return ConfigUtils.saveConfig(string);
    }

    public Map getIdMgrLDAPAttrCache(String string, Map map) throws WIMException {
        AttributesCacheType attributesCacheType;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrLDAPAttrCache", "Parms: " + map.toString());
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = (String)map.get("id");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        CacheConfigurationType cacheConfigurationType = ConfigUtils.getOrCreateCacheConfiguration(ldapRepositoryType);
        if (cacheConfigurationType.isSetCachesDiskOffLoad()) {
            hashMap.put("cachesDiskOffLoad", cacheConfigurationType.isCachesDiskOffLoad());
        }
        if ((attributesCacheType = ConfigUtils.getOrCreateAttributesCache(ldapRepositoryType)).isSetEnabled()) {
            hashMap.put("enabled", attributesCacheType.isEnabled());
        }
        if (attributesCacheType.isSetCacheSize()) {
            hashMap.put("cacheSize", new Integer(attributesCacheType.getCacheSize()));
        }
        if (attributesCacheType.isSetCacheTimeOut()) {
            hashMap.put("cacheTimeOut", new Integer(attributesCacheType.getCacheTimeOut()));
        }
        if (attributesCacheType.isSetAttributeSizeLimit()) {
            hashMap.put("attributeSizeLimit", new Integer(attributesCacheType.getAttributeSizeLimit()));
        }
        if (attributesCacheType.getServerTTLAttribute() != null) {
            hashMap.put("serverTTLAttribute", attributesCacheType.getServerTTLAttribute());
        }
        if (attributesCacheType.getCacheDistPolicy() != null) {
            hashMap.put("cacheDistPolicy", attributesCacheType.getCacheDistPolicy());
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrLDAPAttrCache", "Result: " + ((Object)hashMap).toString());
        }
        return hashMap;
    }

    public String setIdMgrLDAPSearchResultCache(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setIdMgrLDAPSearchResultCache", "Parms: " + map.toString());
        }
        String string2 = (String)map.get("id");
        Boolean bl2 = (Boolean)map.get("cachesDiskOffLoad");
        Boolean bl3 = (Boolean)map.get("enabled");
        Integer n = (Integer)map.get("cacheSize");
        Integer n2 = (Integer)map.get("cacheTimeOut");
        Integer n3 = (Integer)map.get("searchResultSizeLimit");
        String string3 = (String)map.get("cacheDistPolicy");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        if (string3 != null) {
            ValidationHelper.validateParam("cacheDistPolicy", string3, CONFIG_CACHE_DIST_POLICIES);
        }
        CacheConfigurationType cacheConfigurationType = ConfigUtils.getOrCreateCacheConfiguration(ldapRepositoryType);
        if (bl2 != null) {
            cacheConfigurationType.setCachesDiskOffLoad(bl2);
        }
        SearchResultsCacheType searchResultsCacheType = ConfigUtils.getOrCreateSearchResultsCache(ldapRepositoryType);
        if (bl3 != null) {
            searchResultsCacheType.setEnabled(bl3);
        }
        if (n != null) {
            searchResultsCacheType.setCacheSize(n);
        }
        if (n2 != null) {
            searchResultsCacheType.setCacheTimeOut(n2);
        }
        if (n3 != null) {
            searchResultsCacheType.setSearchResultSizeLimit(n3);
        }
        if (string3 != null) {
            searchResultsCacheType.setCacheDistPolicy(string3);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setIdMgrLDAPSearchResultCache");
        }
        return ConfigUtils.saveConfig(string);
    }

    public Map getIdMgrLDAPSearchResultCache(String string, Map map) throws WIMException {
        SearchResultsCacheType searchResultsCacheType;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrLDAPSearchResultCache", "Parms: " + map.toString());
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = (String)map.get("id");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        CacheConfigurationType cacheConfigurationType = ConfigUtils.getOrCreateCacheConfiguration(ldapRepositoryType);
        if (cacheConfigurationType.isSetCachesDiskOffLoad()) {
            hashMap.put("cachesDiskOffLoad", cacheConfigurationType.isCachesDiskOffLoad());
        }
        if ((searchResultsCacheType = ConfigUtils.getOrCreateSearchResultsCache(ldapRepositoryType)).isSetEnabled()) {
            hashMap.put("enabled", searchResultsCacheType.isEnabled());
        }
        if (searchResultsCacheType.isSetCacheSize()) {
            hashMap.put("cacheSize", new Integer(searchResultsCacheType.getCacheSize()));
        }
        if (searchResultsCacheType.isSetCacheTimeOut()) {
            hashMap.put("cacheTimeOut", new Integer(searchResultsCacheType.getCacheTimeOut()));
        }
        if (searchResultsCacheType.isSetSearchResultSizeLimit()) {
            hashMap.put("searchResultSizeLimit", new Integer(searchResultsCacheType.getSearchResultSizeLimit()));
        }
        if (searchResultsCacheType.getCacheDistPolicy() != null) {
            hashMap.put("cacheDistPolicy", searchResultsCacheType.getCacheDistPolicy());
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrLDAPSearchResultCache", "Result: " + ((Object)hashMap).toString());
        }
        return hashMap;
    }

    public List listIdMgrSupportedLDAPServerTypes(String string) throws WIMException {
        if (supportedServers == null) {
            supportedServers = ConfigUtils.convertArrayToList(CONFIG_LDAP_SUPPORTED_TYPES);
        }
        return supportedServers;
    }

    private Map getDefaultValue() {
        if (defaultValue == null) {
            defaultValue = new HashMap();
            defaultValue.put("adapterClassName", "com.ibm.ws.wim.adapter.ldap.LdapAdapter");
            defaultValue.put("supportPaging", Boolean.valueOf("false"));
            defaultValue.put("supportSorting", Boolean.valueOf("false"));
            defaultValue.put("supportTransactions", Boolean.valueOf("false"));
            defaultValue.put("supportTransactions", Boolean.valueOf("false"));
            defaultValue.put("isExtIdUnique", Boolean.valueOf("true"));
            defaultValue.put("supportExternalName", Boolean.valueOf("false"));
            defaultValue.put("ldapServerType", "IDS51");
            defaultValue.put("certificateMapMode", "exactdn");
            defaultValue.put("translateRDN", Boolean.valueOf("false"));
        }
        return defaultValue;
    }

    private void setLdapServerConfigParams(LdapServerConfigurationType ldapServerConfigurationType, Map map) {
        Boolean bl;
        String string;
        Integer n = (Integer)map.get("searchTimeLimit");
        if (n != null) {
            ldapServerConfigurationType.setSearchTimeLimit(n);
        }
        if ((n = (Integer)map.get("searchCountLimit")) != null) {
            ldapServerConfigurationType.setSearchCountLimit(n);
        }
        if ((n = (Integer)map.get("searchPageSize")) != null) {
            ldapServerConfigurationType.setSearchPageSize(n);
        }
        if ((string = (String)map.get("sslConfiguration")) != null) {
            ldapServerConfigurationType.setSslConfiguration(string);
        }
        if ((bl = (Boolean)map.get("returnToPrimaryServer")) != null) {
            ldapServerConfigurationType.setReturnToPrimaryServer(bl);
        }
        if ((n = (Integer)map.get("primaryServerQueryTimeInterval")) != null) {
            ldapServerConfigurationType.setPrimaryServerQueryTimeInterval(n);
        }
    }

    private LdapEntityTypesType getEntityType(LdapRepositoryType ldapRepositoryType, String string, boolean bl) throws WIMException {
        String string2 = "getEntityType";
        LdapEntityTypesType ldapEntityTypesType = null;
        List list = ldapRepositoryType.getLdapEntityTypes();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                LdapEntityTypesType ldapEntityTypesType2 = (LdapEntityTypesType)list.get(i);
                if (!ldapEntityTypesType2.getName().equals(string)) continue;
                ldapEntityTypesType = ldapEntityTypesType2;
                break;
            }
        }
        if (bl && ldapEntityTypesType == null) {
            throw new WIMConfigurationException("INVALID_LDAP_ENTITY_TYPE", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2);
        }
        return ldapEntityTypesType;
    }

    private RdnAttributesType getRDNAttr(LdapEntityTypesType ldapEntityTypesType, String string, boolean bl) throws WIMException {
        String string2 = "getRDNAttr";
        RdnAttributesType rdnAttributesType = null;
        List list = ldapEntityTypesType.getRdnAttributes();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                RdnAttributesType rdnAttributesType2 = (RdnAttributesType)list.get(i);
                if (!rdnAttributesType2.getName().equals(string)) continue;
                rdnAttributesType = rdnAttributesType2;
                break;
            }
        }
        if (bl && rdnAttributesType == null) {
            throw new WIMConfigurationException("INVALID_RDN_ATTR", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2);
        }
        return rdnAttributesType;
    }

    private GroupConfigurationType getLDAPGroupConfig(LdapRepositoryType ldapRepositoryType, boolean bl) throws WIMException {
        String string = "getLDAPGroupConfig";
        GroupConfigurationType groupConfigurationType = ldapRepositoryType.getGroupConfiguration();
        if (bl && groupConfigurationType == null) {
            throw new WIMConfigurationException("MISSING_LDAP_GROUP_CONFIGURATION", WIMMessageHelper.generateMsgParms(ldapRepositoryType.getId()), Level.SEVERE, CLASSNAME, string);
        }
        return groupConfigurationType;
    }

    private MemberAttributesType getGroupMemberAttr(GroupConfigurationType groupConfigurationType, String string, boolean bl) throws WIMException {
        String string2 = "getGroupMemberAttr";
        MemberAttributesType memberAttributesType = null;
        List list = groupConfigurationType.getMemberAttributes();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                MemberAttributesType memberAttributesType2 = (MemberAttributesType)list.get(i);
                if (!memberAttributesType2.getName().equals(string)) continue;
                memberAttributesType = memberAttributesType2;
                break;
            }
        }
        if (bl && memberAttributesType == null) {
            throw new WIMConfigurationException("INVALID_GROUP_MEMBER_ATTR", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2);
        }
        return memberAttributesType;
    }

    private DynamicMemberAttributesType getGroupDynamicMemberAttr(GroupConfigurationType groupConfigurationType, String string, boolean bl) throws WIMException {
        String string2 = "getGroupDynamicMemberAttr";
        DynamicMemberAttributesType dynamicMemberAttributesType = null;
        List list = groupConfigurationType.getDynamicMemberAttributes();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                DynamicMemberAttributesType dynamicMemberAttributesType2 = (DynamicMemberAttributesType)list.get(i);
                if (!dynamicMemberAttributesType2.getName().equals(string)) continue;
                dynamicMemberAttributesType = dynamicMemberAttributesType2;
                break;
            }
        }
        if (bl && dynamicMemberAttributesType == null) {
            throw new WIMConfigurationException("INVALID_DYNAMIC_GROUP_MEMBER_ATTR", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2);
        }
        return dynamicMemberAttributesType;
    }

    private void setDefaultsForIDS(LdapRepositoryType ldapRepositoryType) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setDefaultsForIDS");
        }
        LdapEntityTypesType ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("Group");
        ldapEntityTypesType.getObjectClasses().add("groupOfNames");
        ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("OrgContainer");
        ldapEntityTypesType.getObjectClasses().add("organization");
        ldapEntityTypesType.getObjectClasses().add("organizationalUnit");
        ldapEntityTypesType.getObjectClasses().add("domain");
        ldapEntityTypesType.getObjectClasses().add("container");
        RdnAttributesType rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("o");
        rdnAttributesType.setObjectClass("organization");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("ou");
        rdnAttributesType.setObjectClass("organizationalUnit");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("dc");
        rdnAttributesType.setObjectClass("domain");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("cn");
        rdnAttributesType.setObjectClass("container");
        ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("PersonAccount");
        ldapEntityTypesType.getObjectClasses().add("inetOrgPerson");
        GroupConfigurationType groupConfigurationType = ldapRepositoryType.createGroupConfiguration();
        MemberAttributesType memberAttributesType = groupConfigurationType.createMemberAttributes();
        memberAttributesType.setName("member");
        memberAttributesType.setObjectClass("groupOfNames");
        memberAttributesType.setDummyMember("uid=dummy");
        memberAttributesType.setScope("direct");
        AttributeConfigurationType attributeConfigurationType = ldapRepositoryType.createAttributeConfiguration();
        AttributeType attributeType = attributeConfigurationType.createAttributes();
        attributeType.setName("userPassword");
        attributeType.setPropertyName("password");
        PropertiesNotSupportedType propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("homeAddress");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("businessAddress");
        this.setDefaultContextPoolAndCache(ldapRepositoryType);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setDefaultsForIDS");
        }
    }

    private void setDefaultContextPoolAndCache(LdapRepositoryType ldapRepositoryType) {
        String string = "setDefaultContextPoolAndCache";
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string);
        }
        ContextPoolType contextPoolType = ldapRepositoryType.createContextPool();
        contextPoolType.setEnabled(true);
        contextPoolType.setInitPoolSize(1);
        contextPoolType.setMaxPoolSize(0);
        contextPoolType.setPrefPoolSize(3);
        contextPoolType.setPoolTimeOut(0);
        contextPoolType.setPoolWaitTime(3000);
        CacheConfigurationType cacheConfigurationType = ldapRepositoryType.createCacheConfiguration();
        AttributesCacheType attributesCacheType = cacheConfigurationType.createAttributesCache();
        attributesCacheType.setEnabled(true);
        attributesCacheType.setCacheSize(4000);
        attributesCacheType.setCacheTimeOut(1200);
        attributesCacheType.setAttributeSizeLimit(2000);
        SearchResultsCacheType searchResultsCacheType = cacheConfigurationType.createSearchResultsCache();
        searchResultsCacheType.setEnabled(true);
        searchResultsCacheType.setCacheSize(2000);
        searchResultsCacheType.setCacheTimeOut(600);
        searchResultsCacheType.setSearchResultSizeLimit(1000);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }

    private void setDefaultsForDomino(LdapRepositoryType ldapRepositoryType, String string) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setDefaultsForDomino");
        }
        LdapEntityTypesType ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("Group");
        ldapEntityTypesType.getObjectClasses().add("groupOfNames");
        ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("OrgContainer");
        ldapEntityTypesType.getObjectClasses().add("organization");
        ldapEntityTypesType.getObjectClasses().add("organizationalUnit");
        ldapEntityTypesType.getObjectClasses().add("domain");
        ldapEntityTypesType.getObjectClasses().add("container");
        RdnAttributesType rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("o");
        rdnAttributesType.setObjectClass("organization");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("ou");
        rdnAttributesType.setObjectClass("organizationalUnit");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("dc");
        rdnAttributesType.setObjectClass("domain");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("cn");
        rdnAttributesType.setObjectClass("container");
        ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("PersonAccount");
        ldapEntityTypesType.getObjectClasses().add("inetOrgPerson");
        this.setPersonAccountRDNPropertyForDomino(ldapRepositoryType, string);
        GroupConfigurationType groupConfigurationType = ldapRepositoryType.createGroupConfiguration();
        MemberAttributesType memberAttributesType = groupConfigurationType.createMemberAttributes();
        memberAttributesType.setName("member");
        memberAttributesType.setObjectClass("groupOfNames");
        memberAttributesType.setDummyMember("uid=dummy");
        memberAttributesType.setScope("direct");
        AttributeConfigurationType attributeConfigurationType = ldapRepositoryType.createAttributeConfiguration();
        AttributeType attributeType = attributeConfigurationType.createAttributes();
        attributeType.setName("userPassword");
        attributeType.setPropertyName("password");
        PropertiesNotSupportedType propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("homeAddress");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("businessAddress");
        this.setDefaultContextPoolAndCache(ldapRepositoryType);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setDefaultsForDomino");
        }
    }

    private void setPersonAccountRDNPropertyForDomino(LdapRepositoryType ldapRepositoryType, String string) throws WIMException {
        List list;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setPersonAccountRDNPropertyForDomino");
        }
        if ((list = ConfigUtils.getProfileRepositories(string)) != null && list.size() == 1) {
            ConfigurationProviderType configurationProviderType;
            SupportedEntityTypesType supportedEntityTypesType;
            ProfileRepositoryType profileRepositoryType = (ProfileRepositoryType)list.get(0);
            if (ldapRepositoryType.getId().equals(profileRepositoryType.getId()) && (supportedEntityTypesType = SupportedEntityTypeConfigHelper.getSupportEntityTypeByName((configurationProviderType = ConfigUtils.getConfigProvider(string)).getSupportedEntityTypes(), "PersonAccount")) != null) {
                if (bl) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "setPersonAccountRDNPropertyForDomino", "setting the PersonAccount.RDNProperties to cn");
                }
                supportedEntityTypesType.getRdnProperties().clear();
                supportedEntityTypesType.getRdnProperties().add("cn");
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setPersonAccountRDNPropertyForDomino");
        }
    }

    private void setDefaultsForNDSorSunone(LdapRepositoryType ldapRepositoryType, String string) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setDefaultsForNDSorSunone");
        }
        LdapEntityTypesType ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("Group");
        if (string.equals("SUNONE")) {
            ldapEntityTypesType.getObjectClasses().add("groupOfUniqueNames");
        } else {
            ldapEntityTypesType.getObjectClasses().add("groupOfNames");
        }
        ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("OrgContainer");
        ldapEntityTypesType.getObjectClasses().add("organization");
        ldapEntityTypesType.getObjectClasses().add("organizationalUnit");
        ldapEntityTypesType.getObjectClasses().add("domain");
        ldapEntityTypesType.getObjectClasses().add("container");
        RdnAttributesType rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("o");
        rdnAttributesType.setObjectClass("organization");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("ou");
        rdnAttributesType.setObjectClass("organizationalUnit");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("dc");
        rdnAttributesType.setObjectClass("domain");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("cn");
        rdnAttributesType.setObjectClass("container");
        ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("PersonAccount");
        ldapEntityTypesType.getObjectClasses().add("inetOrgPerson");
        GroupConfigurationType groupConfigurationType = ldapRepositoryType.createGroupConfiguration();
        MemberAttributesType memberAttributesType = groupConfigurationType.createMemberAttributes();
        if (string.equals("SUNONE")) {
            memberAttributesType.setName("uniquemember");
            memberAttributesType.setObjectClass("groupOfUniqueNames");
        } else {
            memberAttributesType.setName("member");
            memberAttributesType.setObjectClass("groupOfNames");
        }
        memberAttributesType.setScope("direct");
        AttributeConfigurationType attributeConfigurationType = ldapRepositoryType.createAttributeConfiguration();
        AttributeType attributeType = attributeConfigurationType.createAttributes();
        attributeType.setName("userPassword");
        attributeType.setPropertyName("password");
        PropertiesNotSupportedType propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("homeAddress");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("businessAddress");
        this.setDefaultContextPoolAndCache(ldapRepositoryType);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setDefaultsForNDSorSunone");
        }
    }

    private void setDefaultsForActiveDirectory(LdapRepositoryType ldapRepositoryType) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setDefaultsForActiveDirectory");
        }
        LdapEntityTypesType ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("Group");
        ldapEntityTypesType.getObjectClasses().add("group");
        ldapEntityTypesType.setSearchFilter("(ObjectCategory=Group)");
        ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("OrgContainer");
        ldapEntityTypesType.getObjectClasses().add("organization");
        ldapEntityTypesType.getObjectClasses().add("organizationalUnit");
        ldapEntityTypesType.getObjectClasses().add("domain");
        ldapEntityTypesType.getObjectClasses().add("container");
        RdnAttributesType rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("o");
        rdnAttributesType.setObjectClass("organization");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("ou");
        rdnAttributesType.setObjectClass("organizationalUnit");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("dc");
        rdnAttributesType.setObjectClass("domain");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("cn");
        rdnAttributesType.setObjectClass("container");
        ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("PersonAccount");
        ldapEntityTypesType.getObjectClasses().add("user");
        GroupConfigurationType groupConfigurationType = ldapRepositoryType.createGroupConfiguration();
        MemberAttributesType memberAttributesType = groupConfigurationType.createMemberAttributes();
        memberAttributesType.setName("member");
        memberAttributesType.setObjectClass("group");
        memberAttributesType.setScope("direct");
        AttributeConfigurationType attributeConfigurationType = ldapRepositoryType.createAttributeConfiguration();
        AttributeType attributeType = attributeConfigurationType.createAttributes();
        attributeType.setName("userAccountControl");
        attributeType.setDefaultValue("544");
        attributeType.getEntityTypes().add("PersonAccount");
        attributeType = attributeConfigurationType.createAttributes();
        attributeType.setName("samAccountName");
        attributeType.setPropertyName("uid");
        attributeType.getEntityTypes().add("PersonAccount");
        attributeType = attributeConfigurationType.createAttributes();
        attributeType.setName("samAccountName");
        attributeType.setDefaultAttribute("cn");
        attributeType.getEntityTypes().add("Group");
        attributeType = attributeConfigurationType.createAttributes();
        attributeType.setName("groupType");
        attributeType.setDefaultValue("8");
        attributeType.getEntityTypes().add("Group");
        attributeType = attributeConfigurationType.createAttributes();
        attributeType.setName("unicodePwd");
        attributeType.setPropertyName("password");
        attributeType.setSyntax("unicodePwd");
        PropertiesNotSupportedType propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("description");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("jpegPhoto");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("labeledURI");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("carLicense");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("pager");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("roomNumber");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("localityName");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("stateOrProvinceName");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("countryName");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("employeeNumber");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("employeeType");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("businessCategory");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("departmentNumber");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("homeAddress");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("businessAddress");
        this.setDefaultContextPoolAndCache(ldapRepositoryType);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setDefaultsForActiveDirectory");
        }
    }

    private void setDefaultsForADAM(LdapRepositoryType ldapRepositoryType) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setDefaultsForActiveDirectory");
        }
        LdapEntityTypesType ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("Group");
        ldapEntityTypesType.getObjectClasses().add("group");
        ldapEntityTypesType.setSearchFilter("(ObjectCategory=Group)");
        ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("OrgContainer");
        ldapEntityTypesType.getObjectClasses().add("organization");
        ldapEntityTypesType.getObjectClasses().add("organizationalUnit");
        ldapEntityTypesType.getObjectClasses().add("domain");
        ldapEntityTypesType.getObjectClasses().add("container");
        RdnAttributesType rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("o");
        rdnAttributesType.setObjectClass("organization");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("ou");
        rdnAttributesType.setObjectClass("organizationalUnit");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("dc");
        rdnAttributesType.setObjectClass("domain");
        rdnAttributesType = ldapEntityTypesType.createRdnAttributes();
        rdnAttributesType.setName("cn");
        rdnAttributesType.setObjectClass("container");
        ldapEntityTypesType = ldapRepositoryType.createLdapEntityTypes();
        ldapEntityTypesType.setName("PersonAccount");
        ldapEntityTypesType.getObjectClasses().add("user");
        GroupConfigurationType groupConfigurationType = ldapRepositoryType.createGroupConfiguration();
        MemberAttributesType memberAttributesType = groupConfigurationType.createMemberAttributes();
        memberAttributesType.setName("member");
        memberAttributesType.setObjectClass("group");
        memberAttributesType.setScope("direct");
        AttributeConfigurationType attributeConfigurationType = ldapRepositoryType.createAttributeConfiguration();
        AttributeType attributeType = attributeConfigurationType.createAttributes();
        attributeType.setName("cn");
        attributeType.setDefaultAttribute("cn");
        attributeType.getEntityTypes().add("Group");
        attributeType = attributeConfigurationType.createAttributes();
        attributeType.setName("groupType");
        attributeType.setDefaultValue("8");
        attributeType.getEntityTypes().add("Group");
        attributeType = attributeConfigurationType.createAttributes();
        attributeType.setName("unicodePwd");
        attributeType.setPropertyName("password");
        attributeType.setSyntax("unicodePwd");
        PropertiesNotSupportedType propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("description");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("jpegPhoto");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("labeledURI");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("carLicense");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("pager");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("roomNumber");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("localityName");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("stateOrProvinceName");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("countryName");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("employeeNumber");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("employeeType");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("businessCategory");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("departmentNumber");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("homeAddress");
        propertiesNotSupportedType = attributeConfigurationType.createPropertiesNotSupported();
        propertiesNotSupportedType.setName("businessAddress");
        this.setDefaultContextPoolAndCache(ldapRepositoryType);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setDefaultsForActiveDirectory");
        }
    }

    private void setDefaultsForCustom(LdapRepositoryType ldapRepositoryType) {
    }

    protected Map getLDAPConnectionData(LdapRepositoryType ldapRepositoryType) throws WIMConfigurationException {
        HashMap hashMap = new HashMap();
        LdapServerConfigurationType ldapServerConfigurationType = ldapRepositoryType.getLdapServerConfiguration();
        if (ldapServerConfigurationType == null) {
            throw new WIMConfigurationException("MISSING_LDAP_SERVER_CONFIGURATION", WIMMessageHelper.generateMsgParms(ldapRepositoryType.getId()), Level.SEVERE, CLASSNAME, "getLDAPConnectionData");
        }
        if (ldapServerConfigurationType != null) {
            List list = ldapServerConfigurationType.getLdapServers();
            if (list != null && list.size() > 0) {
                LdapServersType ldapServersType = (LdapServersType)list.get(0);
                LDAPRepositoryConfigHelper.copyLDAPConnectionData(hashMap, ldapServersType, ldapRepositoryType);
            } else {
                throw new WIMConfigurationException("MISSING_LDAP_SERVER_CONFIGURATION", WIMMessageHelper.generateMsgParms(ldapRepositoryType.getId()), Level.SEVERE, CLASSNAME, "getLDAPConnectionData");
            }
        }
        return hashMap;
    }

    protected static void copyLDAPConnectionData(Map map, LdapServersType ldapServersType, LdapRepositoryType ldapRepositoryType) {
        Object object;
        List list = ldapServersType.getConnections();
        if (list.size() > 0) {
            object = (ConnectionsType)list.get(0);
            map.put("host", object.getHost());
            if (object.isSetPort()) {
                map.put("port", new Integer(object.getPort()));
            }
        }
        if (ldapServersType.getBindDN() != null) {
            map.put("bindDN", ldapServersType.getBindDN());
        }
        if (ldapServersType.getBindPassword() != null) {
            map.put("bindPassword", ldapServersType.getBindPassword());
        }
        if (ldapServersType.isSetAuthentication()) {
            map.put("authentication", ldapServersType.getAuthentication());
        }
        if (ldapServersType.isSetSslEnabled()) {
            map.put("sslEnabled", ldapServersType.isSslEnabled());
        }
        if (ldapServersType.isSetConnectTimeout()) {
            map.put("connectTimeout", new Integer(ldapServersType.getConnectTimeout()));
        }
        map.put("ldapServerType", ldapRepositoryType.getLdapServerType());
        map.put("certificateMapMode", ldapRepositoryType.getCertificateMapMode());
        map.put("certificateFilter", ldapRepositoryType.getCertificateFilter());
        object = ldapRepositoryType.getLdapServerConfiguration();
        if (object != null) {
            map.put("sslConfiguration", object.getSslConfiguration());
        }
    }
}

