/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.wim.ConfigUIConstants;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.config.ConfigValidator;
import com.ibm.ws.wim.config.LDAPRepositoryConfigHelper;
import com.ibm.ws.wim.config.ValidationHelper;
import com.ibm.ws.wim.configmodel.ConnectionsType;
import com.ibm.ws.wim.configmodel.LdapRepositoryType;
import com.ibm.ws.wim.configmodel.LdapServerConfigurationType;
import com.ibm.ws.wim.configmodel.LdapServersType;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LDAPServerConfigHelper
implements ConfigUIConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = LDAPServerConfigHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public String addIdMgrLDAPServer(String string, Map map) throws WIMException {
        LdapServersType ldapServersType;
        String string2 = "addIdMgrLDAPServer";
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, string2, "params: " + WIMTraceHelper.printMapWithoutPassword(map));
        }
        String string3 = (String)map.get("id");
        String string4 = (String)map.get("host");
        Integer n = (Integer)map.get("port");
        ValidationHelper.validateIntegerInput("port", CLASSNAME, string2, n);
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string3, "LdapRepositoryType");
        LdapServerConfigurationType ldapServerConfigurationType = ldapRepositoryType.getLdapServerConfiguration();
        if (ldapServerConfigurationType == null) {
            ldapServerConfigurationType = ldapRepositoryType.createLdapServerConfiguration();
        }
        if ((ldapServersType = this.getServerBasedOnPrimaryHost(string, string3, string4, false)) != null) {
            throw new WIMConfigurationException("PRIMARY_HOST_ALREADY_EXISTS", WIMMessageHelper.generateMsgParms(string4), Level.SEVERE, CLASSNAME, string2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ldapServerType", ldapRepositoryType.getLdapServerType());
        hashMap.put("certificateMapMode", ldapRepositoryType.getCertificateMapMode());
        hashMap.put("certificateFilter", ldapRepositoryType.getCertificateFilter());
        hashMap.put("sslConfiguration", ldapServerConfigurationType.getSslConfiguration());
        hashMap.putAll(map);
        ConfigValidator.validateLDAPParams(string3, hashMap);
        String string5 = (String)map.get("ldapServerType");
        if (string5 != null) {
            ldapRepositoryType.setLdapServerType(string5);
        }
        if ((string5 = (String)map.get("certificateMapMode")) != null) {
            ldapRepositoryType.setCertificateMapMode(string5);
        }
        if ((string5 = (String)map.get("certificateFilter")) != null) {
            ldapRepositoryType.setCertificateFilter(string5);
        }
        if ((string5 = (String)map.get("sslConfiguration")) != null) {
            ldapServerConfigurationType.setSslConfiguration(string5);
        }
        ldapServersType = ldapServerConfigurationType.createLdapServers();
        this.setServerParams(ldapServersType, map);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string2);
        }
        return ConfigUtils.saveConfig(string);
    }

    public String updateIdMgrLDAPServer(String string, Map map) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateIdMgrLDAPServer", "params=" + WIMTraceHelper.printMapWithoutPassword(map));
        }
        Integer n = (Integer)map.get("port");
        ValidationHelper.validateIntegerInput("port", CLASSNAME, "updateIdMgrLDAPServer", n);
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("host");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        LdapServersType ldapServersType = this.getServerBasedOnPrimaryHost(string, string2, string3, true);
        LdapServerConfigurationType ldapServerConfigurationType = ldapRepositoryType.getLdapServerConfiguration();
        if (ldapServerConfigurationType == null) {
            ldapServerConfigurationType = ldapRepositoryType.createLdapServerConfiguration();
        }
        HashMap hashMap = new HashMap();
        LDAPRepositoryConfigHelper.copyLDAPConnectionData(hashMap, ldapServersType, ldapRepositoryType);
        if (map.containsKey("primary_host")) {
            map.put("host", map.get("primary_host"));
        }
        hashMap.putAll(map);
        ConfigValidator.validateLDAPParams(string2, hashMap);
        String string4 = (String)map.get("ldapServerType");
        if (string4 != null) {
            ldapRepositoryType.setLdapServerType(string4);
        }
        if ((string4 = (String)map.get("certificateMapMode")) != null) {
            ldapRepositoryType.setCertificateMapMode(string4);
        }
        if ((string4 = (String)map.get("certificateFilter")) != null) {
            ldapRepositoryType.setCertificateFilter(string4);
        }
        if ((string4 = (String)map.get("sslConfiguration")) != null) {
            ldapServerConfigurationType.setSslConfiguration(string4);
        }
        this.setServerParams(ldapServersType, map);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updateIdMgrLDAPServer");
        }
        return ConfigUtils.saveConfig(string);
    }

    void setServerParams(LdapServersType ldapServersType, Map map) throws WIMException {
        String string = (String)map.get("host");
        Integer n = (Integer)map.get("port");
        String string2 = (String)map.get("bindDN");
        String string3 = (String)map.get("bindPassword");
        String string4 = (String)map.get("authentication");
        String string5 = (String)map.get("referal");
        String string6 = (String)map.get("derefAliases");
        Boolean bl = (Boolean)map.get("sslEnabled");
        Boolean bl2 = (Boolean)map.get("connectionPool");
        Integer n2 = (Integer)map.get("connectTimeout");
        if (string != null || n != null) {
            ConnectionsType connectionsType = null;
            List list = ldapServersType.getConnections();
            connectionsType = list == null || list.size() == 0 ? ldapServersType.createConnections() : (ConnectionsType)list.get(0);
            if (string != null) {
                connectionsType.setHost(string);
            }
            if (n != null) {
                connectionsType.setPort(n);
            }
        }
        if (string2 != null) {
            ldapServersType.setBindDN(string2);
        }
        if (string3 != null) {
            ldapServersType.setBindPassword(ConfigUtils.encodePassword(string3));
        }
        if (string4 != null) {
            ldapServersType.setAuthentication(string4);
        }
        if (string5 != null) {
            ldapServersType.setReferal(string5);
        }
        if (string6 != null) {
            ldapServersType.setDerefAliases(string6);
        }
        if (bl != null) {
            ldapServersType.setSslEnabled(bl);
        }
        if (bl2 != null) {
            ldapServersType.setConnectionPool(bl2);
        }
        if (n2 != null) {
            ldapServersType.setConnectTimeout(n2);
        }
    }

    public String deleteIdMgrLDAPServer(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deleteIdMgrLDAPServer", "params: " + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("host");
        LdapServersType ldapServersType = this.getServerBasedOnPrimaryHost(string, string2, string3, true);
        ((DataObject)ldapServersType).delete();
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deleteIdMgrLDAPServer");
        }
        return ConfigUtils.saveConfig(string);
    }

    public List listIdMgrLDAPServers(String string, Map map) throws WIMException {
        String string2 = "listIdMgrLDAPServers";
        Vector<String> vector = new Vector<String>();
        String string3 = (String)map.get("id");
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string3, "LdapRepositoryType");
        LdapServerConfigurationType ldapServerConfigurationType = ldapRepositoryType.getLdapServerConfiguration();
        if (ldapServerConfigurationType == null) {
            throw new WIMConfigurationException("MISSING_LDAP_SERVER_CONFIGURATION", WIMMessageHelper.generateMsgParms(string3), Level.SEVERE, CLASSNAME, string2);
        }
        List list = ldapServerConfigurationType.getLdapServers();
        Object var9_9 = null;
        for (LdapServersType ldapServersType : list) {
            List list2 = ldapServersType.getConnections();
            if (list2 == null || list2.size() == 0) continue;
            ConnectionsType connectionsType = (ConnectionsType)list2.get(0);
            vector.add(connectionsType.getHost());
        }
        return vector;
    }

    public Map getIdMgrLDAPServer(String string, Map map) throws WIMException {
        LdapServerConfigurationType ldapServerConfigurationType;
        LdapRepositoryType ldapRepositoryType;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrLDAPServer", "params: " + map);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("host");
        LdapServersType ldapServersType = this.getServerBasedOnPrimaryHost(string, string2, string3, true);
        hashMap.put("id", string2);
        hashMap.put("host", string3);
        ConnectionsType connectionsType = (ConnectionsType)ldapServersType.getConnections().get(0);
        if (connectionsType.isSetPort()) {
            hashMap.put("port", new Integer(connectionsType.getPort()));
        }
        if (ldapServersType.getBindDN() != null) {
            hashMap.put("bindDN", ldapServersType.getBindDN());
        }
        if (ldapServersType.getBindPassword() != null) {
            hashMap.put("bindPassword", ldapServersType.getBindPassword());
        }
        if (ldapServersType.isSetAuthentication()) {
            hashMap.put("authentication", ldapServersType.getAuthentication());
        }
        if (ldapServersType.isSetReferal()) {
            hashMap.put("referal", ldapServersType.getReferal());
        }
        if (ldapServersType.getDerefAliases() != null) {
            hashMap.put("derefAliases", ldapServersType.getDerefAliases());
        }
        if (ldapServersType.isSetSslEnabled()) {
            hashMap.put("sslEnabled", ldapServersType.isSslEnabled());
        }
        if (ldapServersType.isSetConnectionPool()) {
            hashMap.put("connectionPool", ldapServersType.isConnectionPool());
        }
        if (ldapServersType.isSetConnectTimeout()) {
            hashMap.put("connectTimeout", new Integer(ldapServersType.getConnectTimeout()));
        }
        if ((ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType")).getLdapServerType() != null) {
            hashMap.put("ldapServerType", ldapRepositoryType.getLdapServerType());
        }
        if (ldapRepositoryType.getCertificateMapMode() != null) {
            hashMap.put("certificateMapMode", ldapRepositoryType.getCertificateMapMode());
        }
        if (ldapRepositoryType.getCertificateFilter() != null) {
            hashMap.put("certificateFilter", ldapRepositoryType.getCertificateFilter());
        }
        if ((ldapServerConfigurationType = ldapRepositoryType.getLdapServerConfiguration()) != null && ldapServerConfigurationType.getSslConfiguration() != null) {
            hashMap.put("sslConfiguration", ldapServerConfigurationType.getSslConfiguration());
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrLDAPServer", "result: " + hashMap.toString());
        }
        return hashMap;
    }

    public String addIdMgrLDAPBackupServer(String string, Map map) throws WIMException {
        ConnectionsType connectionsType;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "addIdMgrLDAPBackupServer", "params: " + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("primary_host");
        String string4 = (String)map.get("host");
        Integer n = (Integer)map.get("port");
        ValidationHelper.validateIntegerInput("port", CLASSNAME, "addIdMgrLDAPBackupServer", n);
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        LdapServersType ldapServersType = this.getServerBasedOnPrimaryHost(string, string2, string3, true);
        List list = ldapServersType.getConnections();
        for (int i = 0; i < list.size(); ++i) {
            connectionsType = (ConnectionsType)list.get(i);
            if (!connectionsType.getHost().equalsIgnoreCase(string4)) continue;
            boolean bl2 = true;
            if (n != null || connectionsType.isSetPort()) {
                if (n != null && connectionsType.isSetPort()) {
                    if (n.intValue() != connectionsType.getPort()) {
                        bl2 = false;
                    }
                } else {
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            throw new WIMConfigurationException("BACKUP_HOST_PORT_ALREADY_EXISTS", WIMMessageHelper.generateMsgParms(string4, n), CLASSNAME, "addIdMgrLDAPBackupServer");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        LDAPRepositoryConfigHelper.copyLDAPConnectionData(hashMap, ldapServersType, ldapRepositoryType);
        hashMap.put("host", string4);
        if (n != null) {
            hashMap.put("port", n);
        } else {
            hashMap.remove("port");
        }
        ConfigValidator.validateLDAPParams(string2, hashMap);
        connectionsType = ldapServersType.createConnections();
        connectionsType.setHost(string4);
        if (n != null) {
            connectionsType.setPort(n);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "addIdMgrLDAPBackupServer");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String removeIdMgrLDAPBackupServer(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "removeIdMgrLDAPBackupServer", "params: " + map);
        }
        String string2 = (String)map.get("id");
        String string3 = (String)map.get("primary_host");
        String string4 = (String)map.get("host");
        Integer n = (Integer)map.get("port");
        ValidationHelper.validateIntegerInput("port", CLASSNAME, "removeIdMgrLDAPBackupServer", n);
        LdapServersType ldapServersType = this.getServerBasedOnPrimaryHost(string, string2, string3, true);
        boolean bl2 = false;
        List list = ldapServersType.getConnections();
        for (int i = 1; i < list.size(); ++i) {
            ConnectionsType connectionsType = (ConnectionsType)list.get(i);
            if ("*".equals(string4)) {
                list.remove(i);
                bl2 = true;
                --i;
                continue;
            }
            if (!connectionsType.getHost().equals(string4)) continue;
            if (n != null) {
                if (!connectionsType.isSetPort() || n.intValue() != connectionsType.getPort()) continue;
                bl2 = true;
                list.remove(i);
                break;
            }
            if (connectionsType.isSetPort()) continue;
            bl2 = true;
            list.remove(i);
            --i;
        }
        if (!bl2) {
            throw new WIMConfigurationException("INVALID_BACKUP_HOST_PORT", WIMMessageHelper.generateMsgParms(string4, n), Level.SEVERE, CLASSNAME, "removeIdMgrLDAPBackupServer");
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "removeIdMgrLDAPBackupServer");
        }
        return ConfigUtils.saveConfig(string);
    }

    public List listIdMgrLDAPBackupServers(String string, Map map) throws Exception {
        String string2;
        String string3;
        LdapServersType ldapServersType;
        List list;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "listIdMgrLDAPBackupServers", "params: " + map);
        }
        if ((list = (ldapServersType = this.getServerBasedOnPrimaryHost(string, string3 = (String)map.get("id"), string2 = (String)map.get("primary_host"), true)).getConnections()) == null) {
            throw new WIMConfigurationException("INVALID_PRIMARY_HOST", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "listIdMgrLDAPBackupServers");
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 1; i < list.size(); ++i) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            ConnectionsType connectionsType = (ConnectionsType)list.get(i);
            if (connectionsType.isSetPort()) {
                hashMap.put(connectionsType.getHost(), new Integer(connectionsType.getPort()));
            } else {
                hashMap.put(connectionsType.getHost(), null);
            }
            arrayList.add(hashMap);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "listIdMgrLDAPBackupServers", "result: " + arrayList);
        }
        return arrayList;
    }

    private LdapServersType getServerBasedOnPrimaryHost(String string, String string2, String string3, boolean bl) throws WIMException {
        String string4 = "getServerBasedOnPrimaryHost";
        LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)ConfigUtils.validateAndGetRepository(string, string2, "LdapRepositoryType");
        LdapServerConfigurationType ldapServerConfigurationType = ldapRepositoryType.getLdapServerConfiguration();
        if (ldapServerConfigurationType == null) {
            throw new WIMConfigurationException("MISSING_LDAP_SERVER_CONFIGURATION", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, string4);
        }
        List list = ldapServerConfigurationType.getLdapServers();
        LdapServersType ldapServersType = null;
        for (LdapServersType ldapServersType2 : list) {
            ConnectionsType connectionsType;
            List list2 = ldapServersType2.getConnections();
            if (list2.size() == 0 || !(connectionsType = (ConnectionsType)list2.get(0)).getHost().equals(string3)) continue;
            ldapServersType = ldapServersType2;
            break;
        }
        if (bl && ldapServersType == null) {
            throw new WIMConfigurationException("INVALID_PRIMARY_HOST", WIMMessageHelper.generateMsgParms(string3), Level.SEVERE, CLASSNAME, string4);
        }
        return ldapServersType;
    }
}

