/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.wim.ConfigUIConstants;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.config.ConfigValidator;
import com.ibm.ws.wim.config.ValidationHelper;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.PropertyExtensionRepositoryType;
import commonj.sdo.DataObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LookAsideRepositoryConfigHelper
implements ConfigUIConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = LookAsideRepositoryConfigHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public String setIdMgrLookAsideRepository(String string, Map map) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setIdMgrLookAsideRepository", "params=" + WIMTraceHelper.printMapWithoutPassword(map));
        }
        String string2 = (String)map.get("dataSourceName");
        String string3 = (String)map.get("databaseType");
        String string4 = (String)map.get("dbURL");
        Integer n = (Integer)map.get("entityRetrievalLimit");
        ValidationHelper.validateIntegerInput("entityRetrievalLimit", CLASSNAME, "setIdMgrLookAsideRepository", n);
        ConfigurationProviderType configurationProviderType = ConfigUtils.getConfigProvider(string);
        PropertyExtensionRepositoryType propertyExtensionRepositoryType = configurationProviderType.getPropertyExtensionRepository();
        if (propertyExtensionRepositoryType == null) {
            ValidationHelper.validateRequiredDBParameters(map, CLASSNAME, "setIdMgrLookAsideRepository");
            ConfigValidator.validateDBParams("LA", map);
            propertyExtensionRepositoryType = configurationProviderType.createPropertyExtensionRepository();
            propertyExtensionRepositoryType.setId("LA");
            propertyExtensionRepositoryType.setAdapterClassName("com.ibm.ws.wim.lookaside.LookasideAdapter");
            propertyExtensionRepositoryType.setEntityRetrievalLimit(new Integer("12"));
        } else {
            HashMap hashMap = new HashMap();
            boolean bl2 = ConfigUtils.buildMapFromOldAndNewValues(hashMap, ConfigValidator.DB_CONNECTION_PARAMS, (DataObject)propertyExtensionRepositoryType, map);
            if (bl2) {
                ConfigValidator.validateDBParams("LA", hashMap);
            }
        }
        if (string3 != null) {
            propertyExtensionRepositoryType.setDatabaseType(string3);
        }
        if (string2 != null) {
            propertyExtensionRepositoryType.setDataSourceName(string2);
        }
        if (string4 != null) {
            propertyExtensionRepositoryType.setDbURL(string4);
        }
        if (map.get("dbAdminId") != null) {
            propertyExtensionRepositoryType.setDbAdminId((String)map.get("dbAdminId"));
        }
        if (map.get("dbAdminPassword") != null) {
            propertyExtensionRepositoryType.setDbAdminPassword(ConfigUtils.encodePassword((String)map.get("dbAdminPassword")));
        }
        if (map.get("JDBCDriverClass") != null) {
            propertyExtensionRepositoryType.setJDBCDriverClass((String)map.get("JDBCDriverClass"));
        }
        if (n != null) {
            propertyExtensionRepositoryType.setEntityRetrievalLimit(n);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setIdMgrLookAsideRepository");
        }
        return ConfigUtils.saveConfig(string);
    }
}

