/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.wim.ConfigUIConstants;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.config.ConfigValidator;
import com.ibm.ws.wim.config.ValidationHelper;
import com.ibm.ws.wim.configmodel.BaseEntriesType;
import com.ibm.ws.wim.configmodel.ConnectionsType;
import com.ibm.ws.wim.configmodel.DatabaseRepositoryType;
import com.ibm.ws.wim.configmodel.FileRepositoryType;
import com.ibm.ws.wim.configmodel.LdapRepositoryType;
import com.ibm.ws.wim.configmodel.LdapServersType;
import com.ibm.ws.wim.configmodel.ParticipatingBaseEntriesType;
import com.ibm.ws.wim.configmodel.ProfileRepositoryType;
import com.ibm.ws.wim.configmodel.RealmConfigurationType;
import com.ibm.ws.wim.configmodel.RealmType;
import com.ibm.ws.wim.configmodel.UserRegistryInfoMappingType;
import com.ibm.ws.wim.util.UniqueNameHelper;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RealmConfigHelper
implements ConfigUIConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = RealmConfigHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public String setIdMgrDefaultRealm(String string, String string2) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setIdMgrDefaultRealm", "name=" + string2);
        }
        RealmConfigurationType realmConfigurationType = ConfigUtils.getRealmConfig(string);
        String string3 = realmConfigurationType.getDefaultRealm();
        if (bl) {
            trcLogger.logp(Level.FINER, CLASSNAME, "setIdMgrDefaultRealm", "current realm name=" + string3);
        }
        ConfigUtils.getRealm(string2, realmConfigurationType);
        realmConfigurationType.setDefaultRealm(string2);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setIdMgrDefaultRealm");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String getIdMgrDefaultRealm(String string) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrDefaultRealm");
        }
        String string2 = null;
        RealmConfigurationType realmConfigurationType = ConfigUtils.getRealmConfig(string);
        string2 = realmConfigurationType.getDefaultRealm();
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrDefaultRealm", "name=" + string2);
        }
        return string2;
    }

    public String createIdMgrRealm(String string, Map map) throws Exception {
        RealmConfigurationType realmConfigurationType;
        RealmType realmType;
        String string2 = (String)map.get("name");
        String string3 = (String)map.get("securityUse");
        String string4 = (String)map.get("delimiter");
        boolean bl = (Boolean)map.get("allowOperationIfReposDown");
        boolean bl2 = trcLogger.isLoggable(Level.FINER);
        if (bl2) {
            trcLogger.entering(CLASSNAME, "createIdMgrRealm", "name=" + string2 + " securityUse=" + string3 + " delimiter=" + string4 + " allowOperationIfReposDown=" + bl);
        }
        if (string3 != null) {
            ValidationHelper.validateParam("securityUse", string3, CONFIG_REALM_SECURITY_USE_VALUES);
        }
        if ((realmType = ConfigUtils.getRealm(string2, realmConfigurationType = ConfigUtils.getOrCreateRealmConfig(string), false)) != null) {
            throw new WIMConfigurationException("REALM_ALREADY_EXISTS", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "createIdMgrRealm");
        }
        realmType = realmConfigurationType.createRealms();
        realmType.setName(string2);
        if (string4 != null) {
            realmType.setDelimiter(string4);
        }
        if (string3 != null) {
            realmType.setSecurityUse(string3);
        }
        this.setDefaultUserRegistryMapping(realmType);
        realmType.setAllowOperationIfReposDown(bl);
        if (bl2) {
            trcLogger.exiting(CLASSNAME, "createIdMgrRealm");
        }
        ConfigUtils.saveConfig(string);
        return "MUST_ADD_BASE_ENTRY_TO_REALM";
    }

    private void setDefaultUserRegistryMapping(RealmType realmType) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setDefaultUserRegistryMapping");
        }
        UserRegistryInfoMappingType userRegistryInfoMappingType = realmType.createUniqueUserIdMapping();
        userRegistryInfoMappingType.setPropertyForInput("uniqueName");
        userRegistryInfoMappingType.setPropertyForOutput("uniqueName");
        userRegistryInfoMappingType = realmType.createUserSecurityNameMapping();
        userRegistryInfoMappingType.setPropertyForInput("principalName");
        userRegistryInfoMappingType.setPropertyForOutput("externalName");
        userRegistryInfoMappingType = realmType.createUserDisplayNameMapping();
        userRegistryInfoMappingType.setPropertyForInput("principalName");
        userRegistryInfoMappingType.setPropertyForOutput("principalName");
        userRegistryInfoMappingType = realmType.createUniqueGroupIdMapping();
        userRegistryInfoMappingType.setPropertyForInput("uniqueName");
        userRegistryInfoMappingType.setPropertyForOutput("uniqueName");
        userRegistryInfoMappingType = realmType.createGroupSecurityNameMapping();
        userRegistryInfoMappingType.setPropertyForInput("cn");
        userRegistryInfoMappingType.setPropertyForOutput("externalName");
        userRegistryInfoMappingType = realmType.createGroupDisplayNameMapping();
        userRegistryInfoMappingType.setPropertyForInput("cn");
        userRegistryInfoMappingType.setPropertyForOutput("cn");
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setDefaultUserRegistryMapping");
        }
    }

    public String updateIdMgrRealm(String string, Map map) throws Exception {
        String string2 = (String)map.get("name");
        String string3 = (String)map.get("securityUse");
        String string4 = (String)map.get("delimiter");
        Boolean bl = (Boolean)map.get("allowOperationIfReposDown");
        boolean bl2 = trcLogger.isLoggable(Level.FINER);
        if (bl2) {
            trcLogger.entering(CLASSNAME, "updateIdMgrRealm", "name=" + string2 + ", securityUse=" + string3 + ", delimiter=" + string4 + ", allowOperationIfReposDown=" + bl);
        }
        RealmConfigurationType realmConfigurationType = ConfigUtils.getRealmConfig(string);
        RealmType realmType = ConfigUtils.getRealm(string2, realmConfigurationType);
        if (string3 != null) {
            ValidationHelper.validateParam("securityUse", string3, CONFIG_REALM_SECURITY_USE_VALUES);
            realmType.setSecurityUse(string3);
        }
        if (string4 != null) {
            realmType.setDelimiter(string4);
        }
        if (bl != null) {
            realmType.setAllowOperationIfReposDown(bl);
        }
        if (bl2) {
            trcLogger.exiting(CLASSNAME, "updateIdMgrRealm");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String deleteIdMgrRealm(String string, String string2) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deleteIdMgrRealm", "name=" + string2);
        }
        RealmConfigurationType realmConfigurationType = ConfigUtils.getRealmConfig(string);
        RealmType realmType = ConfigUtils.getRealm(string2, realmConfigurationType);
        ConfigValidator.validateDeleteIdMgrRealm(ConfigUtils.getConfigProvider(string), string2);
        ((DataObject)realmType).delete();
        String string3 = realmConfigurationType.getDefaultRealm();
        if (string2.equals(string3)) {
            if (bl) {
                trcLogger.logp(Level.FINER, CLASSNAME, "deleteIdMgrRealm", "resetting the default realm name.");
            }
            realmConfigurationType.setDefaultRealm(null);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deleteIdMgrRealm");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String renameIdMgrRealm(String string, String string2, String string3) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "renameIdMgrRealm", "name=" + string2 + " newName=" + string3);
        }
        RealmConfigurationType realmConfigurationType = ConfigUtils.getRealmConfig(string);
        RealmType realmType = ConfigUtils.getRealm(string2, realmConfigurationType);
        RealmType realmType2 = ConfigUtils.getRealm(string3, realmConfigurationType, false);
        if (realmType2 != null) {
            throw new WIMConfigurationException("REALM_ALREADY_EXISTS", WIMMessageHelper.generateMsgParms(string3), Level.SEVERE, CLASSNAME, "renameIdMgrRealm");
        }
        realmType.setName(string3);
        String string4 = this.getIdMgrDefaultRealm(string);
        if (string2.equals(string4)) {
            this.setIdMgrDefaultRealm(string, string3);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "renameIdMgrRealm");
        }
        return ConfigUtils.saveConfig(string);
    }

    public List listIdMgrRealms(String string) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "listIdMgrRealms");
        }
        RealmConfigurationType realmConfigurationType = ConfigUtils.getRealmConfig(string);
        Vector<String> vector = new Vector<String>();
        List list = realmConfigurationType.getRealms();
        for (int i = 0; i < list.size(); ++i) {
            RealmType realmType = (RealmType)list.get(i);
            vector.add(realmType.getName());
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "listIdMgrRealms", "realms=" + vector);
        }
        return vector;
    }

    public Map getIdMgrRealm(String string, String string2) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrRealm", "realmName=" + string2);
        }
        RealmConfigurationType realmConfigurationType = ConfigUtils.getRealmConfig(string);
        RealmType realmType = ConfigUtils.getRealm(string2, realmConfigurationType);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", realmType.getName());
        if (realmType.getSecurityUse() != null) {
            hashMap.put("securityUse", realmType.getSecurityUse());
        }
        if (realmType.getDelimiter() != null) {
            hashMap.put("delimiter", realmType.getDelimiter());
        }
        hashMap.put("allowOperationIfReposDown", realmType.isAllowOperationIfReposDown());
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrRealm", "realms=" + hashMap);
        }
        return hashMap;
    }

    public String addIdMgrRealmBaseEntry(String string, String string2, String string3) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "addIdMgrRealmBaseEntry", "name=" + string2 + " baseEntry=" + string3);
        }
        String string4 = UniqueNameHelper.getValidUniqueName(string3);
        RealmConfigurationType realmConfigurationType = ConfigUtils.getRealmConfig(string);
        RealmType realmType = ConfigUtils.getRealm(string2, realmConfigurationType);
        ConfigValidator.validateAddIdMgrRealmBaseEntry(ConfigUtils.getConfigProvider(string), string2, string4);
        ParticipatingBaseEntriesType participatingBaseEntriesType = realmType.createParticipatingBaseEntries();
        participatingBaseEntriesType.setName(string4);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "addIdMgrRealmBaseEntry");
        }
        return ConfigUtils.saveConfig(string);
    }

    private boolean baseEntryInRealm(RealmType realmType, String string) {
        boolean bl = false;
        List list = realmType.getParticipatingBaseEntries();
        for (int i = 0; i < list.size(); ++i) {
            ParticipatingBaseEntriesType participatingBaseEntriesType = (ParticipatingBaseEntriesType)list.get(i);
            if (!string.equals(participatingBaseEntriesType.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String deleteIdMgrRealmBaseEntry(String string, String string2, String string3) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deleteIdMgrRealmBaseEntry", "name=" + string2 + " baseEntry=" + string3);
        }
        String string4 = UniqueNameHelper.getValidUniqueName(string3);
        RealmConfigurationType realmConfigurationType = ConfigUtils.getRealmConfig(string);
        RealmType realmType = ConfigUtils.getRealm(string2, realmConfigurationType);
        ParticipatingBaseEntriesType participatingBaseEntriesType = ConfigUtils.getBaseEntryInRealm(string4, realmType);
        ConfigValidator.validateDeleteIdMgrRealmBaseEntry(ConfigUtils.getConfigProvider(string), string2, string4);
        ((DataObject)participatingBaseEntriesType).delete();
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deleteIdMgrRealmBaseEntry");
        }
        return ConfigUtils.saveConfig(string);
    }

    public List listIdMgrRealmBaseEntries(String string, String string2) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "listIdMgrRealmBaseEntries", "name=" + string2);
        }
        RealmConfigurationType realmConfigurationType = ConfigUtils.getRealmConfig(string);
        RealmType realmType = ConfigUtils.getRealm(string2, realmConfigurationType);
        Vector<String> vector = new Vector<String>();
        List list = realmType.getParticipatingBaseEntries();
        for (int i = 0; i < list.size(); ++i) {
            ParticipatingBaseEntriesType participatingBaseEntriesType = (ParticipatingBaseEntriesType)list.get(i);
            String string3 = participatingBaseEntriesType.getName();
            vector.add(string3);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "listIdMgrRealmBaseEntries", "returning: " + vector);
        }
        return vector;
    }

    public List getIdMgrRepositoriesForRealm(String string, String string2) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrRepositoriesForRealm", "realmName=" + string2);
        }
        ArrayList<Map> arrayList = new ArrayList<Map>();
        List list = this.listIdMgrRealmBaseEntries(string, string2);
        for (int i = 0; i < list.size(); ++i) {
            String string3 = (String)list.get(i);
            Map map = this.getInformationForBaseEntry(string, string3);
            arrayList.add(map);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrRepositoriesForRealm", "repositoriesForRealm=" + arrayList);
        }
        return arrayList;
    }

    public Map listIdMgrRealmURAttrMappings(String string, String string2) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "listIdMgrRealmURAttrMappings", "realmName = " + string2);
        }
        RealmConfigurationType realmConfigurationType = ConfigUtils.getRealmConfig(string);
        String string3 = string2;
        if (string3 == null) {
            string3 = realmConfigurationType.getDefaultRealm();
            if (bl) {
                trcLogger.logp(Level.FINER, CLASSNAME, "listIdMgrRealmURAttrMappings", "The default realm = " + string3);
            }
        }
        RealmType realmType = ConfigUtils.getRealm(string3, realmConfigurationType);
        HashMap hashMap = new HashMap();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("propertyForInput", realmType.getUniqueGroupIdMapping().getPropertyForInput());
        hashMap2.put("propertyForOutput", realmType.getUniqueGroupIdMapping().getPropertyForOutput());
        hashMap.put("uniqueGroupId", hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put("propertyForInput", realmType.getGroupDisplayNameMapping().getPropertyForInput());
        hashMap2.put("propertyForOutput", realmType.getGroupDisplayNameMapping().getPropertyForOutput());
        hashMap.put("groupDisplayName", hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put("propertyForInput", realmType.getGroupSecurityNameMapping().getPropertyForInput());
        hashMap2.put("propertyForOutput", realmType.getGroupSecurityNameMapping().getPropertyForOutput());
        hashMap.put("groupSecurityName", hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put("propertyForInput", realmType.getUniqueUserIdMapping().getPropertyForInput());
        hashMap2.put("propertyForOutput", realmType.getUniqueUserIdMapping().getPropertyForOutput());
        hashMap.put("uniqueUserId", hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put("propertyForInput", realmType.getUserDisplayNameMapping().getPropertyForInput());
        hashMap2.put("propertyForOutput", realmType.getUserDisplayNameMapping().getPropertyForOutput());
        hashMap.put("userDisplayName", hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put("propertyForInput", realmType.getUserSecurityNameMapping().getPropertyForInput());
        hashMap2.put("propertyForOutput", realmType.getUserSecurityNameMapping().getPropertyForOutput());
        hashMap.put("userSecurityName", hashMap2);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "listIdMgrRealmURAttrMappings", "returnMap = " + hashMap);
        }
        return hashMap;
    }

    public String setIdMgrRealmURAttrMapping(String string, String string2, String string3, String string4, String string5) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "setIdMgrRealmURAttrMapping", "realmName = " + string2 + ", URAttrName = " + string3 + ", propertyForInput = " + string4 + ", propertyForOutput = " + string5);
        }
        RealmConfigurationType realmConfigurationType = ConfigUtils.getRealmConfig(string);
        String string6 = string2;
        if (string6 == null) {
            string6 = realmConfigurationType.getDefaultRealm();
            if (bl) {
                trcLogger.logp(Level.FINER, CLASSNAME, "setIdMgrRealmURAttrMapping", "The default realm = " + string6);
            }
        }
        this.validateInputParams(string3, string4, string5);
        RealmType realmType = ConfigUtils.getRealm(string6, realmConfigurationType);
        UserRegistryInfoMappingType userRegistryInfoMappingType = null;
        if ("uniqueUserId".equals(string3)) {
            userRegistryInfoMappingType = realmType.createUniqueUserIdMapping();
        } else if ("userDisplayName".equals(string3)) {
            userRegistryInfoMappingType = realmType.createUserDisplayNameMapping();
        } else if ("userSecurityName".equals(string3)) {
            userRegistryInfoMappingType = realmType.createUserSecurityNameMapping();
        } else if ("uniqueGroupId".equals(string3)) {
            userRegistryInfoMappingType = realmType.createUniqueGroupIdMapping();
        } else if ("groupDisplayName".equals(string3)) {
            userRegistryInfoMappingType = realmType.createGroupDisplayNameMapping();
        } else if ("groupSecurityName".equals(string3)) {
            userRegistryInfoMappingType = realmType.createGroupSecurityNameMapping();
        }
        userRegistryInfoMappingType.setPropertyForInput(string4);
        userRegistryInfoMappingType.setPropertyForOutput(string5);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "setIdMgrRealmURAttrMapping");
        }
        return ConfigUtils.saveConfig(string);
    }

    private Map getInformationForBaseEntry(String string, String string2) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getInformationForBaseEntry", "baseEntyName=" + string2);
        }
        List list = ConfigUtils.getProfileRepositories(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        block0: for (int i = 0; i < list.size(); ++i) {
            ProfileRepositoryType profileRepositoryType = (ProfileRepositoryType)list.get(i);
            List list2 = profileRepositoryType.getBaseEntries();
            for (int j = 0; j < list2.size(); ++j) {
                ProfileRepositoryType profileRepositoryType2;
                BaseEntriesType baseEntriesType = (BaseEntriesType)list2.get(j);
                String string3 = baseEntriesType.getName();
                if (!string3.toLowerCase().equals(string2.toLowerCase())) continue;
                String string4 = baseEntriesType.getNameInRepository();
                hashMap.put("id", profileRepositoryType.getId());
                hashMap.put("name", string3);
                hashMap.put("nameInRepository", string4);
                if (profileRepositoryType instanceof FileRepositoryType) {
                    hashMap.put("repositoryType", "File");
                    hashMap.put("host", "LocalHost");
                    continue block0;
                }
                if (profileRepositoryType instanceof LdapRepositoryType) {
                    hashMap.put("repositoryType", "LDAP");
                    profileRepositoryType2 = (LdapRepositoryType)profileRepositoryType;
                    hashMap.put("specificRepositoryType", profileRepositoryType2.getLdapServerType());
                    List list3 = profileRepositoryType2.getLdapServerConfiguration().getLdapServers();
                    LdapServersType ldapServersType = (LdapServersType)list3.get(0);
                    List list4 = ldapServersType.getConnections();
                    ConnectionsType connectionsType = (ConnectionsType)list4.get(0);
                    hashMap.put("host", connectionsType.getHost());
                    hashMap.put("port", "" + connectionsType.getPort());
                    continue block0;
                }
                if (profileRepositoryType instanceof DatabaseRepositoryType) {
                    hashMap.put("repositoryType", "DB");
                    profileRepositoryType2 = (DatabaseRepositoryType)profileRepositoryType;
                    hashMap.put("specificRepositoryType", profileRepositoryType2.getDatabaseType());
                    hashMap.put("host", profileRepositoryType2.getDataSourceName());
                    continue block0;
                }
                hashMap.put("repositoryType", "Custom");
                continue block0;
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getInformationForBaseEntry", "result=" + hashMap);
        }
        return hashMap;
    }

    private void validateInputParams(String string, String string2, String string3) throws WIMConfigurationException, WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "validateInputParams", "sURAttrname = " + string + ", propertyForInput = " + string2 + ", propertyForOutput = " + string3);
        }
        boolean bl2 = "uniqueUserId".equals(string);
        boolean bl3 = "userDisplayName".equals(string);
        boolean bl4 = "userSecurityName".equals(string);
        boolean bl5 = "uniqueGroupId".equals(string);
        boolean bl6 = "groupDisplayName".equals(string);
        boolean bl7 = "groupSecurityName".equals(string);
        if (!(bl2 || bl3 || bl4 || bl5 || bl6 || bl7)) {
            throw new WIMConfigurationException("INVALID_USER_REGISTRY_ATTRIBUTE_NAME", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "validateInputParams");
        }
        this.validateProperties(string, string2);
        this.validateProperties(string, string3);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "validateInputParams");
        }
    }

    private void validateProperties(String string, String string2) throws WIMConfigurationException, WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "validateProperties", " sURAttrName = " + string + ", prop = " + string2);
        }
        boolean bl2 = "uniqueId".equals(string2);
        boolean bl3 = "uniqueName".equals(string2);
        boolean bl4 = "externalId".equals(string2);
        boolean bl5 = "externalName".equals(string2);
        if (!(bl2 || bl3 || bl4 || bl5)) {
            String string3 = "user";
            if (string.toLowerCase().contains(string3) ? SchemaManager.singleton().getProperty("PersonAccount", string2) == null : SchemaManager.singleton().getProperty("Group", string2) == null) {
                throw new WIMConfigurationException("PROPERTY_NOT_DEFINED", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "validateProperties");
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "validateProperties");
        }
    }
}

