/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.wim.ConfigConstants;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.config.ValidationHelper;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.SupportedEntityTypesType;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SupportedEntityTypeConfigHelper
implements ConfigConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = SupportedEntityTypeConfigHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public String createIdMgrSupportedEntityType(String string, Map map) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "createIdMgrSupportedEntityType", "params: " + map.toString());
        }
        List list = (List)map.get("rdnProperties");
        String string2 = (String)map.get("defaultParent");
        String string3 = (String)map.get("name");
        ValidationHelper.validateStringInputInList("rdnProperties", CLASSNAME, "createIdMgrSupportedEntityType", list, false);
        ConfigurationProviderType configurationProviderType = ConfigUtils.getConfigProvider(string);
        List list2 = configurationProviderType.getSupportedEntityTypes();
        SupportedEntityTypesType supportedEntityTypesType = SupportedEntityTypeConfigHelper.getSupportEntityTypeByName(list2, string3);
        if (supportedEntityTypesType != null) {
            throw new WIMConfigurationException("SUPPORTED_ENTITY_TYPE_ALREADY_EXISTS", WIMMessageHelper.generateMsgParms(string3), Level.SEVERE, CLASSNAME, "createIdMgrSupportedEntityType");
        }
        supportedEntityTypesType = configurationProviderType.createSupportedEntityTypes();
        supportedEntityTypesType.setName(string3);
        supportedEntityTypesType.setDefaultParent(string2);
        List list3 = supportedEntityTypesType.getRdnProperties();
        for (int i = 0; i < list.size(); ++i) {
            list3.add((String)list.get(i));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "createIdMgrSupportedEntityType");
        }
        return ConfigUtils.saveConfig(string);
    }

    public String updateIdMgrSupportedEntityType(String string, Map map) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "updateIdMgrSupportedEntityType", "params: " + map.toString());
        }
        String string2 = (String)map.get("name");
        List list = (List)map.get("rdnProperties");
        String string3 = (String)map.get("defaultParent");
        ConfigurationProviderType configurationProviderType = ConfigUtils.getConfigProvider(string);
        List list2 = configurationProviderType.getSupportedEntityTypes();
        ValidationHelper.validateStringInputInList("rdnProperties", CLASSNAME, "updateIdMgrSupportedEntityType", list, true);
        SupportedEntityTypesType supportedEntityTypesType = SupportedEntityTypeConfigHelper.getSupportEntityTypeByName(list2, string2);
        if (supportedEntityTypesType == null) {
            throw new WIMConfigurationException("INVALID_SUPPORTED_ENTITY_TYPE", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "updateIdMgrSupportedEntityType");
        }
        if (string3 != null) {
            supportedEntityTypesType.setDefaultParent(string3);
        }
        List list3 = null;
        if (list != null) {
            list3 = supportedEntityTypesType.getRdnProperties();
            ConfigUtils.addOrRemovePresentList("rdnProperties", list, list3);
            list3 = supportedEntityTypesType.getRdnProperties();
        }
        String string4 = ConfigUtils.saveConfig(string);
        if (list3 != null && list3.size() == 0) {
            string4 = "MUST_ADD_RDN_PROP_TO_SUPPORTED_ENTITY_TYPE";
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "updateIdMgrSupportedEntityType");
        }
        return string4;
    }

    public String deleteIdMgrSupportedEntityType(String string, Map map) throws WIMException {
        ConfigurationProviderType configurationProviderType;
        List list;
        SupportedEntityTypesType supportedEntityTypesType;
        String string2 = (String)map.get("name");
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "deleteIdMgrSupportedEntityType", "params: " + map.toString());
        }
        if ((supportedEntityTypesType = SupportedEntityTypeConfigHelper.getSupportEntityTypeByName(list = (configurationProviderType = ConfigUtils.getConfigProvider(string)).getSupportedEntityTypes(), string2)) == null) {
            throw new WIMConfigurationException("INVALID_SUPPORTED_ENTITY_TYPE", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "deleteIdMgrSupportedEntityType");
        }
        ((DataObject)supportedEntityTypesType).delete();
        if (bl) {
            trcLogger.exiting(CLASSNAME, "deleteIdMgrSupportedEntityType");
        }
        return ConfigUtils.saveConfig(string);
    }

    public List listIdMgrSupportedEntityTypes(String string) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "listIdMgrSupportedEntityTypes");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ConfigurationProviderType configurationProviderType = ConfigUtils.getConfigProvider(string);
        List list = configurationProviderType.getSupportedEntityTypes();
        for (int i = 0; i < list.size(); ++i) {
            SupportedEntityTypesType supportedEntityTypesType = (SupportedEntityTypesType)list.get(i);
            arrayList.add(supportedEntityTypesType.getName());
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "listIdMgrSupportedEntityTypes", "result: " + ((Object)arrayList).toString());
        }
        return arrayList;
    }

    public Map getIdMgrSupportedEntityType(String string, Map map) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrSupportedEntityType", "params: " + map);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = (String)map.get("name");
        ConfigurationProviderType configurationProviderType = ConfigUtils.getConfigProvider(string);
        List list = configurationProviderType.getSupportedEntityTypes();
        SupportedEntityTypesType supportedEntityTypesType = SupportedEntityTypeConfigHelper.getSupportEntityTypeByName(list, string2);
        if (supportedEntityTypesType == null) {
            throw new WIMConfigurationException("INVALID_SUPPORTED_ENTITY_TYPE", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "getIdMgrSupportedEntityType");
        }
        hashMap.put("name", string2);
        hashMap.put("defaultParent", supportedEntityTypesType.getDefaultParent());
        hashMap.put("rdnProperties", ConfigUtils.convertEList(supportedEntityTypesType.getRdnProperties()));
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrSupportedEntityType", "result: " + ((Object)hashMap).toString());
        }
        return hashMap;
    }

    public static SupportedEntityTypesType getSupportEntityTypeByName(List list, String string) {
        boolean bl = false;
        SupportedEntityTypesType supportedEntityTypesType = null;
        for (int i = 0; i < list.size(); ++i) {
            supportedEntityTypesType = (SupportedEntityTypesType)list.get(i);
            if (!supportedEntityTypesType.getName().equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            supportedEntityTypesType = null;
        }
        return supportedEntityTypesType;
    }
}

