/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.config;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.wim.ConfigUIConstants;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.config.RealmConfigHelper;
import com.ibm.ws.wim.config.SupportedEntityTypeConfigHelper;
import com.ibm.ws.wim.configmodel.BaseEntriesType;
import com.ibm.ws.wim.configmodel.ConnectionsType;
import com.ibm.ws.wim.configmodel.LdapRepositoryType;
import com.ibm.ws.wim.configmodel.LdapServersType;
import com.ibm.ws.wim.configmodel.ProfileRepositoryType;
import com.ibm.ws.wim.configmodel.RealmConfigurationType;
import com.ibm.ws.wim.configmodel.RealmDefaultParentType;
import com.ibm.ws.wim.configmodel.RealmType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class WASURHelper
implements ConfigUIConstants {
    String fakeSessionId = "111";
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    static final String CLASSNAME = WASURHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static boolean previousCall = false;
    private static boolean previousResult = false;
    private static final String WAS_INFO_NOT_FOUND = "WAS UR Information could not be found";
    private static final String VMM_DEFAULT_PARENT_INFO = "vmmDefaultParentInfo";
    private static final String WAS_UR_INFO = "wasURInfo";
    private static final String VMM_DEFAULT_PARENT_IS_NULL = "vmmDefaultParentInfo = null";
    private static final String UR_TYPE = "userRegistryType";
    private static final String WIM_USER_REGISTRY_CLASS = "com.ibm.ws.wim.registry.WIMUserRegistry";
    private static final String UNSUPPORTED_REGISTRY_TYPE = "unsupportedRegistryType";
    private static final String LDAP_USER_REGISTRY = "LDAPUserRegistry";
    private static final String WIM_USER_REGISTRY = "WIMUserRegistry";
    private static final String CUSTOM_USER_REGISTRY = "CustomUserRegistry";

    public boolean isWASUserRegistry(String string) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "isWASUserRegistry(String entityType)", "entityType: " + string);
        }
        if (previousCall) {
            return previousResult;
        }
        previousCall = true;
        Map map = WASURHelper.getWASURInfoIfLDAP();
        if (bl) {
            trcLogger.logp(Level.FINE, CLASSNAME, "isWASUserRegistry(String entityType)", "wasURInfo = " + map);
        }
        if (map == null) {
            previousResult = false;
        } else if (WIM_USER_REGISTRY_CLASS.equalsIgnoreCase((String)map.get(UR_TYPE))) {
            previousResult = true;
        } else if (LDAP_USER_REGISTRY.equalsIgnoreCase((String)map.get(UR_TYPE))) {
            Map map2 = this.getEntityTypeDefaultParentLDAP(string);
            if (bl) {
                trcLogger.logp(Level.FINE, CLASSNAME, "isWASUserRegistry(String entityType)", "vmmDefaultParentInfo = " + map2);
            }
            if (map2 != null) {
                String string2 = (String)map2.get("host");
                List list = (List)map2.get("baseEntries");
                Integer n = (Integer)map2.get("port");
                String string3 = (String)map.get("host");
                String string4 = (String)map.get("baseDN");
                Integer n2 = (Integer)map.get("port");
                if (string2 != null && string2.equalsIgnoreCase(string3) && this.matchBaseDN(list, string4) && n != null && n.equals(n2)) {
                    previousResult = true;
                }
            }
        } else {
            previousResult = false;
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "isWASUserRegistry(String entityType)", "result: " + previousResult);
        }
        return previousResult;
    }

    private boolean matchBaseDN(List list, String string) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "matchBaseDN(List repoBaseDNs, String wasBaseDN)", "repoBaseEntries: " + list + ", wasBaseDN: " + string);
        }
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            BaseEntriesType baseEntriesType = (BaseEntriesType)list.get(i);
            String string2 = baseEntriesType.getName();
            if (string2 == null) continue;
            if (string2.equals(string)) {
                bl2 = true;
                break;
            }
            if (!string2.endsWith("," + string)) continue;
            bl2 = true;
            break;
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "matchBaseDN(List repoBaseDNs, String wasBaseDN)", "foundMatch: " + bl2);
        }
        return bl2;
    }

    private Map getEntityTypeDefaultParentLDAP(String string) throws Exception {
        RealmConfigurationType realmConfigurationType;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getEntityTypeDefaultParentLDAP(String entityType)", "entityType = " + string);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ProfileRepositoryType profileRepositoryType = null;
        String string2 = null;
        string2 = this.getEntityTypeDefaultParent(string);
        String string3 = new RealmConfigHelper().getIdMgrDefaultRealm(this.fakeSessionId);
        RealmType realmType = ConfigUtils.getRealm(string3, realmConfigurationType = ConfigUtils.getRealmConfig(this.fakeSessionId));
        String string4 = this.getDefaultParentFromRealm(realmType, string);
        if (string4 != null) {
            string2 = string4;
        }
        List list = this.getIdMgrRepositoriesForRealm(this.fakeSessionId, string3);
        if (string2 != null) {
            profileRepositoryType = this.getInformationForBaseEntry(this.fakeSessionId, string2, list);
        }
        if (profileRepositoryType != null && profileRepositoryType instanceof LdapRepositoryType) {
            hashMap.put("baseEntries", profileRepositoryType.getBaseEntries());
            hashMap.put("repositoryType", "LDAP");
            LdapRepositoryType ldapRepositoryType = (LdapRepositoryType)profileRepositoryType;
            hashMap.put("specificRepositoryType", ldapRepositoryType.getLdapServerType());
            List list2 = ldapRepositoryType.getLdapServerConfiguration().getLdapServers();
            LdapServersType ldapServersType = (LdapServersType)list2.get(0);
            List list3 = ldapServersType.getConnections();
            ConnectionsType connectionsType = (ConnectionsType)list3.get(0);
            hashMap.put("host", connectionsType.getHost());
            if (connectionsType.isSetPort()) {
                hashMap.put("port", new Integer(connectionsType.getPort()));
            }
        } else {
            hashMap = null;
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getEntityTypeDefaultParentLDAP(String entityType)", "Map: " + hashMap);
        }
        return hashMap;
    }

    private String getEntityTypeDefaultParent(String string) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getEntityTypeDefaultParentLDAP(String entityType)", "entityType = " + string);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", string);
        Map map = new SupportedEntityTypeConfigHelper().getIdMgrSupportedEntityType(this.fakeSessionId, hashMap);
        String string2 = (String)map.get("defaultParent");
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getEntityTypeDefaultParentLDAP(String entityType)", "supportedEntityTypeDefaultParent: " + string2);
        }
        return string2;
    }

    private String getDefaultParentFromRealm(RealmType realmType, String string) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getDefaultParentFromRealm(RealmType realm, String entityType)");
        }
        String string2 = null;
        List list = realmType.getDefaultParents();
        for (int i = 0; i < list.size(); ++i) {
            RealmDefaultParentType realmDefaultParentType = (RealmDefaultParentType)list.get(i);
            String string3 = realmDefaultParentType.getEntityTypeName();
            if (string == null || !string.equals(string3)) continue;
            string2 = realmDefaultParentType.getParentUniqueName();
            break;
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getDefaultParentFromRealm(RealmType realm, String entityType)", "defaultParentName: " + string2);
        }
        return string2;
    }

    private List getIdMgrRepositoriesForRealm(String string, String string2) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getIdMgrRepositoriesForRealm(String sessionId, String name)");
        }
        List list = new RealmConfigHelper().listIdMgrRealmBaseEntries(string, string2);
        List list2 = ConfigUtils.getProfileRepositories(string);
        ArrayList<ProfileRepositoryType> arrayList = new ArrayList<ProfileRepositoryType>();
        for (int i = 0; i < list.size(); ++i) {
            String string3 = (String)list.get(i);
            ProfileRepositoryType profileRepositoryType = this.getInformationForBaseEntry(string, string3, list2);
            if (profileRepositoryType == null) continue;
            arrayList.add(profileRepositoryType);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getIdMgrRepositoriesForRealm(String sessionId, String name)");
        }
        return arrayList;
    }

    private ProfileRepositoryType getInformationForBaseEntry(String string, String string2, List list) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getInformationForBaseEntry(String sessionId, String baseEntryName, List repos)");
        }
        ProfileRepositoryType profileRepositoryType = null;
        for (int i = 0; i < list.size(); ++i) {
            ProfileRepositoryType profileRepositoryType2 = (ProfileRepositoryType)list.get(i);
            List list2 = profileRepositoryType2.getBaseEntries();
            if (!this.matchBaseDN(string2, list2)) continue;
            profileRepositoryType = profileRepositoryType2;
            break;
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getInformationForBaseEntry(String sessionId, String baseEntryName, List repos)");
        }
        return profileRepositoryType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Map getWASURInfoIfLDAP() throws Exception {
        block36: {
            block37: {
                block34: {
                    block35: {
                        block32: {
                            block33: {
                                var1 = WASURHelper.trcLogger.isLoggable(Level.FINER);
                                if (var1) {
                                    WASURHelper.trcLogger.entering(WASURHelper.CLASSNAME, "getWASURInfoIfLDAP()");
                                }
                                var2_1 = new HashMap<String, Object>();
                                var3_2 = null;
                                try {
                                    var4_3 = AdminServiceFactory.getAdminService().getDeploymentManagerAdminClient();
                                    var3_2 = new ConfigServiceProxy((AdminClient)var4_3);
                                }
                                catch (Exception var4_4) {
                                    // empty catch block
                                }
                                if (var3_2 == null) {
                                    var3_2 = ConfigServiceFactory.getConfigService();
                                }
                                if (var3_2 == null) {
                                    return null;
                                }
                                var4_3 = null;
                                var4_3 = new Session();
                                var5_5 = ConfigServiceHelper.createObjectName(null, "Security");
                                var6_7 = null;
                                var7_8 = var3_2.resolve((Session)var4_3, "Cell=")[0];
                                if (var7_8 != null && (var8_9 /* !! */  = var3_2.queryConfigObjects((Session)var4_3, var7_8, var5_5, null)) != null && var8_9 /* !! */ .length != 0) {
                                    var6_7 = var8_9 /* !! */ [0];
                                }
                                if (var6_7 == null && (var8_9 /* !! */  = var3_2.queryConfigObjects((Session)var4_3, null, var5_5, null)) != null && var8_9 /* !! */ .length != 0) {
                                    var6_7 = var8_9 /* !! */ [0];
                                }
                                var8_9 /* !! */  = (ObjectName)var3_2.getAttribute((Session)var4_3, var6_7, "activeUserRegistry");
                                var9_10 = false;
                                var10_11 = ConfigServiceHelper.getConfigDataType((ObjectName)var8_9 /* !! */ );
                                if (!"WIMUserRegistry".equalsIgnoreCase(var10_11)) break block32;
                                var2_1.put("userRegistryType", "com.ibm.ws.wim.registry.WIMUserRegistry");
                                var11_13 = var2_1;
                                if (var3_2 == null) break block33;
                                var3_2.discard((Session)var4_3);
                            }
                            return var11_13;
                        }
                        if (!"CustomUserRegistry".equalsIgnoreCase(var10_11)) break block34;
                        var10_11 = (String)var3_2.getAttribute((Session)var4_3, (ObjectName)var8_9 /* !! */ , "customRegistryClassName");
                        var2_1.put("userRegistryType", var10_11);
                        var11_14 = var2_1;
                        if (var3_2 == null) break block35;
                        var3_2.discard((Session)var4_3);
                    }
                    return var11_14;
                }
                if ("LDAPUserRegistry".equalsIgnoreCase(var10_11)) {
                    var2_1.put("userRegistryType", "LDAPUserRegistry");
                    var9_10 = true;
                    break block36;
                }
                var2_1.put("userRegistryType", "unsupportedRegistryType");
                var11_15 = var2_1;
                if (var3_2 == null) break block37;
                var3_2.discard((Session)var4_3);
            }
            return var11_15;
        }
        try {
            block39: {
                break block39;
                {
                    catch (Exception var10_12) {
                        // empty catch block
                    }
                }
            }
            var10_11 = null;
            try {
                var10_11 = (String)var3_2.getAttribute((Session)var4_3, (ObjectName)var8_9 /* !! */ , "serverId");
            }
            catch (Exception var11_16) {
                // empty catch block
            }
            if (!var9_10) {
                if (var1) {
                    WASURHelper.trcLogger.logp(Level.FINER, WASURHelper.CLASSNAME, "getWASURInfoIfLDAP()", "The active registry is not LDAP");
                }
                var11_17 = null;
                return var11_17;
            }
            if (var1) {
                WASURHelper.trcLogger.logp(Level.FINER, WASURHelper.CLASSNAME, "getWASURInfoIfLDAP()", "This is LDAP user registry.");
            }
            var11_18 = (ArrayList)var3_2.getAttribute((Session)var4_3, (ObjectName)var8_9 /* !! */ , "hosts");
            var12_19 = "";
            var13_20 = "ldap://";
            if (var11_18 != null) {
                for (var14_21 = 0; var14_21 < var11_18.size(); ++var14_21) {
                    var15_23 = (AttributeList)var11_18.get(var14_21);
                    var16_24 = (String)ConfigServiceHelper.getAttributeValue(var15_23, "host");
                    var17_25 = (Integer)ConfigServiceHelper.getAttributeValue(var15_23, "port");
                    var2_1.put("port", var17_25);
                    var2_1.put("host", var16_24);
                    var18_26 = new StringBuffer();
                    if (var16_24.startsWith(var13_20)) {
                        var16_24 = var16_24.substring(var13_20.length());
                    }
                    var18_26.append(var13_20).append(var16_24);
                    if (var17_25 != null && var17_25 > 0) {
                        var18_26.append(":" + var17_25);
                    }
                    if (var18_26 == null || var18_26.length() <= 0) continue;
                    if (var12_19 == "") {
                        var12_19 = var18_26.toString();
                        continue;
                    }
                    if (var12_19.indexOf(var18_26.toString()) != -1) continue;
                    var12_19 = var12_19 + " " + var18_26.toString();
                }
            }
            var14_22 = (String)var3_2.getAttribute((Session)var4_3, (ObjectName)var8_9 /* !! */ , "baseDN");
            var2_1.put("baseDN", var14_22);
            if (var1) {
                WASURHelper.trcLogger.logp(Level.FINER, WASURHelper.CLASSNAME, "getWASURInfoIfLDAP()", "LDAP Information: " + var2_1.toString());
            }
        }
        catch (Exception var5_6) {
            if (!var1) ** GOTO lbl125
            WASURHelper.trcLogger.logp(Level.FINER, WASURHelper.CLASSNAME, "getWASURInfoIfLDAP()", "Exception ", var5_6);
        }
        catch (Throwable var19_27) {
            throw var19_27;
        }
        finally {
            if (var3_2 != null) {
                var3_2.discard((Session)var4_3);
            }
        }
        if (var1) {
            WASURHelper.trcLogger.exiting(WASURHelper.CLASSNAME, "getWASURInfoIfLDAP()");
        }
        return var2_1;
    }

    private boolean matchBaseDN(String string, List list) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "matchBaseDN(String defaultParent, List repoBaseEntries)", "repoBaseEntries: " + list + ", defaultParent: " + string);
        }
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            BaseEntriesType baseEntriesType = (BaseEntriesType)list.get(i);
            String string2 = baseEntriesType.getName();
            if (string2 == null) continue;
            if (string2.equals(string)) {
                bl2 = true;
                break;
            }
            if (!string.endsWith("," + string2)) continue;
            bl2 = true;
            break;
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "matchBaseDN(String defaultParent, List repoBaseEntries)", "foundMatch: " + bl2);
        }
        return bl2;
    }
}

