/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dao;

import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.wim.exception.EntityAlreadyExistsException;
import com.ibm.websphere.wim.exception.EntityHasDescendantsException;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.InvalidIdentifierException;
import com.ibm.websphere.wim.exception.InvalidPropertyDefinitionException;
import com.ibm.websphere.wim.exception.InvalidPropertyValueException;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.security.util.WSEncoderDecoder;
import com.ibm.ws.wim.EnvironmentManager;
import com.ibm.ws.wim.RepositoryManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.db.DBAccount;
import com.ibm.ws.wim.adapter.db.DBEntity;
import com.ibm.ws.wim.adapter.db.DBEntityIdEntityType;
import com.ibm.ws.wim.adapter.db.DBExtIdReposId;
import com.ibm.ws.wim.adapter.db.DBPropertyCache;
import com.ibm.ws.wim.adapter.db.PropertyToUpdate;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.DataAccessObject;
import com.ibm.ws.wim.dao.KeyManager;
import com.ibm.ws.wim.dao.QuerySet;
import com.ibm.ws.wim.dao.schema.DBRepositoryProperty;
import com.ibm.ws.wim.lookaside.LAEntity;
import com.ibm.ws.wim.lookaside.LAPropertyCache;
import com.ibm.ws.wim.util.DataGraphHelper;
import com.ibm.ws.wim.util.SearchParameter;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class AbstractDAO
implements DataAccessObject {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    public static final String CLASSNAME = AbstractDAO.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    protected String datasourceName = null;
    private DataSource ds = null;
    private QuerySet qs = null;
    private String dbDriver = null;
    private String dbURL = null;
    private Hashtable needCommit = new Hashtable();
    private String dbUserId = null;
    private String dbPassword = null;
    private KeyManager keyMgr = null;
    private String databaseType = null;

    public AbstractDAO() {
    }

    public AbstractDAO(String string, String string2, String string3, String string4, String string5, String string6, QuerySet querySet) throws WIMException {
        this.datasourceName = string2;
        this.databaseType = string;
        this.dbDriver = string6 == null || string6.length() == 0 ? DAOHelper.getDefaultDBDriver(string) : string6;
        this.dbURL = string3;
        WSEncoderDecoder wSEncoderDecoder = new WSEncoderDecoder();
        if (string4 != null && string4.length() != 0) {
            this.dbUserId = string4;
            if (string5 == null || string5.length() == 0) {
                throw new WIMConfigurationException("INVALID_INIT_PROPERTY", WIMMessageHelper.generateMsgParms("dbAdminPassword"), CLASSNAME, "AbstractDAO Constructor");
            }
            this.dbPassword = string5;
            this.dbPassword = wSEncoderDecoder.decode(this.dbPassword);
        }
        this.qs = querySet;
        this.keyMgr = new KeyManager(this);
        if (!EnvironmentManager.singleton().isDirectAccessMode()) {
            this.dsLookup();
        }
    }

    public void reload(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "reload(String dbAdminPwd)");
        }
        if (this.dbPassword != null && this.dbPassword.trim().length() != 0) {
            WSEncoderDecoder wSEncoderDecoder = new WSEncoderDecoder();
            String string2 = wSEncoderDecoder.decode(string);
            if (this.checkDirectConnection(string2)) {
                this.dbPassword = string2;
            } else {
                throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms("reload(String dbAdminPwd)"), CLASSNAME, "reload(String dbAdminPwd)");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "reload(String dbAdminPwd)");
        }
    }

    public DataSource dsLookup() {
        block4: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "dsLookup");
            }
            try {
                InitialContext initialContext = new InitialContext();
                this.ds = (DataSource)initialContext.lookup(this.datasourceName);
            }
            catch (NamingException namingException) {
                if (!trcLogger.isLoggable(Level.FINE)) break block4;
                trcLogger.logp(Level.FINE, CLASSNAME, "dsLookup", "Naming exception when looking up the datasource.", WIMMessageHelper.generateMsgParms(namingException.getMessage()));
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "dsLookup");
        }
        return this.ds;
    }

    public Connection getConnection() throws WIMSystemException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getConnection()");
        }
        if (EnvironmentManager.singleton().isDirectAccessMode()) {
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.logp(Level.FINE, CLASSNAME, "getConnection()", "direct access mode, getting direct access connection");
            }
            return this.getDirectAccessConnection();
        }
        if (this.ds == null) {
            this.dsLookup();
            if (this.ds == null) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "getConnection()", "no datasource, getting direct access connection");
                }
                return this.getDirectAccessConnection();
            }
        }
        try {
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.logp(Level.FINE, CLASSNAME, "getConnection()", "getting datasource connection");
            }
            Connection connection = this.ds.getConnection();
            if (!this.isDB2JCCDriver()) {
                connection.setTransactionIsolation(2);
            }
            return connection;
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getConnection()", (Throwable)sQLException);
        }
    }

    private boolean isDB2JCCDriver() {
        return this.dbDriver.equals("com.ibm.db2.jcc.DB2Driver");
    }

    private Class loadJDBCClass() throws WIMSystemException {
        Class clazz;
        if (EnvironmentManager.singleton().isZOSControlRegion() && this.databaseType.equals("db2zos")) {
            trcLogger.logp(Level.FINE, CLASSNAME, "loadJDBCClass()", "loading JDBC driver for the z/OS control region");
            clazz = DAOHelper.loadJDBCClass(DAOHelper.getDB2Type4JDBCDriver());
        } else {
            trcLogger.logp(Level.FINE, CLASSNAME, "loadJDBCClass()", "loading JDBC driver for database type " + this.databaseType);
            clazz = DAOHelper.loadJDBCClass(this.dbDriver);
        }
        return clazz;
    }

    public Connection getDirectAccessConnection() throws WIMSystemException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getDirectAccessConnection");
        }
        Connection connection = null;
        try {
            Class clazz = this.loadJDBCClass();
            if (this.dbUserId == null || this.dbUserId.length() == 0) {
                trcLogger.logp(Level.INFO, CLASSNAME, "getDirectAccessConnection", "no db userId.");
                Object t = clazz.newInstance();
                Method method2 = clazz.getMethod("connect", String.class, Properties.class);
                connection = (Connection)method2.invoke(t, this.dbURL, new Properties());
                connection.setTransactionIsolation(2);
            } else {
                trcLogger.logp(Level.FINE, CLASSNAME, "getDirectAccessConnection", "dbURL is " + this.dbURL);
                trcLogger.logp(Level.FINE, CLASSNAME, "getDirectAccessConnection", "dbUserId is " + this.dbUserId);
                Object t = clazz.newInstance();
                Method method3 = clazz.getMethod("connect", String.class, Properties.class);
                Properties properties = new Properties();
                properties.put("user", this.dbUserId);
                properties.put("password", this.dbPassword);
                connection = (Connection)method3.invoke(t, this.dbURL, properties);
                connection.setTransactionIsolation(2);
            }
            if (connection == null) {
                throw new WIMSystemException("DATABASE_CONNECTION", WIMMessageHelper.generateMsgParms(this.dbURL), CLASSNAME, "getDirectAccessConnection");
            }
            this.needCommit.put(connection, new Boolean(true));
        }
        catch (Exception exception) {
            throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "getDirectAccessConnection", (Throwable)exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getDirectAccessConnection");
        }
        return connection;
    }

    private boolean checkDirectConnection(String string) throws WIMSystemException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "checkDirectConnection");
        }
        Class clazz = this.loadJDBCClass();
        Connection connection = null;
        try {
            Object t = clazz.newInstance();
            Method method2 = clazz.getMethod("connect", String.class, Properties.class);
            Properties properties = new Properties();
            properties.put("user", this.dbUserId);
            properties.put("password", string);
            connection = (Connection)method2.invoke(t, this.dbURL, properties);
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINE, CLASSNAME, "checkDirectConnection", "Can't get connection with exception: " + exception.getMessage());
            return false;
        }
        if (connection == null) {
            trcLogger.logp(Level.FINE, CLASSNAME, "checkDirectConnection", "Can't get connection without exception.");
            return false;
        }
        trcLogger.logp(Level.FINE, CLASSNAME, "checkDirectConnection", "Can get connection with new password");
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "checkDirectConnection");
        }
        return true;
    }

    public QuerySet getQuerySet() {
        return this.qs;
    }

    public long createDBEntity(DBEntity dBEntity) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createDBEntity");
        }
        String string = dBEntity.getEntityType();
        String string2 = dBEntity.getUniqueId();
        String string3 = dBEntity.getUniqueName();
        String string4 = DAOHelper.getTruncatedUniqueName(string3);
        Connection connection = null;
        Statement statement = null;
        long l = -1L;
        try {
            connection = this.getConnection();
            l = this.keyMgr.getDBKeyForTable(connection, "DBENTITY");
            String string5 = this.qs.createDBEntity;
            statement = connection.prepareStatement(string5);
            statement.setLong(1, l);
            statement.setString(2, string);
            statement.setString(3, string2);
            statement.setString(4, string3);
            statement.setString(5, string4);
            statement.executeUpdate();
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", CLASSNAME, "createDBEntity", (Throwable)namingException);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new EntityAlreadyExistsException("ENTITY_ALREADY_EXIST", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, "createDBEntity");
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createDBEntity", (Throwable)sQLException);
        }
        finally {
            block15: {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    this.closeConnection(connection);
                }
                catch (Exception exception) {
                    if (!trcLogger.isLoggable(Level.FINE)) break block15;
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(exception.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "createDBEntity", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(exception));
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createDBEntity");
        }
        return l;
    }

    public void createParentRelationship(long l, DBEntity dBEntity) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createParentRelationship");
        }
        String string = dBEntity.getUniqueId();
        String string2 = DAOHelper.getTruncatedUniqueName(dBEntity.getUniqueName());
        Connection connection = null;
        Statement statement = null;
        Statement statement2 = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (string != null && string.length() != 0) {
                statement = connection.prepareStatement(this.qs.findDBEntityIdByUniqueId);
                statement.setString(1, string);
            } else if (string2 != null && string2.length() != 0) {
                statement = connection.prepareStatement(this.qs.findDBEntityIdByTruncUniqueName);
                statement.setString(1, string2);
            }
            resultSet = statement.executeQuery();
            long l2 = -1L;
            while (resultSet.next()) {
                l2 = resultSet.getLong(1);
            }
            if (l2 == -1L) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2 + "/" + string), CLASSNAME, "createParentRelationship");
            }
            statement2 = connection.prepareStatement(this.qs.createEntityRelation);
            statement2.setLong(1, l);
            statement2.setLong(2, l2);
            statement2.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createParentRelationship", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement2 != null) {
                    statement2.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createParentRelationship");
        }
    }

    public void closeConnection(Connection connection) {
        block6: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "closeConnection");
            }
            try {
                if (this.needCommit.get(connection) != null) {
                    if (!this.isDB2JCCDriver()) {
                        connection.commit();
                    }
                    this.needCommit.remove(connection);
                }
                connection.close();
            }
            catch (SQLException sQLException) {
                if (!trcLogger.isLoggable(Level.FINE)) break block6;
                StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                stringBuffer.append(sQLException.toString());
                trcLogger.logp(Level.FINE, CLASSNAME, "closeConnection", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "closeConnection");
        }
    }

    /*
     * Loose catch block
     */
    public boolean checkIfEntityHasDescendants(String string) throws WIMSystemException {
        boolean bl;
        String string2;
        block17: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            Connection connection;
            block16: {
                string2 = "checkIfEntityHasDescendant(String uniqueName)";
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.entering(CLASSNAME, string2);
                }
                bl = false;
                connection = null;
                preparedStatement = null;
                resultSet = null;
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(this.qs.findDescendantsByUniqueNames);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block16;
                bl = true;
            }
            Object var9_7 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
                break block17;
            }
            catch (Exception exception) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(exception.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, string2, stringBuffer.toString(), WIMMessageHelper.generateMsgParms(exception));
                }
                break block17;
            }
            {
                catch (SQLException sQLException) {
                    throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, string2, (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                block18: {
                    Object var9_8 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (connection != null) {
                            this.closeConnection(connection);
                        }
                    }
                    catch (Exception exception) {
                        if (!trcLogger.isLoggable(Level.FINE)) break block18;
                        StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                        stringBuffer.append(exception.toString());
                        trcLogger.logp(Level.FINE, CLASSNAME, string2, stringBuffer.toString(), WIMMessageHelper.generateMsgParms(exception));
                    }
                }
                throw throwable;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string2);
        }
        return bl;
    }

    public Long createCompositePropValue(short s, Integer n, long l, Long l2, String string) throws WIMSystemException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createCompositePropValue");
        }
        Long l3 = null;
        Connection connection = null;
        Statement statement = null;
        String string2 = null;
        String string3 = null;
        if (s == 0) {
            string2 = "DBCOMPPROP";
            string3 = this.qs.createDBCompositePropertyValue;
        } else if (s == 1) {
            string2 = "LACOMPPROP";
            string3 = this.qs.createLACompositePropertyValue;
        }
        try {
            connection = this.getConnection();
            long l4 = -1L;
            l4 = s == 0 ? this.keyMgr.getDBKeyForTable(connection, string2) : this.keyMgr.getLAKeyForTable(connection, string2);
            statement = connection.prepareStatement(string3);
            statement.setLong(1, l4);
            statement.setInt(2, n);
            statement.setLong(3, l);
            if (l2 == null || l2 == 0L) {
                statement.setNull(4, -5);
            } else {
                statement.setLong(4, l2);
            }
            if (string == null) {
                statement.setNull(5, 12);
            } else {
                statement.setString(5, string);
            }
            statement.executeUpdate();
            if (l4 != -1L) {
                l3 = new Long(l4);
            }
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", CLASSNAME, "createCompositePropValue", (Throwable)namingException);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createCompositePropValue", (Throwable)sQLException);
        }
        finally {
            try {
                this.closeConnection(connection);
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createCompositePropValue");
        }
        return l3;
    }

    public void createProperties(short s, long l, Hashtable[] hashtableArray, Long l2, Set set, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps, String reposId)");
        }
        if (hashtableArray == null) {
            return;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            for (short s2 = 0; s2 < hashtableArray.length; s2 = (short)(s2 + 1)) {
                Object object;
                if (hashtableArray[s2] == null) continue;
                String string2 = this.getInsertStmtForPropertyValue(s, s2);
                int n = hashtableArray[s2].size();
                Set set2 = hashtableArray[s2].keySet();
                Iterator iterator = set2.iterator();
                if (connection == null) {
                    connection = this.getConnection();
                }
                statement = connection.prepareStatement(string2);
                String string3 = DAOHelper.getValueTableName(s, s2);
                while (iterator.hasNext()) {
                    List list;
                    object = (Integer)iterator.next();
                    if (set.contains(object)) {
                        list = (List)hashtableArray[s2].get(object);
                    } else {
                        list = new ArrayList();
                        list.add(hashtableArray[s2].get(object));
                    }
                    if (list.size() == 0) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        long l3 = -1L;
                        l3 = s == 0 ? this.keyMgr.getDBKeyForTable(connection, string3) : this.keyMgr.getLAKeyForTable(connection, string3);
                        statement.setLong(1, l3);
                        statement.setInt(2, (Integer)object);
                        statement.setString(3, DAOHelper.getDataType(s2));
                        statement.setLong(4, l);
                        if (l2 != null) {
                            statement.setLong(5, l2);
                        } else {
                            statement.setNull(5, -5);
                        }
                        statement.setString(6, "");
                        try {
                            switch (s2) {
                                case 0: {
                                    statement.setString(7, (String)list.get(i));
                                    statement.setString(8, ((String)list.get(i)).toLowerCase());
                                    break;
                                }
                                case 5: {
                                    Date date;
                                    SimpleDateFormat simpleDateFormat;
                                    Object object2;
                                    ByteArrayOutputStream byteArrayOutputStream;
                                    Timestamp timestamp;
                                    Object object3;
                                    DataObject dataObject = (DataObject)list.get(i);
                                    if (RepositoryManager.singleton().isEntryJoin()) {
                                        DataGraphHelper.prepareIdentifierFromFedRepository(dataObject);
                                    } else if (s == 0 && string != null) {
                                        String string4 = dataObject.getString("uniqueName");
                                        object3 = this.findDBEntityByUniqueNameKey(DAOHelper.getTruncatedUniqueName(string4));
                                        dataObject.setString("externalId", ((DBEntity)object3).getUniqueId());
                                        dataObject.setString("repositoryId", string);
                                    } else if (s == 1) {
                                        String string5 = dataObject.getString("uniqueName");
                                        object3 = dataObject.getString("externalId");
                                        String string6 = dataObject.getString("repositoryId");
                                        if (string5 == null || object3 == null || string6 == null) {
                                            DataObject dataObject2 = SchemaManager.singleton().createRootDataObject();
                                            DataObject dataObject3 = dataObject2.createDataObject("entities", "http://www.ibm.com/websphere/wim", "Entity");
                                            timestamp = dataObject3.createDataObject("identifier");
                                            timestamp.setString("uniqueName", string5);
                                            timestamp.setString("externalId", (String)object3);
                                            timestamp.setString("repositoryId", string6);
                                            byteArrayOutputStream = RepositoryManager.singleton().getRepositories()[0].get(dataObject2);
                                            object2 = byteArrayOutputStream.getList("entities");
                                            simpleDateFormat = (DataObject)object2.get(0);
                                            date = simpleDateFormat.getDataObject("identifier");
                                            string5 = date.getString("uniqueName");
                                            object3 = date.getString("externalId");
                                            string6 = RepositoryManager.singleton().getRepositoryIds()[0];
                                            dataObject.setString("uniqueName", string5);
                                            dataObject.setString("externalId", (String)object3);
                                            dataObject.setString("repositoryId", string);
                                        }
                                    }
                                    statement.setString(7, DAOHelper.getTruncatedUniqueName(dataObject.getString("uniqueName")));
                                    statement.setString(8, dataObject.getString("uniqueName"));
                                    statement.setString(9, DAOHelper.getTruncatedExternalId(dataObject.getString("externalId")));
                                    statement.setString(10, dataObject.getString("externalId"));
                                    statement.setString(11, dataObject.getString("repositoryId"));
                                    break;
                                }
                                case 1: {
                                    long l4 = 0L;
                                    try {
                                        l4 = (Long)list.get(i);
                                    }
                                    catch (ClassCastException classCastException) {
                                        l4 = Long.parseLong((String)list.get(i));
                                    }
                                    statement.setLong(7, l4);
                                    break;
                                }
                                case 2: {
                                    double d = 0.0;
                                    try {
                                        d = (Double)list.get(i);
                                    }
                                    catch (ClassCastException classCastException) {
                                        d = Double.parseDouble((String)list.get(i));
                                    }
                                    statement.setDouble(7, d);
                                    break;
                                }
                                case 3: {
                                    int n2 = 0;
                                    try {
                                        n2 = (Integer)list.get(i);
                                    }
                                    catch (ClassCastException classCastException) {
                                        n2 = new Integer(list.get(i).toString());
                                    }
                                    statement.setInt(7, n2);
                                    break;
                                }
                                case 4: {
                                    Date date;
                                    SimpleDateFormat simpleDateFormat;
                                    Object object2;
                                    Timestamp timestamp = null;
                                    try {
                                        timestamp = (Timestamp)list.get(i);
                                    }
                                    catch (ClassCastException classCastException) {
                                        object2 = list.get(i).toString();
                                        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                                        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                                        date = simpleDateFormat.parse((String)object2);
                                        timestamp = new Timestamp(date.getTime());
                                    }
                                    statement.setTimestamp(7, timestamp);
                                    break;
                                }
                                case 6: {
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                    Object object2 = new ObjectOutputStream(byteArrayOutputStream);
                                    ((ObjectOutputStream)object2).writeObject(list.get(i));
                                    ((ObjectOutputStream)object2).close();
                                    statement.setBytes(7, byteArrayOutputStream.toByteArray());
                                }
                            }
                        }
                        catch (Exception exception) {
                            throw new InvalidPropertyValueException("INVALID_PROPERTY_VALUE_FORMAT", WIMMessageHelper.generateMsgParms(object), CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps, String reposId)", (Throwable)exception);
                        }
                        statement.addBatch();
                    }
                }
                object = statement.executeBatch();
            }
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps, String reposId)", (Throwable)namingException);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps, String reposId)", (Throwable)sQLException);
        }
        finally {
            try {
                this.closeConnection(connection);
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps, String reposId)");
        }
    }

    public void createGroupRelationsForEntity(String string, String string2, List list) throws WIMException {
        String string3;
        String string4;
        Object object;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createGroupRelationsForEntity(String reposId, String uuid, List groupIds)");
        }
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = null;
        for (int i = 0; i < list.size(); ++i) {
            object = ((DataObject)list.get(i)).getString("uniqueName");
            if (object != null && ((String)object).trim().length() != 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(((String)object).trim().toLowerCase());
                continue;
            }
            string4 = ((DataObject)list.get(i)).getString("uniqueId");
            if (string4 != null && string4.trim().length() != 0) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<String>();
                }
                arrayList2.add(string4.trim());
                continue;
            }
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", CLASSNAME, "createGroupRelationsForEntity(String reposId, String uuid, List groupIds)");
        }
        Connection connection = null;
        object = null;
        string4 = null;
        ResultSet resultSet = null;
        long[] lArray = new long[list.size()];
        boolean bl = false;
        if (arrayList != null) {
            string4 = this.qs.selectGEntIdwithGNames;
            string3 = null;
            try {
                connection = this.getConnection();
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = connection.prepareStatement(string4);
                    string3 = (String)arrayList.get(i);
                    object.setString(1, string3);
                    resultSet = object.executeQuery();
                    while (resultSet.next()) {
                        lArray[i] = resultSet.getLong(1);
                    }
                    try {
                        resultSet.close();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms("[" + null + "/" + string3 + "]"), CLASSNAME, "createGroupRelationsForEntity(String reposId, String uuid, List groupIds)");
            }
            finally {
                try {
                    object.close();
                    resultSet.close();
                    string4 = null;
                }
                catch (Exception exception) {}
            }
        }
        if (arrayList2 != null) {
            string4 = this.qs.selectGEntIdwithGUIDs;
            string3 = null;
            try {
                if (connection == null) {
                    connection = this.getConnection();
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    object = connection.prepareStatement(string4);
                    string3 = (String)arrayList2.get(i);
                    object.setString(1, string3);
                    resultSet = object.executeQuery();
                    while (resultSet.next()) {
                        lArray[i] = resultSet.getLong(1);
                    }
                    try {
                        resultSet.close();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms("[" + string3 + "/" + null + "]"), CLASSNAME, "createGroupRelationsForEntity(String reposId, String uuid, List groupIds)");
            }
            finally {
                try {
                    object.close();
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        string3 = this.qs.createDBGrpRelation;
        try {
            if (connection == null) {
                connection = this.getConnection();
            }
            object = connection.prepareStatement(string3);
            for (int i = 0; i < lArray.length; ++i) {
                object.setLong(1, lArray[i]);
                object.setString(2, string);
                object.setString(3, DAOHelper.getTruncatedExternalId(string2));
                object.setString(4, string2);
                object.addBatch();
            }
            int[] nArray = object.executeBatch();
        }
        catch (Exception exception) {
            throw new WIMSystemException();
        }
        finally {
            try {
                this.closeConnection(connection);
                object.close();
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createGroupRelationsForEntity(String reposId, String uuid, List groupIds)");
        }
    }

    public void createGroupRelationsForGroup(long l, List list, String string) throws WIMException {
        block18: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "createGroupRelationsForGroup(long newEntId, List memberIds)");
            }
            Connection connection = null;
            Statement statement = null;
            String string2 = null;
            try {
                if (list.size() <= 0) break block18;
                string2 = this.qs.createDBGrpRelation;
                connection = this.getConnection();
                statement = connection.prepareStatement(string2);
                for (int i = 0; i < list.size(); ++i) {
                    String string3 = ((DataObject)list.get(i)).getString("repositoryId");
                    String string4 = ((DataObject)list.get(i)).getString("externalId");
                    String string5 = ((DataObject)list.get(i)).getString("uniqueName");
                    String string6 = ((DataObject)list.get(i)).getString("uniqueId");
                    if (string3 != null && string3.trim().length() != 0 && string4 != null && string4.trim().length() != 0) {
                        statement.setLong(1, l);
                        statement.setString(2, string3);
                        statement.setString(3, DAOHelper.getTruncatedExternalId(string4));
                        statement.setString(4, string4);
                        statement.addBatch();
                        continue;
                    }
                    if (string6 != null && string6.trim().length() != 0) {
                        statement.setLong(1, l);
                        statement.setString(2, string);
                        statement.setString(3, DAOHelper.getTruncatedExternalId(string6));
                        statement.setString(4, string6);
                        statement.addBatch();
                        continue;
                    }
                    if (string5 != null && string5.trim().length() != 0) {
                        String string7 = null;
                        try {
                            string7 = this.findUniqueIdByUniqueName(string5);
                        }
                        catch (Exception exception) {
                            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms("[" + null + "/" + string5 + "]"), CLASSNAME, "createGroupRelationsForGroup(long newEntId, List memberIds)");
                        }
                        if (string7 == null) {
                            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms("[" + null + "/" + string5 + "]"), CLASSNAME, "createGroupRelationsForGroup(long newEntId, List memberIds)");
                        }
                        statement.setLong(1, l);
                        statement.setString(2, string);
                        statement.setString(3, DAOHelper.getTruncatedExternalId(string7));
                        statement.setString(4, string7);
                        statement.addBatch();
                        continue;
                    }
                    throw new InvalidIdentifierException("INVALID_IDENTIFIER", WIMMessageHelper.generateMsgParms("[" + string6 + "/" + string5 + "]"), CLASSNAME, "createGroupRelationsForGroup(long newEntId, List memberIds)");
                }
                int[] nArray = statement.executeBatch();
            }
            catch (SQLException sQLException) {
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createGroupRelationsForGroup(long newEntId, List memberIds)", (Throwable)sQLException);
            }
            finally {
                try {
                    this.closeConnection(connection);
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createGroupRelationsForGroup(long newEntId, List memberIds)");
        }
    }

    protected String getInsertStmtForPropertyValue(short s, short s2) {
        String string = null;
        if (s == 0) {
            if (s2 == 0) {
                string = this.qs.createDBStringValue;
            } else if (s2 == 1) {
                string = this.qs.createDBLongValue;
            } else if (s2 == 2) {
                string = this.qs.createDBDoubleValue;
            } else if (s2 == 3) {
                string = this.qs.createDBIntegerValue;
            } else if (s2 == 4) {
                string = this.qs.createDBTimestampValue;
            } else if (s2 == 5) {
                string = this.qs.createDBReferenceValue;
            } else if (s2 == 6) {
                string = this.qs.createDBBlobValue;
            }
        } else if (s == 1) {
            if (s2 == 0) {
                string = this.qs.createLAStringValue;
            } else if (s2 == 1) {
                string = this.qs.createLALongValue;
            } else if (s2 == 2) {
                string = this.qs.createLADoubleValue;
            } else if (s2 == 3) {
                string = this.qs.createLAIntegerValue;
            } else if (s2 == 4) {
                string = this.qs.createLATimestampValue;
            } else if (s2 == 5) {
                string = this.qs.createLAReferenceValue;
            } else if (s2 == 6) {
                string = this.qs.createLABlobValue;
            }
        }
        return string;
    }

    private String getUpdateStmtForPropertyValue(short s, short s2) {
        String string = null;
        if (s == 0) {
            if (s2 == 0) {
                string = this.qs.updateDBStringValue;
            } else if (s2 == 1) {
                string = this.qs.updateDBLongValue;
            } else if (s2 == 2) {
                string = this.qs.updateDBDoubleValue;
            } else if (s2 == 3) {
                string = this.qs.updateDBIntegerValue;
            } else if (s2 == 4) {
                string = this.qs.updateDBTimestampValue;
            } else if (s2 == 5) {
                string = this.qs.updateDBReferenceValue;
            } else if (s2 == 6) {
                string = this.qs.updateDBBlobValue;
            }
        } else if (s == 1) {
            if (s2 == 0) {
                string = this.qs.updateLAStringValue;
            } else if (s2 == 1) {
                string = this.qs.updateLALongValue;
            } else if (s2 == 2) {
                string = this.qs.updateLADoubleValue;
            } else if (s2 == 3) {
                string = this.qs.updateLAIntegerValue;
            } else if (s2 == 4) {
                string = this.qs.updateLATimestampValue;
            } else if (s2 == 5) {
                string = this.qs.updateLAReferenceValue;
            } else if (s2 == 6) {
                string = this.qs.updateLABlobValue;
            }
        }
        return string;
    }

    private String getUpdateStmtForPropertyValueWithOldValue(short s, short s2) {
        String string = null;
        if (s == 0) {
            if (s2 == 0) {
                string = this.qs.updateDBStringValueWithOldValue;
            } else if (s2 == 1) {
                string = this.qs.updateDBLongValueWithOldValue;
            } else if (s2 == 2) {
                string = this.qs.updateDBDoubleValueWithOldValue;
            } else if (s2 == 3) {
                string = this.qs.updateDBIntegerValueWithOldValue;
            } else if (s2 == 4) {
                string = this.qs.updateDBTimestampValueWithOldValue;
            } else if (s2 == 5) {
                string = this.qs.updateDBReferenceValueWithOldValue;
            } else if (s2 == 6) {
                string = this.qs.updateDBBlobValueWithOldValue;
            }
        } else if (s == 1) {
            if (s2 == 0) {
                string = this.qs.updateLAStringValueWithOldValue;
            } else if (s2 == 1) {
                string = this.qs.updateLALongValueWithOldValue;
            } else if (s2 == 2) {
                string = this.qs.updateLADoubleValueWithOldValue;
            } else if (s2 == 3) {
                string = this.qs.updateLAIntegerValueWithOldValue;
            } else if (s2 == 4) {
                string = this.qs.updateLATimestampValueWithOldValue;
            } else if (s2 == 5) {
                string = this.qs.updateLAReferenceValueWithOldValue;
            } else if (s2 == 6) {
                string = this.qs.updateLABlobValueWithOldValue;
            }
        }
        return string;
    }

    public void deleteDBGroupRelation(Hashtable hashtable) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "deleteDBGroupRelation(Hashtable grpMbrs)", "grpMbrs=" + hashtable);
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String string = null;
        int n = 0;
        ArrayList<String> arrayList = null;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            List list;
            String string2 = (String)enumeration.nextElement();
            if (string2 == null || (list = (List)hashtable.get(string2)) == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string2);
            n += list.size();
        }
        if (n > 0) {
            int n2;
            string = this.qs.removeDBGroupRelationMain;
            for (n2 = 0; n2 < n - 1; ++n2) {
                string = string.concat(this.qs.orRemoveDBGroupRelationByExtIdAndReposId);
            }
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "deleteDBGroupRelation(Hashtable grpMbrs)", "sql statement is " + string);
            }
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(string);
                n2 = 1;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string3 = (String)arrayList.get(i);
                    List list = (List)hashtable.get(string3);
                    for (int j = 0; j < list.size(); ++j) {
                        preparedStatement.setString(n2++, (String)list.get(j));
                        if (trcLogger.isLoggable(Level.FINER)) {
                            trcLogger.logp(Level.FINER, CLASSNAME, "deleteDBGroupRelation(Hashtable grpMbrs)", "param " + n2 + " to set is " + list.get(j));
                        }
                        preparedStatement.setString(n2++, string3);
                        if (!trcLogger.isLoggable(Level.FINER)) continue;
                        trcLogger.logp(Level.FINER, CLASSNAME, "deleteDBGroupRelation(Hashtable grpMbrs)", "param " + n2 + " to set is " + string3);
                    }
                }
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "deleteDBGroupRelation(Hashtable grpMbrs)", (Throwable)sQLException);
            }
            finally {
                block22: {
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (connection != null) {
                            this.closeConnection(connection);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!trcLogger.isLoggable(Level.FINE)) break block22;
                        StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                        stringBuffer.append(sQLException.toString());
                        trcLogger.logp(Level.FINE, CLASSNAME, "deleteDBGroupRelation(Hashtable grpMbrs)", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                    }
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "deleteDBGroupRelation(Hashtable grpMbrs)");
        }
    }

    public void deleteEntityWithDescendants(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "deleteEntityWithDescendants(String uniqueName)");
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.qs.deleteDBEntityWithDescendants);
            statement.setString(1, "%" + string.trim().toLowerCase());
            int n = statement.executeUpdate();
            if (n == 0) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "deleteEntityWithDescendants(String uniqueName)");
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "deleteEntityWithDescendants(String uniqueName)", (Throwable)sQLException);
        }
        finally {
            block15: {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        this.closeConnection(connection);
                    }
                }
                catch (SQLException sQLException) {
                    if (!trcLogger.isLoggable(Level.FINE)) break block15;
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(sQLException.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "deleteEntityWithDescendants(String uniqueName)", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "deleteEntityWithDescendants(String uniqueName)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteCompositeProperties(short s, long l, Hashtable hashtable) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "deleteCompositeProperties(short schema, long entId, Hashtable compProps)");
        }
        Connection connection = null;
        Statement statement = null;
        try {
            int n;
            String string = null;
            string = s == 0 ? this.qs.deleteDBCompositeProperties : this.qs.deleteLACompositeProperties;
            for (n = 0; n < hashtable.size(); n = (int)((short)(n + 1))) {
                string = string + this.qs.PARAM_MARKER;
                if (n == hashtable.size() - 1) continue;
                string = string + this.qs.COMMA;
            }
            string = string + this.qs.RIGHT_BRACKET;
            connection = this.getConnection();
            n = 2;
            statement = connection.prepareStatement(string);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "deleteCompositeProperties(short schema, long entId, Hashtable compProps)", "The delete sql is " + string);
            }
            statement.setLong(1, l);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                statement.setInt(n++, n2);
            }
            statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "deleteCompositeProperties(short schema, long entId, Hashtable compProps)", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                try {
                    this.closeConnection(connection);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    statement.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.closeConnection(connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            statement.close();
        }
        catch (Exception exception) {}
        if (!trcLogger.isLoggable(Level.FINER)) return;
        trcLogger.exiting(CLASSNAME, "deleteCompositeProperties(short schema, long entId, Hashtable compProps)");
    }

    public String findUniqueIdByUniqueName(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "findUniqueIdsByUniqueName(String uniqueName)");
        }
        String string2 = null;
        Connection connection = null;
        Statement statement = null;
        String string3 = null;
        ResultSet resultSet = null;
        try {
            string3 = this.qs.findUniqueIdByUniqueNameKey;
            connection = this.getConnection();
            statement = connection.prepareStatement(string3);
            statement.setString(1, DAOHelper.getTruncatedUniqueName(string));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "findUniqueIdsByUniqueName(String uniqueName)", (Throwable)sQLException);
        }
        finally {
            block15: {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        this.closeConnection(connection);
                    }
                }
                catch (SQLException sQLException) {
                    if (!trcLogger.isLoggable(Level.FINE)) break block15;
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(sQLException.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "findUniqueIdsByUniqueName(String uniqueName)", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "findUniqueIdsByUniqueName(String uniqueName)");
        }
        return string2;
    }

    public List findDBEntitysByParentName(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "findDBEntitysByParentName(String uniqueName)");
        }
        ArrayList<DBEntity> arrayList = null;
        Connection connection = null;
        Statement statement = null;
        String string2 = null;
        ResultSet resultSet = null;
        try {
            string2 = this.qs.findDBEntitysByUniqueNameKeyLike;
            connection = this.getConnection();
            statement = connection.prepareStatement(string2);
            statement.setString(1, "%" + string.toLowerCase());
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<DBEntity>();
                }
                DBEntity dBEntity = new DBEntity();
                dBEntity.setEntityId(resultSet.getLong(1));
                dBEntity.setEntityType(resultSet.getString(2));
                dBEntity.setUniqueId(resultSet.getString(3));
                dBEntity.setUniqueName(resultSet.getString(4));
                arrayList.add(dBEntity);
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "findDBEntitysByParentName(String uniqueName)", (Throwable)sQLException);
        }
        finally {
            block16: {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        this.closeConnection(connection);
                    }
                }
                catch (SQLException sQLException) {
                    if (!trcLogger.isLoggable(Level.FINE)) break block16;
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(sQLException.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "findDBEntitysByParentName(String uniqueName)", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "findDBEntitysByParentName(String uniqueName)");
        }
        return arrayList;
    }

    /*
     * Loose catch block
     */
    private DBEntity findDBEntityByEntityId(long l) throws WIMException {
        DBEntity dBEntity;
        block17: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "findDBEntityByUniqueId(String uniqueId)");
            }
            dBEntity = null;
            Connection connection = null;
            Statement statement = null;
            String string = null;
            ResultSet resultSet = null;
            string = this.qs.findDBEntityByEntityId;
            connection = this.getConnection();
            statement = connection.prepareStatement(string);
            statement.setLong(1, l);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                dBEntity = new DBEntity();
                dBEntity.setEntityId(resultSet.getLong("ENTITY_ID"));
                dBEntity.setEntityType(resultSet.getString("ENTITY_TYPE"));
                dBEntity.setUniqueId(resultSet.getString("UNIQUE_ID").trim());
                dBEntity.setUniqueName(resultSet.getString("UNIQUE_NAME"));
                dBEntity.setTruncUniqueName(resultSet.getString("UNIQUE_NAME_KEY"));
            }
            Object var11_7 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
                break block17;
            }
            catch (SQLException sQLException) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(sQLException.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "findDBEntityByUniqueId(String uniqueId)", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                }
                break block17;
            }
            {
                catch (SQLException sQLException) {
                    throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "findDBEntityByUniqueId(String uniqueId)", (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                block18: {
                    Object var11_8 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (connection != null) {
                            this.closeConnection(connection);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!trcLogger.isLoggable(Level.FINE)) break block18;
                        StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                        stringBuffer.append(sQLException.toString());
                        trcLogger.logp(Level.FINE, CLASSNAME, "findDBEntityByUniqueId(String uniqueId)", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                    }
                }
                throw throwable;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "findDBEntityByUniqueId(String uniqueId)");
        }
        return dBEntity;
    }

    /*
     * Loose catch block
     */
    public DBEntity findDBEntityByUniqueId(String string) throws WIMException {
        DBEntity dBEntity;
        block17: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "findDBEntityByUniqueId(String uniqueId)");
            }
            dBEntity = null;
            Connection connection = null;
            Statement statement = null;
            String string2 = null;
            ResultSet resultSet = null;
            string2 = this.qs.findDBEntityByUniqueId;
            connection = this.getConnection();
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                dBEntity = new DBEntity();
                dBEntity.setEntityId(resultSet.getLong("ENTITY_ID"));
                dBEntity.setEntityType(resultSet.getString("ENTITY_TYPE"));
                dBEntity.setUniqueId(resultSet.getString("UNIQUE_ID").trim());
                dBEntity.setUniqueName(resultSet.getString("UNIQUE_NAME"));
                dBEntity.setTruncUniqueName(resultSet.getString("UNIQUE_NAME_KEY"));
            }
            Object var10_7 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
                break block17;
            }
            catch (SQLException sQLException) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(sQLException.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "findDBEntityByUniqueId(String uniqueId)", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                }
                break block17;
            }
            {
                catch (SQLException sQLException) {
                    throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "findDBEntityByUniqueId(String uniqueId)", (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                block18: {
                    Object var10_8 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (connection != null) {
                            this.closeConnection(connection);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!trcLogger.isLoggable(Level.FINE)) break block18;
                        StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                        stringBuffer.append(sQLException.toString());
                        trcLogger.logp(Level.FINE, CLASSNAME, "findDBEntityByUniqueId(String uniqueId)", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                    }
                }
                throw throwable;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "findDBEntityByUniqueId(String uniqueId)");
        }
        return dBEntity;
    }

    /*
     * Loose catch block
     */
    public DBEntity findDBEntityByUniqueNameKey(String string) throws WIMException {
        DBEntity dBEntity;
        block18: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "findDBEntityByUniqueNameKey(String uniqueNameKey)");
            }
            dBEntity = null;
            Connection connection = null;
            Statement statement = null;
            String string2 = null;
            ResultSet resultSet = null;
            if ((string = DAOHelper.getTruncatedUniqueName(string)).length() > 236) {
                string = string.substring(0, 236);
            }
            string2 = this.qs.findDBEntityByUniqueNameKey;
            connection = this.getConnection();
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                dBEntity = new DBEntity();
                dBEntity.setEntityId(resultSet.getLong("ENTITY_ID"));
                dBEntity.setEntityType(resultSet.getString("ENTITY_TYPE"));
                dBEntity.setUniqueId(resultSet.getString("UNIQUE_ID").trim());
                dBEntity.setUniqueName(resultSet.getString("UNIQUE_NAME"));
                dBEntity.setTruncUniqueName(resultSet.getString("UNIQUE_NAME_KEY"));
            }
            Object var10_7 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
                break block18;
            }
            catch (SQLException sQLException) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(sQLException.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "findDBEntityByUniqueNameKey(String uniqueNameKey)", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                }
                break block18;
            }
            {
                catch (SQLException sQLException) {
                    throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "findDBEntityByUniqueNameKey(String uniqueNameKey)", (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Object var10_8 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (connection != null) {
                            this.closeConnection(connection);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!trcLogger.isLoggable(Level.FINE)) break block19;
                        StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                        stringBuffer.append(sQLException.toString());
                        trcLogger.logp(Level.FINE, CLASSNAME, "findDBEntityByUniqueNameKey(String uniqueNameKey)", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                    }
                }
                throw throwable;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "findDBEntityByUniqueNameKey(String uniqueNameKey)");
        }
        return dBEntity;
    }

    public String getDBPropValuesByEntityQuery(short s) {
        switch (s) {
            case 0: {
                return this.qs.getDBStringPropValuesByEntityId;
            }
            case 3: {
                return this.qs.getDBIntegerPropValuesByEntityId;
            }
            case 1: {
                return this.qs.getDBLongPropValuesByEntityId;
            }
            case 2: {
                return this.qs.getDBDoublePropValuesByEntityId;
            }
            case 4: {
                return this.qs.getDBTimestampPropValuesByEntityId;
            }
            case 5: {
                return this.qs.getDBReferencePropValuesByEntityId;
            }
            case 6: {
                return this.qs.getDBObjectPropValuesByEntityId;
            }
        }
        return null;
    }

    public String getLAPropValuesByEntityQuery(short s) {
        switch (s) {
            case 0: {
                return this.qs.getLAStringPropValuesByEntityId;
            }
            case 3: {
                return this.qs.getLAIntegerPropValuesByEntityId;
            }
            case 1: {
                return this.qs.getLALongPropValuesByEntityId;
            }
            case 2: {
                return this.qs.getLADoublePropValuesByEntityId;
            }
            case 4: {
                return this.qs.getLATimestampPropValuesByEntityId;
            }
            case 5: {
                return this.qs.getLAReferencePropValuesByEntityId;
            }
            case 6: {
                return this.qs.getLAObjectPropValuesByEntityId;
            }
        }
        return null;
    }

    public void readDBProperties(long l, StringBuffer stringBuffer, short s, DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "readDBProperties(long entityId, StringBuffer buff, short datatypeId, DataObject entity)");
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            stringBuffer.append(this.qs.orderByPropertyNameInGetProperties);
            connection = this.getConnection();
            statement = connection.prepareStatement(stringBuffer.toString(), 1003, 1007);
            statement.setLong(1, l);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                DBEntity dBEntity;
                String string = resultSet.getString(1);
                int n = resultSet.getInt(2);
                String string2 = null;
                string2 = SchemaManager.singleton().getQualifiedTypeName(dataObject.getType());
                if (string2.equals("Entity")) {
                    dBEntity = this.findDBEntityByEntityId(l);
                    string2 = dBEntity.getEntityType();
                }
                dBEntity = SchemaManager.singleton().getProperty(string2, string);
                if (s != 5) {
                    if (n == 1) {
                        dataObject.getList((Property)dBEntity).add(DAOHelper.getRightTypeValue(resultSet, s, 3));
                        continue;
                    }
                    dataObject.set((Property)dBEntity, DAOHelper.getRightTypeValue(resultSet, s, 3));
                    continue;
                }
                String[] stringArray = DAOHelper.getRightReferenceTypeValue(resultSet, 3, 4, 5);
                EClass eClass = SchemaManager.singleton().getEClass("IdentifierType");
                DataObject dataObject2 = (DataObject)EcoreUtil.create((EClass)eClass);
                dataObject2.setString("externalId", stringArray[1]);
                dataObject2.setString("repositoryId", stringArray[2]);
                DBEntity dBEntity2 = this.findDBEntityByUniqueId(stringArray[1]);
                if (dBEntity2 != null) {
                    dataObject2.setString("uniqueName", dBEntity2.getUniqueName());
                    dataObject2.setString("uniqueId", stringArray[1]);
                    dataObject2.setString("externalName", dBEntity2.getUniqueName());
                }
                if (n == 1) {
                    dataObject.getList((Property)dBEntity).add(dataObject2);
                    continue;
                }
                dataObject.set((Property)dBEntity, (Object)dataObject2);
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "readDBProperties(long entityId, StringBuffer buff, short datatypeId, DataObject entity)", (Throwable)sQLException);
        }
        catch (IOException iOException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "readDBProperties(long entityId, StringBuffer buff, short datatypeId, DataObject entity)", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "readDBProperties(long entityId, StringBuffer buff, short datatypeId, DataObject entity)", (Throwable)classNotFoundException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "readDBProperties(long entityId, StringBuffer buff, short datatypeId, DataObject entity)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readAllDBPropertiesForEntity(long l, DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "readAllDBProperties(long entityId, DataObject entity)");
        }
        String string2 = SchemaManager.singleton().getQualifiedTypeName(dataObject.getType());
        Connection connection = null;
        Connection connection2 = null;
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        String string3 = this.qs.findAllPropertiesForEntity;
        String string4 = this.qs.findAllBlobPropertiesForEntity;
        try {
            try {
                String string;
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(string3, 1003, 1007);
                trcLogger.logp(Level.FINER, CLASSNAME, "readAllDBProperties(long entityId, DataObject entity)", "read all DB properties sql is:  " + string3);
                preparedStatement.setLong(1, l);
                preparedStatement.setLong(2, l);
                preparedStatement.setLong(3, l);
                preparedStatement.setLong(4, l);
                preparedStatement.setLong(5, l);
                preparedStatement.setLong(6, l);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    string = resultSet.getString(7);
                    Property property = SchemaManager.singleton().getProperty(string2, string);
                    if (this.isOperationalProperty(string)) continue;
                    int n2 = resultSet.getInt(8);
                    short s = resultSet.getShort(2);
                    if (s != 5) {
                        try {
                            if (n2 == 1) {
                                dataObject.getList(property).add(DAOHelper.getRightTypeValue(resultSet, s, n));
                                continue;
                            }
                            dataObject.set(property, DAOHelper.getRightTypeValue(resultSet, s, n));
                        }
                        catch (NullPointerException nullPointerException) {}
                        continue;
                    }
                    String[] stringArray = DAOHelper.getRightReferenceTypeValue(resultSet, 3, 4, 5);
                    EClass eClass = SchemaManager.singleton().getEClass("IdentifierType");
                    DataObject dataObject2 = (DataObject)EcoreUtil.create((EClass)eClass);
                    dataObject2.setString("externalId", stringArray[1]);
                    dataObject2.setString("repositoryId", stringArray[2]);
                    if (n2 == 1) {
                        dataObject.getList(property).add(dataObject2);
                        continue;
                    }
                    dataObject.set(property, (Object)dataObject2);
                }
                preparedStatement = connection.prepareStatement(string4, 1003, 1007);
                trcLogger.logp(Level.FINER, CLASSNAME, "readAllDBProperties(long entityId, DataObject entity)", "read all DB blob properties sql is:  " + string4);
                preparedStatement.setLong(1, l);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string5 = resultSet.getString(2);
                    string = SchemaManager.singleton().getProperty(string2, string5);
                    int n = resultSet.getInt(3);
                    if (n == 1) {
                        dataObject.getList((Property)string).add(this.getBlobValue(resultSet, 4));
                        continue;
                    }
                    dataObject.set((Property)string, this.getBlobValue(resultSet, 4));
                }
                Object var23_26 = null;
            }
            catch (SQLException sQLException) {
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "readAllDBProperties(long entityId, DataObject entity)", (Throwable)sQLException);
            }
            catch (IOException iOException) {
                throw new WIMSystemException("GENERIC", CLASSNAME, "readAllDBProperties(long entityId, DataObject entity)", (Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WIMSystemException("GENERIC", CLASSNAME, "readAllDBProperties(long entityId, DataObject entity)", (Throwable)classNotFoundException);
            }
        }
        catch (Throwable throwable) {
            Object var23_27 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
                if (statement != null) {
                    statement.close();
                }
                if (resultSet2 != null) {
                    resultSet2.close();
                }
                if (connection2 == null) throw throwable;
                this.closeConnection(connection2);
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (connection != null) {
            this.closeConnection(connection);
        }
        if (statement != null) {
            statement.close();
        }
        if (resultSet2 != null) {
            resultSet2.close();
        }
        if (connection2 != null) {
            this.closeConnection(connection2);
        }
        if (!trcLogger.isLoggable(Level.FINER)) return;
        trcLogger.exiting(CLASSNAME, "readAllDBProperties(long entityId, DataObject entity)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readAllLAPropertiesForEntity(long l, DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "readAllLAProperties(long entityId, DataObject entity)");
        }
        String string2 = SchemaManager.singleton().getQualifiedTypeName(dataObject.getType());
        Connection connection = null;
        Connection connection2 = null;
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        String string3 = this.qs.findAllPropertiesForLAEntity;
        String string4 = this.qs.findAllBlobPropertiesForLAEntity;
        try {
            try {
                String string;
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(string3, 1003, 1007);
                trcLogger.logp(Level.FINER, CLASSNAME, "readAllLAProperties(long entityId, DataObject entity)", "read all LA properties sql is:  " + string3);
                preparedStatement.setLong(1, l);
                preparedStatement.setLong(2, l);
                preparedStatement.setLong(3, l);
                preparedStatement.setLong(4, l);
                preparedStatement.setLong(5, l);
                preparedStatement.setLong(6, l);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    string = resultSet.getString(7);
                    Property property = SchemaManager.singleton().getProperty(string2, string);
                    if (this.isOperationalProperty(string)) continue;
                    int n2 = resultSet.getInt(8);
                    short s = resultSet.getShort(2);
                    if (s != 5) {
                        if (n2 == 1) {
                            dataObject.getList(property).add(DAOHelper.getRightTypeValue(resultSet, s, n));
                            continue;
                        }
                        dataObject.set(property, DAOHelper.getRightTypeValue(resultSet, s, n));
                        continue;
                    }
                    String[] stringArray = DAOHelper.getRightReferenceTypeValue(resultSet, 3, 4, 5);
                    EClass eClass = SchemaManager.singleton().getEClass("IdentifierType");
                    DataObject dataObject2 = (DataObject)EcoreUtil.create((EClass)eClass);
                    dataObject2.setString("uniqueName", stringArray[0]);
                    dataObject2.setString("externalId", stringArray[1]);
                    dataObject2.setString("repositoryId", stringArray[2]);
                    if (n2 == 1) {
                        dataObject.getList(property).add(dataObject2);
                        continue;
                    }
                    dataObject.set(property, (Object)dataObject2);
                }
                preparedStatement = connection.prepareStatement(string4, 1003, 1007);
                trcLogger.logp(Level.FINER, CLASSNAME, "readAllLAProperties(long entityId, DataObject entity)", "read all LA blob properties sql is:  " + string4);
                preparedStatement.setLong(1, l);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string5 = resultSet.getString(2);
                    string = SchemaManager.singleton().getProperty(string2, string5);
                    int n = resultSet.getInt(3);
                    if (n == 1) {
                        dataObject.getList((Property)string).add(this.getBlobValue(resultSet, 4));
                        continue;
                    }
                    dataObject.set((Property)string, this.getBlobValue(resultSet, 4));
                }
                Object var23_25 = null;
            }
            catch (SQLException sQLException) {
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "readAllLAProperties(long entityId, DataObject entity)", (Throwable)sQLException);
            }
            catch (IOException iOException) {
                throw new WIMSystemException("GENERIC", CLASSNAME, "readAllLAProperties(long entityId, DataObject entity)", (Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WIMSystemException("GENERIC", CLASSNAME, "readAllLAProperties(long entityId, DataObject entity)", (Throwable)classNotFoundException);
            }
        }
        catch (Throwable throwable) {
            Object var23_26 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
                if (statement != null) {
                    statement.close();
                }
                if (resultSet2 != null) {
                    resultSet2.close();
                }
                if (connection2 == null) throw throwable;
                this.closeConnection(connection2);
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (connection != null) {
            this.closeConnection(connection);
        }
        if (statement != null) {
            statement.close();
        }
        if (resultSet2 != null) {
            resultSet2.close();
        }
        if (connection2 != null) {
            this.closeConnection(connection2);
        }
        if (!trcLogger.isLoggable(Level.FINER)) return;
        trcLogger.exiting(CLASSNAME, "readAllLAProperties(long entityId, DataObject entity)");
    }

    private boolean isOperationalProperty(String string) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isOperationalProperty(String propName)");
        }
        boolean bl = false;
        if (string.equals("createTimestamp")) {
            bl = true;
        }
        if (string.equals("modifyTimestamp")) {
            bl = true;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "isOperationalProperty(String propName)", "Property " + string + " is an operational propery: " + bl);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "isOperationalProperty(String propName)");
        }
        return bl;
    }

    public Object getBlobValue(ResultSet resultSet, int n) throws SQLException, IOException, ClassNotFoundException {
        Blob blob = resultSet.getBlob(n);
        InputStream inputStream = blob.getBinaryStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return objectInputStream.readObject();
    }

    public void readLAProperties(long l, StringBuffer stringBuffer, short s, DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "readLAProperties(long entityId, StringBuffer buff, short datatypeId, DataObject entity)");
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            stringBuffer.append(this.qs.orderByPropertyNameInGetProperties);
            connection = this.getConnection();
            statement = connection.prepareStatement(stringBuffer.toString(), 1003, 1007);
            statement.setLong(1, l);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                int n = resultSet.getInt(2);
                String string2 = SchemaManager.singleton().getQualifiedTypeName(dataObject.getType());
                Property property = SchemaManager.singleton().getProperty(string2, string);
                if (s != 5) {
                    if (n == 1) {
                        dataObject.getList(property).add(DAOHelper.getRightTypeValue(resultSet, s, 3));
                        continue;
                    }
                    dataObject.set(property, DAOHelper.getRightTypeValue(resultSet, s, 3));
                    continue;
                }
                String[] stringArray = DAOHelper.getRightReferenceTypeValue(resultSet, 3, 4, 5);
                EClass eClass = SchemaManager.singleton().getEClass("IdentifierType");
                DataObject dataObject2 = (DataObject)EcoreUtil.create((EClass)eClass);
                dataObject2.setString("uniqueName", stringArray[0]);
                dataObject2.setString("externalId", stringArray[1]);
                dataObject2.setString("repositoryId", stringArray[2]);
                if (n == 1) {
                    dataObject.getList(property).add(dataObject2);
                    continue;
                }
                dataObject.set(property, (Object)dataObject2);
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "readLAProperties(long entityId, StringBuffer buff, short datatypeId, DataObject entity)", (Throwable)sQLException);
        }
        catch (IOException iOException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "readLAProperties(long entityId, StringBuffer buff, short datatypeId, DataObject entity)", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "readLAProperties(long entityId, StringBuffer buff, short datatypeId, DataObject entity)", (Throwable)classNotFoundException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "readLAProperties(long entityId, StringBuffer buff, short datatypeId, DataObject entity)");
        }
    }

    public DBEntity findParent(long l) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "DBEntity findParent(long entityId)");
        }
        DBEntity dBEntity = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string = this.qs.findParentByEntityId;
            connection = this.getConnection();
            statement = connection.prepareStatement(string);
            statement.setLong(1, l);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                dBEntity = new DBEntity();
                dBEntity.setEntityId(resultSet.getLong(1));
                dBEntity.setUniqueId(resultSet.getString(2).trim());
                dBEntity.setUniqueName(resultSet.getString(3));
                dBEntity.setEntityType(resultSet.getString(4));
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "DBEntity findParent(long entityId)", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "DBEntity findParent(long entityId)");
        }
        return dBEntity;
    }

    public String getSpecificDatatypePropertyForEntitiesQuery(short s) {
        StringBuffer stringBuffer = new StringBuffer(512);
        switch (s) {
            case 0: {
                stringBuffer.append(this.qs.findStringPropertyForEntities);
                break;
            }
            case 3: {
                stringBuffer.append(this.qs.findIntegerPropertyForEntities);
                break;
            }
            case 2: {
                stringBuffer.append(this.qs.findDoublePropertyForEntities);
                break;
            }
            case 1: {
                stringBuffer.append(this.qs.findLongPropertyForEntities);
                break;
            }
            case 4: {
                stringBuffer.append(this.qs.findTimestampPropertyForEntities);
                break;
            }
            case 5: {
                stringBuffer.append(this.qs.findReferencePropertyForEntities);
                break;
            }
        }
        return stringBuffer.toString();
    }

    public void getDBEntityInformation(String string, DataObject dataObject, String string2, String string3) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getDBEntityInformation(String query, DataObject entity, String DOPropName, String reposId)");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            long l = -1L;
            long l2 = -1L;
            int n = -100;
            DataObject dataObject2 = null;
            while (resultSet.next()) {
                String string4;
                n = resultSet.getInt(1);
                l2 = resultSet.getLong(3);
                if (l2 != l) {
                    string4 = SchemaManager.singleton().getEClass(resultSet.getString(6));
                    dataObject2 = (DataObject)EcoreUtil.create((EClass)string4);
                    DataObject dataObject3 = dataObject2.createDataObject("identifier");
                    String string5 = resultSet.getString(4);
                    String string6 = resultSet.getString(5);
                    dataObject3.setString("uniqueName", string5);
                    dataObject3.setString("externalName", string5);
                    dataObject3.setString("uniqueId", string6);
                    dataObject3.setString("externalId", string6);
                    dataObject3.setString("repositoryId", string3);
                    dataObject.getList(string2).add(dataObject2);
                }
                string4 = resultSet.getString(8);
                int n2 = resultSet.getInt(9);
                short s = resultSet.getShort(2);
                if (n != -100 && s != 5) {
                    if (n2 == 1) {
                        dataObject2.getList(string4).add(DAOHelper.getRightTypeValue(resultSet, s, n));
                    } else {
                        dataObject2.set(string4, DAOHelper.getRightTypeValue(resultSet, s, n));
                    }
                }
                l = l2;
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getDBEntityInformation(String query, DataObject entity, String DOPropName, String reposId)", (Throwable)sQLException);
        }
        catch (IOException iOException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "getDBEntityInformation(String query, DataObject entity, String DOPropName, String reposId)", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "getDBEntityInformation(String query, DataObject entity, String DOPropName, String reposId)", (Throwable)classNotFoundException);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getDBEntityInformation(String query, DataObject entity, String DOPropName, String reposId)");
        }
    }

    public List getAllDescendantsByUniqueNameKey(String string, List list) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getAllDescendantsByUniqueNameKey(String uniqueNameKey)");
        }
        ArrayList<Long> arrayList = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.qs.findAllDescendantsByUniqueNameKey;
            if (list != null && list.size() != 0) {
                string2 = string2.concat(this.qs.entityTypesIn);
                for (int i = 0; i < list.size(); ++i) {
                    string2 = string2.concat(this.qs.SINGLE_QUOTE);
                    string2 = string2.concat((String)list.get(i));
                    string2 = string2.concat(this.qs.SINGLE_QUOTE);
                    if (i == list.size() - 1) continue;
                    string2 = string2.concat(this.qs.COMMA_AND_SPACE);
                }
                string2 = string2.concat(this.qs.RIGHT_BRACKET);
            }
            connection = this.getConnection();
            statement = connection.prepareStatement(string2);
            statement.setString(1, "%," + string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Long>();
                }
                arrayList.add(new Long(resultSet.getLong(1)));
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getAllDescendantsByUniqueNameKey(String uniqueNameKey)", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getAllDescendantsByUniqueNameKey(String uniqueNameKey)");
        }
        return arrayList;
    }

    public List getChildrenByUniqueNameKey(String string, List list) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getChildrenByUniqueNameKey(String uniqueNameKey)");
        }
        ArrayList<Long> arrayList = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.qs.findChildrenByUniqueNameKey;
            if (list != null && list.size() != 0) {
                string2 = string2.concat(this.qs.childrenEntityTypesIn);
                for (int i = 0; i < list.size(); ++i) {
                    string2 = string2.concat(this.qs.SINGLE_QUOTE);
                    string2 = string2.concat((String)list.get(i));
                    string2 = string2.concat(this.qs.SINGLE_QUOTE);
                    if (i == list.size() - 1) continue;
                    string2 = string2.concat(this.qs.COMMA_AND_SPACE);
                }
                string2 = string2.concat(this.qs.RIGHT_BRACKET);
            }
            connection = this.getConnection();
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Long>();
                }
                arrayList.add(new Long(resultSet.getLong(1)));
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getChildrenByUniqueNameKey(String uniqueNameKey)", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getChildrenByUniqueNameKey(String uniqueNameKey)");
        }
        return arrayList;
    }

    public List getChildrenByEntityIdList(List list, List list2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getChildrenByEntityIdList");
        }
        ArrayList<Long> arrayList = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int n;
            String string = this.qs.findChildrenByAncestorIdIn;
            if (list != null && list.size() != 0) {
                for (n = 0; n < list.size(); ++n) {
                    string = string.concat(list.get(n).toString());
                    if (n == list.size() - 1) continue;
                    string = string.concat(this.qs.COMMA_AND_SPACE);
                }
                string = string.concat(this.qs.RIGHT_BRACKET);
            }
            if (list2 != null && list2.size() != 0) {
                string = string.concat(this.qs.childrenEntityTypesIn);
                for (n = 0; n < list2.size(); ++n) {
                    string = string.concat(this.qs.SINGLE_QUOTE);
                    string = string.concat((String)list2.get(n));
                    string = string.concat(this.qs.SINGLE_QUOTE);
                    if (n == list2.size() - 1) continue;
                    string = string.concat(this.qs.COMMA_AND_SPACE);
                }
                string = string.concat(this.qs.RIGHT_BRACKET);
            }
            connection = this.getConnection();
            statement = connection.prepareStatement(string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Long>();
                }
                arrayList.add(new Long(resultSet.getLong(1)));
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getChildrenByEntityIdList", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getChildrenByEntityIdList");
        }
        return arrayList;
    }

    public List getImmediateGroupsForEntity(String string, String string2, List list) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getImmediateGroupsForEntity(long entityId, String extReposId)");
        }
        ArrayList<Long> arrayList = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string3 = null;
            if (list == null || list.size() == 0) {
                string3 = this.qs.findImmediateGroupIdsByExtIdAndReposId;
                connection = this.getConnection();
                statement = connection.prepareStatement(string3);
                statement.setString(1, DAOHelper.getTruncatedExternalId(string));
                statement.setString(2, string2);
            } else {
                String string4;
                int n;
                string3 = this.qs.findImmediateGroupIdsByExtIdAndReposIdUnderSearchBases;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (n = 0; n < list.size(); ++n) {
                    string4 = (String)list.get(n);
                    DBEntity dBEntity = this.findDBEntityByUniqueNameKey(DAOHelper.getTruncatedUniqueName(string4));
                    if (dBEntity == null) continue;
                    arrayList2.add(dBEntity.getUniqueName());
                    if (n > 0) {
                        string3 = string3 + this.qs.OR;
                    }
                    string3 = string3 + this.qs.uniqueNameEndWith;
                }
                string3 = string3 + this.qs.RIGHT_BRACKET;
                connection = this.getConnection();
                statement = connection.prepareStatement(string3);
                statement.setString(1, DAOHelper.getTruncatedExternalId(string));
                statement.setString(2, string2);
                for (n = 0; n < arrayList2.size(); ++n) {
                    string4 = (String)arrayList2.get(n);
                    statement.setString(n + 3, "%" + string4.toLowerCase());
                }
            }
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Long>();
                }
                arrayList.add(new Long(resultSet.getLong(1)));
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getImmediateGroupsForEntity(long entityId, String extReposId)", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getImmediateGroupsForEntity(long entityId, String extReposId)");
        }
        return arrayList;
    }

    public List getNestedGroupsForEntity(String string, String string2, String string3, List list, List list2) throws WIMException {
        Object object;
        Object object2;
        Object object3;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getNestedGroupsForEntity(String entityId, String extReposId, String currentReposId)");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        try {
            object3 = null;
            object3 = this.qs.findNestedGroupIdsByExtIdAndReposId;
            connection = this.getConnection();
            statement = connection.prepareStatement((String)object3);
            statement.setString(1, DAOHelper.getTruncatedExternalId(string));
            statement.setString(2, string2);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                object2 = new Long(resultSet.getLong(1));
                object = resultSet.getString(2);
                if (list2 != null && list2.size() != 0) {
                    if (this.isEntityUnderSearchBases((Long)object2, list2)) {
                        arrayList.add(object2);
                    }
                } else {
                    arrayList.add(object2);
                }
                hashMap.put(object, object2);
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getNestedGroupsForEntity(String entityId, String extReposId, String currentReposId)", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        object3 = new ArrayList();
        if (hashMap.size() != 0) {
            object2 = hashMap.keySet();
            object = object2.iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                Long l = (Long)hashMap.get(string4);
                if (list == null || list.contains(l) || object3.contains(l)) continue;
                list.add(l);
                object3.addAll(this.getNestedGroupsForEntity(string4, string3, string3, list, list2));
            }
        }
        arrayList.addAll((Collection<Object>)object3);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getNestedGroupsForEntity(String entityId, String extReposId, String currentReposId)");
        }
        return arrayList;
    }

    private boolean isEntityUnderSearchBases(long l, List list) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isEntityUnderSearchBases");
        }
        DBEntity dBEntity = this.findDBEntityByEntityId(l);
        String string = dBEntity.getUniqueName();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.toLowerCase().endsWith(list.get(i).toString().toLowerCase())) continue;
            return true;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "isEntityUnderSearchBases");
        }
        return false;
    }

    public Set[] getImmediateGroupMembers(long l, List list, List list2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getImmediateGroupMembers(long grpEntId, String returnEntType, List searchBases)");
        }
        Set[] setArray = new Set[]{new HashSet(), new HashSet()};
        String string = null;
        if (list != null && list.size() != 0) {
            string = this.qs.findImmediateGroupMemberIdsByGroupEntIdForEntityType;
            for (int i = 0; i < list.size(); ++i) {
                string = string.concat(this.qs.SINGLE_QUOTE);
                string = string.concat((String)list.get(i));
                string = string.concat(this.qs.SINGLE_QUOTE);
                string = i != list.size() - 1 ? string.concat(this.qs.COMMA_AND_SPACE) : string.concat(this.qs.RIGHT_BRACKET);
            }
            string = string.concat(this.qs.findImmediateGroupMemberIdsByGroupEntIdForEntityTypeWhere);
        } else {
            string = this.qs.findImmediateGroupMemberIdsByGroupEntId;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.log(Level.FINER, "SQL to execute: " + string);
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                DBExtIdReposId dBExtIdReposId = new DBExtIdReposId();
                dBExtIdReposId.setExtId(resultSet.getString(1));
                dBExtIdReposId.setReposId(resultSet.getString(2));
                DBEntityIdEntityType dBEntityIdEntityType = new DBEntityIdEntityType();
                long l2 = resultSet.getLong(3);
                if (l2 != 0L) {
                    dBEntityIdEntityType.setEntId(new Long(l2));
                    dBEntityIdEntityType.setEntType(resultSet.getString(4));
                    if (list2 != null && list2.size() != 0) {
                        if (!this.isEntityUnderSearchBases(l2, list2)) continue;
                        setArray[0].add(dBEntityIdEntityType);
                        continue;
                    }
                    setArray[0].add(dBEntityIdEntityType);
                    continue;
                }
                setArray[1].add(dBExtIdReposId);
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getImmediateGroupMembers(long grpEntId, String returnEntType, List searchBases)", (Throwable)sQLException);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getImmediateGroupMembers(long grpEntId, String returnEntType, List searchBases)");
        }
        return setArray;
    }

    public Set[] getNestedGroupMembers(long l, List list, List list2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getImmediateGroupMembers(long grpEntId, String returnEntType, List searchBases)");
        }
        Set[] setArray = new Set[]{new HashSet(), new HashSet()};
        this.getNestedGroupMembers(l, list, list2, new ArrayList(), setArray);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getImmediateGroupMembers(long grpEntId, String returnEntType, List searchBases)");
        }
        return setArray;
    }

    private void getNestedGroupMembers(long l, List list, List list2, List list3, Set[] setArray) throws WIMException {
        Set[] setArray2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getImmediateGroupMembers(long grpEntId, List returnEntTypes, List checkedGroups, Set[] result)");
        }
        if ((setArray2 = this.getImmediateGroupMembers(l, null, null))[1] != null && setArray2[1].size() != 0) {
            setArray[1].addAll(setArray2[1]);
        }
        if (setArray2[0] != null && setArray2[0].size() != 0) {
            for (DBEntityIdEntityType dBEntityIdEntityType : setArray2[0]) {
                Long l2;
                String string = dBEntityIdEntityType.getEntType();
                long l3 = dBEntityIdEntityType.getEntId();
                if (list != null) {
                    if (list.contains(string)) {
                        if (list2 != null && list2.size() != 0) {
                            if (this.isEntityUnderSearchBases(l3, list2)) {
                                setArray[0].add(dBEntityIdEntityType);
                            }
                        } else {
                            setArray[0].add(dBEntityIdEntityType);
                        }
                    }
                } else if (list2 != null && list2.size() != 0) {
                    if (this.isEntityUnderSearchBases(l3, list2)) {
                        setArray[0].add(dBEntityIdEntityType);
                    }
                } else {
                    setArray[0].add(dBEntityIdEntityType);
                }
                if (!string.equals("Group") || list3.contains(l2 = dBEntityIdEntityType.getEntId())) continue;
                list3.add(l2);
                this.getNestedGroupMembers(l2, list, list2, list3, setArray);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getImmediateGroupMembers(long grpEntId, List returnEntTypes, List checkedGroups, Set[] result)");
        }
    }

    public String renameEntity(long l, String string) throws WIMException {
        Object object;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "renameEntity(long entId, String newRdnValue)");
        }
        String string2 = null;
        String string3 = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            object = this.qs.findLeafEntityUniqueName;
            connection = this.getConnection();
            statement = connection.prepareStatement((String)object);
            statement.setLong(1, l);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "renameEntity(long entId, String newRdnValue)", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (string2 != null) {
            object = new Object[]{string2};
            throw new EntityHasDescendantsException("ENTITY_HAS_DESCENDENTS", CLASSNAME, "renameEntity(long entId, String newRdnValue)");
        }
        try {
            object = this.qs.findDBEntityByEntityId;
            connection = this.getConnection();
            statement = connection.prepareStatement((String)object);
            statement.setLong(1, l);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                string2 = resultSet.getString(4);
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "renameEntity(long entId, String newRdnValue)", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        int n = string2.indexOf(61);
        int n2 = string2.indexOf(44);
        String string4 = null;
        String string5 = null;
        if (n != -1) {
            string4 = string2.substring(0, n + 1);
            if (n2 != -1) {
                string5 = string2.substring(n2);
            }
        }
        if (string4 != null) {
            string3 = string4 + string;
        }
        if (string5 != null) {
            string3 = string3 + string5;
        }
        try {
            String string6 = this.qs.updateEntityUniqueName;
            connection = this.getConnection();
            statement = connection.prepareStatement(string6);
            statement.setString(1, string3);
            statement.setString(2, DAOHelper.getTruncatedUniqueName(string3));
            statement.setLong(3, l);
            statement.executeUpdate();
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new EntityAlreadyExistsException("ENTITY_ALREADY_EXIST", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, "renameEntity(long entId, String newRdnValue)");
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "renameEntity(long entId, String newRdnValue)", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "renameEntity(long entId, String newRdnValue)");
        }
        return string3;
    }

    public void updateAccount(long l, byte[] byArray, String string, String string2, String string3) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateAccount(Long entId, String loginId, String pwd, String pExtId, String reposId)");
        }
        Connection connection = null;
        Statement statement = null;
        try {
            String string4 = null;
            connection = this.getConnection();
            string4 = this.qs.updateDBAcct;
            statement = connection.prepareStatement(string4);
            if (byArray != null) {
                statement.setBytes(1, byArray);
                statement.setString(2, string);
            } else {
                statement.setNull(1, -3);
                statement.setNull(2, 12);
            }
            if (string2 != null) {
                statement.setString(3, DAOHelper.getTruncatedExternalId(string2));
                statement.setString(4, string2);
                statement.setString(5, string3);
            } else {
                statement.setNull(3, 12);
                statement.setNull(4, 12);
                statement.setNull(5, 12);
            }
            statement.setLong(6, l);
            statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "updateAccount(Long entId, String loginId, String pwd, String pExtId, String reposId)", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updateAccount(Long entId, String loginId, String pwd, String pExtId, String reposId)");
        }
    }

    public void updateProperties(short s, long l, Hashtable[] hashtableArray) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateProperties(long entId, Hashtable[] propertyToUpdate)");
        }
        Connection connection = null;
        Connection connection2 = null;
        Connection connection3 = null;
        Statement statement = null;
        Statement statement2 = null;
        Statement statement3 = null;
        for (short s2 = 0; s2 < hashtableArray.length; s2 = (short)((short)(s2 + 1))) {
            try {
                if (hashtableArray[s2] != null && hashtableArray[s2].size() != 0) {
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    Enumeration enumeration = hashtableArray[s2].keys();
                    while (enumeration.hasMoreElements()) {
                        DataObject dataObject;
                        Integer n = (Integer)enumeration.nextElement();
                        PropertyToUpdate propertyToUpdate = (PropertyToUpdate)hashtableArray[s2].get(n);
                        Object object = propertyToUpdate.getOldValue();
                        Object object2 = propertyToUpdate.getNewValue();
                        if (object != null) {
                            if (string == null) {
                                if (s2 != 6) {
                                    string = this.getUpdateStmtForPropertyValueWithOldValue(s, s2);
                                } else {
                                    string = s == 0 ? this.qs.deletePropertiesFromDBBlobProp : this.qs.deletePropertiesFromLABlobProp;
                                    string = string + this.qs.PARAM_MARKER + this.qs.RIGHT_BRACKET + this.qs.AND + this.qs.entityIDEquals;
                                    if (trcLogger.isLoggable(Level.FINE)) {
                                        trcLogger.logp(Level.FINE, CLASSNAME, "updateProperties(long entId, Hashtable[] propertyToUpdate)", "update sql is " + string);
                                    }
                                    if (string3 == null) {
                                        string3 = s == 0 ? this.qs.createDBBlobValue : this.qs.createLABlobValue;
                                    }
                                    if (connection3 == null) {
                                        connection3 = this.getConnection();
                                    }
                                    statement3 = connection3.prepareStatement(string3);
                                }
                                if (connection == null) {
                                    connection = this.getConnection();
                                }
                                statement = connection.prepareStatement(string);
                            }
                            try {
                                switch (s2) {
                                    case 0: {
                                        statement.setString(1, (String)object2);
                                        statement.setString(2, ((String)object2).toLowerCase());
                                        statement.setInt(3, n);
                                        statement.setLong(4, l);
                                        statement.setString(5, ((String)object).toLowerCase());
                                        break;
                                    }
                                    case 5: {
                                        dataObject = (DataObject)object2;
                                        statement.setString(1, DAOHelper.getTruncatedUniqueName(dataObject.getString("uniqueName")));
                                        statement.setString(2, dataObject.getString("uniqueName"));
                                        statement.setString(3, DAOHelper.getTruncatedExternalId(dataObject.getString("externalId")));
                                        statement.setString(4, dataObject.getString("externalId"));
                                        statement.setString(5, dataObject.getString("repositoryId"));
                                        statement.setInt(6, n);
                                        statement.setLong(7, l);
                                        DataObject dataObject2 = (DataObject)object;
                                        statement.setString(8, DAOHelper.getTruncatedExternalId(dataObject2.getString("externalId")));
                                        statement.setString(9, dataObject2.getString("repositoryId"));
                                        break;
                                    }
                                    case 1: {
                                        long l2 = 0L;
                                        try {
                                            l2 = (Long)object2;
                                        }
                                        catch (ClassCastException classCastException) {
                                            l2 = Long.parseLong((String)object2);
                                        }
                                        statement.setLong(1, l2);
                                        statement.setInt(2, n);
                                        statement.setLong(3, l);
                                        long l3 = 0L;
                                        try {
                                            l3 = (Long)object;
                                        }
                                        catch (ClassCastException classCastException) {
                                            l3 = Long.parseLong((String)object);
                                        }
                                        statement.setLong(4, l3);
                                        break;
                                    }
                                    case 2: {
                                        double d = 0.0;
                                        try {
                                            d = (Double)object2;
                                        }
                                        catch (ClassCastException classCastException) {
                                            d = Double.parseDouble((String)object2);
                                        }
                                        statement.setDouble(1, d);
                                        statement.setInt(2, n);
                                        statement.setLong(3, l);
                                        double d2 = 0.0;
                                        try {
                                            d2 = (Double)object;
                                        }
                                        catch (ClassCastException classCastException) {
                                            d2 = Double.parseDouble((String)object);
                                        }
                                        statement.setDouble(4, d2);
                                        break;
                                    }
                                    case 3: {
                                        int n2 = 0;
                                        try {
                                            n2 = (Integer)object2;
                                        }
                                        catch (ClassCastException classCastException) {
                                            n2 = Integer.parseInt((String)object2);
                                        }
                                        statement.setInt(1, n2);
                                        statement.setInt(2, n);
                                        statement.setLong(3, l);
                                        int n3 = 0;
                                        try {
                                            n3 = (Integer)object;
                                        }
                                        catch (ClassCastException classCastException) {
                                            n3 = Integer.parseInt((String)object);
                                        }
                                        statement.setInt(4, n3);
                                        break;
                                    }
                                    case 4: {
                                        Timestamp timestamp;
                                        Timestamp timestamp2;
                                        try {
                                            timestamp2 = (Timestamp)object2;
                                        }
                                        catch (ClassCastException classCastException) {
                                            timestamp2 = Timestamp.valueOf((String)object2);
                                        }
                                        statement.setTimestamp(1, timestamp2);
                                        statement.setInt(2, n);
                                        statement.setLong(3, l);
                                        try {
                                            timestamp = (Timestamp)object;
                                        }
                                        catch (ClassCastException classCastException) {
                                            timestamp = Timestamp.valueOf((String)object);
                                        }
                                        statement.setTimestamp(4, timestamp);
                                        break;
                                    }
                                    case 6: {
                                        statement.setInt(1, n);
                                        statement.setLong(2, l);
                                        long l4 = -1L;
                                        l4 = s == 0 ? this.keyMgr.getDBKeyForTable(connection3, "DBBLOBPROP") : this.keyMgr.getLAKeyForTable(connection3, "LABLOBPROP");
                                        statement3.setLong(1, l4);
                                        statement3.setInt(2, n);
                                        statement3.setString(3, DAOHelper.getDataType(s2));
                                        statement3.setLong(4, l);
                                        statement3.setNull(5, -5);
                                        statement3.setString(6, "");
                                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                                        objectOutputStream.writeObject(object2);
                                        objectOutputStream.close();
                                        statement3.setBytes(7, byteArrayOutputStream.toByteArray());
                                    }
                                }
                                statement.addBatch();
                                continue;
                            }
                            catch (Exception exception) {
                                throw new InvalidPropertyValueException("INVALID_PROPERTY_VALUE_FORMAT", WIMMessageHelper.generateMsgParms(n), CLASSNAME, "updateProperties(long entId, Hashtable[] propertyToUpdate)", (Throwable)exception);
                            }
                        }
                        if (string2 == null) {
                            if (s2 != 6) {
                                string2 = this.getUpdateStmtForPropertyValue(s, s2);
                            } else {
                                string2 = s == 0 ? this.qs.deletePropertiesFromDBBlobProp : this.qs.deletePropertiesFromLABlobProp;
                                string2 = string2 + this.qs.PARAM_MARKER + this.qs.RIGHT_BRACKET + this.qs.AND + this.qs.entityIDEquals;
                                if (trcLogger.isLoggable(Level.FINE)) {
                                    trcLogger.logp(Level.FINE, CLASSNAME, "updateProperties(long entId, Hashtable[] propertyToUpdate)", "update sql is " + string2);
                                }
                                if (string3 == null) {
                                    string3 = s == 0 ? this.qs.createDBBlobValue : this.qs.createLABlobValue;
                                }
                                if (connection3 == null) {
                                    connection3 = this.getConnection();
                                }
                                if (trcLogger.isLoggable(Level.FINE)) {
                                    trcLogger.logp(Level.FINE, CLASSNAME, "updateProperties(long entId, Hashtable[] propertyToUpdate)", "insert sql for Object type  is " + string3);
                                }
                                statement3 = connection3.prepareStatement(string3);
                            }
                            if (connection2 == null) {
                                connection2 = this.getConnection();
                            }
                            statement2 = connection2.prepareStatement(string2);
                        }
                        try {
                            switch (s2) {
                                case 0: {
                                    statement2.setString(1, (String)object2);
                                    statement2.setString(2, ((String)object2).toLowerCase());
                                    statement2.setInt(3, n);
                                    statement2.setLong(4, l);
                                    break;
                                }
                                case 5: {
                                    dataObject = (DataObject)object2;
                                    statement.setString(1, DAOHelper.getTruncatedUniqueName(dataObject.getString("uniqueName")));
                                    statement.setString(2, dataObject.getString("uniqueName"));
                                    statement.setString(3, DAOHelper.getTruncatedExternalId(dataObject.getString("externalId")));
                                    statement.setString(4, dataObject.getString("externalId"));
                                    statement.setString(5, dataObject.getString("repositoryId"));
                                    statement.setInt(6, n);
                                    statement.setLong(7, l);
                                    break;
                                }
                                case 1: {
                                    long l5 = 0L;
                                    try {
                                        l5 = (Long)object2;
                                    }
                                    catch (ClassCastException classCastException) {
                                        l5 = Long.parseLong((String)object2);
                                    }
                                    statement2.setLong(1, l5);
                                    statement2.setInt(2, n);
                                    statement2.setLong(3, l);
                                    break;
                                }
                                case 2: {
                                    double d = 0.0;
                                    try {
                                        d = (Double)object2;
                                    }
                                    catch (ClassCastException classCastException) {
                                        d = Double.parseDouble((String)object2);
                                    }
                                    statement2.setDouble(1, d);
                                    statement2.setInt(2, n);
                                    statement2.setLong(3, l);
                                    break;
                                }
                                case 3: {
                                    int n4 = 0;
                                    try {
                                        n4 = (Integer)object2;
                                    }
                                    catch (ClassCastException classCastException) {
                                        n4 = Integer.parseInt((String)object2);
                                    }
                                    statement2.setInt(1, n4);
                                    statement2.setInt(2, n);
                                    statement2.setLong(3, l);
                                    break;
                                }
                                case 4: {
                                    Timestamp timestamp;
                                    try {
                                        timestamp = (Timestamp)object2;
                                    }
                                    catch (ClassCastException classCastException) {
                                        timestamp = Timestamp.valueOf((String)object2);
                                    }
                                    statement2.setTimestamp(1, timestamp);
                                    statement2.setInt(2, n);
                                    statement2.setLong(3, l);
                                    break;
                                }
                                case 6: {
                                    statement2.setInt(1, n);
                                    statement2.setLong(2, l);
                                    long l6 = -1L;
                                    l6 = s == 0 ? this.keyMgr.getDBKeyForTable(connection3, "DBBLOBPROP") : this.keyMgr.getLAKeyForTable(connection3, "LABLOBPROP");
                                    statement3.setLong(1, l6);
                                    statement3.setInt(2, n);
                                    statement3.setString(3, DAOHelper.getDataType(s2));
                                    statement3.setLong(4, l);
                                    statement3.setNull(5, -5);
                                    statement3.setString(6, "");
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                                    objectOutputStream.writeObject(object2);
                                    objectOutputStream.close();
                                    statement3.setBytes(7, byteArrayOutputStream.toByteArray());
                                }
                            }
                            statement2.addBatch();
                            if (statement3 == null) continue;
                            statement3.addBatch();
                        }
                        catch (Exception exception) {
                            throw new InvalidPropertyValueException("INVALID_PROPERTY_VALUE_FORMAT", WIMMessageHelper.generateMsgParms(n), CLASSNAME, "updateProperties(long entId, Hashtable[] propertyToUpdate)", (Throwable)exception);
                        }
                    }
                }
                if (statement != null) {
                    statement.executeBatch();
                }
                if (statement2 != null) {
                    statement2.executeBatch();
                }
                if (statement3 == null) continue;
                statement3.executeBatch();
                continue;
            }
            catch (SQLException sQLException) {
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "updateProperties(long entId, Hashtable[] propertyToUpdate)", (Throwable)sQLException);
            }
            finally {
                try {
                    this.closeConnection(connection);
                    this.closeConnection(connection2);
                    this.closeConnection(connection3);
                }
                catch (Exception exception) {}
                try {
                    statement.close();
                    statement2.close();
                    statement3.close();
                }
                catch (Exception exception) {}
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updateProperties(long entId, Hashtable[] propertyToUpdate)");
        }
    }

    public void replaceProperties(short s, long l, Hashtable[] hashtableArray, Set set, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "replaceProperties(short schema, long entId, Hashtable[] propertyToReplace, Set multiValProps, String reposId)");
        }
        Connection connection = null;
        Statement statement = null;
        try {
            for (int n = 0; n < hashtableArray.length; n = (int)((short)(n + 1))) {
                int n2;
                if (hashtableArray[n] == null || hashtableArray[n].size() == 0) continue;
                String string2 = null;
                switch (n) {
                    case 0: {
                        if (s == 0) {
                            string2 = this.qs.deletePropertiesFromDBStringProp;
                            break;
                        }
                        string2 = this.qs.deletePropertiesFromLAStringProp;
                        break;
                    }
                    case 5: {
                        if (s == 0) {
                            string2 = this.qs.deletePropertiesFromDBReferenceProp;
                            break;
                        }
                        string2 = this.qs.deletePropertiesFromLAReferenceProp;
                        break;
                    }
                    case 1: {
                        if (s == 0) {
                            string2 = this.qs.deletePropertiesFromDBLongProp;
                            break;
                        }
                        string2 = this.qs.deletePropertiesFromLALongProp;
                        break;
                    }
                    case 2: {
                        if (s == 0) {
                            string2 = this.qs.deletePropertiesFromDBDoubleProp;
                            break;
                        }
                        string2 = this.qs.deletePropertiesFromLADoubleProp;
                        break;
                    }
                    case 3: {
                        if (s == 0) {
                            string2 = this.qs.deletePropertiesFromDBIntegerProp;
                            break;
                        }
                        string2 = this.qs.deletePropertiesFromLAIntegerProp;
                        break;
                    }
                    case 4: {
                        if (s == 0) {
                            string2 = this.qs.deletePropertiesFromDBTimestampProp;
                            break;
                        }
                        string2 = this.qs.deletePropertiesFromLATimestampProp;
                        break;
                    }
                    case 6: {
                        string2 = s == 0 ? this.qs.deletePropertiesFromDBBlobProp : this.qs.deletePropertiesFromLABlobProp;
                    }
                }
                for (n2 = 0; n2 < hashtableArray[n].size(); n2 = (int)((short)(n2 + 1))) {
                    string2 = string2 + this.qs.PARAM_MARKER;
                    if (n2 == hashtableArray[n].size() - 1) continue;
                    string2 = string2 + this.qs.COMMA;
                }
                string2 = string2 + this.qs.RIGHT_BRACKET;
                string2 = string2 + this.qs.AND + this.qs.entityIDEquals;
                if (connection == null) {
                    connection = this.getConnection();
                }
                n2 = 1;
                statement = connection.prepareStatement(string2);
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "replaceProperties(short schema, long entId, Hashtable[] propertyToReplace, Set multiValProps, String reposId)", "The delete sql is " + string2);
                }
                Enumeration enumeration = hashtableArray[n].keys();
                while (enumeration.hasMoreElements()) {
                    Integer n3 = (Integer)enumeration.nextElement();
                    statement.setInt(n2++, n3);
                }
                statement.setLong(n2++, l);
                statement.executeUpdate();
            }
            this.createProperties(s, l, hashtableArray, null, set, string);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "replaceProperties(short schema, long entId, Hashtable[] propertyToReplace, Set multiValProps, String reposId)", (Throwable)sQLException);
        }
        finally {
            try {
                this.closeConnection(connection);
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "replaceProperties(short schema, long entId, Hashtable[] propertyToReplace, Set multiValProps, String reposId)");
        }
    }

    public void assignMemberToGroups(DBExtIdReposId dBExtIdReposId, List list) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assignMemberToGroups(DBExtIdReposId extReposId, List groupEntIds)");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String string = this.qs.createDBGrpRelation;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(string);
            for (int i = 0; i < list.size(); ++i) {
                preparedStatement.setLong(1, (Long)list.get(i));
                preparedStatement.setString(2, dBExtIdReposId.getReposId());
                preparedStatement.setString(3, DAOHelper.getTruncatedExternalId(dBExtIdReposId.getExtId()));
                preparedStatement.setString(4, dBExtIdReposId.getExtId());
                preparedStatement.addBatch();
            }
            int[] nArray = preparedStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "assignMemberToGroups(DBExtIdReposId extReposId, List groupEntIds)", (Throwable)sQLException);
        }
        finally {
            try {
                this.closeConnection(connection);
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assignMemberToGroups(DBExtIdReposId extReposId, List groupEntIds)");
        }
    }

    public void assignMembersToGroup(List list, long l) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assignMembersToGroup(List members, long grpEntId)");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String string = this.qs.createDBGrpRelation;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(string);
            for (int i = 0; i < list.size(); ++i) {
                preparedStatement.setLong(1, l);
                preparedStatement.setString(2, ((DBExtIdReposId)list.get(i)).getReposId());
                preparedStatement.setString(3, DAOHelper.getTruncatedExternalId(((DBExtIdReposId)list.get(i)).getExtId()));
                preparedStatement.setString(4, ((DBExtIdReposId)list.get(i)).getExtId());
                try {
                    preparedStatement.executeUpdate();
                    continue;
                }
                catch (DuplicateKeyException duplicateKeyException) {
                    // empty catch block
                }
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "assignMembersToGroup(List members, long grpEntId)", (Throwable)sQLException);
        }
        finally {
            try {
                this.closeConnection(connection);
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assignMembersToGroup(List members, long grpEntId)");
        }
    }

    public void unassignMemberFromAllGroups(DBExtIdReposId dBExtIdReposId) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "unassignMemberFromAllGroups(DBExtIdReposId extReposId)");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String string = this.qs.deleteAllDBGrpRelationForMember;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, dBExtIdReposId.getReposId());
            preparedStatement.setString(2, DAOHelper.getTruncatedExternalId(dBExtIdReposId.getExtId()));
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "unassignMemberFromAllGroups(DBExtIdReposId extReposId)", (Throwable)sQLException);
        }
        finally {
            try {
                this.closeConnection(connection);
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "unassignMemberFromAllGroups(DBExtIdReposId extReposId)");
        }
    }

    public void unassignAllMembersFromGroup(long l) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "unassignAllMembersFromGroup(long grpEntId)");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String string = this.qs.deleteAllDBGrpRelationForGroup;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "unassignAllMembersFromGroup(long grpEntId)", (Throwable)sQLException);
        }
        finally {
            try {
                this.closeConnection(connection);
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "unassignAllMembersFromGroup(long grpEntId)");
        }
    }

    public void unassignMemberFromGroups(DBExtIdReposId dBExtIdReposId, List list) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "unassignMemberFromGroups(DBExtIdReposId extReposId, List groupEntIds)");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String string = this.qs.unassignGrpRelation;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(string);
            for (int i = 0; i < list.size(); ++i) {
                preparedStatement.setLong(1, (Long)list.get(i));
                preparedStatement.setString(2, dBExtIdReposId.getReposId());
                preparedStatement.setString(3, DAOHelper.getTruncatedExternalId(dBExtIdReposId.getExtId()));
                preparedStatement.addBatch();
            }
            int[] nArray = preparedStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "unassignMemberFromGroups(DBExtIdReposId extReposId, List groupEntIds)", (Throwable)sQLException);
        }
        finally {
            try {
                this.closeConnection(connection);
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "unassignMemberFromGroups(DBExtIdReposId extReposId, List groupEntIds)");
        }
    }

    public void unassignMembersFromGroup(List list, long l, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "unassignMembersFromGroup(List members, long grpEntId)");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String string2 = this.qs.unassignGrpRelation;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(string2);
            for (int i = 0; i < list.size(); ++i) {
                preparedStatement.setLong(1, l);
                preparedStatement.setString(2, ((DBExtIdReposId)list.get(i)).getReposId());
                preparedStatement.setString(3, DAOHelper.getTruncatedExternalId(((DBExtIdReposId)list.get(i)).getExtId()));
                preparedStatement.addBatch();
            }
            int[] nArray = preparedStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "unassignMembersFromGroup(List members, long grpEntId)", (Throwable)sQLException);
        }
        finally {
            try {
                this.closeConnection(connection);
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "unassignMembersFromGroup(List members, long grpEntId)");
        }
    }

    public int createLookAsidePropertyDefinition(DBRepositoryProperty dBRepositoryProperty) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createLookAsidePropertyDefinition(DBRepositoryProperty prop)");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        int n = -1;
        try {
            connection = this.getConnection();
            n = new Long(this.keyMgr.getLAKeyForTable(connection, "LAPROP")).intValue();
            preparedStatement = connection.prepareStatement(this.qs.createLAPropertyDefintion);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, dBRepositoryProperty.getName());
            preparedStatement.setString(3, dBRepositoryProperty.getDataType());
            preparedStatement.setString(4, dBRepositoryProperty.getMetadataName());
            preparedStatement.setInt(5, dBRepositoryProperty.isComposite() ? 1 : 0);
            preparedStatement.setInt(6, dBRepositoryProperty.getValueLength());
            preparedStatement.setInt(7, dBRepositoryProperty.isReadOnly() ? 1 : 0);
            preparedStatement.setInt(8, dBRepositoryProperty.isMultipleValued() ? 1 : 0);
            preparedStatement.setInt(9, dBRepositoryProperty.isCaseSensitive() ? 1 : 0);
            if (dBRepositoryProperty.getDataType().equalsIgnoreCase("OBJECT")) {
                preparedStatement.setString(10, dBRepositoryProperty.getClassName());
            } else {
                preparedStatement.setNull(10, 12);
            }
            if (dBRepositoryProperty.getDescription() != null) {
                preparedStatement.setString(11, dBRepositoryProperty.getDescription());
            } else {
                preparedStatement.setNull(11, 12);
            }
            preparedStatement.setString(12, dBRepositoryProperty.getApplicationId());
            preparedStatement.executeUpdate();
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Set set = dBRepositoryProperty.getApplicableEntityTypes();
            Set set2 = dBRepositoryProperty.getRequiredEntityTypes();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                PreparedStatement preparedStatement2 = connection.prepareStatement(this.qs.createLAPropertyEntity);
                String string = (String)iterator.next();
                preparedStatement2.setLong(1, n);
                preparedStatement2.setString(2, string);
                if (set2 != null) {
                    preparedStatement2.setInt(3, set2.contains(string) ? 1 : 0);
                } else {
                    preparedStatement2.setInt(3, 0);
                }
                preparedStatement2.executeUpdate();
                try {
                    preparedStatement2.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", CLASSNAME, "createLookAsidePropertyDefinition(DBRepositoryProperty prop)", (Throwable)namingException);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createLookAsidePropertyDefinition(DBRepositoryProperty prop)", (Throwable)sQLException);
        }
        finally {
            try {
                this.closeConnection(connection);
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createLookAsidePropertyDefinition(DBRepositoryProperty prop)");
        }
        return n;
    }

    public int createPropertyDefinition(DBRepositoryProperty dBRepositoryProperty) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createPropertyDefinition(DBRepositoryProperty prop)");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        int n = -1;
        try {
            connection = this.getConnection();
            n = new Long(this.keyMgr.getDBKeyForTable(connection, "DBPROP")).intValue();
            preparedStatement = connection.prepareStatement(this.qs.createPropertyDefintion);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, dBRepositoryProperty.getName());
            preparedStatement.setString(3, dBRepositoryProperty.getDataType());
            preparedStatement.setString(4, dBRepositoryProperty.getMetadataName());
            preparedStatement.setInt(5, dBRepositoryProperty.isComposite() ? 1 : 0);
            preparedStatement.setInt(6, dBRepositoryProperty.getValueLength());
            preparedStatement.setInt(7, dBRepositoryProperty.isReadOnly() ? 1 : 0);
            preparedStatement.setInt(8, dBRepositoryProperty.isMultipleValued() ? 1 : 0);
            preparedStatement.setInt(9, dBRepositoryProperty.isCaseSensitive() ? 1 : 0);
            if (dBRepositoryProperty.getDataType().equalsIgnoreCase("OBJECT")) {
                preparedStatement.setString(10, dBRepositoryProperty.getClassName());
            } else {
                preparedStatement.setNull(10, 12);
            }
            if (dBRepositoryProperty.getDescription() != null) {
                preparedStatement.setString(11, dBRepositoryProperty.getDescription());
            } else {
                preparedStatement.setNull(11, 12);
            }
            preparedStatement.setString(12, dBRepositoryProperty.getApplicationId());
            preparedStatement.executeUpdate();
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Set set = dBRepositoryProperty.getApplicableEntityTypes();
            Set set2 = dBRepositoryProperty.getRequiredEntityTypes();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                PreparedStatement preparedStatement2 = connection.prepareStatement(this.qs.createPropertyEntity);
                String string = (String)iterator.next();
                preparedStatement2.setLong(1, n);
                preparedStatement2.setString(2, string);
                if (set2 != null) {
                    preparedStatement2.setInt(3, set2.contains(string) ? 1 : 0);
                } else {
                    preparedStatement2.setInt(3, 0);
                }
                preparedStatement2.executeUpdate();
                try {
                    preparedStatement2.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", CLASSNAME, "createPropertyDefinition(DBRepositoryProperty prop)", (Throwable)namingException);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createPropertyDefinition(DBRepositoryProperty prop)", (Throwable)sQLException);
        }
        finally {
            try {
                this.closeConnection(connection);
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createPropertyDefinition(DBRepositoryProperty prop)");
        }
        return n;
    }

    public Map search(String string, List list, boolean bl, DataObject dataObject, String string2, int n) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "search(String searchQuery, List parameters, boolean needIdsOnly, DataObject returnRT)");
        }
        SchemaManager schemaManager = SchemaManager.singleton();
        Connection connection = null;
        Statement statement = null;
        HashMap<Long, DataObject> hashMap = new HashMap<Long, DataObject>();
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(string, 1003, 1007);
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                for (SearchParameter searchParameter : list) {
                    switch (searchParameter.dataType) {
                        case 0: {
                            statement.setString(n2, (String)searchParameter.paramValue);
                            break;
                        }
                        case 3: {
                            if (searchParameter.paramValue == null) {
                                statement.setInt(n2, searchParameter.propId);
                                break;
                            }
                            statement.setInt(n2, (Integer)searchParameter.paramValue);
                            break;
                        }
                        case 2: {
                            statement.setDouble(n2, (Double)searchParameter.paramValue);
                            break;
                        }
                        case 1: {
                            statement.setLong(n2, (Long)searchParameter.paramValue);
                            break;
                        }
                        case 4: {
                            statement.setTimestamp(n2, (Timestamp)searchParameter.paramValue);
                            break;
                        }
                        case 5: {
                            statement.setString(n2, (String)searchParameter.paramValue);
                        }
                    }
                    ++n2;
                }
            }
            ResultSet resultSet = statement.executeQuery();
            boolean bl2 = true;
            long l = -1L;
            long l2 = -1L;
            boolean bl3 = true;
            EClass eClass = null;
            List list2 = dataObject.getList("entities");
            if (bl) {
                DataObject dataObject2 = null;
                while (resultSet.next()) {
                    String string3 = resultSet.getString(4).trim();
                    eClass = SchemaManager.singleton().getEClass(string3);
                    dataObject2 = (DataObject)EcoreUtil.create((EClass)eClass);
                    DataObject dataObject3 = dataObject2.createDataObject("identifier");
                    l2 = resultSet.getLong(1);
                    String string4 = resultSet.getString(2);
                    dataObject3.setString("uniqueName", string4);
                    dataObject3.setString("externalName", string4);
                    dataObject3.setString("externalId", resultSet.getString(3));
                    dataObject3.setString("repositoryId", string2);
                    list2.add(dataObject2);
                    hashMap.put(new Long(l2), dataObject2);
                }
                if (dataObject2 != null) {
                    list2.add(dataObject2);
                    hashMap.put(new Long(l2), dataObject2);
                }
            } else {
                DataObject dataObject4 = null;
                String string5 = null;
                while (resultSet.next()) {
                    String string6;
                    int n3 = resultSet.getInt(1);
                    l2 = resultSet.getLong(3);
                    if (l2 != l) {
                        if (dataObject4 != null) {
                            list2.add(dataObject4);
                            hashMap.put(new Long(l2), dataObject4);
                        }
                        string5 = resultSet.getString(6).trim();
                        eClass = SchemaManager.singleton().getEClass(string5);
                        dataObject4 = (DataObject)EcoreUtil.create((EClass)eClass);
                        string6 = dataObject4.createDataObject("identifier");
                        String string7 = resultSet.getString(4);
                        String string8 = resultSet.getString(5);
                        string6.setString("uniqueName", string7);
                        string6.setString("externalName", string7);
                        string6.setString("uniqueId", string8);
                        string6.setString("externalId", string8);
                        string6.setString("repositoryId", string2);
                    }
                    string6 = resultSet.getString(8);
                    int n4 = resultSet.getInt(9);
                    short s = resultSet.getShort(2);
                    Property property = schemaManager.getProperty(string5, string6);
                    if (n3 != -100) {
                        if (s != 5) {
                            if (n4 == 1) {
                                dataObject4.getList(property).add(DAOHelper.getRightTypeValue(resultSet, s, n3));
                            } else {
                                dataObject4.set(property, DAOHelper.getRightTypeValue(resultSet, s, n3));
                            }
                        } else {
                            String[] stringArray = DAOHelper.getRightReferenceTypeValue(resultSet, 10, n3, n3 + 1);
                            EClass eClass2 = SchemaManager.singleton().getEClass("IdentifierType");
                            DataObject dataObject5 = (DataObject)EcoreUtil.create((EClass)eClass2);
                            dataObject5.setString("uniqueName", stringArray[0]);
                            dataObject5.setString("externalId", stringArray[1]);
                            dataObject5.setString("repositoryId", stringArray[2]);
                            if (n4 == 1) {
                                dataObject4.getList(property).add(dataObject5);
                            } else {
                                dataObject4.set(property, (Object)dataObject5);
                            }
                        }
                    }
                    l = l2;
                }
                if (dataObject4 != null) {
                    list2.add(dataObject4);
                    hashMap.put(new Long(l2), dataObject4);
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "search(String searchQuery, List parameters, boolean needIdsOnly, DataObject returnRT)", (Throwable)sQLException);
        }
        catch (IOException iOException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "search(String searchQuery, List parameters, boolean needIdsOnly, DataObject returnRT)", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "search(String searchQuery, List parameters, boolean needIdsOnly, DataObject returnRT)", (Throwable)classNotFoundException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "search(String searchQuery, List parameters, boolean needIdsOnly, DataObject returnRT)");
        }
        return hashMap;
    }

    public Map searchLA(String string, List list, boolean bl, DataObject dataObject, String string2, int n) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "searchLA(String searchQuery, List parameters, boolean needIdsOnly, DataObject returnRT, String reposId, int unionCount)", WIMTraceHelper.printObjectArray(new Object[]{string, list, bl, string2, new Integer(n)}));
        }
        SchemaManager schemaManager = SchemaManager.singleton();
        Connection connection = null;
        Statement statement = null;
        HashMap<Long, DataObject> hashMap = new HashMap<Long, DataObject>();
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(string, 1003, 1007);
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                for (SearchParameter searchParameter : list) {
                    switch (searchParameter.dataType) {
                        case 0: {
                            statement.setString(n2, (String)searchParameter.paramValue);
                            break;
                        }
                        case 3: {
                            if (searchParameter.paramValue == null) {
                                statement.setInt(n2, searchParameter.propId);
                                break;
                            }
                            statement.setInt(n2, (Integer)searchParameter.paramValue);
                            break;
                        }
                        case 2: {
                            statement.setDouble(n2, (Double)searchParameter.paramValue);
                            break;
                        }
                        case 1: {
                            statement.setLong(n2, (Long)searchParameter.paramValue);
                            break;
                        }
                        case 4: {
                            statement.setTimestamp(n2, (Timestamp)searchParameter.paramValue);
                            break;
                        }
                        case 5: {
                            statement.setString(n2, (String)searchParameter.paramValue);
                        }
                    }
                    ++n2;
                }
            }
            ResultSet resultSet = statement.executeQuery();
            boolean bl2 = true;
            long l = -1L;
            long l2 = -1L;
            boolean bl3 = true;
            EClass eClass = null;
            List list2 = dataObject.getList("entities");
            if (bl) {
                DataObject dataObject2 = null;
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1).trim();
                    eClass = SchemaManager.singleton().getEClass(string3);
                    dataObject2 = (DataObject)EcoreUtil.create((EClass)eClass);
                    DataObject dataObject3 = dataObject2.createDataObject("identifier");
                    dataObject3.setString("externalId", resultSet.getString(2));
                    dataObject3.setString("repositoryId", resultSet.getString(3).trim());
                    list2.add(dataObject2);
                }
            } else {
                DataObject dataObject4 = null;
                String string4 = null;
                while (resultSet.next()) {
                    String string5;
                    int n3 = resultSet.getInt(1);
                    l2 = resultSet.getLong(3);
                    if (l2 != l) {
                        if (dataObject4 != null) {
                            list2.add(dataObject4);
                            hashMap.put(new Long(l2), dataObject4);
                        }
                        string4 = resultSet.getString(4).trim();
                        eClass = SchemaManager.singleton().getEClass(string4);
                        dataObject4 = (DataObject)EcoreUtil.create((EClass)eClass);
                        string5 = dataObject4.createDataObject("identifier");
                        string5.setString("externalId", resultSet.getString(5));
                        string5.setString("repositoryId", resultSet.getString(6).trim());
                    }
                    string5 = resultSet.getString(8);
                    int n4 = resultSet.getInt(9);
                    short s = resultSet.getShort(2);
                    Property property = schemaManager.getProperty(string4, string5);
                    if (n3 != -100) {
                        if (s != 5) {
                            if (n4 == 1) {
                                dataObject4.getList(property).add(DAOHelper.getRightTypeValue(resultSet, s, n3));
                            } else {
                                dataObject4.set(property, DAOHelper.getRightTypeValue(resultSet, s, n3));
                            }
                        } else {
                            String[] stringArray = DAOHelper.getRightReferenceTypeValue(resultSet, 15, 17, 16);
                            EClass eClass2 = SchemaManager.singleton().getEClass("IdentifierType");
                            DataObject dataObject5 = (DataObject)EcoreUtil.create((EClass)eClass2);
                            dataObject5.setString("uniqueName", stringArray[0]);
                            dataObject5.setString("externalId", stringArray[1]);
                            dataObject5.setString("repositoryId", stringArray[2]);
                            if (n4 == 1) {
                                dataObject4.getList(property).add(dataObject5);
                            } else {
                                dataObject4.set(property, (Object)dataObject5);
                            }
                        }
                    }
                    l = l2;
                }
                if (dataObject4 != null) {
                    list2.add(dataObject4);
                    hashMap.put(new Long(l2), dataObject4);
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "searchLA(String searchQuery, List parameters, boolean needIdsOnly, DataObject returnRT, String reposId, int unionCount)", (Throwable)sQLException);
        }
        catch (IOException iOException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "searchLA(String searchQuery, List parameters, boolean needIdsOnly, DataObject returnRT, String reposId, int unionCount)", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "searchLA(String searchQuery, List parameters, boolean needIdsOnly, DataObject returnRT, String reposId, int unionCount)", (Throwable)classNotFoundException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "searchLA(String searchQuery, List parameters, boolean needIdsOnly, DataObject returnRT, String reposId, int unionCount)", WIMMessageHelper.generateMsgParms(hashMap));
        }
        return hashMap;
    }

    public void getObjectProperties(Map map, String string, String string2, boolean bl) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getObjectProperties(Map entities, String objectQuery, String entityIdsSQL, boolean dbRepos)", WIMMessageHelper.generateMsgParms(map, string, string2, bl));
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            if (map != null && string != null && string2 != null) {
                StringBuffer stringBuffer = new StringBuffer(256 + string.length() + string2.length());
                if (bl) {
                    stringBuffer.append(this.qs.getDBObjectPropertyValuesByEntityIds);
                    stringBuffer.append(string2);
                    stringBuffer.append(this.qs.RIGHT_BRACKET);
                    stringBuffer.append(this.qs.andDBObjectPropertyIdInWithLeftBracket);
                    stringBuffer.append(string);
                    stringBuffer.append(this.qs.RIGHT_BRACKET);
                } else {
                    stringBuffer.append(this.qs.getLAObjectPropertyValuesByEntityIds);
                    stringBuffer.append(string2);
                    stringBuffer.append(this.qs.RIGHT_BRACKET);
                    stringBuffer.append(this.qs.andLAObjectPropertyIdInWithLeftBracket);
                    stringBuffer.append(string);
                    stringBuffer.append(this.qs.RIGHT_BRACKET);
                }
                if (trcLogger.isLoggable(Level.FINEST)) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "getObjectProperties(Map entities, String objectQuery, String entityIdsSQL, boolean dbRepos)", stringBuffer.toString());
                }
                connection = this.getConnection();
                statement = connection.prepareStatement(stringBuffer.toString(), 1003, 1007);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    Long l = new Long(resultSet.getLong(1));
                    String string3 = resultSet.getString(2);
                    int n = resultSet.getInt(3);
                    DataObject dataObject = (DataObject)map.get(l);
                    Type type = dataObject.getType();
                    Property property = SchemaManager.singleton().getProperty(type, string3);
                    if (n == 1) {
                        dataObject.getList(property).add(DAOHelper.getRightTypeValue(resultSet, (short)6, 4));
                        continue;
                    }
                    dataObject.set(property, DAOHelper.getRightTypeValue(resultSet, (short)6, 4));
                }
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getObjectProperties(Map entities, String objectQuery, String entityIdsSQL, boolean dbRepos)", (Throwable)sQLException);
        }
        catch (IOException iOException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "getObjectProperties(Map entities, String objectQuery, String entityIdsSQL, boolean dbRepos)", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "getObjectProperties(Map entities, String objectQuery, String entityIdsSQL, boolean dbRepos)", (Throwable)classNotFoundException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getOperator(String string, short s) {
        if (string != null && string.equals("!=")) {
            return this.getQuerySet().NOT_EQUAL;
        }
        return string;
    }

    public void getCompositeProperties(Map map, String string, boolean[] blArray, String string2, boolean bl) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getCompositeProperties(Map entities, String compositeQuery, boolean[] compositeTypes, String entityIdsSQL, boolean dbRepos)", WIMMessageHelper.generateMsgParms(map, string, string2, bl));
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            if (map != null && string != null && string2 != null) {
                StringBuffer stringBuffer = new StringBuffer(256 + string.length() + string2.length());
                StringBuffer stringBuffer2 = new StringBuffer(1024);
                if (bl) {
                    stringBuffer.append(this.qs.andDBCompositePropertyIdInWithLeftBracket);
                    stringBuffer.append(string);
                    stringBuffer.append(this.qs.RIGHT_BRACKET);
                    stringBuffer.append(this.qs.andDBCompositeEntityIdInWithLeftBracket);
                    stringBuffer.append(string2);
                    stringBuffer.append(this.qs.RIGHT_BRACKET);
                    stringBuffer2.append(this.qs.findCompositePropertiesForDBEntities);
                    stringBuffer2.append(stringBuffer.toString());
                    if (blArray[0]) {
                        stringBuffer2.append(this.qs.UNION);
                        stringBuffer2.append(this.qs.findStringCompositePropertiessForDBEntities);
                        stringBuffer2.append(stringBuffer.toString());
                    }
                    if (blArray[1]) {
                        stringBuffer2.append(this.qs.UNION);
                        stringBuffer2.append(this.qs.findLongCompositePropertiessForDBEntities);
                        stringBuffer2.append(stringBuffer.toString());
                    }
                    if (blArray[2]) {
                        stringBuffer2.append(this.qs.UNION);
                        stringBuffer2.append(this.qs.findDoubleCompositePropertiessForDBEntities);
                        stringBuffer2.append(stringBuffer.toString());
                    }
                    if (blArray[3]) {
                        stringBuffer2.append(this.qs.UNION);
                        stringBuffer2.append(this.qs.findIntegerCompositePropertiessForDBEntities);
                        stringBuffer2.append(stringBuffer.toString());
                    }
                    if (blArray[4]) {
                        stringBuffer2.append(this.qs.UNION);
                        stringBuffer2.append(this.qs.findTimestampCompositePropertiessForDBEntities);
                        stringBuffer2.append(stringBuffer.toString());
                    }
                    if (blArray[5]) {
                        stringBuffer2.append(this.qs.UNION);
                        stringBuffer2.append(this.qs.findReferenceCompositePropertiessForDBEntities);
                        stringBuffer2.append(stringBuffer.toString());
                    }
                } else {
                    stringBuffer.append(this.qs.andLACompositePropertyIdInWithLeftBracket);
                    stringBuffer.append(string);
                    stringBuffer.append(this.qs.RIGHT_BRACKET);
                    stringBuffer.append(this.qs.andLACompositeEntityIdInWithLeftBracket);
                    stringBuffer.append(string2);
                    stringBuffer.append(this.qs.RIGHT_BRACKET);
                    stringBuffer2.append(this.qs.findCompositePropertiesForLAEntities);
                    stringBuffer2.append(stringBuffer.toString());
                    if (blArray[0]) {
                        stringBuffer2.append(this.qs.UNION);
                        stringBuffer2.append(this.qs.findStringCompositePropertiessForLAEntities);
                        stringBuffer2.append(stringBuffer.toString());
                    }
                    if (blArray[1]) {
                        stringBuffer2.append(this.qs.UNION);
                        stringBuffer2.append(this.qs.findLongCompositePropertiessForLAEntities);
                        stringBuffer2.append(stringBuffer.toString());
                    }
                    if (blArray[2]) {
                        stringBuffer2.append(this.qs.UNION);
                        stringBuffer2.append(this.qs.findDoubleCompositePropertiessForLAEntities);
                        stringBuffer2.append(stringBuffer.toString());
                    }
                    if (blArray[3]) {
                        stringBuffer2.append(this.qs.UNION);
                        stringBuffer2.append(this.qs.findIntegerCompositePropertiessForLAEntities);
                        stringBuffer2.append(stringBuffer.toString());
                    }
                    if (blArray[4]) {
                        stringBuffer2.append(this.qs.UNION);
                        stringBuffer2.append(this.qs.findTimestampCompositePropertiessForLAEntities);
                        stringBuffer2.append(stringBuffer.toString());
                    }
                    if (blArray[5]) {
                        stringBuffer2.append(this.qs.UNION);
                        stringBuffer2.append(this.qs.findReferenceCompositePropertiessForLAEntities);
                        stringBuffer2.append(stringBuffer.toString());
                    }
                }
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(this.qs.findCompositePropertiesOrderBy);
                }
                if (trcLogger.isLoggable(Level.FINEST)) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "getCompositeProperties(Map entities, String compositeQuery, boolean[] compositeTypes, String entityIdsSQL, boolean dbRepos)", stringBuffer2.toString());
                }
                connection = this.getConnection();
                statement = connection.prepareStatement(stringBuffer2.toString(), 1003, 1007);
                resultSet = statement.executeQuery();
                long l = -1L;
                long l2 = -1L;
                DataObject dataObject = null;
                DataObject dataObject2 = null;
                Type type = null;
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    l2 = resultSet.getLong(3);
                    if (l2 != l) {
                        dataObject = (DataObject)map.get(new Long(l2));
                    }
                    Type type2 = dataObject.getType();
                    String string3 = resultSet.getString(5);
                    String string4 = resultSet.getString(8);
                    if (n == -100) {
                        Property property = SchemaManager.singleton().getProperty(type2, string3);
                        dataObject2 = dataObject.createDataObject(property);
                        type = dataObject2.getType();
                        continue;
                    }
                    short s = resultSet.getShort(2);
                    int n2 = resultSet.getInt(9);
                    string4 = resultSet.getString(8).substring(string3.length() + 1);
                    Property property = SchemaManager.singleton().getProperty(type, string4);
                    if (s != 5) {
                        if (n2 == 1) {
                            dataObject2.getList(property).add(DAOHelper.getRightTypeValue(resultSet, s, n));
                            continue;
                        }
                        dataObject2.set(property, DAOHelper.getRightTypeValue(resultSet, s, n));
                        continue;
                    }
                    String[] stringArray = (String[])DAOHelper.getRightTypeValue(resultSet, s, n);
                    EClass eClass = SchemaManager.singleton().getEClass("IdentifierType");
                    DataObject dataObject3 = (DataObject)EcoreUtil.create((EClass)eClass);
                    dataObject3.setString("externalId", stringArray[0]);
                    dataObject3.setString("repositoryId", stringArray[1]);
                    if (n2 == 1) {
                        dataObject2.getList(property).add(dataObject3);
                        continue;
                    }
                    dataObject2.set(property, (Object)dataObject3);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getCompositeProperties(Map entities, String compositeQuery, boolean[] compositeTypes, String entityIdsSQL, boolean dbRepos)", (Throwable)sQLException);
        }
        catch (IOException iOException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "getCompositeProperties(Map entities, String compositeQuery, boolean[] compositeTypes, String entityIdsSQL, boolean dbRepos)", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WIMSystemException("GENERIC", CLASSNAME, "getCompositeProperties(Map entities, String compositeQuery, boolean[] compositeTypes, String entityIdsSQL, boolean dbRepos)", (Throwable)classNotFoundException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Loose catch block
     */
    public DBAccount getDBAccountByEntId(long l) throws WIMException {
        DBAccount dBAccount;
        block17: {
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block16: {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.entering(CLASSNAME, "getDBAccountByDBEntity(long entId)");
                }
                dBAccount = null;
                connection = null;
                statement = null;
                resultSet = null;
                String string = null;
                connection = this.getConnection();
                string = this.qs.findDBAccountByEntId;
                statement = connection.prepareStatement(string);
                statement.setLong(1, l);
                resultSet = statement.executeQuery();
                if (!resultSet.next()) break block16;
                dBAccount = new DBAccount();
                dBAccount.setEntityId(resultSet.getLong(1));
                dBAccount.setPassword(resultSet.getBytes(2));
                dBAccount.setSalt(resultSet.getString(3));
                dBAccount.setExternalId(resultSet.getString(4));
                dBAccount.setRepositoryId(resultSet.getString(5));
            }
            Object var11_7 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
                break block17;
            }
            catch (SQLException sQLException) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(sQLException.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "getDBAccountByDBEntity(long entId)", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                }
                break block17;
            }
            {
                catch (SQLException sQLException) {
                    throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getDBAccountByDBEntity(long entId)", (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                block18: {
                    Object var11_8 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (connection != null) {
                            this.closeConnection(connection);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!trcLogger.isLoggable(Level.FINE)) break block18;
                        StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                        stringBuffer.append(sQLException.toString());
                        trcLogger.logp(Level.FINE, CLASSNAME, "getDBAccountByDBEntity(long entId)", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                    }
                }
                throw throwable;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getDBAccountByDBEntity(long entId)");
        }
        return dBAccount;
    }

    public void createAccount(long l, byte[] byArray, String string, String string2, String string3) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createAccount(long entId, byte[]bytepwd, String salt, String extId, String reposId)");
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            String string4 = this.qs.createAccount;
            statement = connection.prepareStatement(string4);
            statement.setLong(1, l);
            statement.setBytes(2, byArray);
            statement.setString(3, string);
            if (string2 == null) {
                statement.setNull(4, 12);
                statement.setNull(5, 12);
                statement.setNull(6, 12);
            } else {
                statement.setString(4, DAOHelper.getTruncatedExternalId(string2));
                statement.setString(5, string2);
                statement.setString(6, string3);
            }
            statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createAccount(long entId, byte[]bytepwd, String salt, String extId, String reposId)", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                this.closeConnection(connection);
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createAccount(long entId, byte[]bytepwd, String salt, String extId, String reposId)");
        }
    }

    public long createLAEntity(LAEntity lAEntity) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createLAEntity(LAEntity newEnt)");
        }
        String string = lAEntity.getEntityType();
        String string2 = lAEntity.getExternalId();
        String string3 = lAEntity.getRepositoryId();
        Connection connection = null;
        Statement statement = null;
        long l = -1L;
        try {
            connection = this.getConnection();
            l = this.keyMgr.getLAKeyForTable(connection, "LAENTITY");
            String string4 = this.qs.createLAEntity;
            statement = connection.prepareStatement(string4);
            statement.setLong(1, l);
            statement.setString(2, string);
            statement.setString(3, DAOHelper.getTruncatedExternalId(string2));
            statement.setString(4, string2);
            statement.setString(5, string3);
            statement.executeUpdate();
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", CLASSNAME, "createLAEntity(LAEntity newEnt)", (Throwable)namingException);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createLAEntity(LAEntity newEnt)", (Throwable)sQLException);
        }
        finally {
            block14: {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    this.closeConnection(connection);
                }
                catch (Exception exception) {
                    if (!trcLogger.isLoggable(Level.FINE)) break block14;
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(exception.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "createLAEntity(LAEntity newEnt)", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(exception));
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createLAEntity(LAEntity newEnt)");
        }
        return l;
    }

    /*
     * Loose catch block
     */
    public LAEntity findLAEntityByExtIdReposId(String string, String string2) throws WIMException {
        LAEntity lAEntity;
        block17: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "findLAEntityByExtIdReposId", "extId=" + string + ", reposId=" + string2);
            }
            lAEntity = null;
            Connection connection = null;
            Statement statement = null;
            String string3 = null;
            ResultSet resultSet = null;
            string3 = this.qs.findLAEntityByExtIdReposId;
            connection = this.getConnection();
            statement = connection.prepareStatement(string3);
            statement.setString(1, DAOHelper.getTruncatedExternalId(string));
            statement.setString(2, string2.trim());
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                lAEntity = new LAEntity();
                lAEntity.setEntityId(resultSet.getLong("ENTITY_ID"));
                lAEntity.setEntityType(resultSet.getString("ENTITY_TYPE"));
                lAEntity.setExternalId(resultSet.getString("EXT_ID").trim());
                lAEntity.setRepositoryId(resultSet.getString("REPOS_ID").trim());
            }
            Object var11_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
                break block17;
            }
            catch (SQLException sQLException) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(sQLException.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "findLAEntityByExtIdReposId", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                }
                break block17;
            }
            {
                catch (SQLException sQLException) {
                    throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "findLAEntityByExtIdReposId", (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                block18: {
                    Object var11_9 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (connection != null) {
                            this.closeConnection(connection);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!trcLogger.isLoggable(Level.FINE)) break block18;
                        StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                        stringBuffer.append(sQLException.toString());
                        trcLogger.logp(Level.FINE, CLASSNAME, "findLAEntityByExtIdReposId", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                    }
                }
                throw throwable;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "findLAEntityByExtIdReposId", "anEnt=" + lAEntity);
        }
        return lAEntity;
    }

    /*
     * Loose catch block
     */
    private List getLAEntityTypesListOfExistingEntities(List list) throws WIMException {
        ArrayList<String> arrayList;
        block18: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            Connection connection;
            block17: {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.entering(CLASSNAME, "getLAEntityTypesListOfExistingEntities", "inEntTypeList=" + list);
                }
                connection = null;
                preparedStatement = null;
                String string = null;
                resultSet = null;
                connection = this.getConnection();
                arrayList = null;
                string = this.qs.getLAEntitypesForExisting;
                preparedStatement = connection.prepareStatement(string);
                resultSet = preparedStatement.executeQuery();
                arrayList = new ArrayList<String>();
                while (resultSet.next()) {
                    String string2 = resultSet.getString("ENTITY_TYPE");
                    arrayList.add(string2);
                }
                if (list == null || list.size() <= 0 || arrayList.size() <= 0) break block17;
                arrayList.retainAll(list);
            }
            Object var10_9 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
                break block18;
            }
            catch (SQLException sQLException) {
                if (trcLogger.isLoggable(Level.FINE) && trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "getLAEntityTypesListOfExistingEntities", "Unexpected error when closing the prepared statement or the connection : ", sQLException);
                }
                break block18;
            }
            {
                catch (SQLException sQLException) {
                    throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getLAEntityTypesListOfExistingEntities", (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Object var10_10 = null;
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (connection != null) {
                            this.closeConnection(connection);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!trcLogger.isLoggable(Level.FINE) || !trcLogger.isLoggable(Level.FINE)) break block19;
                        trcLogger.logp(Level.FINE, CLASSNAME, "getLAEntityTypesListOfExistingEntities", "Unexpected error when closing the prepared statement or the connection : ", sQLException);
                    }
                }
                throw throwable;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getLAEntityTypesListOfExistingEntities", "laEntTypeList=" + arrayList);
        }
        return arrayList;
    }

    private Map getLAPropertyAttributes(String string, List list) throws WIMException {
        HashMap<String, Object> hashMap;
        block18: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "getLAPropertyAttributes", "inPropName=" + string + ", laEntTypeList=" + list);
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            Integer n = null;
            String string2 = null;
            String string3 = null;
            hashMap = null;
            StringBuffer stringBuffer = new StringBuffer(this.qs.getLAPropAttributeForEntitype);
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append(this.qs.PARAM_MARKER);
                if (i == list.size() - 1) continue;
                stringBuffer.append(this.qs.COMMA);
            }
            stringBuffer.append(this.qs.RIGHT_BRACKET);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "getLAPropertyAttributes", "queryStmt=" + stringBuffer);
            }
            Connection connection = this.getConnection();
            try {
                int n2 = 1;
                preparedStatement = connection.prepareStatement(stringBuffer.toString());
                preparedStatement.setString(n2++, string);
                for (int i = 0; i < list.size(); ++i) {
                    String string4 = (String)list.get(i);
                    preparedStatement.setString(n2++, string4);
                }
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt("PROP_ID");
                    string2 = resultSet.getString("TYPE_ID").trim();
                    string3 = DAOHelper.getValueTableName((short)1, DAOHelper.getDataTypeId(string2));
                    hashMap = new HashMap<String, Object>();
                    hashMap.put("name", string);
                    hashMap.put("PROP_ID", n);
                    hashMap.put("TYPE_ID", string2);
                    hashMap.put("TABLE_NAME", string3);
                    break block18;
                }
                throw new InvalidPropertyDefinitionException("EXTENDED_PROPERTY_NOT_DEFINED_FOR_ENTITY_TYPES", WIMMessageHelper.generateMsgParms(string, list.toString()), CLASSNAME, "getLAPropertyAttributes");
            }
            catch (SQLException sQLException) {
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getLAPropertyAttributes", (Throwable)sQLException);
            }
            finally {
                block19: {
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (connection != null) {
                            this.closeConnection(connection);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!trcLogger.isLoggable(Level.FINE)) break block19;
                        trcLogger.logp(Level.FINE, CLASSNAME, "getLAPropertyAttributes", "Unexpected error when closing the prepared statement or the connection : ", sQLException);
                    }
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getLAPropertyAttributes", "laPropertyAttributes=" + hashMap);
        }
        return hashMap;
    }

    /*
     * Unable to fully structure code
     */
    private void deleteLAPropertiesDataForEntTypes(Map var1_1, List var2_2) throws WIMException {
        block39: {
            block38: {
                if (AbstractDAO.trcLogger.isLoggable(Level.FINER)) {
                    AbstractDAO.trcLogger.entering(AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes", "laPropertyAttributes=" + var1_1 + ", laEntTypeList=" + var2_2);
                }
                var4_3 = null;
                var5_4 = 0;
                var6_5 = null;
                var7_6 = (Integer)var1_1.get("PROP_ID");
                var8_7 = (String)var1_1.get("TABLE_NAME");
                var9_8 = (String)var1_1.get("name");
                var10_9 = new ArrayList<Long>();
                var11_10 = new ArrayList<String>();
                var12_11 = new ArrayList<String>();
                var13_12 = new StringBuffer(this.qs.getLAEntIdsByPropIdAndEntTypes + var8_7);
                var13_12.append(this.qs.getLAEntIdsWhereClause);
                for (var14_13 = 0; var14_13 < var2_2.size(); ++var14_13) {
                    var13_12.append(this.qs.PARAM_MARKER);
                    if (var14_13 == var2_2.size() - 1) continue;
                    var13_12.append(this.qs.COMMA);
                }
                var13_12.append(this.qs.RIGHT_BRACKET);
                if (AbstractDAO.trcLogger.isLoggable(Level.FINER)) {
                    AbstractDAO.trcLogger.logp(Level.FINER, AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes", "queryStmt=" + var13_12);
                }
                var14_14 = this.getConnection();
                var15_15 = 1;
                var4_3 = var14_14.prepareStatement(var13_12.toString());
                var4_3.setInt(var15_15++, var7_6);
                for (var16_19 = 0; var16_19 < var2_2.size(); ++var16_19) {
                    var17_22 = (String)var2_2.get(var16_19);
                    var4_3.setString(var15_15++, var17_22);
                }
                var6_5 = var4_3.executeQuery();
                while (var6_5.next()) {
                    var16_20 = var6_5.getLong("ENTITY_ID");
                    var17_22 = var6_5.getString("FULL_EXT_ID");
                    var18_24 = var6_5.getString("REPOS_ID");
                    var10_9.add(var16_20);
                    var11_10.add(var17_22);
                    var12_11.add((String)var18_24);
                }
                if (!AbstractDAO.trcLogger.isLoggable(Level.FINER)) break block38;
                AbstractDAO.trcLogger.logp(Level.FINER, AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes", "delLAEidList=" + var10_9);
                AbstractDAO.trcLogger.logp(Level.FINER, AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes", "delrepoEidList=" + var11_10);
                AbstractDAO.trcLogger.logp(Level.FINER, AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes", "delrepoIdList=" + var12_11);
            }
            var20_25 = null;
            try {
                if (var4_3 != null) {
                    var4_3.close();
                }
                if (var14_14 != null) {
                    this.closeConnection(var14_14);
                    var14_14 = null;
                }
                if (var6_5 != null) {
                    var6_5.close();
                    var6_5 = null;
                }
                break block39;
            }
            catch (SQLException var21_27) {
                if (AbstractDAO.trcLogger.isLoggable(Level.FINE)) {
                    AbstractDAO.trcLogger.logp(Level.FINE, AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes", "Unexpected error when closing the prepared statement or the connection : ", var21_27);
                }
                break block39;
            }
            {
                catch (SQLException var15_16) {
                    throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(var15_16.getMessage()), AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes", (Throwable)var15_16);
                }
            }
            catch (Throwable var19_29) {
                block40: {
                    var20_26 = null;
                    try {
                        if (var4_3 != null) {
                            var4_3.close();
                        }
                        if (var14_14 != null) {
                            this.closeConnection(var14_14);
                            var14_14 = null;
                        }
                        if (var6_5 != null) {
                            var6_5.close();
                            var6_5 = null;
                        }
                    }
                    catch (SQLException var21_28) {
                        if (!AbstractDAO.trcLogger.isLoggable(Level.FINE)) break block40;
                        AbstractDAO.trcLogger.logp(Level.FINE, AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes", "Unexpected error when closing the prepared statement or the connection : ", var21_28);
                    }
                }
                throw var19_29;
            }
        }
        if (var10_9.size() > 0) {
            if (var14_14 == null) {
                var14_14 = this.getConnection();
            }
            try {
                var15_15 = 1;
                var16_21 = new StringBuffer(this.qs.deleteEntityDataFromLAPropValueTable + var8_7 + this.qs.whereINEIdsClause);
                for (var17_23 = 0; var17_23 < var10_9.size(); ++var17_23) {
                    var16_21.append(this.qs.PARAM_MARKER);
                    if (var17_23 == var10_9.size() - 1) continue;
                    var16_21.append(this.qs.COMMA);
                }
                var16_21.append(this.qs.RIGHT_BRACKET);
                var16_21.append(this.qs.andPropIDEqualTo);
                if (AbstractDAO.trcLogger.isLoggable(Level.FINER)) {
                    AbstractDAO.trcLogger.logp(Level.FINER, AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes", "deleteStmt=" + var16_21);
                }
                var4_3 = var14_14.prepareStatement(var16_21.toString());
                for (var17_23 = 0; var17_23 < var10_9.size(); ++var17_23) {
                    var18_24 = (Long)var10_9.get(var17_23);
                    var4_3.setLong(var15_15++, var18_24.longValue());
                }
                var4_3.setInt(var15_15++, var7_6);
                var5_4 = var4_3.executeUpdate();
                if (var5_4 <= 0 || !AbstractDAO.trcLogger.isLoggable(Level.FINE)) ** GOTO lbl136
                AbstractDAO.trcLogger.logp(Level.FINE, AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes", "Deleted extended property " + var9_8 + " data for entities with LA entity ids as : " + var10_9 + " repository entity unique ids as : " + var11_10 + " and Repository ids as : " + var12_11);
            }
            catch (SQLException var15_18) {
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(var15_18.getMessage()), AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes", (Throwable)var15_18);
            }
            finally {
                block41: {
                    try {
                        if (var4_3 != null) {
                            var4_3.close();
                        }
                        if (var14_14 != null) {
                            this.closeConnection(var14_14);
                        }
                    }
                    catch (SQLException var23_31) {
                        if (!AbstractDAO.trcLogger.isLoggable(Level.FINE)) break block41;
                        AbstractDAO.trcLogger.logp(Level.FINE, AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes", "Unexpected error when closing the prepared statement or the connection : ", var23_31);
                    }
                }
            }
        } else if (AbstractDAO.trcLogger.isLoggable(Level.FINER)) {
            AbstractDAO.trcLogger.logp(Level.FINER, AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes", "No data found in LA for property : " + var9_8 + " with applicable any entity types as : " + var2_2);
        }
lbl136:
        // 5 sources

        if (AbstractDAO.trcLogger.isLoggable(Level.FINER)) {
            AbstractDAO.trcLogger.exiting(AbstractDAO.CLASSNAME, "deleteLAPropertiesDataForEntTypes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEntIdsFromLAIfNoEntityPropDataExists() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "deleteEntIdsFromLAIfNoEntityPropDataExists");
        }
        Connection connection = null;
        Statement statement = null;
        String string = null;
        String string2 = null;
        connection = this.getConnection();
        int n = 0;
        ResultSet resultSet = null;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        try {
            string = this.qs.getEidsForLACleanup;
            statement = connection.prepareStatement(string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Long l = resultSet.getLong("ENTITY_ID");
                String string3 = resultSet.getString("FULL_EXT_ID");
                String string4 = resultSet.getString("REPOS_ID");
                arrayList.add(l);
                arrayList2.add(string3);
                arrayList3.add(string4.trim());
            }
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "deleteEntIdsFromLAIfNoEntityPropDataExists", "delLAEidList=" + arrayList);
                trcLogger.logp(Level.FINER, CLASSNAME, "deleteEntIdsFromLAIfNoEntityPropDataExists", "delrepoEidList=" + arrayList2);
                trcLogger.logp(Level.FINER, CLASSNAME, "deleteEntIdsFromLAIfNoEntityPropDataExists", "delrepoIdList=" + arrayList3);
            }
        }
        catch (SQLException sQLException) {
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.logp(Level.FINE, CLASSNAME, "deleteEntIdsFromLAIfNoEntityPropDataExists", "Unexpected error when deleting the entities from LA as a part of extended property data cleanup operation : ", sQLException);
            }
        }
        finally {
            block35: {
                try {
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                    if (connection != null) {
                        this.closeConnection(connection);
                        connection = null;
                    }
                }
                catch (SQLException sQLException) {
                    if (!trcLogger.isLoggable(Level.FINE)) break block35;
                    trcLogger.logp(Level.FINE, CLASSNAME, "deleteEntIdsFromLAIfNoEntityPropDataExists", "Unexpected error when closing the prepared statement or the connection : ", sQLException);
                }
            }
        }
        if (arrayList.size() > 0) {
            trcLogger.logp(Level.FINE, CLASSNAME, "deleteEntIdsFromLAIfNoEntityPropDataExists", "No more extended property data associated with LA entities " + arrayList + " with repository entity id as " + arrayList2 + " and repository id as " + arrayList3);
            connection = this.getConnection();
            try {
                string2 = this.qs.deleteEntityFromLAIfNoPropValueIsAssociateWith;
                statement = connection.prepareStatement(string2);
                n = statement.executeUpdate();
                if (n > 0) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "deleteEntIdsFromLAIfNoEntityPropDataExists", "Successfully deleted the entities " + arrayList2 + " located in LA with ids " + arrayList3);
                }
            }
            catch (SQLException sQLException) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "deleteEntIdsFromLAIfNoEntityPropDataExists", "Unexpected error when deleting the entities from LA as a part of extended property data cleanup operation : ", sQLException);
                }
            }
            finally {
                block37: {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            this.closeConnection(connection);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!trcLogger.isLoggable(Level.FINE)) break block37;
                        trcLogger.logp(Level.FINE, CLASSNAME, "deleteEntIdsFromLAIfNoEntityPropDataExists", "Unexpected error when closing the prepared statement or the connection : ", sQLException);
                    }
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "deleteEntIdsFromLAIfNoEntityPropDataExists");
        }
    }

    public void deleteLAPropertyDataForEntityTypes(String string, List list) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "deleteLAPropertyDataForEntityTypes", "input property name = " + string + ", input applicable entity type list = " + list);
        }
        if (!(this.databaseType.equals("derby") || this.dsLookup() != null || this.dbUserId != null && this.dbUserId.length() != 0 && this.dbPassword != null && this.dbPassword.length() != 0)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "deleteLAPropertyDataForEntityTypes", "Invalid db user id or password. Empty or null user id and password are not supported for DB of type " + this.databaseType);
            throw new WIMConfigurationException("INVALID_DB_CREDENTIALS", CLASSNAME, "deleteLAPropertyDataForEntityTypes");
        }
        List list2 = null;
        list2 = this.getLAEntityTypesListOfExistingEntities(list);
        if (list2 != null && list2.size() > 0) {
            Map map = this.getLAPropertyAttributes(string, list2);
            this.deleteLAPropertiesDataForEntTypes(map, list2);
            this.deleteEntIdsFromLAIfNoEntityPropDataExists();
        } else if (trcLogger.isLoggable(Level.FINER)) {
            if (list.size() == 0) {
                trcLogger.logp(Level.FINER, CLASSNAME, "deleteLAPropertyDataForEntityTypes", "No property extension(LA) entity found for any supported entity types ");
            } else {
                trcLogger.logp(Level.FINER, CLASSNAME, "deleteLAPropertyDataForEntityTypes", "No property extension(LA) entity found for entity types " + list);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "deleteLAPropertyDataForEntityTypes");
        }
    }

    public void deleteLAEntity(String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "deleteLAEntity", "extId=" + string + ", reposId=" + string2);
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.qs.deleteLAEntity);
            statement.setString(1, string);
            statement.setString(2, string2);
            int n = statement.executeUpdate();
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "deleteLAEntity", "deleted=" + n);
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "deleteLAEntity", (Throwable)sQLException);
        }
        finally {
            block15: {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        this.closeConnection(connection);
                    }
                }
                catch (SQLException sQLException) {
                    if (!trcLogger.isLoggable(Level.FINE)) break block15;
                    trcLogger.logp(Level.FINE, CLASSNAME, "deleteLAEntity", "Unexpected error when closing the prepared statement or the connection : ", sQLException);
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "deleteLAEntity");
        }
    }

    public void createNewPropertyEntityRelationInDB(String string, String string2, DBPropertyCache dBPropertyCache) throws WIMException {
        Set set;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createNewPropertyEntityRelationInDB(String newEntName, String parentEntName, DBPropertyCache cache)");
        }
        if ((set = dBPropertyCache.getSupportedAttributes(string2)) != null) {
            Iterator iterator = set.iterator();
            String string3 = this.qs.createDBPropertyEntity;
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(string3);
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    DBRepositoryProperty dBRepositoryProperty = dBPropertyCache.getPropertyDefinition(string4);
                    preparedStatement.setInt(1, dBRepositoryProperty.getPropId());
                    preparedStatement.setString(2, string);
                    if (dBRepositoryProperty.getRequiredEntityTypes().contains(string2)) {
                        preparedStatement.setInt(3, 1);
                    } else {
                        preparedStatement.setInt(3, 0);
                    }
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
            }
            catch (SQLException sQLException) {
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createNewPropertyEntityRelationInDB(String newEntName, String parentEntName, DBPropertyCache cache)", (Throwable)sQLException);
            }
            finally {
                try {
                    this.closeConnection(connection);
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createNewPropertyEntityRelationInDB(String newEntName, String parentEntName, DBPropertyCache cache)");
        }
    }

    public void createNewPropertyEntityRelationInLA(String string, String string2, LAPropertyCache lAPropertyCache) throws WIMException {
        Set set;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createNewPropertyEntityRelationInLA(String newEntName, String parentEntName, LAPropertyCache cache)");
        }
        if ((set = lAPropertyCache.getSupportedAttributes(string2)) != null) {
            Iterator iterator = set.iterator();
            String string3 = this.qs.createLAPropertyEntity;
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(string3);
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    DBRepositoryProperty dBRepositoryProperty = lAPropertyCache.getPropertyDefinition(string4);
                    preparedStatement.setInt(1, dBRepositoryProperty.getPropId());
                    preparedStatement.setString(2, string);
                    if (dBRepositoryProperty.getRequiredEntityTypes().contains(string2)) {
                        preparedStatement.setInt(3, 1);
                    } else {
                        preparedStatement.setInt(3, 0);
                    }
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
            }
            catch (SQLException sQLException) {
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createNewPropertyEntityRelationInLA(String newEntName, String parentEntName, LAPropertyCache cache)", (Throwable)sQLException);
            }
            finally {
                try {
                    this.closeConnection(connection);
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createNewPropertyEntityRelationInLA(String newEntName, String parentEntName, LAPropertyCache cache)");
        }
    }

    protected KeyManager getKeyManager() {
        return this.keyMgr;
    }

    public boolean isMemberInGroup(long l, String string, String string2, String string3, int n) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isMemberInGroup(long grpId, String mbrExtId, String reposId, String dbReposId, int level)");
        }
        boolean bl = false;
        Connection connection = null;
        Statement statement = null;
        String string4 = null;
        ResultSet resultSet = null;
        try {
            if (n == 1) {
                string4 = this.qs.isMemberinImmediateGroup;
                connection = this.getConnection();
                statement = connection.prepareStatement(string4);
                statement.setLong(1, l);
                statement.setString(2, DAOHelper.getTruncatedExternalId(string));
                statement.setString(3, string2);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    bl = true;
                }
            } else {
                List list = this.getNestedGroupsForEntity(string, string2, string3, new ArrayList(), null);
                if (list.contains(new Long(l))) {
                    bl = true;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "isMemberInGroup(long grpId, String mbrExtId, String reposId, String dbReposId, int level)", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "isMemberInGroup(long grpId, String mbrExtId, String reposId, String dbReposId, int level)");
        }
        return bl;
    }

    public void deleteProperties(short s, long l, Hashtable[] hashtableArray, Set set, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "deleteProperties(short schema, long entId, Hashtable[] propertyToDelete, Set multiValProps, String reposId)");
        }
        Connection connection = null;
        Statement statement = null;
        try {
            for (int n = 0; n < hashtableArray.length; n = (int)((short)(n + 1))) {
                int n2;
                if (hashtableArray[n] == null || hashtableArray[n].size() == 0) continue;
                String string2 = null;
                switch (n) {
                    case 0: {
                        if (s == 0) {
                            string2 = this.qs.deletePropertiesFromDBStringProp;
                            break;
                        }
                        string2 = this.qs.deletePropertiesFromLAStringProp;
                        break;
                    }
                    case 5: {
                        if (s == 0) {
                            string2 = this.qs.deletePropertiesFromDBReferenceProp;
                            break;
                        }
                        string2 = this.qs.deletePropertiesFromLAReferenceProp;
                        break;
                    }
                    case 1: {
                        if (s == 0) {
                            string2 = this.qs.deletePropertiesFromDBLongProp;
                            break;
                        }
                        string2 = this.qs.deletePropertiesFromLALongProp;
                        break;
                    }
                    case 2: {
                        if (s == 0) {
                            string2 = this.qs.deletePropertiesFromDBDoubleProp;
                            break;
                        }
                        string2 = this.qs.deletePropertiesFromLADoubleProp;
                        break;
                    }
                    case 3: {
                        if (s == 0) {
                            string2 = this.qs.deletePropertiesFromDBIntegerProp;
                            break;
                        }
                        string2 = this.qs.deletePropertiesFromLAIntegerProp;
                        break;
                    }
                    case 4: {
                        if (s == 0) {
                            string2 = this.qs.deletePropertiesFromDBTimestampProp;
                            break;
                        }
                        string2 = this.qs.deletePropertiesFromLATimestampProp;
                        break;
                    }
                    case 6: {
                        string2 = s == 0 ? this.qs.deletePropertiesFromDBBlobProp : this.qs.deletePropertiesFromLABlobProp;
                    }
                }
                for (n2 = 0; n2 < hashtableArray[n].size(); n2 = (int)((short)(n2 + 1))) {
                    string2 = string2 + this.qs.PARAM_MARKER;
                    if (n2 == hashtableArray[n].size() - 1) continue;
                    string2 = string2 + this.qs.COMMA;
                }
                string2 = string2 + this.qs.RIGHT_BRACKET;
                string2 = string2 + this.qs.AND + this.qs.entityIDEquals;
                if (connection == null) {
                    connection = this.getConnection();
                }
                n2 = 1;
                statement = connection.prepareStatement(string2);
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "deleteProperties(short schema, long entId, Hashtable[] propertyToDelete, Set multiValProps, String reposId)", "The delete sql is " + string2);
                }
                Enumeration enumeration = hashtableArray[n].keys();
                while (enumeration.hasMoreElements()) {
                    Integer n3 = (Integer)enumeration.nextElement();
                    statement.setInt(n2++, n3);
                }
                statement.setLong(n2++, l);
                statement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "deleteProperties(short schema, long entId, Hashtable[] propertyToDelete, Set multiValProps, String reposId)", (Throwable)sQLException);
        }
        finally {
            try {
                this.closeConnection(connection);
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "deleteProperties(short schema, long entId, Hashtable[] propertyToDelete, Set multiValProps, String reposId)");
        }
    }
}

