/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dao;

import com.ibm.websphere.wim.exception.DatabaseTypeNotSupportedException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.dao.DataAccessObject;
import com.ibm.ws.wim.dao.QuerySet;
import com.ibm.ws.wim.dao.db2.DB2DAO;
import com.ibm.ws.wim.dao.db2.DB2QuerySet;
import com.ibm.ws.wim.dao.db2iseries.DB2iSeriesDAO;
import com.ibm.ws.wim.dao.db2iseries.DB2iSeriesQuerySet;
import com.ibm.ws.wim.dao.db2zos.DB2ZOSDAO;
import com.ibm.ws.wim.dao.db2zos.DB2ZOSQuerySet;
import com.ibm.ws.wim.dao.derby.DerbyDAO;
import com.ibm.ws.wim.dao.derby.DerbyQuerySet;
import com.ibm.ws.wim.dao.informix.InformixDAO;
import com.ibm.ws.wim.dao.informix.InformixQuerySet;
import com.ibm.ws.wim.dao.oracle.OracleDAO;
import com.ibm.ws.wim.dao.oracle.OracleQuerySet;
import com.ibm.ws.wim.dao.schema.DBDataType;
import com.ibm.ws.wim.dao.schema.DBRepositoryProperty;
import com.ibm.ws.wim.dao.sqlserver.SQLServerDAO;
import com.ibm.ws.wim.dao.sqlserver.SQLServerQuerySet;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import commonj.sdo.DataObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DAOHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    private static final String CLASSNAME = DAOHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    public static final short DB_SCHEMA = 0;
    public static final short LA_SCHEMA = 1;
    public static final short FED_SCHEMA = 2;
    private static final String DB2_DAO_CLASSNAME = "com.ibm.ws.wim.dao.db2.DB2DAO";
    private static final String ORACLE_DAO_CLASSNAME = "com.ibm.ws.wim.dao.oracle.OracleDAO";
    private static final String SQLSERVER_DAO_CLASSNAME = "com.ibm.ws.wim.dao.sqlserver.SqlServerDAO";
    private static final String INFORMIX_DAO_CLASSNAME = "com.ibm.ws.wim.dao.informix.InformixDAO";
    private static final String CLOUDSCAPE_DAO_CLASSNAME = "com.ibm.ws.wim.dao.cloudscape.CloudscapeDAO";
    private static final String DB2_ISERIES_DAO_CLASSNAME = "com.ibm.ws.wim.dao.db2iseries.DB2iSeriesDAO";
    private static final String DB2_ZOS_DAO_CLASSNAME = "com.ibm.ws.wim.dao.db2zos.DB2zOSDAO";
    public static final short DATATYPE_ID_STRING = 0;
    public static final short DATATYPE_ID_LONG = 1;
    public static final short DATATYPE_ID_DOUBLE = 2;
    public static final short DATATYPE_ID_INTEGER = 3;
    public static final short DATATYPE_ID_TIMESTAMP = 4;
    public static final short DATATYPE_ID_IDENTIFIER = 5;
    public static final short DATATYPE_ID_OBJECT = 6;
    public static final String[] types = new String[]{"STRING", "LONG", "DOUBLE", "INTEGER", "TIMESTAMP", "IDENTIFIER", "OBJECT"};
    public static final String DBTYPE_DB2 = "db2";
    public static final String DBTYPE_ORACLE = "oracle";
    public static final String DBTYPE_SQLSERVER = "sqlserver";
    public static final String DBTYPE_INFORMIX = "informix";
    public static final String DBTYPE_DERBY = "derby";
    public static final String DBTYPE_DB2ISERIES = "db2iseries";
    public static final String DBTYPE_DB2ZOS = "db2zos";
    public static final String DB_ENTITY = "DBENTITY";
    public static final String DB_PROPERTY_TYPE = "DBPROPTYPE";
    public static final String DB_PROPERTY = "DBPROP";
    public static final String DB_PROPERTY_ENTITY = "DBPROPENT";
    public static final String DB_PROPERTY_LONG_VALUE = "DBLONGPROP";
    public static final String DB_PROPERTY_BLOB_VALUE = "DBBLOBPROP";
    public static final String DB_PROPERTY_DOUBLE_VALUE = "DBDBLPROP";
    public static final String DB_PROPERTY_INTEGER_VALUE = "DBINTPROP";
    public static final String DB_PROPERTY_REFERENCE_VALUE = "DBREFPROP";
    public static final String DB_PROPERTY_STRING_VALUE = "DBSTRPROP";
    public static final String DB_PROPERTY_TIMESTAMP_VALUE = "DBTSPROP";
    public static final String DB_COMPOSITE_RELATION = "DBCOMPREL";
    public static final String DB_COMPOSITE_PROPERTY_VALUE = "DBCOMPPROP";
    public static final String DB_ENTITY_RELATION = "DBENTREL";
    public static final String DB_KEYS = "DBKEYS";
    public static final String DB_GROUP_RELATION = "DBGRPREL";
    public static final String DB_ACCOUNT = "DBACCT";
    public static final String LA_ENTITY = "LAENTITY";
    public static final String LA_ENTITY_EXT_ID = "LAEXTID";
    public static final String LA_KEYS = "LAKEYS";
    public static final String LA_PROPERTY = "LAPROP";
    public static final String LA_PROPERTY_TYPE = "LAPROPTYPE";
    public static final String LA_PROPERTY_ENTITY = "LAPROPENT";
    public static final String LA_PROPERTY_LONG_VALUE = "LALONGPROP";
    public static final String LA_PROPERTY_BLOB_VALUE = "LABLOBPROP";
    public static final String LA_PROPERTY_DOUBLE_VALUE = "LADBLPROP";
    public static final String LA_PROPERTY_INTEGER_VALUE = "LAINTPROP";
    public static final String LA_PROPERTY_REFERENCE_VALUE = "LAREFPROP";
    public static final String LA_PROPERTY_STRING_VALUE = "LASTRPROP";
    public static final String LA_PROPERTY_TIMESTAMP_VALUE = "LATSPROP";
    public static final String LA_COMPOSITE_RELATION = "LACOMPREL";
    public static final String LA_COMPOSITE_PROPERTY_VALUE = "LACOMPPROP";
    public static final String COL_PROP_ID = "PROP_ID";
    public static final String COL_TYPE_ID = "TYPE_ID";
    public static final String COL_ENTITY_ID = "ENTITY_ID";
    public static final String COL_ENTITY_TYPE = "ENTITY_TYPE";
    public static final String COL_EXT_ID = "EXT_ID";
    public static final String COL_FULL_EXT_ID = "FULL_EXT_ID";
    public static final String COL_REPOS_ID = "REPOS_ID";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final int GET_PROP_QUERY_LENGTH = 256;
    public static final int GET_ENTITY_QUERY_LENGTH = 256;
    public static final int PROP_ID_LENGTH = 8;
    public static final int DEFAULT_VALUE_INDEX = -100;
    public static final String COMPOSITE_COMPONENT_SEPERATOR = "/";
    public static final int LONG_QUERY_LENGTH = 1024;
    public static final String OPERATOR_NOT_EQUAL = "!=";
    public static final String OPERATOR_EQUAL = "=";
    public static final String FED_ENTITY = "FEDENTITY";
    public static final int UNIQUE_NAME_KEY_LENGTH = 236;
    public static final int TRUNC_EXT_ID_LENGTH = 200;
    public static final String COMMA = ",";
    public static final String WASVAR_JDBC_CLASSPATH = "VMM_JDBC_CLASSPATH";
    private static ConcurrentHashMap dbClassMap = new ConcurrentHashMap();

    public static DataAccessObject getNewDAOClass(String string, String string2, String string3, String string4, String string5, String string6) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getNewDAOClass(String dbType, String datasourceName, String dbURL, String dbUserId, String dbPwd, String dbDriver)");
        }
        Object var7_6 = null;
        if (string.equalsIgnoreCase(DBTYPE_DB2)) {
            return new DB2DAO(string2, string3, string4, string5, string6);
        }
        if (string.equalsIgnoreCase(DBTYPE_ORACLE)) {
            return new OracleDAO(string2, string3, string4, string5, string6);
        }
        if (string.equalsIgnoreCase(DBTYPE_SQLSERVER)) {
            return new SQLServerDAO(string2, string3, string4, string5, string6);
        }
        if (string.equalsIgnoreCase(DBTYPE_INFORMIX)) {
            return new InformixDAO(string2, string3, string4, string5, string6);
        }
        if (string.equalsIgnoreCase(DBTYPE_DERBY)) {
            return new DerbyDAO(string2, string3, string4, string5, string6);
        }
        if (string.equalsIgnoreCase(DBTYPE_DB2ISERIES)) {
            return new DB2iSeriesDAO(string2, string3, string4, string5, string6);
        }
        if (string.equalsIgnoreCase(DBTYPE_DB2ZOS)) {
            return new DB2ZOSDAO(string2, string3, string4, string5, string6);
        }
        throw new DatabaseTypeNotSupportedException("DB_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getNewDAOClass(String dbType, String datasourceName, String dbURL, String dbUserId, String dbPwd, String dbDriver)");
    }

    public static QuerySet getQuerySet(String string) {
        QuerySet querySet = new DB2QuerySet();
        if (string.equalsIgnoreCase(DBTYPE_ORACLE)) {
            querySet = new OracleQuerySet();
        } else if (string.equalsIgnoreCase(DBTYPE_SQLSERVER)) {
            querySet = new SQLServerQuerySet();
        } else if (string.equalsIgnoreCase(DBTYPE_INFORMIX)) {
            querySet = new InformixQuerySet();
        } else if (string.equalsIgnoreCase(DBTYPE_DERBY)) {
            querySet = new DerbyQuerySet();
        } else if (string.equalsIgnoreCase(DBTYPE_DB2ISERIES)) {
            querySet = new DB2iSeriesQuerySet();
        } else if (string.equalsIgnoreCase(DBTYPE_DB2ZOS)) {
            querySet = new DB2ZOSQuerySet();
        }
        return querySet;
    }

    public static String getValueTableName(short s, short s2) {
        String string = null;
        if (s == 0) {
            switch (s2) {
                case 0: {
                    string = DB_PROPERTY_STRING_VALUE;
                    break;
                }
                case 1: {
                    string = DB_PROPERTY_LONG_VALUE;
                    break;
                }
                case 2: {
                    string = DB_PROPERTY_DOUBLE_VALUE;
                    break;
                }
                case 3: {
                    string = DB_PROPERTY_INTEGER_VALUE;
                    break;
                }
                case 4: {
                    string = DB_PROPERTY_TIMESTAMP_VALUE;
                    break;
                }
                case 5: {
                    string = DB_PROPERTY_REFERENCE_VALUE;
                    break;
                }
                case 6: {
                    string = DB_PROPERTY_BLOB_VALUE;
                }
            }
        } else if (s == 1) {
            switch (s2) {
                case 0: {
                    string = LA_PROPERTY_STRING_VALUE;
                    break;
                }
                case 1: {
                    string = LA_PROPERTY_LONG_VALUE;
                    break;
                }
                case 2: {
                    string = LA_PROPERTY_DOUBLE_VALUE;
                    break;
                }
                case 3: {
                    string = LA_PROPERTY_INTEGER_VALUE;
                    break;
                }
                case 4: {
                    string = LA_PROPERTY_TIMESTAMP_VALUE;
                    break;
                }
                case 5: {
                    string = LA_PROPERTY_REFERENCE_VALUE;
                    break;
                }
                case 6: {
                    string = LA_PROPERTY_BLOB_VALUE;
                }
            }
        }
        return string;
    }

    public static String getDataType(short s) {
        switch (s) {
            case 0: {
                return "STRING";
            }
            case 1: {
                return "LONG";
            }
            case 2: {
                return "DOUBLE";
            }
            case 3: {
                return "INTEGER";
            }
            case 4: {
                return "TIMESTAMP";
            }
            case 5: {
                return "IDENTIFIER";
            }
            case 6: {
                return "OBJECT";
            }
        }
        return null;
    }

    public static DBDataType getDBDataTypeFromCommonDataType(String string) {
        DBDataType dBDataType = new DBDataType();
        if (string.equalsIgnoreCase("String") || string.equalsIgnoreCase("Token")) {
            dBDataType.setDatatype("STRING");
        } else if (string.equalsIgnoreCase("Double")) {
            dBDataType.setDatatype("DOUBLE");
        } else if (string.equalsIgnoreCase("DateTime")) {
            dBDataType.setDatatype("TIMESTAMP");
        } else if (string.equalsIgnoreCase("Base64Binary")) {
            dBDataType.setDatatype("BYTEARRAY");
        } else if (string.equalsIgnoreCase("Int") || string.equalsIgnoreCase("Short")) {
            dBDataType.setDatatype("INTEGER");
        } else if (string.equalsIgnoreCase("Long")) {
            dBDataType.setDatatype("LONG");
        } else if (string.equalsIgnoreCase("IdentifierType")) {
            dBDataType.setDatatype("IDENTIFIER");
        } else if (string.equalsIgnoreCase("Boolean")) {
            dBDataType.setDatatype("OBJECT");
            dBDataType.setClassname("java.lang.Boolean");
        } else {
            dBDataType.setDatatype("OBJECT");
        }
        return dBDataType;
    }

    public static short getDataTypeId(String string) {
        if (string.equalsIgnoreCase("STRING")) {
            return 0;
        }
        if (string.equalsIgnoreCase("INTEGER")) {
            return 3;
        }
        if (string.equalsIgnoreCase("LONG")) {
            return 1;
        }
        if (string.equalsIgnoreCase("DOUBLE")) {
            return 2;
        }
        if (string.equalsIgnoreCase("TIMESTAMP")) {
            return 4;
        }
        if (string.equalsIgnoreCase("IDENTIFIER")) {
            return 5;
        }
        if (string.equalsIgnoreCase("OBJECT") || string.equalsIgnoreCase("BYTEARRAY")) {
            return 6;
        }
        return -1;
    }

    public static String resumeComponentName(String string, String string2) {
        return string.substring(string2.length() + COMPOSITE_COMPONENT_SEPERATOR.length(), string.length());
    }

    public static Object getRightTypeValue(ResultSet resultSet, short s, int n) throws SQLException, IOException, ClassNotFoundException {
        switch (s) {
            case 0: {
                return resultSet.getString(n);
            }
            case 3: {
                return new Integer(resultSet.getInt(n));
            }
            case 1: {
                return new Long(resultSet.getLong(n));
            }
            case 2: {
                return new Double(resultSet.getDouble(n));
            }
            case 4: {
                Timestamp timestamp = resultSet.getTimestamp(n);
                Date date = new Date(timestamp.getTime());
                String string = SDOHelper.getDateString(date);
                return string;
            }
            case 5: {
                String[] stringArray = new String[3];
                stringArray[0] = resultSet.getString(n);
                stringArray[1] = resultSet.getString(n + 1).trim();
                return stringArray;
            }
        }
        Blob blob = resultSet.getBlob(n);
        InputStream inputStream = blob.getBinaryStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return objectInputStream.readObject();
    }

    public static String[] getRightReferenceTypeValue(ResultSet resultSet, int n, int n2, int n3) throws SQLException {
        String[] stringArray = new String[]{resultSet.getString(n), resultSet.getString(n2), resultSet.getString(n3).trim()};
        return stringArray;
    }

    public static String getTruncatedUniqueName(String string) {
        String string2 = string;
        if (string2.length() > 236) {
            string2 = string2.substring(0, 236);
        }
        return string2.toLowerCase();
    }

    public static String getTruncatedExternalId(String string) {
        String string2 = string;
        if (string2.length() > 200) {
            string2 = string2.substring(0, 200);
        }
        return string2.toLowerCase();
    }

    public static String formatValueForDB(String string) {
        return DAOHelper.replaceAll(string, "'", "''");
    }

    public static final String replaceAll(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        int n = string.indexOf(string2);
        while (n != -1) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
            n = string.indexOf(string2, n + string3.length());
        }
        return string;
    }

    public static boolean isPropInCommonSchema(String string, Set set) throws WIMException {
        for (String string2 : set) {
            if (SchemaManager.singleton().getProperty(string2, string) != null) {
                return true;
            }
            String string3 = DAOHelper.getCompName(string);
            if (string3 == null || SchemaManager.singleton().getProperty(string2, string3) == null) continue;
            return true;
        }
        return false;
    }

    public static String buildEntityIdSQL(Map map) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "buildEntityIdSQL(Map entities)", WIMMessageHelper.generateMsgParms(map));
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        if (map != null && map.size() > 0) {
            Iterator iterator = map.keySet().iterator();
            if (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
            }
            while (iterator.hasNext()) {
                stringBuffer.append(COMMA);
                stringBuffer.append(iterator.next().toString());
            }
        }
        return stringBuffer.toString();
    }

    public static String getCompName(String string) {
        String string2 = null;
        int n = 47;
        int n2 = string.indexOf(n);
        if (n2 != -1) {
            string2 = string.substring(0, n2);
        }
        return string2;
    }

    public static void setPropertySchema(DBRepositoryProperty dBRepositoryProperty, String string, DataObject dataObject, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "setPropertySchema(DBRepositoryProperty prop, String name, DataObject pSchema, String entityTypeName)", string);
        }
        Set set = dBRepositoryProperty.getApplicableEntityTypes();
        if (string2 == null || set.contains(string2)) {
            String string3 = SchemaManager.singleton().getTypeName(string);
            String string4 = SchemaManager.singleton().getTypeNsURI(string);
            dataObject.setString("propertyName", string3);
            dataObject.set("nsURI", (Object)string4);
            dataObject.set("nsPrefix", (Object)SchemaManager.singleton().getNsPrefix(string4));
            DataObject dataObject2 = SDOHelper.createDataObject("http://www.ibm.com/websphere/wim", "MetaDataType");
            dataObject2.set("name", (Object)"repositoryDataType");
            dataObject2.getList("values").add(dBRepositoryProperty.getDataType());
            dataObject.getList("metaData").add(dataObject2);
            if (dBRepositoryProperty.getDataType().equalsIgnoreCase("STRING")) {
                dataObject2 = SDOHelper.createDataObject("http://www.ibm.com/websphere/wim", "MetaDataType");
                dataObject2.set("name", (Object)"valueLength");
                dataObject2.getList("values").add(String.valueOf(dBRepositoryProperty.getValueLength()));
                dataObject.getList("metaData").add(dataObject2);
                dataObject2 = SDOHelper.createDataObject("http://www.ibm.com/websphere/wim", "MetaDataType");
                dataObject2.set("name", (Object)"caseExactMatch");
                dataObject2.getList("values").add(String.valueOf(dBRepositoryProperty.isCaseSensitive()));
                dataObject.getList("metaData").add(dataObject2);
            }
            if (dBRepositoryProperty.getDataType().equalsIgnoreCase("OBJECT") && !dBRepositoryProperty.isComposite()) {
                dataObject2 = SDOHelper.createDataObject("http://www.ibm.com/websphere/wim", "MetaDataType");
                dataObject2.set("name", (Object)"classname");
                dataObject2.getList("values").add(dBRepositoryProperty.getClassName());
                dataObject.getList("metaData").add(dataObject2);
            }
            dataObject2 = SDOHelper.createDataObject("http://www.ibm.com/websphere/wim", "MetaDataType");
            dataObject2.set("name", (Object)"multiValued");
            dataObject2.getList("values").add(String.valueOf(dBRepositoryProperty.isMultipleValued()));
            dataObject.getList("metaData").add(dataObject2);
            dataObject2 = SDOHelper.createDataObject("http://www.ibm.com/websphere/wim", "MetaDataType");
            dataObject2.set("name", (Object)"readOnly");
            dataObject2.getList("values").add(String.valueOf(dBRepositoryProperty.isReadOnly()));
            dataObject.getList("metaData").add(dataObject2);
            dataObject2 = SDOHelper.createDataObject("http://www.ibm.com/websphere/wim", "MetaDataType");
            dataObject2.set("name", (Object)"applicationId");
            dataObject2.getList("values").add(dBRepositoryProperty.getApplicationId());
            dataObject.getList("metaData").add(dataObject2);
            if (dBRepositoryProperty.getDescription() != null && dBRepositoryProperty.getDescription().trim().length() != 0) {
                dataObject2 = SDOHelper.createDataObject("http://www.ibm.com/websphere/wim", "MetaDataType");
                dataObject2.set("name", (Object)"description");
                dataObject2.getList("values").add(dBRepositoryProperty.getDescription());
                dataObject.getList("metaData").add(dataObject2);
            }
            dataObject2 = SDOHelper.createDataObject("http://www.ibm.com/websphere/wim", "MetaDataType");
            dataObject2.set("name", (Object)"isComposite");
            dataObject2.getList("values").add(String.valueOf(dBRepositoryProperty.isComposite()));
            dataObject.getList("metaData").add(dataObject2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                dataObject.getList("applicableEntityTypeNames").add(SchemaManager.singleton().getQualifiedTypeName("http://www.ibm.com/websphere/wim", (String)iterator.next()));
            }
            Set set2 = dBRepositoryProperty.getRequiredEntityTypes();
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                dataObject.getList("requiredEntityTypeNames").add(SchemaManager.singleton().getQualifiedTypeName("http://www.ibm.com/websphere/wim", (String)iterator2.next()));
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "setPropertySchema(DBRepositoryProperty prop, String name, DataObject pSchema, String entityTypeName)");
        }
    }

    public static String getDefaultDBDriver(String string) {
        String string2 = "COM.ibm.db2.jdbc.app.DB2Driver";
        if (string.equalsIgnoreCase(DBTYPE_ORACLE)) {
            string2 = "oracle.jdbc.driver.OracleDriver";
        } else if (string.equalsIgnoreCase(DBTYPE_SQLSERVER)) {
            string2 = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        } else if (string.equalsIgnoreCase(DBTYPE_DERBY)) {
            string2 = "org.apache.derby.jdbc.EmbeddedDriver";
        } else if (string.equalsIgnoreCase(DBTYPE_INFORMIX)) {
            string2 = "com.informix.jdbc.IfxDriver";
        } else if (string.equalsIgnoreCase(DBTYPE_DB2ISERIES)) {
            string2 = "com.ibm.as400.access.AS400JDBCDriver";
        }
        return string2;
    }

    public static String getDB2Type4JDBCDriver() {
        return "com.ibm.db2.jcc.DB2Driver";
    }

    public static Class loadJDBCClass(String string) throws WIMSystemException {
        Class<?> clazz = null;
        Object object = null;
        String string2 = null;
        trcLogger.entering(CLASSNAME, "loadJDBCClass(String dbDriver)");
        clazz = (Class<?>)dbClassMap.get(string);
        if (clazz == null) {
            trcLogger.log(Level.FINE, "Loading JDBC driver class: " + string);
            object = ExtClassLoader.getInstance();
            if (object == null) {
                object = DAOHelper.class.getClassLoader();
            }
            try {
                String string3 = "${VMM_JDBC_CLASSPATH}";
                trcLogger.log(Level.FINER, "Getting " + string3 + " using variable map...");
                VariableMap variableMap = (VariableMap)WsServiceRegistry.getService((Object)"", VariableMap.class);
                string2 = variableMap.expand(string3);
                trcLogger.log(Level.FINER, "Custom classloader WAS variable: VMM_JDBC_CLASSPATH=" + string2);
                if (string2 != null) {
                    URL[] uRLArray;
                    trcLogger.log(Level.FINER, "Building custom classloader...");
                    ArrayList<URL> arrayList = new ArrayList<URL>();
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
                    while (stringTokenizer.hasMoreTokens()) {
                        uRLArray = new File(stringTokenizer.nextToken());
                        arrayList.add(uRLArray.toURL());
                        trcLogger.log(Level.FINER, "\tAdded classpath entry: " + uRLArray);
                    }
                    uRLArray = arrayList.toArray(new URL[arrayList.size()]);
                    object = new URLClassLoader(uRLArray, DAOHelper.class.getClassLoader());
                } else {
                    trcLogger.log(Level.FINER, "Using default classloader");
                }
            }
            catch (Exception exception) {
                trcLogger.log(Level.FINE, "Failed to retrieve WAS variable: VMM_JDBC_CLASSPATH", exception);
            }
            try {
                trcLogger.log(Level.FINER, "Loading JDBC driver...");
                clazz = ((ClassLoader)object).loadClass(string);
                trcLogger.log(Level.FINER, "Loaded JDBC driver successfully");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WIMSystemException(classNotFoundException);
            }
            dbClassMap.put(string, clazz);
        } else {
            trcLogger.log(Level.FINE, "Retrieving JDBC driver class from cache: " + string);
        }
        trcLogger.exiting(CLASSNAME, "loadJDBCClass(String dbDriver)");
        return clazz;
    }

    public static Connection createConnection(String string, String string2, Properties properties) throws WIMSystemException {
        trcLogger.entering(CLASSNAME, "createConnection");
        Connection connection = null;
        if (properties == null) {
            properties = new Properties();
        }
        try {
            Class clazz = DAOHelper.loadJDBCClass(string);
            Object t = clazz.newInstance();
            Method method2 = clazz.getMethod("connect", String.class, Properties.class);
            connection = (Connection)method2.invoke(t, string2, properties);
        }
        catch (Exception exception) {
            if (exception instanceof InvocationTargetException && exception.getCause() instanceof SQLException) {
                SQLException sQLException = (SQLException)exception.getCause();
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createConnection", (Throwable)sQLException);
            }
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "createConnection", (Throwable)exception);
        }
        trcLogger.exiting(CLASSNAME, "createConnection");
        return connection;
    }
}

