/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dao;

import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.extensionhelper.TxHandle;
import com.ibm.ws.wim.EnvironmentManager;
import com.ibm.ws.wim.adapter.db.KeyGenerator;
import com.ibm.ws.wim.dao.DataAccessObject;
import com.ibm.ws.wim.tx.JTAHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class KeyManager {
    public static final String CLASSNAME = KeyManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private DataAccessObject dao = null;
    private Hashtable dbKeys = null;
    private Hashtable laKeys = null;
    public static final int KEY_TYPE_DB = 1;
    public static final int KEY_TYPE_LA = 2;
    private KeyGenerator keyGen = null;
    boolean dbInit = false;
    boolean laInit = false;
    private TransactionControl txControl = null;
    private JTAHelper jtaHelper = new JTAHelper();
    private EnvironmentManager environmentManager = null;

    public KeyManager() {
        this.initializeTransactionControl();
    }

    public KeyManager(DataAccessObject dataAccessObject) {
        this.dao = dataAccessObject;
        this.initializeTransactionControl();
    }

    private void initializeTransactionControl() {
        block2: {
            try {
                this.environmentManager = EnvironmentManager.singleton();
            }
            catch (WIMSystemException wIMSystemException) {
                if (!trcLogger.isLoggable(Level.SEVERE)) break block2;
                trcLogger.logp(Level.SEVERE, CLASSNAME, "initializeTransactionControl", "", WIMMessageHelper.generateMsgParms(wIMSystemException));
            }
        }
    }

    public synchronized long getDBKeyForTable(Connection connection, String string) throws SQLException, NamingException {
        long l;
        long[] lArray;
        long l2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getDBKeyForTable");
        }
        string = string.trim().toUpperCase();
        if (!this.dbInit) {
            this.initialize(connection, 1);
        }
        if ((l2 = (lArray = (long[])this.dbKeys.get(string))[0]) > (l = lArray[1])) {
            l2 = this.updateKey(connection, string, 1);
            lArray = (long[])this.dbKeys.get(string);
        }
        long l3 = l2++;
        lArray[0] = l2;
        this.dbKeys.put(string, lArray);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getDBKeyForTable");
        }
        return l3;
    }

    public synchronized long getLAKeyForTable(Connection connection, String string) throws SQLException, NamingException {
        long l;
        long[] lArray;
        long l2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getLAKeyForTable");
        }
        if (!this.laInit) {
            this.initialize(connection, 2);
        }
        if ((l2 = (lArray = (long[])this.laKeys.get(string))[0]) > (l = lArray[1])) {
            l2 = this.updateKey(connection, string, 2);
            lArray = (long[])this.laKeys.get(string);
        }
        long l3 = l2++;
        lArray[0] = l2;
        this.laKeys.put(string, lArray);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getLAKeyForTable");
        }
        return l3;
    }

    private synchronized void initialize(Connection connection, int n) throws SQLException, NamingException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initialize");
        }
        long[] lArray = new long[]{0L, -1L};
        Hashtable<String, long[]> hashtable = new Hashtable<String, long[]>();
        String string = null;
        String string2 = this.dao.getQuerySet().selectDBKeys;
        if (n == 2) {
            string2 = this.dao.getQuerySet().selectLAKeys;
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            string = resultSet.getString("TABLENAME");
            hashtable.put(string.trim().toUpperCase(), lArray);
        }
        if (n == 1) {
            this.dbKeys = hashtable;
            this.dbInit = true;
        } else {
            this.laKeys = hashtable;
            this.laInit = true;
        }
        this.keyGen = new KeyGenerator(this.dao);
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long updateKey(Connection connection, String string, int n) throws SQLException, NamingException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateKey");
        }
        long l = -1L;
        long l2 = -1L;
        long l3 = -1L;
        long l4 = -1L;
        String string2 = this.dao.getQuerySet().selectDBKeysByTable;
        if (n == 2) {
            string2 = this.dao.getQuerySet().selectLAKeysByTable;
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            throw new SQLException("Key not found");
        }
        l = resultSet.getLong("COUNTER");
        l2 = resultSet.getLong("PREFETCH_SIZE");
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        l3 = l + l2;
        l4 = l3 + 1L;
        long[] lArray = new long[]{l, l3};
        String string3 = this.dao.getQuerySet().updateDBKeysByTable;
        if (n == 1) {
            this.dbKeys.put(string, lArray);
        } else if (n == 2) {
            string3 = this.dao.getQuerySet().updateLAKeysByTable;
            this.laKeys.put(string, lArray);
        }
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = this.jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = this.jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, true);
            }
            this.keyGen.updateKey(string3, string, l4);
            bl = true;
        }
        catch (Exception exception) {
            if (trcLogger.isLoggable(Level.SEVERE)) {
                trcLogger.logp(Level.SEVERE, CLASSNAME, "updateKey", "", WIMMessageHelper.generateMsgParms(exception));
            }
        }
        finally {
            if (bl2) {
                this.jtaHelper.closeTransaction("updateKey", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Update Key: Query=").append(string3).append(", table=").append(string).append(", nextValue=").append(l4);
            trcLogger.logp(Level.FINER, CLASSNAME, "updateKey", stringBuffer.toString());
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateKey");
        }
        return l;
    }
}

