/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dao;

import com.ibm.websphere.wim.ras.WIMLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class LocalKeyManager {
    public static final String CLASSNAME = LocalKeyManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static LocalKeyManager singleton = null;
    private static Hashtable dbKeys = new Hashtable();
    private static Hashtable laKeys = new Hashtable();
    public static final int KEY_TYPE_DB = 1;
    public static final int KEY_TYPE_LA = 2;
    public static final String selectDBKeys = "SELECT * FROM DBKEYS";
    public static final String selectDBKeysByTable = "SELECT * FROM DBKEYS WHERE TABLENAME = ?";
    public static final String selectLAKeys = "SELECT * FROM LAKEYS";
    public static final String selectLAKeysByTable = "SELECT * FROM LAKEYS WHERE TABLENAME = ?";
    public static final String updateDBKeysByTable = "UPDATE DBKEYS SET COUNTER = ? WHERE TABLENAME = ?";
    public static final String updateLAKeysByTable = "UPDATE LAKEYS SET COUNTER = ? WHERE TABLENAME = ?";
    private boolean dbInit = false;
    private boolean laInit = false;

    public static synchronized LocalKeyManager singleton() throws NamingException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "singleton");
        }
        if (singleton == null) {
            singleton = new LocalKeyManager();
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "singleton");
        }
        return singleton;
    }

    public synchronized long getDBKeyForTable(Connection connection, String string) throws SQLException, NamingException {
        long l;
        long[] lArray;
        long l2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getDBKeyForTable");
        }
        string = string.trim().toUpperCase();
        if (!this.dbInit) {
            this.initialize(connection, 1);
        }
        if ((l2 = (lArray = (long[])dbKeys.get(string))[0]) > (l = lArray[1])) {
            l2 = this.updateKey(connection, string, 1);
            lArray = (long[])dbKeys.get(string);
        }
        long l3 = l2++;
        lArray[0] = l2;
        dbKeys.put(string, lArray);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getDBKeyForTable");
        }
        return l3;
    }

    public synchronized long getLAKeyForTable(Connection connection, String string) throws SQLException, NamingException {
        long l;
        long[] lArray;
        long l2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getLAKeyForTable");
        }
        string = string.trim().toUpperCase();
        if (!this.laInit) {
            this.initialize(connection, 2);
        }
        if ((l2 = (lArray = (long[])laKeys.get(string))[0]) > (l = lArray[1])) {
            l2 = this.updateKey(connection, string, 2);
            lArray = (long[])laKeys.get(string);
        }
        long l3 = l2++;
        lArray[0] = l2;
        laKeys.put(string, lArray);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getLAKeyForTable");
        }
        return l3;
    }

    private synchronized void initialize(Connection connection, int n) throws SQLException, NamingException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initialize");
        }
        long[] lArray = new long[]{0L, -1L};
        Hashtable<String, long[]> hashtable = new Hashtable<String, long[]>();
        String string = null;
        String string2 = selectDBKeys;
        if (n == 2) {
            string2 = selectLAKeys;
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            string = resultSet.getString("TABLENAME");
            hashtable.put(string.trim().toUpperCase(), lArray);
        }
        if (n == 1) {
            dbKeys = hashtable;
            this.dbInit = true;
        } else if (n == 2) {
            laKeys = hashtable;
            this.laInit = true;
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize");
        }
    }

    private long updateKey(Connection connection, String string, int n) throws SQLException, NamingException {
        Object object;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateKey");
        }
        long l = -1L;
        long l2 = -1L;
        long l3 = -1L;
        long l4 = -1L;
        String string2 = selectDBKeysByTable;
        if (n == 2) {
            string2 = selectLAKeysByTable;
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            throw new SQLException("Key not found");
        }
        l = resultSet.getLong("COUNTER");
        l2 = resultSet.getLong("PREFETCH_SIZE");
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        l3 = l + l2;
        l4 = l3 + 1L;
        long[] lArray = new long[]{l, l3};
        String string3 = updateDBKeysByTable;
        if (n == 1) {
            object = (long[])dbKeys.get(string);
            if (object[0] == l4) {
                l = l4;
                l3 = l + l2;
                l4 = l3 + 1L;
                lArray[0] = l;
                lArray[1] = l3;
            }
            dbKeys.put(string, lArray);
        } else if (n == 2) {
            object = (long[])laKeys.get(string);
            if (object[0] == l4) {
                l = l4;
                l3 = l + l2;
                l4 = l3 + 1L;
                lArray[0] = l;
                lArray[1] = l3;
            }
            string3 = updateLAKeysByTable;
            laKeys.put(string, lArray);
        }
        try {
            object = connection.prepareStatement(string3);
            object.setLong(1, l4);
            object.setString(2, string);
            object.executeUpdate();
            if (trcLogger.isLoggable(Level.FINER)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Update Key: Query=").append(string3).append(", table=").append(string).append(", nextValue=").append(l4);
                trcLogger.logp(Level.FINER, CLASSNAME, "updateKey", stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateKey");
        }
        return l;
    }
}

