/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dao.derby;

import com.ibm.websphere.wim.exception.InvalidPropertyValueException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.RepositoryManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.db.DBEntity;
import com.ibm.ws.wim.dao.AbstractDAO;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.derby.DerbyQuerySet;
import com.ibm.ws.wim.util.DataGraphHelper;
import commonj.sdo.DataObject;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class DerbyDAO
extends AbstractDAO {
    public static final String CLASSNAME = DerbyDAO.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public DerbyDAO(String string, String string2, String string3, String string4, String string5) throws WIMException {
        super("derby", string, string2, string3, string4, string5, new DerbyQuerySet());
    }

    public void createProperties(short s, long l, Hashtable[] hashtableArray, Long l2, Set set, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps)");
        }
        if (hashtableArray == null) {
            return;
        }
        for (short s2 = 0; s2 < hashtableArray.length; s2 = (short)((short)(s2 + 1))) {
            if (hashtableArray[s2] == null) continue;
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            String string2 = this.getInsertStmtForPropertyValue(s, s2);
            int n = hashtableArray[s2].size();
            Set set2 = hashtableArray[s2].keySet();
            Iterator iterator = set2.iterator();
            try {
                Object object;
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(string2);
                String string3 = DAOHelper.getValueTableName(s, s2);
                while (iterator.hasNext()) {
                    List list;
                    object = (Integer)iterator.next();
                    if (set.contains(object)) {
                        list = (List)hashtableArray[s2].get(object);
                    } else {
                        list = new ArrayList();
                        list.add(hashtableArray[s2].get(object));
                    }
                    if (list.size() == 0) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        long l3 = -1L;
                        l3 = s == 0 ? this.getKeyManager().getDBKeyForTable(connection, string3) : this.getKeyManager().getLAKeyForTable(connection, string3);
                        preparedStatement.setLong(1, l3);
                        preparedStatement.setInt(2, (Integer)object);
                        preparedStatement.setString(3, DAOHelper.getDataType(s2));
                        preparedStatement.setLong(4, l);
                        if (l2 != null) {
                            preparedStatement.setLong(5, l2);
                        } else {
                            preparedStatement.setNull(5, -5);
                        }
                        preparedStatement.setString(6, "");
                        try {
                            switch (s2) {
                                case 0: {
                                    preparedStatement.setString(7, (String)list.get(i));
                                    preparedStatement.setString(8, ((String)list.get(i)).toLowerCase());
                                    break;
                                }
                                case 5: {
                                    Object object2;
                                    ByteArrayOutputStream byteArrayOutputStream;
                                    Timestamp timestamp;
                                    Object object3;
                                    DataObject dataObject = (DataObject)list.get(i);
                                    if (RepositoryManager.singleton().isEntryJoin()) {
                                        DataGraphHelper.prepareIdentifierFromFedRepository(dataObject);
                                    } else if (s == 0 && string != null) {
                                        String string4 = dataObject.getString("uniqueName");
                                        object3 = this.findDBEntityByUniqueNameKey(DAOHelper.getTruncatedUniqueName(string4));
                                        dataObject.setString("externalId", ((DBEntity)object3).getUniqueId());
                                        dataObject.setString("repositoryId", string);
                                    } else if (s == 1) {
                                        String string5 = dataObject.getString("uniqueName");
                                        object3 = dataObject.getString("externalId");
                                        String string6 = dataObject.getString("repositoryId");
                                        if (string5 == null || object3 == null || string6 == null) {
                                            DataObject dataObject2 = SchemaManager.singleton().createRootDataObject();
                                            DataObject dataObject3 = dataObject2.createDataObject("entities", "http://www.ibm.com/websphere/wim", "Entity");
                                            timestamp = dataObject3.createDataObject("identifier");
                                            timestamp.setString("uniqueName", string5);
                                            timestamp.setString("externalId", (String)object3);
                                            timestamp.setString("repositoryId", string6);
                                            byteArrayOutputStream = RepositoryManager.singleton().getRepositories()[0].get(dataObject2);
                                            object2 = byteArrayOutputStream.getList("entities");
                                            DataObject dataObject4 = (DataObject)object2.get(0);
                                            DataObject dataObject5 = dataObject4.getDataObject("identifier");
                                            string5 = dataObject5.getString("uniqueName");
                                            object3 = dataObject5.getString("externalId");
                                            string6 = RepositoryManager.singleton().getRepositoryIds()[0];
                                            dataObject.setString("uniqueName", string5);
                                            dataObject.setString("externalId", (String)object3);
                                            dataObject.setString("repositoryId", string);
                                        }
                                    }
                                    preparedStatement.setString(7, DAOHelper.getTruncatedUniqueName(dataObject.getString("uniqueName")));
                                    preparedStatement.setString(8, dataObject.getString("uniqueName"));
                                    preparedStatement.setString(9, DAOHelper.getTruncatedExternalId(dataObject.getString("externalId")));
                                    preparedStatement.setString(10, dataObject.getString("externalId"));
                                    preparedStatement.setString(11, dataObject.getString("repositoryId"));
                                    break;
                                }
                                case 1: {
                                    long l4 = 0L;
                                    try {
                                        l4 = (Long)list.get(i);
                                    }
                                    catch (ClassCastException classCastException) {
                                        l4 = Long.parseLong((String)list.get(i));
                                    }
                                    preparedStatement.setLong(7, l4);
                                    break;
                                }
                                case 2: {
                                    double d = 0.0;
                                    try {
                                        d = (Double)list.get(i);
                                    }
                                    catch (ClassCastException classCastException) {
                                        d = Double.parseDouble((String)list.get(i));
                                    }
                                    preparedStatement.setDouble(7, d);
                                    break;
                                }
                                case 3: {
                                    int n2 = 0;
                                    try {
                                        n2 = (Integer)list.get(i);
                                    }
                                    catch (ClassCastException classCastException) {
                                        n2 = new Integer(list.get(i).toString());
                                    }
                                    preparedStatement.setInt(7, n2);
                                    break;
                                }
                                case 4: {
                                    Timestamp timestamp = null;
                                    try {
                                        timestamp = (Timestamp)list.get(i);
                                    }
                                    catch (ClassCastException classCastException) {
                                        try {
                                            timestamp = Timestamp.valueOf((String)list.get(i));
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    preparedStatement.setTimestamp(7, timestamp);
                                    break;
                                }
                                case 6: {
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                    Object object2 = new ObjectOutputStream(byteArrayOutputStream);
                                    ((ObjectOutputStream)object2).writeObject(list.get(i));
                                    ((ObjectOutputStream)object2).close();
                                    preparedStatement.setBytes(7, byteArrayOutputStream.toByteArray());
                                    preparedStatement.executeUpdate();
                                }
                            }
                        }
                        catch (Exception exception) {
                            throw new InvalidPropertyValueException();
                        }
                        if (s2 == 6) continue;
                        preparedStatement.addBatch();
                    }
                }
                if (s2 == 6) continue;
                object = preparedStatement.executeBatch();
                continue;
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps)", (Throwable)namingException);
            }
            catch (SQLException sQLException) {
                throw new WIMSystemException("SQL_EXCEPTION", CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps)", (Throwable)sQLException);
            }
            finally {
                try {
                    this.closeConnection(connection);
                }
                catch (Exception exception) {}
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps)");
        }
    }
}

