/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dao.oracle;

import com.ibm.websphere.wim.exception.InvalidPropertyValueException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.RepositoryManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.db.DBEntity;
import com.ibm.ws.wim.dao.AbstractDAO;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.oracle.OracleQuerySet;
import com.ibm.ws.wim.util.DataGraphHelper;
import commonj.sdo.DataObject;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class OracleDAO
extends AbstractDAO {
    public static final String CLASSNAME = OracleDAO.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public OracleDAO(String string, String string2, String string3, String string4, String string5) throws WIMException {
        super("oracle", string, string2, string3, string4, string5, new OracleQuerySet());
    }

    public void createProperties(short s, long l, Hashtable[] hashtableArray, Long l2, Set set, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps)");
        }
        if (hashtableArray == null) {
            return;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            for (short s2 = 0; s2 < hashtableArray.length; s2 = (short)(s2 + 1)) {
                if (hashtableArray[s2] == null) continue;
                String string2 = this.getInsertStmtForPropertyValue(s, s2);
                int n = hashtableArray[s2].size();
                Set set2 = hashtableArray[s2].keySet();
                Iterator iterator = set2.iterator();
                if (connection == null) {
                    connection = this.getConnection();
                }
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps)", "insert statement is " + string2);
                }
                statement = connection.prepareStatement(string2);
                String string3 = DAOHelper.getValueTableName(s, s2);
                while (iterator.hasNext()) {
                    List list;
                    Integer n2 = (Integer)iterator.next();
                    if (set.contains(n2)) {
                        list = (List)hashtableArray[s2].get(n2);
                    } else {
                        list = new ArrayList();
                        list.add(hashtableArray[s2].get(n2));
                    }
                    if (list.size() == 0) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        long l3 = -1L;
                        l3 = s == 0 ? this.getKeyManager().getDBKeyForTable(connection, string3) : this.getKeyManager().getLAKeyForTable(connection, string3);
                        statement.setLong(1, l3);
                        statement.setInt(2, n2);
                        statement.setString(3, DAOHelper.getDataType(s2));
                        statement.setLong(4, l);
                        if (l2 != null) {
                            statement.setLong(5, l2);
                        } else {
                            statement.setNull(5, -5);
                        }
                        statement.setString(6, "");
                        try {
                            switch (s2) {
                                case 0: {
                                    statement.setString(7, (String)list.get(i));
                                    statement.setString(8, ((String)list.get(i)).toLowerCase());
                                    break;
                                }
                                case 5: {
                                    Object object;
                                    ByteArrayOutputStream byteArrayOutputStream;
                                    Timestamp timestamp;
                                    Object object2;
                                    DataObject dataObject = (DataObject)list.get(i);
                                    if (RepositoryManager.singleton().isEntryJoin()) {
                                        DataGraphHelper.prepareIdentifierFromFedRepository(dataObject);
                                    } else if (s == 0 && string != null) {
                                        String string4 = dataObject.getString("uniqueName");
                                        object2 = this.findDBEntityByUniqueNameKey(DAOHelper.getTruncatedUniqueName(string4));
                                        dataObject.setString("externalId", ((DBEntity)object2).getUniqueId());
                                        dataObject.setString("repositoryId", string);
                                    } else if (s == 1) {
                                        String string5 = dataObject.getString("uniqueName");
                                        object2 = dataObject.getString("externalId");
                                        String string6 = dataObject.getString("repositoryId");
                                        if (string5 == null || object2 == null || string6 == null) {
                                            DataObject dataObject2 = SchemaManager.singleton().createRootDataObject();
                                            DataObject dataObject3 = dataObject2.createDataObject("entities", "http://www.ibm.com/websphere/wim", "Entity");
                                            timestamp = dataObject3.createDataObject("identifier");
                                            timestamp.setString("uniqueName", string5);
                                            timestamp.setString("externalId", (String)object2);
                                            timestamp.setString("repositoryId", string6);
                                            byteArrayOutputStream = RepositoryManager.singleton().getRepositories()[0].get(dataObject2);
                                            object = byteArrayOutputStream.getList("entities");
                                            DataObject dataObject4 = (DataObject)object.get(0);
                                            DataObject dataObject5 = dataObject4.getDataObject("identifier");
                                            string5 = dataObject5.getString("uniqueName");
                                            object2 = dataObject5.getString("externalId");
                                            string6 = RepositoryManager.singleton().getRepositoryIds()[0];
                                            dataObject.setString("uniqueName", string5);
                                            dataObject.setString("externalId", (String)object2);
                                            dataObject.setString("repositoryId", string);
                                        }
                                    }
                                    statement.setString(7, DAOHelper.getTruncatedUniqueName(dataObject.getString("uniqueName")));
                                    statement.setString(8, dataObject.getString("uniqueName"));
                                    statement.setString(9, DAOHelper.getTruncatedExternalId(dataObject.getString("externalId")));
                                    statement.setString(10, dataObject.getString("externalId"));
                                    statement.setString(11, dataObject.getString("repositoryId"));
                                    break;
                                }
                                case 1: {
                                    long l4 = 0L;
                                    try {
                                        l4 = (Long)list.get(i);
                                    }
                                    catch (ClassCastException classCastException) {
                                        l4 = Long.parseLong((String)list.get(i));
                                    }
                                    statement.setLong(7, l4);
                                    break;
                                }
                                case 2: {
                                    double d = 0.0;
                                    try {
                                        d = (Double)list.get(i);
                                    }
                                    catch (ClassCastException classCastException) {
                                        d = Double.parseDouble((String)list.get(i));
                                    }
                                    statement.setDouble(7, d);
                                    break;
                                }
                                case 3: {
                                    int n3 = 0;
                                    try {
                                        n3 = (Integer)list.get(i);
                                    }
                                    catch (ClassCastException classCastException) {
                                        n3 = new Integer(list.get(i).toString());
                                    }
                                    statement.setInt(7, n3);
                                    break;
                                }
                                case 4: {
                                    Timestamp timestamp = null;
                                    try {
                                        timestamp = (Timestamp)list.get(i);
                                    }
                                    catch (ClassCastException classCastException) {
                                        try {
                                            timestamp = Timestamp.valueOf((String)list.get(i));
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    statement.setTimestamp(7, timestamp);
                                    break;
                                }
                                case 6: {
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                    Object object = new ObjectOutputStream(byteArrayOutputStream);
                                    ((ObjectOutputStream)object).writeObject(list.get(i));
                                    ((ObjectOutputStream)object).close();
                                    statement.setBytes(7, byteArrayOutputStream.toByteArray());
                                }
                            }
                        }
                        catch (Exception exception) {
                            throw new InvalidPropertyValueException();
                        }
                        statement.executeUpdate();
                    }
                }
            }
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps)", (Throwable)namingException);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps)", (Throwable)sQLException);
        }
        finally {
            try {
                this.closeConnection(connection);
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createProperties(short schema, long mbrId, Hashtable[] attrs, Set multiValProps)");
        }
    }
}

