/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dao.schema;

import com.ibm.websphere.wim.exception.MissingInitPropertyException;
import com.ibm.websphere.wim.exception.PropertyNotDefinedException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.util.UniqueIdGenerator;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.LocalKeyManager;
import com.ibm.ws.wim.dao.QuerySet;
import com.ibm.ws.wim.util.PasswordEncryptionUtil;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBInitSetup {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = DBInitSetup.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private String defaultOrgDN = null;
    private String adminId = null;
    private String adminPwd = null;
    private String dbURL = null;
    private String dbDriver = null;
    private String dbUserId = null;
    private String dbUserPwd = null;
    private QuerySet querySet = null;
    private boolean changeDN = false;
    private boolean setAdmin = false;
    private String encryptionKey = "1234567890abcdef";
    private int saltLength = 12;

    public static void main(String[] stringArray) throws WIMSystemException {
        DBInitSetup dBInitSetup = new DBInitSetup(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], stringArray[7], stringArray[8], stringArray[9]);
        dBInitSetup.setup();
    }

    public DBInitSetup(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws WIMSystemException {
        this.defaultOrgDN = string;
        this.adminId = string2;
        this.adminPwd = string3;
        if (string4 != null && string4.trim().length() != 0) {
            try {
                this.encryptionKey = PasswordEncryptionUtil.decrypt(string4.trim(), null).trim();
            }
            catch (NullPointerException nullPointerException) {
                this.encryptionKey = string4;
            }
        }
        if (string5 != null && string5.trim().length() != 0) {
            this.saltLength = new Integer(string5);
        }
        this.dbURL = string7;
        this.dbDriver = string8;
        this.dbUserId = string9;
        this.dbUserPwd = string10;
        this.querySet = DAOHelper.getQuerySet(string6);
    }

    private Class loadJDBCClass() throws WIMSystemException {
        return DAOHelper.loadJDBCClass(this.dbDriver);
    }

    private Connection getConnection() throws WIMSystemException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getConnection");
        }
        Connection connection = null;
        Properties properties = new Properties();
        if (this.dbUserId != null && this.dbUserPwd != null) {
            properties.put("user", this.dbUserId);
            properties.put("password", this.dbUserPwd);
        }
        try {
            Class clazz = this.loadJDBCClass();
            Object t = clazz.newInstance();
            Method method2 = clazz.getMethod("connect", String.class, Properties.class);
            connection = (Connection)method2.invoke(t, this.dbURL, properties);
        }
        catch (Exception exception) {
            try {
                if (this.dbDriver != null) {
                    Class.forName(this.dbDriver);
                }
                connection = DriverManager.getConnection(this.dbURL, properties);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(classNotFoundException.getMessage()), CLASSNAME, "getConnection", (Throwable)classNotFoundException);
            }
            catch (SQLException sQLException) {
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getConnection", (Throwable)sQLException);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getConnection");
        }
        return connection;
    }

    public void setup() throws WIMSystemException {
        Connection connection = null;
        try {
            if (this.defaultOrgDN != null && this.defaultOrgDN.trim().length() != 0) {
                this.changeDN = true;
                if (trcLogger.isLoggable(Level.INFO)) {
                    trcLogger.logp(Level.INFO, CLASSNAME, "setup", "DefaultOrg is change to " + this.defaultOrgDN);
                }
            }
            if (this.adminId != null && this.adminId.trim().length() != 0) {
                if (this.adminPwd != null && this.adminPwd.trim().length() != 0) {
                    this.setAdmin = true;
                    if (trcLogger.isLoggable(Level.INFO)) {
                        trcLogger.logp(Level.INFO, CLASSNAME, "setup", "new admin to create is " + this.adminId);
                    }
                } else {
                    throw new MissingInitPropertyException("MISSING_OR_EMPTY_PASSWORD", CLASSNAME, "setup");
                }
            }
            if (this.changeDN || this.setAdmin) {
                connection = this.getConnection();
                connection.setAutoCommit(false);
                if (this.changeDN) {
                    this.changeDefaultOrg(connection);
                    if (trcLogger.isLoggable(Level.INFO)) {
                        trcLogger.logp(Level.INFO, CLASSNAME, "setup", "DefaultOrg is changed.");
                    }
                }
                if (this.setAdmin) {
                    this.setAdminData(connection);
                    if (trcLogger.isLoggable(Level.INFO)) {
                        trcLogger.logp(Level.INFO, CLASSNAME, "setup", "New admin is created.");
                    }
                }
            } else if (trcLogger.isLoggable(Level.INFO)) {
                trcLogger.logp(Level.INFO, CLASSNAME, "setup", "No change to default database");
            }
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "setup", (Throwable)exception);
        }
        try {
            if (connection != null) {
                connection.commit();
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void changeDefaultOrg(Connection connection) throws WIMSystemException {
        Statement statement = null;
        try {
            String string = this.querySet.updateDefaultOrg;
            statement = connection.prepareStatement(string);
            statement.setString(1, this.defaultOrgDN);
            statement.setString(2, DAOHelper.getTruncatedUniqueName(this.defaultOrgDN));
            statement.executeUpdate();
        }
        catch (Exception exception) {
            throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "changeDefaultOrg", (Throwable)exception);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    private void setAdminData(Connection connection) throws WIMSystemException {
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        PreparedStatement preparedStatement4 = null;
        ResultSet resultSet = null;
        try {
            String string = this.querySet.createDBEntity;
            statement = connection.prepareStatement(string);
            statement.setLong(1, -1000L);
            statement.setString(2, "PersonAccount");
            statement.setString(3, UniqueIdGenerator.newUniqueId());
            String string2 = "uid=" + this.adminId + ",o=Default Organization";
            if (this.defaultOrgDN != null) {
                string2 = "uid=" + this.adminId + "," + this.defaultOrgDN;
            }
            statement.setString(4, string2);
            statement.setString(5, DAOHelper.getTruncatedUniqueName(string2));
            statement.executeUpdate();
            String string3 = this.querySet.createEntityRelation;
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setLong(1, -1000L);
            preparedStatement.setLong(2, -2000L);
            preparedStatement.executeUpdate();
            String string4 = this.querySet.findDBPropId;
            preparedStatement2 = connection.prepareStatement(string4);
            preparedStatement2.setString(1, "uid");
            resultSet = preparedStatement2.executeQuery();
            int n = -1;
            if (!resultSet.next()) {
                throw new PropertyNotDefinedException("PROPERTY_NOT_DEFINED", WIMMessageHelper.generateMsgParms("uid"), CLASSNAME, "setAdminData");
            }
            n = resultSet.getInt(1);
            String string5 = this.querySet.createDBStringValue;
            preparedStatement3 = connection.prepareStatement(string5);
            LocalKeyManager localKeyManager = LocalKeyManager.singleton();
            long l = new Long(localKeyManager.getDBKeyForTable(connection, "DBSTRPROP"));
            preparedStatement3.setLong(1, l);
            preparedStatement3.setInt(2, n);
            preparedStatement3.setString(3, "STRING");
            preparedStatement3.setLong(4, -1000L);
            preparedStatement3.setNull(5, -5);
            preparedStatement3.setString(6, "");
            preparedStatement3.setString(7, this.adminId);
            preparedStatement3.setString(8, this.adminId.toLowerCase());
            preparedStatement3.executeUpdate();
            String string6 = PasswordEncryptionUtil.generateSalt(this.saltLength);
            byte[] byArray = this.encrypt(this.adminPwd.getBytes("UTF-8"), string6);
            String string7 = this.querySet.createAccount;
            preparedStatement4 = connection.prepareStatement(string7);
            preparedStatement4.setLong(1, -1000L);
            preparedStatement4.setBytes(2, byArray);
            preparedStatement4.setString(3, string6);
            preparedStatement4.setNull(4, 12);
            preparedStatement4.setNull(5, 12);
            preparedStatement4.setNull(6, 12);
            preparedStatement4.executeUpdate();
        }
        catch (Exception exception) {
            throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "setAdminData", (Throwable)exception);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    private byte[] encrypt(byte[] byArray, String string) throws WIMSystemException {
        String string2 = null;
        string2 = string == null || string.trim().length() == 0 ? PasswordEncryptionUtil.hash(byArray).trim() : PasswordEncryptionUtil.hash(PasswordEncryptionUtil.getSaltedTextBytes(string.trim(), byArray)).trim();
        byte[] byArray2 = null;
        byArray2 = PasswordEncryptionUtil.formatPassword(PasswordEncryptionUtil.encrypt(string2, this.encryptionKey).trim().getBytes());
        return byArray2;
    }
}

