/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dao.schema;

import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.adapter.db.DBCompositeRelation;
import com.ibm.ws.wim.adapter.db.DBProperty;
import com.ibm.ws.wim.adapter.db.DBPropertyEntity;
import com.ibm.ws.wim.dao.schema.DBLoaderDao;
import com.ibm.ws.wim.dao.schema.DBRepositoryProperty;
import com.ibm.ws.wim.lookaside.LACompositeRelation;
import com.ibm.ws.wim.lookaside.LAProperty;
import com.ibm.ws.wim.lookaside.LAPropertyEntity;
import com.ibm.ws.xml.ParserFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DBLoadManager {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = DBLoadManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private String dbType;
    private String url;
    private String driver;
    private String user;
    private String password;
    private DBLoaderDao dbLoaderDao;
    private boolean traceOn;

    public DBLoadManager() {
    }

    public DBLoadManager(String string, String string2, String string3, boolean bl) throws WIMSystemException {
        this.dbType = string;
        this.url = string2;
        this.driver = string3;
        this.traceOn = bl;
    }

    public DBLoadManager(String string, String string2, String string3, String string4, String string5, boolean bl) throws WIMSystemException {
        this.dbType = string;
        this.url = string2;
        this.driver = string3;
        this.user = string4;
        this.password = string5;
        this.traceOn = bl;
    }

    private Set getEntityNameSet(Element element) {
        HashSet<String> hashSet = null;
        NodeList nodeList = element.getElementsByTagName("wimprop:entityName");
        if (nodeList.getLength() != 0) {
            hashSet = new HashSet<String>();
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            hashSet.add(node.getFirstChild().getNodeValue());
        }
        return hashSet;
    }

    public void createDBCompRelationEntry(int n, Hashtable hashtable) throws WIMSystemException {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)hashtable.get(n2);
            DBCompositeRelation dBCompositeRelation = new DBCompositeRelation();
            dBCompositeRelation.setCompositeId(n);
            dBCompositeRelation.setComponentId(n2);
            boolean bl = new Boolean((String)hashtable2.get("requiredInComposite"));
            dBCompositeRelation.setRequiredInComposite(bl ? 1 : 0);
            boolean bl2 = new Boolean((String)hashtable2.get("keyInComposite"));
            dBCompositeRelation.setKeyInComposite(bl2 ? 1 : 0);
            try {
                this.dbLoaderDao.createDBCompositeRelation(dBCompositeRelation);
            }
            catch (Exception exception) {
                throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "createDBCompRelationEntry", (Throwable)exception);
            }
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "createDBCompRelationEntry", "Database composite property: " + n + " is created.");
        }
    }

    public void createLACompRelationEntry(int n, Hashtable hashtable) throws WIMSystemException {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)hashtable.get(n2);
            LACompositeRelation lACompositeRelation = new LACompositeRelation();
            lACompositeRelation.setCompositeId(n);
            lACompositeRelation.setComponentId(n2);
            boolean bl = new Boolean((String)hashtable2.get("requiredInComposite"));
            lACompositeRelation.setRequiredInComposite(bl ? 1 : 0);
            boolean bl2 = new Boolean((String)hashtable2.get("keyInComposite"));
            lACompositeRelation.setKeyInComposite(bl2 ? 1 : 0);
            try {
                this.dbLoaderDao.createLACompositeRelation(lACompositeRelation);
            }
            catch (Exception exception) {
                throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "createLACompRelationEntry", (Throwable)exception);
            }
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "createLACompRelationEntry", "Lookaside composite property: " + n + " is created.");
        }
    }

    public Hashtable createNCompositePropertyEntry(String string, Element element, boolean bl, Set set, String string2) throws WIMSystemException {
        Hashtable hashtable = new Hashtable();
        DBRepositoryProperty dBRepositoryProperty = new DBRepositoryProperty();
        boolean bl2 = true;
        String string3 = string + "/" + element.getAttribute("wimPropertyName");
        dBRepositoryProperty.setName(string3);
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "createNCompositePropertyEntry", "...Loading composite property: " + dBRepositoryProperty.getName());
        }
        dBRepositoryProperty.setDataType("OBJECT");
        dBRepositoryProperty.setValueLength(0);
        dBRepositoryProperty.setMetadataName("DEFAULT");
        String string4 = element.getAttribute("multiValued");
        if (string4.length() != 0) {
            dBRepositoryProperty.setMultipleValued(new Boolean(string4));
        }
        dBRepositoryProperty.setDescription(element.getAttribute("description"));
        String string5 = element.getAttribute("readOnly");
        if (string5.length() != 0) {
            dBRepositoryProperty.setReadOnly(new Boolean(string5));
        }
        dBRepositoryProperty.setApplicationId(string2);
        dBRepositoryProperty.setComposite(true);
        dBRepositoryProperty.setApplicableEntityTypes(set);
        try {
            Integer n = new Integer(-1);
            n = bl ? this.createDBProp(dBRepositoryProperty) : this.createLAProp(dBRepositoryProperty);
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            String string6 = element.getAttribute("requiredInComposite");
            String string7 = element.getAttribute("keyInComposite");
            hashtable2.put("requiredInComposite", string6);
            hashtable2.put("keyInComposite", string7);
            if (n != -1) {
                hashtable.put(n, hashtable2);
            }
            NodeList nodeList = element.getChildNodes();
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node = nodeList.item(i);
                Hashtable hashtable3 = new Hashtable();
                Hashtable hashtable4 = new Hashtable();
                if (node.getNodeType() != 1) continue;
                String string8 = ((Element)node).getTagName();
                if (string8.equals("wimprop:componentProperty")) {
                    hashtable3 = this.createComponentPropertyEntry(dBRepositoryProperty.getName(), (Element)node, bl, dBRepositoryProperty.getApplicableEntityTypes(), dBRepositoryProperty.getApplicationId());
                    if (bl) {
                        this.createDBCompRelationEntry(n, hashtable3);
                        continue;
                    }
                    this.createLACompRelationEntry(n, hashtable3);
                    continue;
                }
                if (!string8.equals("wimprop:compositeProperty")) continue;
                hashtable4 = this.createNCompositePropertyEntry(dBRepositoryProperty.getName(), (Element)node, bl, dBRepositoryProperty.getApplicableEntityTypes(), dBRepositoryProperty.getApplicationId());
                if (bl) {
                    this.createDBCompRelationEntry(n, hashtable4);
                    continue;
                }
                this.createLACompRelationEntry(n, hashtable4);
            }
        }
        catch (Exception exception) {
            throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "createNCompositePropertyEntry", (Throwable)exception);
        }
        return hashtable;
    }

    public void createCompositePropertyEntry(NodeList nodeList, boolean bl) throws WIMSystemException {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Object object2;
            Object object3;
            String string;
            Element element = (Element)nodeList.item(i);
            DBRepositoryProperty dBRepositoryProperty = new DBRepositoryProperty();
            String string2 = element.getAttribute("wimPropertyName");
            dBRepositoryProperty.setName(string2);
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.logp(Level.FINE, CLASSNAME, "createCompositePropertyEntry", "...Loading composite property: " + dBRepositoryProperty.getName());
            }
            dBRepositoryProperty.setDataType("OBJECT");
            dBRepositoryProperty.setValueLength(0);
            String string3 = element.getAttribute("metadataName");
            if (string3.trim().length() == 0) {
                string3 = "DEFAULT";
            }
            dBRepositoryProperty.setMetadataName(string3);
            String string4 = element.getAttribute("multiValued");
            if (string4.length() != 0) {
                dBRepositoryProperty.setMultipleValued(new Boolean(string4));
            }
            dBRepositoryProperty.setDescription(element.getAttribute("description"));
            String string5 = element.getAttribute("readOnly");
            if (string5.length() != 0) {
                dBRepositoryProperty.setReadOnly(new Boolean(string5));
            }
            if ((string = element.getAttribute("applicationId")).trim().length() == 0) {
                string = "com.ibm.websphere.wim";
            }
            dBRepositoryProperty.setApplicationId(string);
            dBRepositoryProperty.setComposite(true);
            NodeList nodeList2 = element.getElementsByTagName("wimprop:applicableEntityName");
            if (nodeList2.getLength() != 0 && (object3 = this.getEntityNameSet((Element)(object2 = (Element)nodeList2.item(0)))) != null) {
                dBRepositoryProperty.setApplicableEntityTypes((Set)object3);
            }
            if ((object2 = element.getElementsByTagName("wimprop:requiredEntityName")).getLength() != 0 && (object = this.getEntityNameSet((Element)(object3 = (Element)object2.item(0)))) != null) {
                dBRepositoryProperty.setRequiredEntityTypes((Set)object);
            }
            try {
                int n = bl ? this.createDBProp(dBRepositoryProperty).intValue() : this.createLAProp(dBRepositoryProperty).intValue();
                object = element.getChildNodes();
                int n2 = object.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node = object.item(j);
                    Hashtable hashtable = new Hashtable();
                    Hashtable hashtable2 = new Hashtable();
                    if (node.getNodeType() != 1) continue;
                    String string6 = ((Element)node).getTagName();
                    if (string6.equals("wimprop:componentProperty")) {
                        hashtable = this.createComponentPropertyEntry(dBRepositoryProperty.getName(), (Element)node, bl, dBRepositoryProperty.getApplicableEntityTypes(), dBRepositoryProperty.getApplicationId());
                        if (bl) {
                            this.createDBCompRelationEntry(n, hashtable);
                            continue;
                        }
                        this.createLACompRelationEntry(n, hashtable);
                        continue;
                    }
                    if (!string6.equals("wimprop:componentCompositeProperty")) continue;
                    hashtable2 = this.createNCompositePropertyEntry(dBRepositoryProperty.getName(), (Element)node, bl, dBRepositoryProperty.getApplicableEntityTypes(), dBRepositoryProperty.getApplicationId());
                    if (bl) {
                        this.createDBCompRelationEntry(n, hashtable2);
                        continue;
                    }
                    this.createLACompRelationEntry(n, hashtable2);
                }
                continue;
            }
            catch (Exception exception) {
                throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "createCompositePropertyEntry", (Throwable)exception);
            }
        }
    }

    public Integer createDBProp(DBRepositoryProperty dBRepositoryProperty) throws WIMSystemException {
        DBProperty dBProperty = new DBProperty();
        dBProperty.setName(dBRepositoryProperty.getName());
        dBProperty.setTypeId(dBRepositoryProperty.getDataType().toUpperCase(Locale.ENGLISH));
        dBProperty.setMetadataName(dBRepositoryProperty.getMetadataName());
        dBProperty.setValueLength(dBRepositoryProperty.getValueLength());
        if (dBRepositoryProperty.isCaseSensitive()) {
            dBProperty.setCaseExactMatch(1);
        } else {
            dBProperty.setCaseExactMatch(0);
        }
        if (dBRepositoryProperty.isMultipleValued()) {
            dBProperty.setMultiValued(1);
        } else {
            dBProperty.setMultiValued(0);
        }
        if (dBRepositoryProperty.isReadOnly()) {
            dBProperty.setReadOnly(1);
        } else {
            dBProperty.setReadOnly(0);
        }
        dBProperty.setClassName(dBRepositoryProperty.getClassName());
        dBProperty.setDescription(dBRepositoryProperty.getDescription());
        dBProperty.setApplicationId(dBRepositoryProperty.getApplicationId());
        if (dBRepositoryProperty.isComposite()) {
            dBProperty.setIsComposite(1);
        } else {
            dBProperty.setIsComposite(0);
        }
        int n = this.dbLoaderDao.createDBProperty(dBProperty);
        Set set = dBRepositoryProperty.getApplicableEntityTypes();
        Set set2 = dBRepositoryProperty.getRequiredEntityTypes();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                DBPropertyEntity dBPropertyEntity = new DBPropertyEntity();
                dBPropertyEntity.setPropertyId(n);
                String string = (String)iterator.next();
                dBPropertyEntity.setApplicableEntityType(string);
                if (set2 != null && set2.contains(string)) {
                    dBPropertyEntity.setRequiredEntityType(1);
                }
                this.dbLoaderDao.createDBPropertyEntity(dBPropertyEntity);
            }
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "createDBProp", "Database Property:" + dBRepositoryProperty.getName() + " is loaded.");
        }
        return new Integer(n);
    }

    public Integer createLAProp(DBRepositoryProperty dBRepositoryProperty) throws WIMSystemException {
        LAProperty lAProperty = new LAProperty();
        lAProperty.setName(dBRepositoryProperty.getName());
        lAProperty.setDatatypeId(dBRepositoryProperty.getDataType().toUpperCase(Locale.ENGLISH));
        lAProperty.setMetadataName(dBRepositoryProperty.getMetadataName());
        lAProperty.setValueLength(dBRepositoryProperty.getValueLength());
        if (dBRepositoryProperty.isCaseSensitive()) {
            lAProperty.setCaseExactMatch(1);
        } else {
            lAProperty.setCaseExactMatch(0);
        }
        if (dBRepositoryProperty.isMultipleValued()) {
            lAProperty.setMultiValued(1);
        } else {
            lAProperty.setMultiValued(0);
        }
        if (dBRepositoryProperty.isReadOnly()) {
            lAProperty.setReadOnly(1);
        } else {
            lAProperty.setReadOnly(0);
        }
        lAProperty.setClassname(dBRepositoryProperty.getClassName());
        lAProperty.setDescription(dBRepositoryProperty.getDescription());
        lAProperty.setApplicationId(dBRepositoryProperty.getApplicationId());
        if (dBRepositoryProperty.isComposite()) {
            lAProperty.setIsComposite(1);
        } else {
            lAProperty.setIsComposite(0);
        }
        int n = this.dbLoaderDao.createLAProperty(lAProperty);
        Set set = dBRepositoryProperty.getApplicableEntityTypes();
        Set set2 = dBRepositoryProperty.getRequiredEntityTypes();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                LAPropertyEntity lAPropertyEntity = new LAPropertyEntity();
                lAPropertyEntity.setPropertyId(n);
                String string = (String)iterator.next();
                lAPropertyEntity.setApplicableEntityType(string);
                if (set2 != null && set2.contains(string)) {
                    lAPropertyEntity.setRequiredEntityType(1);
                }
                this.dbLoaderDao.createLAPropertyEntity(lAPropertyEntity);
            }
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "createLAProp", "Lookaside Property:" + dBRepositoryProperty.getName() + " is loaded.");
        }
        return new Integer(n);
    }

    public Hashtable createComponentPropertyEntry(String string, Element element, boolean bl, Set set, String string2) throws WIMSystemException {
        String string3;
        String string4;
        String string5;
        String string6;
        Hashtable hashtable = new Hashtable();
        DBRepositoryProperty dBRepositoryProperty = new DBRepositoryProperty();
        dBRepositoryProperty.setName(string + "/" + element.getAttribute("wimPropertyName"));
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "createComponentPropertyEntry", "...Loading property: " + dBRepositoryProperty.getName());
        }
        dBRepositoryProperty.setDataType(element.getAttribute("dataType"));
        String string7 = element.getAttribute("valueLength");
        if (string7.length() == 0) {
            string7 = dBRepositoryProperty.getDataType().toUpperCase(Locale.ENGLISH).equals("STRING") ? "1500" : "0";
        }
        dBRepositoryProperty.setValueLength(new Integer(string7));
        dBRepositoryProperty.setMetadataName("DEFAULT");
        String string8 = element.getAttribute("multiValued");
        if (string8.length() != 0) {
            dBRepositoryProperty.setMultipleValued(new Boolean(string8));
        }
        if ((string6 = element.getAttribute("readOnly")).length() != 0) {
            dBRepositoryProperty.setReadOnly(new Boolean(string6));
        }
        if ((string5 = element.getAttribute("classname")).length() != 0 && dBRepositoryProperty.getDataType().equalsIgnoreCase("OBJECT")) {
            dBRepositoryProperty.setClassName(string5);
        }
        if ((string4 = element.getAttribute("caseExactMatch")).length() != 0) {
            dBRepositoryProperty.setCaseSensitive(new Boolean(string4));
        }
        if ((string3 = element.getAttribute("description")).length() != 0) {
            dBRepositoryProperty.setDescription(string3);
        }
        dBRepositoryProperty.setApplicationId(string2);
        dBRepositoryProperty.setApplicableEntityTypes(set);
        Integer n = new Integer(-1);
        try {
            n = bl ? this.createDBProp(dBRepositoryProperty) : this.createLAProp(dBRepositoryProperty);
        }
        catch (Exception exception) {
            throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "createComponentPropertyEntry", (Throwable)exception);
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        String string9 = element.getAttribute("requiredInComposite");
        String string10 = element.getAttribute("keyInComposite");
        hashtable2.put("requiredInComposite", string9);
        hashtable2.put("keyInComposite", string10);
        if (n != -1) {
            hashtable.put(n, hashtable2);
        }
        return hashtable;
    }

    public void createSinglePropertyEntry(NodeList nodeList, boolean bl) throws WIMSystemException {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            Element element = (Element)nodeList.item(i);
            DBRepositoryProperty dBRepositoryProperty = new DBRepositoryProperty();
            dBRepositoryProperty.setName(element.getAttribute("wimPropertyName"));
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.logp(Level.FINE, CLASSNAME, "createSinglePropertyEntry", "...Loading property: " + dBRepositoryProperty.getName());
            }
            dBRepositoryProperty.setDataType(element.getAttribute("dataType"));
            String string6 = element.getAttribute("valueLength");
            if (string6.length() == 0) {
                string6 = dBRepositoryProperty.getDataType().toUpperCase(Locale.ENGLISH).equals("STRING") ? "1500" : "0";
            }
            dBRepositoryProperty.setValueLength(new Integer(string6));
            String string7 = element.getAttribute("metadataName");
            if (string7.trim().length() == 0) {
                string7 = "DEFAULT";
            }
            dBRepositoryProperty.setMetadataName(string7);
            String string8 = element.getAttribute("multiValued");
            if (string8.length() != 0) {
                dBRepositoryProperty.setMultipleValued(new Boolean(string8));
            }
            if ((string5 = element.getAttribute("readOnly")).length() != 0) {
                dBRepositoryProperty.setReadOnly(new Boolean(string5));
            }
            if ((string4 = element.getAttribute("classname")).length() != 0 && dBRepositoryProperty.getDataType().equalsIgnoreCase("OBJECT")) {
                dBRepositoryProperty.setClassName(string4);
            }
            if ((string3 = element.getAttribute("caseExactMatch")).length() != 0) {
                dBRepositoryProperty.setCaseSensitive(new Boolean(string3));
            }
            if ((string2 = element.getAttribute("description")).trim().length() != 0) {
                dBRepositoryProperty.setDescription(string2);
            }
            if ((string = element.getAttribute("applicationId")).trim().length() == 0) {
                string = "com.ibm.websphere.wim";
            }
            dBRepositoryProperty.setApplicationId(string);
            NodeList nodeList3 = element.getElementsByTagName("wimprop:applicableEntityName");
            Element element2 = (Element)nodeList3.item(0);
            Set set = this.getEntityNameSet(element2);
            if (set != null) {
                dBRepositoryProperty.setApplicableEntityTypes(set);
            }
            if ((nodeList2 = element.getElementsByTagName("wimprop:requiredEntityName")).getLength() != 0) {
                Element element3 = (Element)nodeList2.item(0);
                Set set2 = this.getEntityNameSet(element3);
                if (set != null) {
                    dBRepositoryProperty.setRequiredEntityTypes(set2);
                }
            }
            try {
                if (bl) {
                    this.createDBProp(dBRepositoryProperty);
                    continue;
                }
                this.createLAProp(dBRepositoryProperty);
                continue;
            }
            catch (Exception exception) {
                throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "createSinglePropertyEntry", (Throwable)exception);
            }
        }
    }

    public void initialize(String string) throws WIMSystemException {
        try {
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.logp(Level.FINE, CLASSNAME, "initialize", "File: " + string + " is processing...");
            }
            DocumentBuilderFactory documentBuilderFactory = ParserFactory.newDocumentBuilderFactory();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            Element element = document.getDocumentElement();
            String string2 = element.getAttribute("repositoryName");
            boolean bl = false;
            if (string2.equalsIgnoreCase("wimDB")) {
                bl = true;
            } else if (string2.equalsIgnoreCase("wimLA")) {
                bl = false;
            } else {
                String string3 = "repositoryName in file " + string + " must be either " + "wimDB" + " or " + "wimLA";
                throw new WIMSystemException(string3, CLASSNAME, "initialize");
            }
            if (trcLogger.isLoggable(Level.FINE)) {
                if (bl) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "initialize", "Loading property data into database repository.");
                } else {
                    trcLogger.logp(Level.FINE, CLASSNAME, "initialize", "Loading property data into lookaside repository");
                }
            }
            this.dbLoaderDao = this.user != null && this.password != null ? new DBLoaderDao(this.dbType, this.url, this.driver, this.user, this.password, this.traceOn) : new DBLoaderDao(this.dbType, this.url, this.driver, this.traceOn);
            if (!bl && element.getElementsByTagName("wimprop:property").getLength() == 0 && element.getElementsByTagName("wimprop:compositeProperty").getLength() == 0) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "initialize", "Checking whether the database exist and also if the tables exist in the database....");
                }
                Connection connection = null;
                try {
                    connection = this.dbLoaderDao.getConnection();
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.logp(Level.FINE, CLASSNAME, "initialize", "Database exists.Now checking whether the tables exist..");
                    }
                    String string4 = this.dbLoaderDao.querySet.selectLAKeys;
                    PreparedStatement preparedStatement = connection.prepareStatement(string4);
                    preparedStatement.executeQuery();
                }
                catch (Exception exception) {
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.logp(Level.FINE, CLASSNAME, "initialize", "Either the database or the tables in the database do not exist ", exception);
                    }
                    if (!(exception.getCause() instanceof SQLException)) {
                        throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "initialize", (Throwable)exception);
                    }
                    throw exception;
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            this.createSinglePropertyEntry(element.getElementsByTagName("wimprop:property"), bl);
            this.createCompositePropertyEntry(element.getElementsByTagName("wimprop:compositeProperty"), bl);
        }
        catch (Exception exception) {
            throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "initialize", (Throwable)exception);
        }
    }
}

