/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dao.schema;

import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.adapter.db.DBCompositeRelation;
import com.ibm.ws.wim.adapter.db.DBProperty;
import com.ibm.ws.wim.adapter.db.DBPropertyEntity;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.LocalKeyManager;
import com.ibm.ws.wim.dao.QuerySet;
import com.ibm.ws.wim.dao.db2.DB2QuerySet;
import com.ibm.ws.wim.lookaside.LACompositeRelation;
import com.ibm.ws.wim.lookaside.LAProperty;
import com.ibm.ws.wim.lookaside.LAPropertyEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class DBLoaderDao {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = DBLoaderDao.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private String url = null;
    private String driver = null;
    private String user = null;
    private String password = null;
    private boolean traceOn;
    QuerySet querySet = new DB2QuerySet();

    public DBLoaderDao() {
    }

    public DBLoaderDao(String string, String string2, String string3, boolean bl) {
        this.url = string2;
        this.driver = string3;
        this.querySet = DAOHelper.getQuerySet(string);
        this.traceOn = bl;
    }

    public DBLoaderDao(String string, String string2, String string3, String string4, String string5, boolean bl) {
        this.url = string2;
        this.driver = string3;
        this.user = string4;
        this.password = string5;
        this.querySet = DAOHelper.getQuerySet(string);
        this.traceOn = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            connection = null;
        }
    }

    public int createDBProperty(DBProperty dBProperty) throws WIMSystemException {
        String string = dBProperty.getTypeId();
        String string2 = dBProperty.getMetadataName();
        int n = dBProperty.getIsComposite();
        int n2 = dBProperty.getValueLength();
        int n3 = dBProperty.getReadOnly();
        int n4 = dBProperty.getMultiValued();
        String string3 = dBProperty.getName();
        int n5 = dBProperty.getCaseExactMatch();
        String string4 = dBProperty.getClassName();
        String string5 = dBProperty.getDescription();
        String string6 = dBProperty.getApplicationId();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            LocalKeyManager localKeyManager = LocalKeyManager.singleton();
            int n6 = new Long(localKeyManager.getDBKeyForTable(connection, "DBPROP")).intValue();
            String string7 = this.querySet.createDBProperty;
            statement = connection.prepareStatement(string7);
            statement.setInt(1, n6);
            statement.setString(2, string3);
            statement.setString(3, string);
            statement.setString(4, string2);
            statement.setInt(5, n);
            statement.setInt(6, n2);
            statement.setInt(7, n3);
            statement.setInt(8, n4);
            statement.setInt(9, n5);
            statement.setString(10, string4);
            statement.setString(11, string5);
            statement.setString(12, string6);
            statement.executeUpdate();
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.logp(Level.FINE, CLASSNAME, "createDBProperty", "attribute " + string3 + " is created with id=" + n6);
            }
            int n7 = n6;
            return n7;
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createDBProperty", (Throwable)sQLException);
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.getMessage()), CLASSNAME, "createDBProperty", (Throwable)namingException);
        }
        finally {
            block12: {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    this.closeConnection(connection);
                }
                catch (Exception exception) {
                    if (!trcLogger.isLoggable(Level.FINE)) break block12;
                    trcLogger.logp(Level.FINE, CLASSNAME, "createDBProperty", exception.getMessage(), exception);
                }
            }
        }
    }

    public void createDBPropertyEntity(DBPropertyEntity dBPropertyEntity) throws WIMSystemException {
        int n = dBPropertyEntity.getPropertyId();
        String string = dBPropertyEntity.getApplicableEntityType();
        int n2 = dBPropertyEntity.getRequiredEntityType();
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string2 = this.querySet.createDBPropertyEntity;
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            preparedStatement.setInt(3, n2);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createDBPropertyEntity", (Throwable)sQLException);
        }
        finally {
            this.closeConnection(connection);
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "createDBPropertyEntity", "Entity Type " + string + " is created for " + n);
        }
    }

    public void createDBCompositeRelation(DBCompositeRelation dBCompositeRelation) throws WIMSystemException {
        int n = dBCompositeRelation.getCompositeId();
        int n2 = dBCompositeRelation.getComponentId();
        int n3 = dBCompositeRelation.getRequiredInComposite();
        int n4 = dBCompositeRelation.getKeyInComposite();
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string = this.querySet.createDBCompositeRelation;
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            preparedStatement.setInt(3, n3);
            preparedStatement.setInt(4, n4);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createDBCompositeRelation", (Throwable)sQLException);
        }
        finally {
            this.closeConnection(connection);
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "createDBCompositeRelation", "component " + n2 + " is set for parent composite " + n);
        }
    }

    public int createLAProperty(LAProperty lAProperty) throws WIMSystemException {
        String string = lAProperty.getName();
        String string2 = lAProperty.getDatatypeId();
        String string3 = lAProperty.getMetadataName();
        int n = lAProperty.getIsComposite();
        int n2 = lAProperty.getValueLength();
        int n3 = lAProperty.getReadOnly();
        int n4 = lAProperty.getMultiValued();
        int n5 = lAProperty.getCaseExactMatch();
        String string4 = lAProperty.getClassname();
        String string5 = lAProperty.getDescription();
        String string6 = lAProperty.getApplicationId();
        Connection connection = null;
        try {
            connection = this.getConnection();
            LocalKeyManager localKeyManager = LocalKeyManager.singleton();
            int n6 = new Long(localKeyManager.getLAKeyForTable(connection, "LAPROP")).intValue();
            String string7 = this.querySet.createLAProperty;
            PreparedStatement preparedStatement = connection.prepareStatement(string7);
            preparedStatement.setLong(1, n6);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            preparedStatement.setString(4, string3);
            preparedStatement.setInt(5, n);
            preparedStatement.setInt(6, n2);
            preparedStatement.setInt(7, n3);
            preparedStatement.setInt(8, n4);
            preparedStatement.setInt(9, n5);
            preparedStatement.setString(10, string4);
            preparedStatement.setString(11, string5);
            preparedStatement.setString(12, string6);
            preparedStatement.executeUpdate();
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.logp(Level.FINE, CLASSNAME, "createLAProperty", "Prooerty  " + string + " is created with id=" + n6);
            }
            int n7 = n6;
            return n7;
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createLAProperty", (Throwable)sQLException);
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.getMessage()), CLASSNAME, "createLAProperty", (Throwable)namingException);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    public void createLAPropertyEntity(LAPropertyEntity lAPropertyEntity) throws WIMSystemException {
        int n = lAPropertyEntity.getPropertyId();
        String string = lAPropertyEntity.getApplicableEntityType();
        int n2 = lAPropertyEntity.getRequiredEntityType();
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string2 = this.querySet.createLAPropertyEntity;
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            preparedStatement.setInt(3, n2);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createLAPropertyEntity", (Throwable)sQLException);
        }
        finally {
            this.closeConnection(connection);
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "createLAPropertyEntity", "Entity Type " + string + " is created for " + n);
        }
    }

    public void createLACompositeRelation(LACompositeRelation lACompositeRelation) throws WIMSystemException {
        int n = lACompositeRelation.getCompositeId();
        int n2 = lACompositeRelation.getComponentId();
        int n3 = lACompositeRelation.getRequiredInComposite();
        int n4 = lACompositeRelation.getKeyInComposite();
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string = this.querySet.createLACompositeRelation;
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            preparedStatement.setInt(3, n3);
            preparedStatement.setInt(4, n4);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createLACompositeRelation", (Throwable)sQLException);
        }
        finally {
            this.closeConnection(connection);
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "createLACompositeRelation", "component " + n2 + " is set for parent composite " + n);
        }
    }

    public Connection getConnection() throws WIMSystemException {
        return this.makeConnection();
    }

    public Connection makeConnection() throws WIMSystemException {
        trcLogger.entering(CLASSNAME, "makeConnection");
        Properties properties = new Properties();
        if (this.user != null && this.password != null) {
            properties.put("user", this.user);
            properties.put("password", this.password);
        }
        Connection connection = DAOHelper.createConnection(this.driver, this.url, properties);
        trcLogger.exiting(CLASSNAME, "makeConnection");
        return connection;
    }
}

