/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dao.schema;

import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.dao.DAOHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDBCConnection {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = JDBCConnection.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final String JDBC_USER_PARAMETER = "user";
    private static final String JDBC_USER_PASSWORD_PARAMETER = "password";
    private String jdbcURL = null;
    private String jdbcDriver = null;
    private Properties jdbcProperties = new Properties();
    private int jdbcIsolationLevel = 2;

    private Class loadJDBCClass() throws WIMSystemException {
        return DAOHelper.loadJDBCClass(this.jdbcDriver);
    }

    public Connection getConnection() throws WIMSystemException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getConnection");
        }
        Connection connection = null;
        try {
            trcLogger.logp(Level.FINEST, CLASSNAME, "getConnection", "Loading JDBC driver with external class loader");
            Class clazz = this.loadJDBCClass();
            trcLogger.logp(Level.FINEST, CLASSNAME, "getConnection", "Creating driver instance");
            Object t = clazz.newInstance();
            Method method2 = clazz.getMethod("connect", String.class, Properties.class);
            trcLogger.logp(Level.FINEST, CLASSNAME, "getConnection", "Invoking connect() method on driver");
            connection = (Connection)method2.invoke(t, this.jdbcURL, this.jdbcProperties);
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINEST, CLASSNAME, "getConnection", "Caught exception", exception);
            if (exception instanceof InvocationTargetException && exception.getCause() instanceof SQLException) {
                SQLException sQLException = (SQLException)exception.getCause();
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getConnection", (Throwable)sQLException);
            }
            try {
                if (this.jdbcDriver != null) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "getConnection", "Loading JDBC driver with default class loader " + this.jdbcDriver);
                    Class.forName(this.jdbcDriver);
                }
                trcLogger.logp(Level.FINEST, CLASSNAME, "getConnection", "Calling DriverManager() to get JDBC connection");
                connection = DriverManager.getConnection(this.jdbcURL, this.jdbcProperties);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(classNotFoundException.getMessage()), CLASSNAME, "getConnection", (Throwable)classNotFoundException);
            }
            catch (SQLException sQLException) {
                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getConnection", (Throwable)sQLException);
            }
            catch (Exception exception2) {
                throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "getConnection", (Throwable)exception);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getConnection");
        }
        return connection;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public String getJdbcUser() {
        return this.jdbcProperties.getProperty(JDBC_USER_PARAMETER);
    }

    public String getJdbcUserPassword() {
        return this.jdbcProperties.getProperty(JDBC_USER_PASSWORD_PARAMETER);
    }

    public void setJdbcDriver(String string) {
        this.jdbcDriver = string;
    }

    public void setJdbcURL(String string) {
        this.jdbcURL = string;
    }

    public void setJdbcUser(String string) {
        this.jdbcProperties.put(JDBC_USER_PARAMETER, string);
    }

    public void setJdbcUserPassword(String string) {
        this.jdbcProperties.put(JDBC_USER_PASSWORD_PARAMETER, string);
    }

    public void setJdbcIsolationLevel(int n) {
        this.jdbcIsolationLevel = n;
    }

    public String getJdbcProperty(String string) {
        return this.jdbcProperties.getProperty(string);
    }

    public void setJdbcProperty(String string, String string2) {
        this.jdbcProperties.put(string, string2);
    }

    public Enumeration getJdbcPropertyNames() {
        return this.jdbcProperties.keys();
    }

    public void removeJdbcProperty(String string) {
        this.jdbcProperties.remove(string);
    }

    public void removeAllJdbcProperties() {
        this.jdbcProperties.clear();
    }
}

