/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dao.schema;

import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.dao.schema.JDBCConnection;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDBCSqlImport {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = JDBCSqlImport.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final char SQL_ENDING_DELIM = ';';
    private static final String SQL_COMMENT = "--";
    private JDBCConnection jdbcConnection = new JDBCConnection();
    private Connection connection = null;
    private boolean debug = false;
    private boolean reportsqlerror = true;

    public JDBCSqlImport(String string, String string2, String string3, String string4) throws WIMSystemException {
        this.jdbcConnection.setJdbcDriver(string2);
        this.jdbcConnection.setJdbcURL(string);
        this.jdbcConnection.setJdbcUser(string3);
        this.jdbcConnection.setJdbcUserPassword(string4);
        this.connection = this.jdbcConnection.getConnection();
    }

    public JDBCSqlImport(String string, String string2) throws WIMSystemException {
        this.jdbcConnection.setJdbcDriver(string2);
        this.jdbcConnection.setJdbcURL(string);
        this.connection = this.jdbcConnection.getConnection();
    }

    public void importFile(String string) throws WIMSystemException {
        if (trcLogger.isLoggable(Level.INFO)) {
            trcLogger.logp(Level.INFO, CLASSNAME, "importFile(String file)", "opening file:  " + string);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            int n = -1;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStreamReader.read()) != -1) {
                if ((char)n == ';') {
                    block13: {
                        if (stringBuffer.length() > 0) {
                            int n2;
                            String string2 = stringBuffer.toString().trim();
                            if (string2.startsWith(SQL_COMMENT) && (n2 = string2.lastIndexOf(SQL_COMMENT)) > 0) {
                                string2 = string2.substring(n2 + 2);
                            }
                            if (trcLogger.isLoggable(Level.INFO)) {
                                trcLogger.logp(Level.INFO, CLASSNAME, "importFile(String file)", string2);
                            }
                            try {
                                PreparedStatement preparedStatement = this.connection.prepareStatement(string2);
                                preparedStatement.execute();
                                preparedStatement.close();
                            }
                            catch (SQLException sQLException) {
                                if (string.endsWith("dbclean.sql")) break block13;
                                throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "importFile(String file)", (Throwable)sQLException);
                            }
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    continue;
                }
                stringBuffer.append((char)n);
            }
            if (trcLogger.isLoggable(Level.INFO)) {
                trcLogger.logp(Level.INFO, CLASSNAME, "importFile(String file)", "left over file contents: " + stringBuffer.toString());
            }
            inputStreamReader.close();
            if (trcLogger.isLoggable(Level.INFO)) {
                trcLogger.logp(Level.INFO, CLASSNAME, "importFile(String file)", "import completed!");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WIMSystemException("ERROR_READING_FILE", WIMMessageHelper.generateMsgParms(string, fileNotFoundException.getMessage()), CLASSNAME, "importFile(String file)", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(iOException.getMessage()), CLASSNAME, "importFile(String file)", (Throwable)iOException);
        }
    }

    public static void main(String[] stringArray) throws WIMSystemException {
        int n = stringArray.length;
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        JDBCSqlImport jDBCSqlImport = null;
        if (n == 5) {
            string6 = stringArray[3];
            string7 = stringArray[4];
            jDBCSqlImport = new JDBCSqlImport(string2, string3);
        } else {
            string4 = stringArray[3];
            string5 = stringArray[4];
            string6 = stringArray[5];
            string7 = stringArray[6];
            jDBCSqlImport = new JDBCSqlImport(string2, string3, string4, string5);
        }
        if ("true".equalsIgnoreCase(string6)) {
            jDBCSqlImport.setDebug(true);
        } else {
            jDBCSqlImport.setDebug(false);
        }
        if ("true".equalsIgnoreCase(string7)) {
            jDBCSqlImport.setReportsqlerror(true);
        } else {
            jDBCSqlImport.setReportsqlerror(false);
        }
        jDBCSqlImport.importFile(string);
        jDBCSqlImport.closeConnection();
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setReportsqlerror(boolean bl) {
        this.reportsqlerror = bl;
    }

    public void closeConnection() {
        block3: {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (Exception exception) {
                if (!trcLogger.isLoggable(Level.INFO)) break block3;
                trcLogger.logp(Level.INFO, CLASSNAME, "closeConnection", "encounter problem closing connection: " + exception.getMessage());
            }
        }
    }
}

