/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dao.sqlserver;

import com.ibm.websphere.wim.exception.EntityAlreadyExistsException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.adapter.db.DBEntity;
import com.ibm.ws.wim.dao.AbstractDAO;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.sqlserver.SQLServerQuerySet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class SQLServerDAO
extends AbstractDAO {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public SQLServerDAO(String string, String string2, String string3, String string4, String string5) throws WIMException {
        super("sqlserver", string, string2, string3, string4, string5, new SQLServerQuerySet());
    }

    public Object getBlobValue(ResultSet resultSet, int n) throws SQLException, IOException, ClassNotFoundException {
        byte[] byArray = resultSet.getBytes(n);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public long createDBEntity(DBEntity dBEntity) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createDBEntity");
        }
        String string = dBEntity.getEntityType();
        String string2 = dBEntity.getUniqueId();
        String string3 = dBEntity.getUniqueName();
        String string4 = DAOHelper.getTruncatedUniqueName(string3);
        Connection connection = null;
        Statement statement = null;
        long l = -1L;
        try {
            connection = this.getConnection();
            l = this.getKeyManager().getDBKeyForTable(connection, "DBENTITY");
            String string5 = this.getQuerySet().createDBEntity;
            statement = connection.prepareStatement(string5);
            statement.setLong(1, l);
            statement.setString(2, string);
            statement.setString(3, string2);
            statement.setString(4, string3);
            statement.setString(5, string4);
            statement.executeUpdate();
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", CLASSNAME, "createDBEntity", (Throwable)namingException);
        }
        catch (SQLException sQLException) {
            DBEntity dBEntity2 = this.findDBEntityByUniqueNameKey(string4);
            if (dBEntity2 != null) {
                throw new EntityAlreadyExistsException("ENTITY_ALREADY_EXIST", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, "createDBEntity");
            }
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "createDBEntity", (Throwable)sQLException);
        }
        finally {
            block15: {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    this.closeConnection(connection);
                }
                catch (Exception exception) {
                    if (!trcLogger.isLoggable(Level.FINE)) break block15;
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(exception.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "createDBEntity", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(exception));
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createDBEntity");
        }
        return l;
    }
}

