/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dbsetup;

import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.wim.ConfigConstants;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.config.ValidationHelper;
import com.ibm.ws.wim.config.commands.ConfigCommandHelper;
import com.ibm.ws.wim.dao.schema.DBInitSetup;
import com.ibm.ws.wim.dao.schema.DBLoadManager;
import com.ibm.ws.wim.dao.schema.JDBCSqlImport;
import com.ibm.ws.wim.dbsetup.DBConstants;
import com.ibm.ws.wim.dbsetup.LACleanup;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBSetup
extends SimpleCommandProvider
implements ConfigConstants,
DBConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    private static final String CLASSNAME = DBSetup.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private Map params = null;
    boolean callDBInitSetup = false;
    String[] REPORT_SQL_ERROR_LEGAL = new String[]{"true", "false"};

    private void setParam(String string) throws WIMApplicationException {
        String string2 = null;
        String string3 = null;
        if (string.charAt(0) != '#') {
            int n = string.indexOf("=");
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1, string.length());
            this.params.put(string2, string3);
        }
    }

    private void readParamsFile(String string) throws Exception {
        String string2;
        trcLogger.logp(Level.FINER, CLASSNAME, "readParamsFile", "fileName=" + string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            this.setParam(string2);
        }
        bufferedReader.close();
    }

    private void getParams(AbstractAdminCommand abstractAdminCommand) throws Exception {
        this.params = new HashMap();
        Map map = ConfigCommandHelper.convertToMap(abstractAdminCommand);
        Set set = map.keySet();
        if (set.contains("file")) {
            this.readParamsFile((String)map.get("file"));
        }
        this.params.putAll(map);
        this.setDerbySystemHome();
    }

    private void getParamsWithMV(AbstractAdminCommand abstractAdminCommand) throws Exception {
        this.params = new HashMap();
        Map map = ConfigCommandHelper.convertToMapOfUniques(abstractAdminCommand, null, null, null, LACleanup.getMVParams());
        this.params.putAll(map);
    }

    private void checkCleanIdMgrParams() throws Exception {
        if (this.params.get("schemaLocation") == null) {
            this.throwPropMissingException("schemaLocation");
        }
        if (this.params.get("databaseType") == null) {
            this.throwPropMissingException("databaseType");
        }
        this.validateDBType((String)this.params.get("databaseType"));
        if (this.params.get("dbURL") == null) {
            this.throwPropMissingException("dbURL");
        }
        this.checkReportSQLError();
    }

    private void performTrace() throws Exception {
        Map map = this.params;
        trcLogger.logp(Level.FINER, CLASSNAME, "performTrace", "Specified parameters: " + map);
    }

    private void checkReportSQLError() throws Exception {
        if (this.params.get("reportSqlError") == null) {
            this.params.put("reportSqlError", "false");
        } else {
            String string = (String)this.params.get("reportSqlError");
            ValidationHelper.validateParam("reportSqlError", string, this.REPORT_SQL_ERROR_LEGAL);
            this.params.put("reportSqlError", string.toLowerCase());
        }
    }

    private void checkSetupIdMgrDBParams() throws Exception {
        if (this.params.get("schemaLocation") == null) {
            this.throwPropMissingException("schemaLocation");
        }
        if (this.params.get("databaseType") == null) {
            this.throwPropMissingException("databaseType");
        }
        this.validateDBType((String)this.params.get("databaseType"));
        if (this.params.get("dbURL") == null) {
            this.throwPropMissingException("dbURL");
        }
        if (this.params.get("dbPropXML") == null) {
            this.throwPropMissingException("dbPropXML");
        }
        this.checkReportSQLError();
        if (this.params.get("dn") == null && (this.params.get("wasAdminId") == null || this.params.get("wasAdminPassword") == null)) {
            this.callDBInitSetup = false;
        } else {
            this.callDBInitSetup = true;
            if (this.params.get("dbDriver") == null) {
                this.throwPropMissingException("dbDriver");
            }
            if (!((String)this.params.get("databaseType")).equals("derby")) {
                if (this.params.get("dbAdminId") == null) {
                    this.throwPropMissingException("dbAdminId");
                }
                if (this.params.get("dbAdminPassword") == null) {
                    this.throwPropMissingException("dbAdminPassword");
                }
            }
            if (this.params.get("saltLength") != null && ((String)this.params.get("saltLength")).trim().length() != 0) {
                new Integer((String)this.params.get("saltLength")).intValue();
            }
        }
    }

    private void checkSetupIdMgrLAParams() throws Exception {
        if (this.params.get("schemaLocation") == null) {
            this.throwPropMissingException("schemaLocation");
        }
        if (this.params.get("databaseType") == null) {
            this.throwPropMissingException("databaseType");
        }
        this.validateDBType((String)this.params.get("databaseType"));
        if (this.params.get("dbURL") == null) {
            this.throwPropMissingException("dbURL");
        }
        if (this.params.get("laPropXML") == null) {
            this.throwPropMissingException("laPropXML");
        }
        this.checkReportSQLError();
    }

    private void checkSetupIdMgrFEDParams() throws Exception {
        if (this.params.get("schemaLocation") == null) {
            this.throwPropMissingException("schemaLocation");
        }
        if (this.params.get("databaseType") == null) {
            this.throwPropMissingException("databaseType");
        }
        this.validateDBType((String)this.params.get("databaseType"));
        if (this.params.get("dbURL") == null) {
            this.throwPropMissingException("dbURL");
        }
        this.checkReportSQLError();
    }

    public String deleteIdMgrDBTables(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "deleteIdMgrDBTables";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        this.getParams(abstractAdminCommand);
        this.checkCleanIdMgrParams();
        this.performTrace();
        String[] stringArray = this.getJDBCSqlImportArgs();
        this.cleanDB(stringArray);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return ConfigCommandHelper.getLocalizedMessage(abstractAdminCommand, "COMMAND_COMPLETED_SUCCESSFULLY");
    }

    public String deleteIdMgrPropertyExtensionRepositoryTables(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "deleteIdMgrPropertyExtensionRepositoryTables";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        this.getParams(abstractAdminCommand);
        this.checkCleanIdMgrParams();
        this.performTrace();
        String[] stringArray = this.getJDBCSqlImportArgs();
        this.cleanLA(stringArray);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return ConfigCommandHelper.getLocalizedMessage(abstractAdminCommand, "COMMAND_COMPLETED_SUCCESSFULLY");
    }

    public String deleteIdMgrPropertyExtensionEntityData(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "deleteIdMgrPropertyExtensionEntityData";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        this.getParamsWithMV(abstractAdminCommand);
        String string2 = ConfigCommandHelper.getSessionId(abstractAdminCommand);
        HashMap<String, String> hashMap = new HashMap<String, String>(this.params);
        hashMap.put(LACleanup.CMD_SESSION_ID, string2);
        LACleanup lACleanup = new LACleanup(hashMap);
        lACleanup.deleteLAEntityData();
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return ConfigCommandHelper.getLocalizedMessage(abstractAdminCommand, "COMMAND_COMPLETED_SUCCESSFULLY");
    }

    public String deleteIdMgrEntryMappingRepositoryTables(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "deleteIdMgrEntryMappingRepositoryTables";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        this.getParams(abstractAdminCommand);
        this.checkCleanIdMgrParams();
        this.performTrace();
        String[] stringArray = this.getJDBCSqlImportArgs();
        this.cleanFED(stringArray);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return ConfigCommandHelper.getLocalizedMessage(abstractAdminCommand, "COMMAND_COMPLETED_SUCCESSFULLY");
    }

    public String setupIdMgrDBTables(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "setupIdMgrDBTables";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        this.getParams(abstractAdminCommand);
        this.checkSetupIdMgrDBParams();
        this.performTrace();
        this.validateFile((String)this.params.get("dbPropXML"));
        String[] stringArray = this.getJDBCSqlImportArgs();
        this.setupDB(stringArray);
        String[] stringArray2 = this.getDBLoadArgs();
        this.loadProperties(stringArray2);
        if (this.callDBInitSetup) {
            this.invokeDBInitSetup();
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return ConfigCommandHelper.getLocalizedMessage(abstractAdminCommand, "COMMAND_COMPLETED_SUCCESSFULLY");
    }

    public String setupIdMgrPropertyExtensionRepositoryTables(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "setupIdMgrPropertyExtensionRepositoryTables";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        this.getParams(abstractAdminCommand);
        this.checkSetupIdMgrLAParams();
        this.performTrace();
        this.validateFile((String)this.params.get("laPropXML"));
        String[] stringArray = this.getJDBCSqlImportArgs();
        if (this.params.get("skipDBCreation") == null || !((Boolean)this.params.get("skipDBCreation")).booleanValue()) {
            this.setupLA(stringArray);
        }
        String[] stringArray2 = this.getLALoadArgs();
        this.loadProperties(stringArray2);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return ConfigCommandHelper.getLocalizedMessage(abstractAdminCommand, "COMMAND_COMPLETED_SUCCESSFULLY");
    }

    public String setupIdMgrEntryMappingRepositoryTables(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "setupIdMgrEntryMappingRepositoryTables";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        this.getParams(abstractAdminCommand);
        this.checkSetupIdMgrFEDParams();
        this.performTrace();
        String[] stringArray = this.getJDBCSqlImportArgs();
        this.setupFED(stringArray);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return ConfigCommandHelper.getLocalizedMessage(abstractAdminCommand, "COMMAND_COMPLETED_SUCCESSFULLY");
    }

    private void throwPropMissingException(String string) throws WIMApplicationException {
        String string2 = "throwPropMissingException";
        throw new WIMApplicationException("DB_SETUP_PROPERTY_MISSING", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2);
    }

    private void validateDBType(String string) throws WIMApplicationException {
        ValidationHelper.validateParam("databaseType", string, CONFIG_DB_SUPPORTED_TYPES);
    }

    private String[] getDBLoadArgs() {
        String[] stringArray = new String[]{(String)this.params.get("dbPropXML"), (String)this.params.get("databaseType"), (String)this.params.get("dbURL"), (String)this.params.get("dbDriver"), (String)this.params.get("dbAdminId"), (String)this.params.get("dbAdminPassword"), "true"};
        return stringArray;
    }

    private String[] getLALoadArgs() {
        String[] stringArray = new String[]{(String)this.params.get("laPropXML"), (String)this.params.get("databaseType"), (String)this.params.get("dbURL"), (String)this.params.get("dbDriver"), (String)this.params.get("dbAdminId"), (String)this.params.get("dbAdminPassword"), "true"};
        return stringArray;
    }

    private String[] getJDBCSqlImportArgs() throws Exception {
        String[] stringArray = null;
        stringArray = this.params.get("dbAdminId") != null ? new String[]{null, (String)this.params.get("dbURL"), (String)this.params.get("dbDriver"), (String)this.params.get("dbAdminId"), (String)this.params.get("dbAdminPassword"), "true", (String)this.params.get("reportSqlError")} : new String[]{null, (String)this.params.get("dbURL"), (String)this.params.get("dbDriver"), "true", (String)this.params.get("reportSqlError")};
        return stringArray;
    }

    private void cleanDB(String[] stringArray) throws Exception {
        String string = "cleanDB";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        String string2 = (String)this.params.get("schemaLocation") + DATABASE + (String)this.params.get("databaseType") + File.separator;
        String string3 = string2 + "dbclean.sql";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        this.readSQLFiles(stringArray, arrayList);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }

    private void cleanLA(String[] stringArray) throws Exception {
        String string = "cleanLA";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        String string2 = (String)this.params.get("schemaLocation") + LOOKASIDE + (String)this.params.get("databaseType") + File.separator;
        String string3 = string2 + "dbclean.sql";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        this.readSQLFiles(stringArray, arrayList);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }

    private void cleanFED(String[] stringArray) throws Exception {
        String string = "cleanFED";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        String string2 = (String)this.params.get("schemaLocation") + FEDERATION + (String)this.params.get("databaseType") + File.separator;
        String string3 = string2 + "dbclean.sql";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        this.readSQLFiles(stringArray, arrayList);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }

    private void setupDB(String[] stringArray) throws Exception {
        String string = "setupDB)";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        String string2 = (String)this.params.get("schemaLocation") + DATABASE + (String)this.params.get("databaseType") + File.separator;
        String string3 = (String)this.params.get("schemaLocation") + DATABASE;
        String string4 = string2 + "schema.sql";
        String string5 = string2 + "primarykeys.sql";
        String string6 = string2 + "indexes.sql";
        String string7 = string2 + "references.sql";
        String string8 = string3 + "keys.sql";
        String string9 = string3 + "bootstrap.sql";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string4);
        arrayList.add(string5);
        arrayList.add(string6);
        arrayList.add(string7);
        arrayList.add(string8);
        arrayList.add(string9);
        this.readSQLFiles(stringArray, arrayList);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }

    private void setupLA(String[] stringArray) throws Exception {
        String string = "setupLA";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        String string2 = (String)this.params.get("schemaLocation") + LOOKASIDE + (String)this.params.get("databaseType") + File.separator;
        String string3 = (String)this.params.get("schemaLocation") + LOOKASIDE;
        String string4 = string2 + "schema.sql";
        String string5 = string2 + "primarykeys.sql";
        String string6 = string2 + "indexes.sql";
        String string7 = string2 + "references.sql";
        String string8 = string3 + "keys.sql";
        String string9 = string3 + "bootstrap.sql";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string4);
        arrayList.add(string5);
        arrayList.add(string6);
        arrayList.add(string7);
        arrayList.add(string8);
        arrayList.add(string9);
        this.readSQLFiles(stringArray, arrayList);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }

    private void setupFED(String[] stringArray) throws Exception {
        String string = "setupFED";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        String string2 = (String)this.params.get("schemaLocation") + FEDERATION + (String)this.params.get("databaseType") + File.separator;
        String string3 = string2 + "schema.sql";
        String string4 = string2 + "primarykeys.sql";
        String string5 = string2 + "indexes.sql";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        this.readSQLFiles(stringArray, arrayList);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }

    private void validateSQLFile(List list) throws WIMApplicationException {
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            this.validateFile(string);
        }
    }

    private void validateFile(String string) throws WIMApplicationException {
        String string2 = "validateFile";
        File file = new File(string);
        if (file == null || !file.exists()) {
            throw new WIMApplicationException("FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2);
        }
    }

    private JDBCSqlImport getJDBCSqlImport(String[] stringArray) throws Exception {
        int n = stringArray.length;
        String string = stringArray[1];
        String string2 = stringArray[2];
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        JDBCSqlImport jDBCSqlImport = null;
        if (n == 5) {
            string5 = stringArray[3];
            string6 = stringArray[4];
            jDBCSqlImport = new JDBCSqlImport(string, string2);
        } else {
            string3 = stringArray[3];
            string4 = stringArray[4];
            string5 = stringArray[5];
            string6 = stringArray[6];
            jDBCSqlImport = new JDBCSqlImport(string, string2, string3, string4);
        }
        if ("true".equalsIgnoreCase(string5)) {
            jDBCSqlImport.setDebug(true);
        } else {
            jDBCSqlImport.setDebug(false);
        }
        if ("true".equalsIgnoreCase(string6)) {
            jDBCSqlImport.setReportsqlerror(true);
        } else {
            jDBCSqlImport.setReportsqlerror(false);
        }
        return jDBCSqlImport;
    }

    private void readSQLFiles(String[] stringArray, List list) throws Exception {
        String string = "readSQLFiles";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        this.validateSQLFile(list);
        JDBCSqlImport jDBCSqlImport = this.getJDBCSqlImport(stringArray);
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            trcLogger.log(Level.FINER, "Importing file " + string2);
            jDBCSqlImport.importFile(string2);
        }
        jDBCSqlImport.closeConnection();
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }

    private void invokeDBInitSetup() throws Exception {
        String string = "invokeDBInitSetup";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        DBInitSetup dBInitSetup = new DBInitSetup((String)this.params.get("dn"), (String)this.params.get("wasAdminId"), (String)this.params.get("wasAdminPassword"), (String)this.params.get("encryptionKey"), (String)this.params.get("saltLength"), (String)this.params.get("databaseType"), (String)this.params.get("dbURL"), (String)this.params.get("dbDriver"), (String)this.params.get("dbAdminId"), (String)this.params.get("dbAdminPassword"));
        dBInitSetup.setup();
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }

    public void setDerbySystemHome() throws WIMApplicationException {
        if ("derby".equals((String)this.params.get("databaseType"))) {
            this.validateDerbyHome((String)this.params.get("derbySystemHome"));
            System.setProperty("derby.system.home", (String)this.params.get("derbySystemHome"));
        }
    }

    private void validateDerbyHome(String string) throws WIMApplicationException {
        String string2 = "validateDerbyHome";
        if (string == null) {
            throw new WIMApplicationException("PROPERTY_NOT_DEFINED", WIMMessageHelper.generateMsgParms("derby.system.home"), Level.SEVERE, CLASSNAME, string2);
        }
    }

    private void loadProperties(String[] stringArray) throws Exception {
        String string = "loadProperties";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        int n = stringArray.length;
        boolean bl2 = false;
        if (n == 4) {
            DBLoadManager dBLoadManager = new DBLoadManager(stringArray[1], stringArray[2], stringArray[3], bl2);
            dBLoadManager.initialize(stringArray[0]);
        } else if (n == 5) {
            bl2 = Boolean.valueOf(stringArray[4]);
            DBLoadManager dBLoadManager = new DBLoadManager(stringArray[1], stringArray[2], stringArray[3], bl2);
            dBLoadManager.initialize(stringArray[0]);
        } else if (n == 6) {
            DBLoadManager dBLoadManager = new DBLoadManager(stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], bl2);
            dBLoadManager.initialize(stringArray[0]);
        } else if (n == 7) {
            bl2 = new Boolean(stringArray[6]);
            DBLoadManager dBLoadManager = new DBLoadManager(stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], bl2);
            dBLoadManager.initialize(stringArray[0]);
        } else {
            trcLogger.log(Level.FINER, "Parameters: <filename> <dbtype> <url> <driver> <user> <password> <trace>");
            trcLogger.log(Level.FINER, "If there are no <user id> and <password>, system default user id and password will be used. ");
            trcLogger.log(Level.FINER, "If there are any spaces in the parameter, double quote is needed.");
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }
}

