/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.dbsetup;

import com.ibm.websphere.wim.ConfigConstants;
import com.ibm.websphere.wim.exception.InvalidSchemaException;
import com.ibm.websphere.wim.exception.PropertyNotDefinedException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.DataAccessObject;
import com.ibm.ws.wim.dbsetup.DBConstants;
import com.ibm.ws.wim.schema.SchemaValidator;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LACleanup
implements ConfigConstants,
DBConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2009";
    private static final String CLASSNAME = LACleanup.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private Map params = null;
    private static List mvParams = null;
    public static String CMD_SESSION_ID = "CMD_SESSION_ID";

    public LACleanup(Map map) {
        this.params = map;
    }

    public static List getMVParams() {
        if (mvParams == null) {
            mvParams = new ArrayList();
            mvParams.add("entityTypeNames");
        }
        return mvParams;
    }

    private String getNSPrefix(String string) throws WIMApplicationException {
        String string2 = "getNSPrefix";
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, string2, "qualifiedName=" + string);
        }
        String string3 = null;
        int n = string.indexOf(":");
        if (n > 1) {
            string3 = string.substring(0, n);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string2, "typeNsPrefix=" + string3);
        }
        return string3;
    }

    private void validatePropertyForApplicableEntTypes(String string, List list) throws Exception {
        String string2 = "validatePropertyForApplicableEntTypes";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string2, "qPropname=" + string + ", entList=" + list);
        }
        String string3 = this.getNSPrefix(string);
        if (null == SchemaManager.singleton().getNsURI(string3)) {
            throw new InvalidSchemaException("INVALID_NS_PREFIX_FOR_ENTITY_TYPE_OR_PROPERTY", WIMMessageHelper.generateMsgParms(string3, string), Level.FINER, CLASSNAME, string2);
        }
        String string4 = this.getLATypeNameFromQTypeName(string);
        this.params.put("name", string4);
        if (list != null && list.size() > 0) {
            SchemaManager schemaManager = SchemaManager.singleton();
            for (int i = 0; i < list.size(); ++i) {
                String string5 = (String)list.get(i);
                if (schemaManager.getProperty(string5, string) != null) continue;
                throw new PropertyNotDefinedException("PROPERTY_NOT_DEFINED_FOR_ENTITY", WIMMessageHelper.generateMsgParms(string, string5), CLASSNAME, string2);
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, string2);
        }
    }

    private String getLATypeNameFromQTypeName(String string) throws Exception {
        String string2 = "getLATypeNameFromQTypeName";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string2, "typeName=" + string);
        }
        String string3 = string;
        String string4 = this.getNSPrefix(string);
        if (string4 != null) {
            SchemaManager schemaManager = SchemaManager.singleton();
            String string5 = string3 = string4.equalsIgnoreCase("wim") ? schemaManager.getTypeName(string) : string;
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, string2, "laTypeName=" + string3);
        }
        return string3;
    }

    private void validateEntityNames(List list) throws Exception {
        String string = "validateEntityNames";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string, "input entity type List : " + list);
        }
        if (list != null && list.size() > 0) {
            SchemaValidator.validateEntityTypeName(list);
            for (int i = 0; i < list.size(); ++i) {
                String string2 = this.getNSPrefix((String)list.get(i));
                if (null == SchemaManager.singleton().getNsURI(string2)) {
                    throw new InvalidSchemaException("INVALID_NS_PREFIX_FOR_ENTITY_TYPE_OR_PROPERTY", WIMMessageHelper.generateMsgParms(string2, (String)list.get(i)), Level.FINER, CLASSNAME, string);
                }
                list.set(i, this.getLATypeNameFromQTypeName((String)list.get(i)));
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, string, "input entity type list after stripping wim nsprefix: " + list);
        }
    }

    private void validateLAConfiguration(String string, String string2) throws Exception {
        String string3 = "validateLAConfiguration";
        DataObject dataObject = null;
        String string4 = (String)this.params.get(CMD_SESSION_ID);
        dataObject = (DataObject)ConfigUtils.getRepositoryByIdIncludeLAandFED(string4, "LA");
        if (dataObject == null) {
            throw new WIMConfigurationException("PROPERTY_EXTENSION_REPOSITORY_NOT_DEFINED", CLASSNAME, string3);
        }
        String string5 = dataObject.getString("databaseType");
        String string6 = dataObject.getString("dbURL");
        String string7 = dataObject.getString("dataSourceName");
        String string8 = dataObject.getString("JDBCDriverClass");
        this.params.put("databaseType", string5);
        this.params.put("dbURL", string6);
        this.params.put("dataSourceName", string7);
        this.params.put("JDBCDriverClass", string8);
        this.params.put("dbAdminId", string);
        this.params.put("dbAdminPassword", string2);
    }

    private void validateAllParams() throws Exception {
        List list = (List)this.params.get("entityTypeNames");
        String string = (String)this.params.get("name");
        String string2 = (String)this.params.get("dbAdminId");
        String string3 = (String)this.params.get("dbAdminPassword");
        if (list != null && list.size() > 0) {
            this.validateEntityNames(list);
            this.validatePropertyForApplicableEntTypes(string, list);
        }
        this.validateLAConfiguration(string2, string3);
    }

    public void deleteLAEntityData() throws Exception {
        String string = "deleteLAEntityData";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string, "input params=" + WIMTraceHelper.printMapWithoutPassword(this.params));
        }
        this.validateAllParams();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, string, "input params after validation=" + WIMTraceHelper.printMapWithoutPassword(this.params));
        }
        DataAccessObject dataAccessObject = DAOHelper.getNewDAOClass((String)this.params.get("databaseType"), (String)this.params.get("dataSourceName"), (String)this.params.get("dbURL"), (String)this.params.get("dbAdminId"), (String)this.params.get("dbAdminPassword"), (String)this.params.get("JDBCDriverClass"));
        dataAccessObject.deleteLAPropertyDataForEntityTypes((String)this.params.get("name"), (List)this.params.get("entityTypeNames"));
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }
}

