/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.federation;

import com.ibm.websphere.wim.DynamicConfigService;
import com.ibm.websphere.wim.exception.DynamicUpdateConfigException;
import com.ibm.websphere.wim.exception.InitializationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.util.UniqueIdGenerator;
import com.ibm.ws.wim.RepositoryManager;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.DataAccessObject;
import com.ibm.ws.wim.federation.FederationEntity;
import com.ibm.ws.wim.federation.FederationRepository;
import commonj.sdo.DataObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class FederationAdapter
implements FederationRepository,
DynamicConfigService {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = FederationAdapter.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final String SCHEMA_UNIQUE_ID = "UNIQUE_ID";
    private static final String SCHEMA_UNIQUE_NAME = "UNIQUE_NAME";
    private static final String SCHEMA_UNIQUE_NAME_KEY = "UNIQUE_NAME_KEY";
    private static final String SCHEMA_ENTITY_TYPE = "ENTITY_TYPE";
    private static final String SCHEMA_REPOSITORY_ID = "REPOS_ID";
    private static final String SCHEMA_EXTERNAL_ID = "EXT_ID";
    private static final String SCHEMA_FULL_EXTERNAL_ID = "FULL_EXT_ID";
    private DataAccessObject dao = null;

    public String create(String string, String string2, String string3, String string4) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "create(entityType,uniqueName,repositoryId,externalId)", "( " + string + ", " + string2 + ", " + string3 + ", " + string4 + ")");
        }
        String string5 = null;
        string5 = RepositoryManager.singleton().isGenerateUniqueId(string3) ? UniqueIdGenerator.newUniqueId() : string4;
        FederationEntity federationEntity = new FederationEntity();
        federationEntity.setEntityType(string);
        federationEntity.setUniqueId(string5);
        federationEntity.setRepositoryId(string3);
        federationEntity.setExternalId(string4);
        federationEntity.setUniqueName(string2);
        try {
            this.createFederationEntity(federationEntity);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "create(entityType,uniqueName,repositoryId,externalId)", (Throwable)sQLException);
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.getMessage()), CLASSNAME, "create(entityType,uniqueName,repositoryId,externalId)", (Throwable)namingException);
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "create(entityType,uniqueName,repositoryId,externalId)", (Throwable)exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string5 + " " + "create(entityType,uniqueName,repositoryId,externalId)");
        }
        return string5;
    }

    public FederationEntity get(String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "get(repositoryId,extId)", "( " + string + ", " + string2 + " )");
        }
        FederationEntity federationEntity = null;
        try {
            FederationEntity federationEntity2 = this.findFederationEntityByRepositoryIdAndExternalId(string, string2);
            if (federationEntity2 != null) {
                federationEntity = federationEntity2;
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "get(repositoryId,extId)", (Throwable)sQLException);
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.getMessage()), CLASSNAME, "get(repositoryId,extId)", (Throwable)namingException);
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "get(repositoryId,extId)", (Throwable)exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, federationEntity + " " + "get(repositoryId,extId)");
        }
        return federationEntity;
    }

    public FederationEntity get(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "get(uniqueId)", "( " + string + ")");
        }
        FederationEntity federationEntity = null;
        try {
            FederationEntity federationEntity2 = this.findFederationEntityByEntityId(string);
            if (federationEntity2 != null) {
                federationEntity = federationEntity2;
            }
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "get(uniqueId)", (Throwable)sQLException);
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.getMessage()), CLASSNAME, "get(uniqueId)", (Throwable)namingException);
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "get(uniqueId)", (Throwable)exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, federationEntity + " " + "get(uniqueId)");
        }
        return federationEntity;
    }

    public Map lookup(String string, Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "lookup(repositoryId,extIds)", "(" + string + ", " + set + " )");
        }
        Map map = null;
        try {
            map = this.findFederationEntitiesByRepositoryIdAndExternalIds(string, set);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "lookup(repositoryId,extIds)", (Throwable)sQLException);
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.getMessage()), CLASSNAME, "lookup(repositoryId,extIds)", (Throwable)namingException);
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "lookup(repositoryId,extIds)", (Throwable)exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, map + " " + "lookup(repositoryId,extIds)");
        }
        return map;
    }

    public void remove(FederationEntity federationEntity) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "remove( fedEntity )", "" + federationEntity);
        }
        try {
            this.removeFederationEntity(federationEntity);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "remove( fedEntity )", (Throwable)sQLException);
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.getMessage()), CLASSNAME, "remove( fedEntity )", (Throwable)namingException);
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "remove( fedEntity )", (Throwable)exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "remove( fedEntity )");
        }
    }

    public void updateExtId(String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateExtId(uniqueId,newExtId)", "( " + string + ", " + string2 + " )");
        }
        try {
            this.updateFederationExternalIdByUniqueId(string, string2);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "updateExtId(uniqueId,newExtId)", (Throwable)sQLException);
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.getMessage()), CLASSNAME, "updateExtId(uniqueId,newExtId)", (Throwable)namingException);
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "updateExtId(uniqueId,newExtId)", (Throwable)exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updateExtId(uniqueId,newExtId)");
        }
    }

    public boolean initialize(DataObject dataObject) throws WIMException {
        if (dataObject == null) {
            throw new InitializationException("GENERIC", WIMMessageHelper.generateMsgParms("configObj is null."), CLASSNAME, "initialize");
        }
        String string = dataObject.getString("dataSourceName");
        String string2 = dataObject.getString("databaseType");
        String string3 = dataObject.getString("dbURL");
        String string4 = dataObject.getString("dbAdminId");
        String string5 = dataObject.getString("dbAdminPassword");
        String string6 = dataObject.getString("JDBCDriverClass");
        if (string == null || string.length() == 0) {
            string = "jdbc/wimDS";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "db2";
        }
        this.dao = DAOHelper.getNewDAOClass(string2, string, string3, string4, string5, string6);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFederationEntity(FederationEntity federationEntity) throws Exception {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createFederationEntity");
        }
        String string = federationEntity.getEntityType();
        String string2 = federationEntity.getUniqueId();
        String string3 = federationEntity.getExternalId();
        String string4 = federationEntity.getRepositoryId();
        String string5 = federationEntity.getUniqueName();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string3);
        Map map = this.findFederationEntitiesByRepositoryIdAndExternalIds(string4, hashSet);
        if (map != null && map.size() == 1) {
            FederationEntity federationEntity2 = (FederationEntity)map.get(string3);
            String string6 = federationEntity2.getUniqueId();
            this.updateFederationUniqueNameByUniqueId(string6, string5);
            return;
        }
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            String string7 = this.dao.getQuerySet().createFederationEntity;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "createFederationEntity", string7);
            }
            statement = connection.prepareStatement(string7);
            statement.setString(1, string2);
            statement.setString(2, DAOHelper.getTruncatedUniqueName(string5));
            statement.setString(3, string5);
            statement.setString(4, string);
            statement.setString(5, string4);
            statement.setString(6, DAOHelper.getTruncatedExternalId(string3));
            statement.setString(7, string3);
            statement.executeUpdate();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.dao.closeConnection(connection);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createFederationEntity");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FederationEntity findFederationEntityByRepositoryIdAndExternalId(String string, String string2) throws Exception {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "findFederationEntityByrepositoryIdAndExternalId(repId,extId)");
        }
        Connection connection = this.dao.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        FederationEntity federationEntity = new FederationEntity();
        try {
            String string3 = this.dao.getQuerySet().findFederationEntityByRepositoryAndExternalId;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "findFederationEntityByrepositoryIdAndExternalId(repId,extId)", string3);
            }
            statement = connection.prepareStatement(string3);
            statement.setString(1, string);
            statement.setString(2, DAOHelper.getTruncatedExternalId(string2));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                federationEntity.setUniqueId(resultSet.getString(SCHEMA_UNIQUE_ID));
                federationEntity.setUniqueName(resultSet.getString(SCHEMA_UNIQUE_NAME));
                federationEntity.setEntityType(resultSet.getString(SCHEMA_ENTITY_TYPE));
                federationEntity.setRepositoryId(resultSet.getString(SCHEMA_REPOSITORY_ID));
                federationEntity.setExternalId(resultSet.getString(SCHEMA_FULL_EXTERNAL_ID));
            } else {
                federationEntity = null;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.dao.closeConnection(connection);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "findFederationEntityByrepositoryIdAndExternalId(repId,extId)", federationEntity);
        }
        return federationEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FederationEntity findFederationEntityByEntityId(String string) throws Exception {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "findFederationEntityByEntityId(uniqueId)");
        }
        Connection connection = this.dao.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        FederationEntity federationEntity = new FederationEntity();
        try {
            String string2 = this.dao.getQuerySet().findFederationEntityByUniqueId;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "findFederationEntityByEntityId(uniqueId)", string2);
            }
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                federationEntity.setUniqueId(resultSet.getString(SCHEMA_UNIQUE_ID));
                federationEntity.setUniqueName(resultSet.getString(SCHEMA_UNIQUE_NAME));
                federationEntity.setEntityType(resultSet.getString(SCHEMA_ENTITY_TYPE));
                federationEntity.setRepositoryId(resultSet.getString(SCHEMA_REPOSITORY_ID));
                federationEntity.setExternalId(resultSet.getString(SCHEMA_FULL_EXTERNAL_ID));
            } else {
                federationEntity = null;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.dao.closeConnection(connection);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "findFederationEntityByEntityId(uniqueId)", federationEntity);
        }
        return federationEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FederationEntity findFederationEntityByUniqueName(String string) throws Exception {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "findFederationEntityByUniqueName(uniqueName)");
        }
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Connection connection = this.dao.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        FederationEntity federationEntity = new FederationEntity();
        try {
            String string2 = this.dao.getQuerySet().findFederationEntityByUniqueName;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "findFederationEntityByUniqueName(uniqueName)", string2);
            }
            statement = connection.prepareStatement(string2);
            statement.setString(1, DAOHelper.getTruncatedUniqueName(string));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                federationEntity.setUniqueId(resultSet.getString(SCHEMA_UNIQUE_ID));
                federationEntity.setUniqueName(resultSet.getString(SCHEMA_UNIQUE_NAME));
                federationEntity.setEntityType(resultSet.getString(SCHEMA_ENTITY_TYPE));
                federationEntity.setRepositoryId(resultSet.getString(SCHEMA_REPOSITORY_ID));
                federationEntity.setExternalId(resultSet.getString(SCHEMA_FULL_EXTERNAL_ID));
            } else {
                federationEntity = null;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.dao.closeConnection(connection);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "findFederationEntityByUniqueName(uniqueName)", federationEntity);
        }
        return federationEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map findFederationEntitiesByRepositoryIdAndExternalIds(String string, Set set) throws Exception {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "findFederationEntitiesByRepositoryIdAndExternalIds(repositoryId,externalIdSet)");
        }
        Connection connection = this.dao.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        HashMap<String, FederationEntity> hashMap = new HashMap<String, FederationEntity>();
        try {
            int n;
            String string2 = this.dao.getQuerySet().findFederationEntitiesByReposIdAndExtIds;
            int n2 = set.size();
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < n2; ++n) {
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(this.dao.getQuerySet().PARAM_MARKER);
                    continue;
                }
                stringBuffer.append(this.dao.getQuerySet().COMMA_AND_SPACE + this.dao.getQuerySet().PARAM_MARKER);
            }
            string2 = string2 + stringBuffer.toString() + this.dao.getQuerySet().RIGHT_BRACKET;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "findFederationEntitiesByRepositoryIdAndExternalIds(repositoryId,externalIdSet)", string2);
            }
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            n = 2;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                statement.setString(n++, DAOHelper.getTruncatedExternalId((String)iterator.next()));
            }
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                hashMap.put(resultSet.getString(SCHEMA_FULL_EXTERNAL_ID), new FederationEntity(resultSet.getString(SCHEMA_UNIQUE_ID), resultSet.getString(SCHEMA_UNIQUE_NAME), resultSet.getString(SCHEMA_ENTITY_TYPE), resultSet.getString(SCHEMA_REPOSITORY_ID), resultSet.getString(SCHEMA_FULL_EXTERNAL_ID)));
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.dao.closeConnection(connection);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "findFederationEntitiesByRepositoryIdAndExternalIds(repositoryId,externalIdSet)", hashMap);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFederationEntity(FederationEntity federationEntity) throws Exception {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "removeFederationEntity(fedEntity)");
        }
        Connection connection = this.dao.getConnection();
        Statement statement = null;
        Object var5_4 = null;
        try {
            String string = federationEntity.getUniqueId();
            String string2 = federationEntity.getUniqueName();
            String string3 = federationEntity.getExternalId();
            String string4 = federationEntity.getRepositoryId();
            if (string != null && string.length() > 0) {
                String string5 = this.dao.getQuerySet().removeFederationEntityByEntityId;
                statement = connection.prepareStatement(string5);
                statement.setString(1, string);
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "removeFederationEntity(fedEntity)", string5 + ", uniqueId = " + string);
                }
            } else if (string2 != null && string2.length() > 0) {
                String string6 = this.dao.getQuerySet().removeFederationEntityByEntityName;
                statement = connection.prepareStatement(string6);
                statement.setString(1, DAOHelper.getTruncatedUniqueName(string2));
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "removeFederationEntity(fedEntity)", string6 + ", uniqueName = " + string2);
                }
            } else {
                String string7 = this.dao.getQuerySet().removeFederationEntityByExternalId;
                statement = connection.prepareStatement(string7);
                statement.setString(1, string4);
                statement.setString(2, DAOHelper.getTruncatedExternalId(string3));
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "removeFederationEntity(fedEntity)", string7 + ", repositoryId = " + string4 + "/externalId = " + string3);
                }
            }
            statement.executeUpdate();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.dao.closeConnection(connection);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "removeFederationEntity(fedEntity)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFederationExternalIdByUniqueId(String string, String string2) throws Exception {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateFederationExternalIdByUniqueId(niqueId,newExtId)");
        }
        Connection connection = this.dao.getConnection();
        Statement statement = null;
        Object var6_5 = null;
        try {
            String string3 = this.dao.getQuerySet().updateFederationExternalIdByUniqueId;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "updateFederationExternalIdByUniqueId(niqueId,newExtId)", string3);
            }
            statement = connection.prepareStatement(string3);
            statement.setString(1, string2);
            statement.setString(2, DAOHelper.getTruncatedExternalId(string2));
            statement.setString(3, string);
            statement.executeUpdate();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.dao.closeConnection(connection);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updateFederationExternalIdByUniqueId(niqueId,newExtId)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFederationUniqueNameByUniqueId(String string, String string2) throws Exception {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateFederationUniqueNameByUniqueId(uniqueid,uniqueName)");
        }
        Connection connection = this.dao.getConnection();
        Statement statement = null;
        Object var6_5 = null;
        try {
            String string3 = this.dao.getQuerySet().updateFederationUniqueNameByUniqueId;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "updateFederationUniqueNameByUniqueId(uniqueid,uniqueName)", string3);
            }
            statement = connection.prepareStatement(string3);
            statement.setString(1, string2);
            statement.setString(2, DAOHelper.getTruncatedUniqueName(string2));
            statement.setString(3, string);
            statement.executeUpdate();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.dao.closeConnection(connection);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updateFederationUniqueNameByUniqueId(uniqueid,uniqueName)");
        }
    }

    private Connection getConnection() throws WIMException {
        return this.dao.getConnection();
    }

    public FederationEntity lookupByUniqueId(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "lookupByUniqueId(uniqueId)");
        }
        FederationEntity federationEntity = null;
        try {
            federationEntity = this.findFederationEntityByEntityId(string);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "lookupByUniqueId(uniqueId)", (Throwable)sQLException);
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.getMessage()), CLASSNAME, "lookupByUniqueId(uniqueId)", (Throwable)namingException);
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "lookupByUniqueId(uniqueId)", (Throwable)exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "lookupByUniqueId(uniqueId)", federationEntity);
        }
        return federationEntity;
    }

    public FederationEntity lookupByUniqueName(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "lookupByUniqueName(uniqueName)");
        }
        FederationEntity federationEntity = null;
        try {
            federationEntity = this.findFederationEntityByUniqueName(string);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "lookupByUniqueName(uniqueName)", (Throwable)sQLException);
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.getMessage()), CLASSNAME, "lookupByUniqueName(uniqueName)", (Throwable)namingException);
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "lookupByUniqueName(uniqueName)", (Throwable)exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "lookupByUniqueName(uniqueName)", federationEntity);
        }
        return federationEntity;
    }

    public void updateUniqueName(String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateUniqueName(uniqueId,uniqueName)");
        }
        try {
            this.updateFederationUniqueNameByUniqueId(string, string2);
        }
        catch (SQLException sQLException) {
            throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "updateUniqueName(uniqueId,uniqueName)", (Throwable)sQLException);
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.getMessage()), CLASSNAME, "updateUniqueName(uniqueId,uniqueName)", (Throwable)namingException);
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "updateUniqueName(uniqueId,uniqueName)", (Throwable)exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updateUniqueName(uniqueId,uniqueName)");
        }
    }

    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "dynamicUpdateConfig(String updateEvent, Map configData)");
        }
        if (string.equals("websphere.usermanager.serviceprovider.update.entrymapping.adminidpassword")) {
            byte[] byArray = (byte[])hashtable.get("DYNA_CONFIG_KEY_DB_ADMIN_PASSWORD");
            try {
                String string2 = new String(byArray, "UTF-8");
                this.dao.reload(string2);
            }
            catch (Exception exception) {
                throw new DynamicUpdateConfigException("REPOSITORY_CONNECTION_FAILED", WIMMessageHelper.generateMsgParms("FED", "DYNA_CONFIG_KEY_DB_ADMIN_PASSWORD"), CLASSNAME, "dynamicUpdateConfig(String updateEvent, Map configData)");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "dynamicUpdateConfig(String updateEvent, Map configData)");
        }
    }
}

