/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.lookaside;

import com.ibm.websphere.wim.DynamicConfigService;
import com.ibm.websphere.wim.common.RepositoryProperty;
import com.ibm.websphere.wim.exception.DynamicUpdateConfigException;
import com.ibm.websphere.wim.exception.InvalidIdentifierException;
import com.ibm.websphere.wim.exception.InvalidPropertyDefinitionException;
import com.ibm.websphere.wim.exception.MissingMandatoryPropertyException;
import com.ibm.websphere.wim.exception.MissingSearchControlException;
import com.ibm.websphere.wim.exception.OperationNotSupportedException;
import com.ibm.websphere.wim.exception.SearchControlException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.DataAccessObject;
import com.ibm.ws.wim.dao.schema.DBDataType;
import com.ibm.ws.wim.dao.schema.DBRepositoryProperty;
import com.ibm.ws.wim.lookaside.LAEntity;
import com.ibm.ws.wim.lookaside.LAPropertyCache;
import com.ibm.ws.wim.lookaside.LookasideRepository;
import com.ibm.ws.wim.util.ControlsHelper;
import com.ibm.ws.wim.xpath.ParseException;
import com.ibm.ws.wim.xpath.TokenMgrError;
import com.ibm.ws.wim.xpath.WIMXPathInterpreter;
import com.ibm.ws.wim.xpath.lookaside.util.LAXPathTranslateHelper;
import com.ibm.ws.wim.xpath.mapping.datatype.XPathNode;
import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LookasideAdapter
implements LookasideRepository,
DynamicConfigService {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = LookasideAdapter.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final String PROPKEY_ROOT = "Root";
    private static final String PROPKEY_ANCESTORS = "Ancestors";
    private static final String PROPKEY_DESCENDENTS = "Descendents";
    private static final String PROPKEY_GROUPMEMBERS = "GroupMembers";
    private static final String PROPKEY_GROUPMEMBERSHIP = "GroupMembership";
    SchemaManager schemaMgr = null;
    String reposId = "LA";
    int entityRetrievalLimit = 200;
    DataAccessObject dao = null;
    LAPropertyCache propertyManager = null;

    public DataObject create(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI create(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        List list = dataObject.getList("entities");
        DataObject dataObject3 = (DataObject)list.get(0);
        String string = dataObject3.getDataObject("identifier").getString("externalId");
        String string2 = this.schemaMgr.getQualifiedTypeName(dataObject3.getType());
        String string3 = dataObject3.getDataObject("identifier").getString("repositoryId");
        if (string == null || string2 == null || string3 == null) {
            throw new InvalidIdentifierException("INVALID_IDENTIFIER", CLASSNAME, "create(DataObject)");
        }
        LAEntity lAEntity = new LAEntity();
        lAEntity.setEntityType(string2);
        lAEntity.setExternalId(string);
        lAEntity.setRepositoryId(string3);
        long l = this.dao.createLAEntity(lAEntity);
        long l2 = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(l2);
        dataObject3.set("createTimestamp", (Object)timestamp);
        dataObject3.set("modifyTimestamp", (Object)timestamp);
        this.createProperties(l, dataObject3);
        DataObject dataObject4 = dataObject2.createDataObject("entities", this.schemaMgr.getTypeNsURI(string2), this.schemaMgr.getTypeName(string2));
        DataObject dataObject5 = dataObject4.createDataObject("identifier");
        dataObject5.setString("externalId", string);
        dataObject5.setString("repositoryId", string3);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI create(DataObject)", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    private void createProperties(long l, DataObject dataObject) throws WIMException {
        Object object;
        Object object2;
        Integer n;
        Object object3;
        Object object4;
        Object object52;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createProperties(long mbrId, DataObject entity)");
        }
        String string = this.schemaMgr.getQualifiedTypeName(dataObject.getType());
        Hashtable[] hashtableArray = new Hashtable[7];
        Hashtable<Integer, Object[]> hashtable = null;
        HashSet hashSet = this.propertyManager.getMandatoryAttributes(string);
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        for (Object object52 : hashSet) {
            object4 = this.schemaMgr.getProperty(string, (String)object52);
            if (dataObject.isSet((Property)object4)) {
                object3 = this.propertyManager.getPropertyDefinition((String)object52);
                n = ((DBRepositoryProperty)object3).getPropId();
                object2 = ((RepositoryProperty)object3).getDataType();
                short s = DAOHelper.getDataTypeId((String)object2);
                if (this.propertyManager.isCompositeProperty((String)object52)) {
                    if (hashtable == null) {
                        hashtable = new Hashtable<Integer, Object[]>();
                    }
                    if (this.propertyManager.isMultivaluedProperty((String)object52)) {
                        object = new Object[]{object52, dataObject.getList((Property)object4)};
                        hashtable.put(n, (Object[])object);
                        continue;
                    }
                    object = new Object[]{object52, dataObject.get((Property)object4)};
                    hashtable.put(n, (Object[])object);
                    continue;
                }
                if (hashtableArray[s] == null) {
                    hashtableArray[s] = new Hashtable();
                }
                if (this.propertyManager.isMultivaluedProperty((String)object52)) {
                    hashtableArray[s].put(n, dataObject.getList((Property)object4));
                    continue;
                }
                hashtableArray[s].put(n, dataObject.get((Property)object4));
                continue;
            }
            object3 = new Object[]{object52};
            throw new MissingMandatoryPropertyException("MISSING_MANDATORY_PROPERTY", (Object[])object3, CLASSNAME, "createProperties(long mbrId, DataObject entity)");
        }
        object52 = this.propertyManager.getSupportedAttributes(string);
        if (object52 == null) {
            object52 = new HashSet();
        }
        object4 = object52.iterator();
        while (object4.hasNext()) {
            object3 = (String)object4.next();
            n = this.schemaMgr.getProperty(string, (String)object3);
            try {
                if (!dataObject.isSet((Property)n) || hashSet.contains(n)) continue;
                object2 = this.propertyManager.getPropertyDefinition((String)object3);
                Integer n2 = ((DBRepositoryProperty)object2).getPropId();
                object = ((RepositoryProperty)object2).getDataType();
                short s = DAOHelper.getDataTypeId((String)object);
                if (this.propertyManager.isCompositeProperty((String)object3)) {
                    Object[] objectArray;
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                    }
                    if (this.propertyManager.isMultivaluedProperty((String)object3)) {
                        objectArray = new Object[]{object3, dataObject.getList((Property)n)};
                        hashtable.put(n2, objectArray);
                        continue;
                    }
                    objectArray = new Object[]{object3, dataObject.get((Property)n)};
                    hashtable.put(n2, objectArray);
                    continue;
                }
                if (hashtableArray[s] == null) {
                    hashtableArray[s] = new Hashtable();
                }
                if (this.propertyManager.isMultivaluedProperty((String)object3)) {
                    hashtableArray[s].put(n2, dataObject.getList((Property)n));
                    continue;
                }
                hashtableArray[s].put(n2, dataObject.get((Property)n));
            }
            catch (Exception exception) {
                throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "createProperties(long mbrId, DataObject entity)", (Throwable)exception);
            }
        }
        this.dao.createProperties((short)1, l, hashtableArray, null, this.propertyManager.getMultiValuePropertyIds(), dataObject.getDataObject("identifier").getString("repositoryId"));
        if (hashtable != null && hashtable.size() != 0) {
            this.createCompositeProperties(l, hashtable, this.propertyManager.getMultiValuePropertyIds());
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createProperties(long mbrId, DataObject entity)");
        }
    }

    private void createCompositeProperties(long l, Hashtable hashtable, Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createCompositeProperties(short schema, long mbrId, Hashtable compAttrs, Set multiValProps)");
        }
        Set set2 = hashtable.keySet();
        for (Integer n : set2) {
            Object[] objectArray = (Object[])hashtable.get(n);
            String string = (String)objectArray[0];
            List<Object> list = null;
            if (set.contains(n)) {
                list = (List)objectArray[1];
            } else {
                list = new ArrayList();
                list.add(objectArray[1]);
            }
            this.createOneCompositeProperty(n, string, l, list, null);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createCompositeProperties(short schema, long mbrId, Hashtable compAttrs, Set multiValProps)");
        }
    }

    private void createOneCompositeProperty(Integer n, String string, long l, List list, Long l2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createOneCompositeProperty");
        }
        for (int i = 0; i < list.size(); ++i) {
            Hashtable[] hashtableArray = new Hashtable[7];
            Long l3 = this.dao.createCompositePropValue((short)1, n, l, null, null);
            DataObject dataObject = (DataObject)list.get(i);
            Set set = (Set)this.propertyManager.getCompositeProperties().get(string);
            Set set2 = this.propertyManager.getRequiredComponentProperties(string);
            for (String string2 : set) {
                Object[] objectArray;
                String string3 = DAOHelper.resumeComponentName(string2, string);
                if (dataObject.isSet(string3)) {
                    objectArray = this.propertyManager.getPropertyDefinition(string2);
                    Integer n2 = objectArray.getPropId();
                    String string4 = objectArray.getDataType();
                    short s = DAOHelper.getDataTypeId(string4);
                    if (this.propertyManager.isCompositeProperty(string2)) {
                        ArrayList<Object> arrayList = null;
                        if (this.propertyManager.isMultivaluedProperty(string2)) {
                            arrayList = dataObject.getList(string3);
                        } else {
                            arrayList = new ArrayList<Object>();
                            arrayList.add(dataObject.get(string3));
                        }
                        this.createOneCompositeProperty(n2, string2, l, arrayList, l3);
                        continue;
                    }
                    if (hashtableArray[s] == null) {
                        hashtableArray[s] = new Hashtable();
                    }
                    if (this.propertyManager.isMultivaluedProperty(string2)) {
                        hashtableArray[s].put(n2, dataObject.getList(string3));
                        continue;
                    }
                    hashtableArray[s].put(n2, dataObject.get(string3));
                    continue;
                }
                if (!set2.contains(string2)) continue;
                objectArray = new Object[]{string3};
                throw new MissingMandatoryPropertyException("MISSING_MANDATORY_PROPERTY", objectArray, CLASSNAME, "createOneCompositeProperty");
            }
            this.dao.createProperties((short)1, l, hashtableArray, l3, this.propertyManager.getMultiValuePropertyIds(), this.reposId);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createOneCompositeProperty");
        }
    }

    public DataObject delete(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI delete(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        List list = dataObject.getList("entities");
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject3 = (DataObject)list.get(i);
                String string = dataObject3.getDataObject("identifier").getString("externalId");
                String string2 = dataObject3.getDataObject("identifier").getString("repositoryId");
                if (string == null || string2 == null) continue;
                this.dao.deleteLAEntity(string, string2);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI delete(DataObject)", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    private String[] getPropertiesForControl(DataObject dataObject) {
        ArrayList<String> arrayList = null;
        List list = null;
        if (dataObject != null) {
            arrayList = new ArrayList(dataObject.getList("properties"));
            list = dataObject.getList("contextProperties");
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject2 = (DataObject)list.get(i);
                arrayList.add(dataObject2.getString("value"));
            }
        } else {
            arrayList = new ArrayList<String>();
        }
        return arrayList.toArray(new String[0]);
    }

    private Map getPropertyNamesMap(DataObject dataObject) {
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject2 = (DataObject)map.get("PropertyControl");
        DataObject dataObject3 = (DataObject)map.get("AncestorControl");
        DataObject dataObject4 = (DataObject)map.get("DescendantControl");
        DataObject dataObject5 = (DataObject)map.get("GroupMemberControl");
        DataObject dataObject6 = (DataObject)map.get("GroupMembershipControl");
        String[] stringArray = this.getPropertiesForControl(dataObject2);
        String[] stringArray2 = this.getPropertiesForControl(dataObject3);
        String[] stringArray3 = this.getPropertiesForControl(dataObject4);
        String[] stringArray4 = this.getPropertiesForControl(dataObject5);
        String[] stringArray5 = this.getPropertiesForControl(dataObject6);
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        hashtable.put(PROPKEY_ROOT, stringArray);
        hashtable.put(PROPKEY_ANCESTORS, stringArray2);
        hashtable.put(PROPKEY_DESCENDENTS, stringArray3);
        hashtable.put(PROPKEY_GROUPMEMBERS, stringArray4);
        hashtable.put(PROPKEY_GROUPMEMBERSHIP, stringArray5);
        return hashtable;
    }

    private void getEntityProperties(DataObject dataObject, String[] stringArray) throws WIMException {
        trcLogger.entering(CLASSNAME, "getEntityProperties(DataObject entity, String propNames[])");
        String string = this.schemaMgr.getQualifiedTypeName(dataObject.getType());
        String string2 = dataObject.getDataObject("identifier").getString("externalId");
        String string3 = dataObject.getDataObject("identifier").getString("repositoryId");
        LAEntity lAEntity = this.dao.findLAEntityByExtIdReposId(string2, string3);
        if (lAEntity != null) {
            String string4 = lAEntity.getEntityType();
            long l = lAEntity.getEntityId();
            dataObject.getDataObject("identifier").setString("repositoryId", lAEntity.getRepositoryId().trim());
            if (stringArray.length > 0) {
                this.getProperties(dataObject, l, stringArray);
            }
        } else {
            trcLogger.logp(Level.FINER, CLASSNAME, "getEntityProperties(DataObject entity, String propNames[])", "[" + string2 + "/" + string3 + "] not found in lookaside repository");
        }
        trcLogger.exiting(CLASSNAME, "getEntityProperties(DataObject entity, String propNames[])");
    }

    private void getRecursively(DataObject dataObject, String string, Map map, boolean bl) throws WIMException {
        DataObject dataObject2;
        int n;
        Object object;
        trcLogger.entering(CLASSNAME, "getRecursively(DataObject entity, String propKey, Map propNamesMap, boolean getAll)");
        this.getEntityProperties(dataObject, (String[])map.get(string));
        if ((bl || string.equals(PROPKEY_ANCESTORS)) && (object = (DataObject)dataObject.get("parent")) != null) {
            this.getRecursively((DataObject)object, PROPKEY_ANCESTORS, map, false);
        }
        if (bl || string.equals(PROPKEY_DESCENDENTS)) {
            object = dataObject.getList("children");
            for (n = 0; n < object.size(); ++n) {
                dataObject2 = (DataObject)object.get(n);
                this.getRecursively(dataObject2, PROPKEY_DESCENDENTS, map, false);
            }
        }
        if (bl || string.equals(PROPKEY_GROUPMEMBERSHIP)) {
            object = dataObject.getList("groups");
            for (n = 0; n < object.size(); ++n) {
                dataObject2 = (DataObject)object.get(n);
                this.getRecursively(dataObject2, PROPKEY_GROUPMEMBERSHIP, map, false);
            }
        }
        if ((bl || string.equals(PROPKEY_GROUPMEMBERS)) && this.schemaMgr.isSuperType("Group", (String)(object = this.schemaMgr.getQualifiedTypeName(dataObject.getType())))) {
            List list = dataObject.getList("members");
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject3 = (DataObject)list.get(i);
                this.getRecursively(dataObject3, PROPKEY_GROUPMEMBERS, map, false);
            }
        }
        trcLogger.exiting(CLASSNAME, "getRecursively(DataObject entity, String propKey, Map propNamesMap, boolean getAll)");
    }

    public DataObject get(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI get(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        Map map = this.getPropertyNamesMap(dataObject);
        List list = dataObject.getList("entities");
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject2 = (DataObject)list.get(i);
            this.getRecursively(dataObject2, PROPKEY_ROOT, map, true);
        }
        ControlsHelper.removeControls(dataObject);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI get(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        return dataObject;
    }

    public void initialize(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI initialize (DataObject laConfig)");
        }
        if (dataObject == null) {
            throw new WIMSystemException("LOAD_DATAGRAPH_FAILED", WIMMessageHelper.generateMsgParms("lookaside repository configuration is not defined."), CLASSNAME, "initialize (DataObject laConfig)");
        }
        this.schemaMgr = SchemaManager.singleton();
        String string = dataObject.getString("databaseType");
        String string2 = dataObject.getString("dataSourceName");
        String string3 = dataObject.getString("dbURL");
        String string4 = dataObject.getString("dbAdminId");
        String string5 = dataObject.getString("dbAdminPassword");
        String string6 = dataObject.getString("JDBCDriverClass");
        boolean bl = false;
        if (dataObject.isSet("entityRetrievalLimit")) {
            this.entityRetrievalLimit = dataObject.getInt("entityRetrievalLimit");
        }
        this.dao = DAOHelper.getNewDAOClass(string, string2, string3, string4, string5, string6);
        this.propertyManager = LAPropertyCache.singleton(this.dao);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI initialize (DataObject laConfig)");
        }
    }

    public DataObject search(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI search(DataObject inRoot)", WIMTraceHelper.printDataObject(dataObject));
        }
        DataObject dataObject2 = null;
        String string = null;
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject3 = (DataObject)map.get("SearchControl");
        if (dataObject3 == null) {
            throw new MissingSearchControlException("MISSING_SEARCH_CONTROL", CLASSNAME, "search(DataObject inRoot)");
        }
        List list = dataObject3.getList("properties");
        string = dataObject3.getString("expression");
        if (string == null || string.length() == 0) {
            throw new SearchControlException("MISSING_SEARCH_EXPRESSION", CLASSNAME, "search(DataObject inRoot)");
        }
        List list2 = dataObject3.getList("searchBases");
        boolean bl = dataObject3.getBoolean("returnSubType");
        try {
            Object object;
            CharSequence charSequence;
            int n;
            Collection<DBRepositoryProperty> collection;
            String string2;
            Object object2;
            WIMXPathInterpreter wIMXPathInterpreter = new WIMXPathInterpreter(new StringReader(string));
            XPathNode xPathNode = wIMXPathInterpreter.parse(null);
            List list3 = wIMXPathInterpreter.getEntityTypes();
            HashSet<String> hashSet = new HashSet<String>();
            if (bl) {
                for (int i = 0; i < list3.size(); ++i) {
                    object2 = this.schemaMgr.getSubEntityTypes((String)list3.get(i));
                    if (object2 != null) {
                        hashSet.addAll((Collection<String>)object2);
                    }
                    hashSet.add((String)list3.get(i));
                }
            } else {
                hashSet.addAll(list3);
            }
            if (list.size() == 1 && (string2 = (String)list.get(0)).equals("*")) {
                list.clear();
                object2 = hashSet.iterator();
                while (object2.hasNext()) {
                    collection = this.propertyManager.getSupportedAttributes((String)object2.next());
                    list.addAll(collection);
                }
            }
            ArrayList arrayList = new ArrayList();
            object2 = this.buildSearchConditionWhereClause(hashSet, xPathNode, arrayList, list2);
            trcLogger.logp(Level.FINER, CLASSNAME, "search(DataObject inRoot)", "Search Condition WHERE: " + WIMTraceHelper.printObjectArray(new Object[]{object2}));
            dataObject2 = this.schemaMgr.createRootDataObject();
            collection = new ArrayList();
            for (n = 0; n < list.size(); n += 1) {
                charSequence = (String)list.get(n);
                object = this.propertyManager.getPropertyDefinition((String)charSequence);
                if (object == null) continue;
                collection.add((DBRepositoryProperty)object);
            }
            n = 0;
            if (collection.size() == 0) {
                n = 1;
            }
            charSequence = new StringBuffer();
            object = new StringBuffer(256);
            boolean[] blArray = new boolean[DAOHelper.types.length];
            StringBuffer stringBuffer = new StringBuffer(256);
            int n2 = this.searchString((StringBuffer)charSequence, (String)object2, arrayList, (List)collection, dataObject2, blArray, (StringBuffer)object, stringBuffer);
            trcLogger.logp(Level.FINER, CLASSNAME, "search(DataObject inRoot)", "Search SQL " + WIMTraceHelper.printObjectArray(new Object[]{((StringBuffer)charSequence).toString()}));
            Map map2 = this.dao.searchLA(((StringBuffer)charSequence).toString(), arrayList, n != 0, dataObject2, this.reposId, n2);
            List list4 = dataObject2.getList("entities");
            if ((object != null || stringBuffer != null) && list4.size() > 0) {
                String string3 = DAOHelper.buildEntityIdSQL(map2);
                if (((StringBuffer)object).length() > 0) {
                    this.dao.getCompositeProperties(map2, ((StringBuffer)object).toString(), blArray, string3, false);
                }
                if (stringBuffer.length() > 0) {
                    this.dao.getObjectProperties(map2, stringBuffer.toString(), string3, false);
                }
            }
        }
        catch (ParseException parseException) {
            throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "search(DataObject inRoot)", (Throwable)parseException);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "search(DataObject inRoot)", (Throwable)tokenMgrError);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI search(DataObject inRoot)", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    private String buildSearchConditionWhereClause(Set set, XPathNode xPathNode, List list, List list2) throws WIMApplicationException {
        String string;
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "String buildSearchConditionWhereClause(Set, XPathNode, List, List)", WIMTraceHelper.printObjectArray(new Object[]{set, xPathNode, list, list2}));
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(set);
        LAXPathTranslateHelper lAXPathTranslateHelper = new LAXPathTranslateHelper(arrayList, xPathNode, list, this.propertyManager, this.dao);
        StringBuffer stringBuffer3 = new StringBuffer();
        lAXPathTranslateHelper.genSearchString(stringBuffer3, xPathNode);
        stringBuffer = lAXPathTranslateHelper.getWhereClause();
        stringBuffer2 = lAXPathTranslateHelper.getFromClause();
        StringBuffer stringBuffer4 = new StringBuffer(stringBuffer2.length() + stringBuffer.length() + 128);
        stringBuffer4.append(this.dao.getQuerySet().SearchLAEntitySubSelect);
        stringBuffer4.append(stringBuffer2);
        stringBuffer4.append(stringBuffer);
        stringBuffer4.append(this.dao.getQuerySet().AND);
        stringBuffer4.append(this.dao.getQuerySet().LEFT_BRACKET);
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            stringBuffer4.append(this.dao.getQuerySet().searchLAEntityTypeCondition);
            string = (String)iterator.next();
            stringBuffer4.append(string);
            stringBuffer4.append(this.dao.getQuerySet().SINGLE_QUOTE);
        }
        while (iterator.hasNext()) {
            stringBuffer4.append(this.dao.getQuerySet().OR);
            stringBuffer4.append(this.dao.getQuerySet().searchLAEntityTypeCondition);
            string = (String)iterator.next();
            stringBuffer4.append(string);
            stringBuffer4.append(this.dao.getQuerySet().SINGLE_QUOTE);
        }
        stringBuffer4.append(this.dao.getQuerySet().RIGHT_BRACKET);
        stringBuffer4.append(this.dao.getQuerySet().RIGHT_BRACKET);
        string = stringBuffer4.toString();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "String buildSearchConditionWhereClause(Set, XPathNode, List, List)", WIMTraceHelper.printObjectArray(new Object[]{string, list}));
        }
        return string;
    }

    public DataObject update(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI update(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        try {
            Object object;
            Object object22;
            DataObject dataObject32;
            ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
            List list = changeSummary.getChangedDataObjects();
            for (DataObject dataObject32 : list) {
                for (Object object22 : changeSummary.getOldValues(dataObject32)) {
                    object = object22.getProperty();
                    Object object3 = dataObject32.get(object);
                    if (object3 instanceof List && ((List)object3).size() == 0) {
                        object3 = null;
                    }
                    if (object3 != null && dataObject32.isSet(object) || arrayList.contains(object)) continue;
                    arrayList.add((Property)object);
                }
            }
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "update(DataObject)", "deletedAttributes=" + arrayList);
            }
            List list2 = dataObject.getList("entities");
            dataObject32 = (DataObject)list2.get(0);
            Object object4 = null;
            object22 = dataObject32.getDataObject("identifier").getString("externalId");
            object = dataObject32.getDataObject("identifier").getString("repositoryId");
            if (object22 != null && object != null) {
                object4 = this.dao.findLAEntityByExtIdReposId((String)object22, (String)object);
            }
            if (object4 != null) {
                dataObject32.getDataObject("identifier").set("externalId", object22);
                dataObject32.getDataObject("identifier").set("repositoryId", object);
                this.updateProperties(((LAEntity)object4).getEntityId(), dataObject32, arrayList);
                dataObject2.getList("entities").add(dataObject32);
            } else {
                dataObject2 = this.create(dataObject);
            }
        }
        catch (Exception exception) {
            WIMApplicationException wIMApplicationException = new WIMApplicationException("Failed to update entity: " + exception.toString());
            throw wIMApplicationException;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI update(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        return dataObject2;
    }

    private void replaceCompositeProperties(long l, Hashtable hashtable) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "replaceCompositeProperties(long entId, Hashtable compProps)");
        }
        this.dao.deleteCompositeProperties((short)0, l, hashtable);
        this.createCompositeProperties(l, hashtable, this.propertyManager.getMultiValuePropertyIds());
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "replaceCompositeProperties(long entId, Hashtable compProps)");
        }
    }

    public DataObject createSchema(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI createSchema(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        DataObject dataObject3 = dataObject.getDataObject("schema");
        if (dataObject3 != null) {
            List list;
            String string;
            Object object;
            String string2;
            List list2 = dataObject3.getList("entitySchema");
            if (list2 != null && list2.size() > 0) {
                for (int i = 0; i < list2.size(); ++i) {
                    DataObject dataObject4 = (DataObject)list2.get(i);
                    string2 = dataObject4.getString("nsURI");
                    object = dataObject4.getString("entityName");
                    if (!string2.equals("http://www.ibm.com/websphere/wim")) {
                        object = this.schemaMgr.getQualifiedTypeName(string2, (String)object);
                    }
                    string = dataObject4.getString("parentEntityName");
                    this.dao.createNewPropertyEntityRelationInLA((String)object, string, this.propertyManager);
                    this.propertyManager.updatePropertyEntityRelationCache((String)object, string);
                }
            }
            if ((list = dataObject3.getList("extensionPropertySchema")) != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    int n;
                    Object object2;
                    Object object3;
                    Object object4;
                    string2 = (DataObject)list.get(i);
                    object = new DBRepositoryProperty();
                    string = string2.getString("nsURI");
                    String string3 = string2.getString("propertyName");
                    if (!string.equals("http://www.ibm.com/websphere/wim")) {
                        string3 = this.schemaMgr.getQualifiedTypeName(string, string3);
                    }
                    ((RepositoryProperty)object).setName(string3);
                    List list3 = string2.getList("metaData");
                    String string4 = string2.getString("dataType");
                    DBDataType dBDataType = DAOHelper.getDBDataTypeFromCommonDataType(string4);
                    ((RepositoryProperty)object).setDataType(dBDataType.getDatatype());
                    if (dBDataType.getClassname() != null && dBDataType.getClassname().length() != 0) {
                        ((DBRepositoryProperty)object).setClassName(dBDataType.getClassname());
                    }
                    ((RepositoryProperty)object).setMultipleValued(string2.getBoolean("multiValued"));
                    for (int j = 0; j < list3.size(); ++j) {
                        object4 = (DataObject)list3.get(j);
                        object3 = object4.getString("name");
                        object2 = (String)object4.getList("values").get(0);
                        if (((String)object3).equals("classname")) {
                            ((DBRepositoryProperty)object).setClassName((String)object2);
                            continue;
                        }
                        if (((String)object3).equals("applicationId")) {
                            ((DBRepositoryProperty)object).setApplicationId((String)object2);
                            continue;
                        }
                        if (((String)object3).equals("caseExactMatch")) {
                            ((RepositoryProperty)object).setCaseSensitive(new Boolean((String)object2));
                            continue;
                        }
                        if (((String)object3).equals("description")) {
                            ((DBRepositoryProperty)object).setDescription((String)object2);
                            continue;
                        }
                        if (((String)object3).equals("isComposite")) {
                            n = new Boolean((String)object2).booleanValue();
                            if (n != 0) {
                                throw new OperationNotSupportedException("OPERATION_NOT_SUPPORTED_IN_REPOSITORY", WIMMessageHelper.generateMsgParms(this.reposId + "|" + "isComposite"), CLASSNAME, "createSchema(DataObject)");
                            }
                            ((DBRepositoryProperty)object).setComposite(n != 0);
                            continue;
                        }
                        if (((String)object3).equals("multiValued")) {
                            ((RepositoryProperty)object).setMultipleValued(new Boolean((String)object2));
                            continue;
                        }
                        if (((String)object3).equals("readOnly")) {
                            ((DBRepositoryProperty)object).setReadOnly(new Boolean((String)object2));
                            continue;
                        }
                        if (((String)object3).equals("valueLength")) {
                            ((RepositoryProperty)object).setValueLength(new Integer((String)object2));
                            continue;
                        }
                        if (!((String)object3).equals("metaName")) continue;
                        ((DBRepositoryProperty)object).setMetadataName((String)object2);
                    }
                    if (dBDataType.getDatatype().equals("OBJECT") && (((DBRepositoryProperty)object).getClassName() == null || ((DBRepositoryProperty)object).getClassName().length() == 0)) {
                        throw new InvalidPropertyDefinitionException("INVALID_PROPERTY_DATA_TYPE", WIMMessageHelper.generateMsgParms(string2.getString("propertyName")), CLASSNAME, "createSchema(DataObject)");
                    }
                    if (string4.equalsIgnoreCase("STRING") && ((RepositoryProperty)object).getValueLength() == 0) {
                        ((RepositoryProperty)object).setValueLength(254);
                    }
                    if (((DBRepositoryProperty)object).getMetadataName() == null) {
                        ((DBRepositoryProperty)object).setMetadataName("DEFAULT");
                    }
                    if (((DBRepositoryProperty)object).getApplicationId() == null) {
                        ((DBRepositoryProperty)object).setApplicationId("com.ibm.websphere.wim");
                    }
                    List list4 = string2.getList("applicableEntityTypeNames");
                    object4 = new HashSet();
                    for (int j = 0; j < list4.size(); ++j) {
                        object2 = (String)list4.get(j);
                        object4.add(object2);
                        Set set = this.schemaMgr.getSubEntityTypes((String)object2);
                        if (set.size() == 0) continue;
                        object4.addAll(set);
                    }
                    object3 = string2.getList("requiredEntityTypeNames");
                    object2 = null;
                    if (object3 != null) {
                        object2 = new HashSet();
                        for (int j = 0; j < object3.size(); ++j) {
                            String string5 = (String)object3.get(j);
                            if (list4.contains(string5)) {
                                object2.add(string5);
                                Set set = this.schemaMgr.getSubEntityTypes(string5);
                                if (set.size() == 0) continue;
                                object2.addAll(set);
                                continue;
                            }
                            throw new InvalidPropertyDefinitionException("INVALID_PROPERTY_DEFINITION", WIMMessageHelper.generateMsgParms("requiredEntityTypeNames", string5, ((RepositoryProperty)object).getName()), CLASSNAME, "createSchema(DataObject)");
                        }
                    }
                    ((RepositoryProperty)object).setApplicableEntityTypes((Set)object4);
                    ((RepositoryProperty)object).setRequiredEntityTypes((Set)object2);
                    n = this.dao.createLookAsidePropertyDefinition((DBRepositoryProperty)object);
                    ((DBRepositoryProperty)object).setPropId(new Integer(n));
                    this.propertyManager.updatePropertyCache((DBRepositoryProperty)object);
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI createSchema(DataObject)", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    public DataObject getSchema(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI getSchema(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject3 = (DataObject)map.get("ExtensionPropertyDataTypeControl");
        DataObject dataObject4 = (DataObject)map.get("ExtensionPropertyDefinitionControl");
        if (dataObject3 != null) {
            Set set = this.propertyManager.getSupportedPropertyTypes();
            DataObject dataObject5 = dataObject2.getDataObject("schema");
            if (dataObject5 == null) {
                dataObject5 = dataObject2.createDataObject("schema");
            }
            for (String string : set) {
                dataObject5.getList("propertyDataTypes").add(string);
            }
        } else if (dataObject4 != null) {
            DataObject dataObject6 = dataObject2.getDataObject("schema");
            if (dataObject6 == null) {
                dataObject6 = dataObject2.createDataObject("schema");
            }
            String string = dataObject4.getString("entityTypeName");
            List list = dataObject4.getList("propertyNames");
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    String string2 = (String)list.get(i);
                    DBRepositoryProperty dBRepositoryProperty = this.propertyManager.getPropertyDefinition(string2);
                    if (dBRepositoryProperty == null) {
                        if (!trcLogger.isLoggable(Level.FINE)) continue;
                        trcLogger.logp(Level.FINE, CLASSNAME, "getSchema(DataObject)", "The property " + string2 + " is not defined in repository " + this.reposId);
                        continue;
                    }
                    DataObject dataObject7 = dataObject6.createDataObject("extensionPropertySchema");
                    DAOHelper.setPropertySchema(dBRepositoryProperty, string2, dataObject7, string);
                }
            } else {
                Set set = this.propertyManager.getSupportedAttributes(string);
                if (set != null) {
                    for (String string3 : set) {
                        DBRepositoryProperty dBRepositoryProperty = this.propertyManager.getPropertyDefinition(string3);
                        if (dBRepositoryProperty == null) {
                            if (!trcLogger.isLoggable(Level.FINE)) continue;
                            trcLogger.logp(Level.FINE, CLASSNAME, "getSchema(DataObject)", "The property " + string3 + " is not defined in repository " + this.reposId);
                            continue;
                        }
                        DataObject dataObject8 = dataObject6.createDataObject("extensionPropertySchema");
                        DAOHelper.setPropertySchema(dBRepositoryProperty, string3, dataObject8, string);
                    }
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI getSchema(DataObject)", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    private void getProperties(DataObject dataObject, long l, String[] stringArray) throws WIMException {
        String string;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getProperties(DataObject entity, long entityId, String[] propNames)");
        }
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        StringBuffer stringBuffer3 = null;
        StringBuffer stringBuffer4 = null;
        StringBuffer stringBuffer5 = null;
        StringBuffer stringBuffer6 = null;
        StringBuffer stringBuffer7 = null;
        StringBuffer stringBuffer8 = null;
        boolean bl = false;
        boolean[] blArray = null;
        if (stringArray != null) {
            block9: for (int i = 0; i < stringArray.length; ++i) {
                DBRepositoryProperty dBRepositoryProperty;
                string = stringArray[i];
                if (string.equals("*")) {
                    this.dao.readAllLAPropertiesForEntity(l, dataObject);
                }
                if ((dBRepositoryProperty = this.propertyManager.getPropertyDefinition(string)) == null) continue;
                if (dBRepositoryProperty.isComposite()) {
                    if (!bl) {
                        blArray = new boolean[DAOHelper.types.length];
                        for (int j = 0; j < DAOHelper.types.length; ++j) {
                            blArray[j] = false;
                        }
                        bl = true;
                        stringBuffer8 = new StringBuffer(256);
                        stringBuffer8.append(dBRepositoryProperty.getPropId());
                    } else {
                        stringBuffer8.append(this.dao.getQuerySet().COMMA);
                        stringBuffer8.append(dBRepositoryProperty.getPropId());
                    }
                    this.appendCompositeProperty(dBRepositoryProperty, stringBuffer8, blArray);
                    continue;
                }
                String string2 = dBRepositoryProperty.getDataType();
                short s = DAOHelper.getDataTypeId(string2);
                switch (s) {
                    case 0: {
                        stringBuffer = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer);
                        continue block9;
                    }
                    case 3: {
                        stringBuffer2 = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer2);
                        continue block9;
                    }
                    case 2: {
                        stringBuffer3 = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer3);
                        continue block9;
                    }
                    case 1: {
                        stringBuffer4 = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer4);
                        continue block9;
                    }
                    case 4: {
                        stringBuffer5 = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer5);
                        continue block9;
                    }
                    case 5: {
                        stringBuffer6 = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer6);
                        continue block9;
                    }
                    case 6: {
                        stringBuffer7 = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer7);
                    }
                }
            }
            if (stringBuffer != null) {
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readLAProperties(l, stringBuffer, (short)0, dataObject);
            }
            if (stringBuffer2 != null) {
                stringBuffer2.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readLAProperties(l, stringBuffer2, (short)3, dataObject);
            }
            if (stringBuffer3 != null) {
                stringBuffer3.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readLAProperties(l, stringBuffer3, (short)2, dataObject);
            }
            if (stringBuffer4 != null) {
                stringBuffer4.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readLAProperties(l, stringBuffer4, (short)1, dataObject);
            }
            if (stringBuffer5 != null) {
                stringBuffer5.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readLAProperties(l, stringBuffer5, (short)4, dataObject);
            }
            if (stringBuffer6 != null) {
                stringBuffer6.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readLAProperties(l, stringBuffer6, (short)5, dataObject);
            }
            if (stringBuffer7 != null) {
                stringBuffer7.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readLAProperties(l, stringBuffer7, (short)6, dataObject);
            }
        }
        if (bl) {
            HashMap<Long, DataObject> hashMap = new HashMap<Long, DataObject>();
            hashMap.put(new Long(l), dataObject);
            string = DAOHelper.buildEntityIdSQL(hashMap);
            this.dao.getCompositeProperties(hashMap, stringBuffer8.toString(), blArray, string, false);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getProperties(DataObject entity, long entityId, String[] propNames)");
        }
    }

    private int searchString(StringBuffer stringBuffer, String string, List list, List list2, DataObject dataObject, boolean[] blArray, StringBuffer stringBuffer2, StringBuffer stringBuffer3) throws WIMException {
        String string2 = "http://www.ibm.com/websphere/wim";
        int n = 1;
        int n2 = 1;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "searchString(StringBuffer sql, String conditionWhere, List parameters, List returnPropDefs, DataObject returnRT)", WIMTraceHelper.printObjectArray(new Object[]{stringBuffer, string, list, list2, dataObject, stringBuffer2, stringBuffer3}));
        }
        if (list2.size() == 0) {
            stringBuffer.ensureCapacity(256 + string.length());
            stringBuffer.append(this.dao.getQuerySet().searchLANoResultPropertyWhere);
            stringBuffer.append(string);
        } else {
            DBRepositoryProperty dBRepositoryProperty = null;
            StringBuffer stringBuffer4 = null;
            StringBuffer stringBuffer5 = null;
            StringBuffer stringBuffer6 = null;
            StringBuffer stringBuffer7 = null;
            StringBuffer stringBuffer8 = null;
            StringBuffer stringBuffer9 = null;
            boolean bl = false;
            block9: for (int i = 0; i < list2.size(); ++i) {
                dBRepositoryProperty = (DBRepositoryProperty)list2.get(i);
                if (dBRepositoryProperty.getParentCompositeName() != null) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "searchString(StringBuffer sql, String conditionWhere, List parameters, List returnPropDefs, DataObject returnRT)", "A component property '" + dBRepositoryProperty.getName() + "' that is part of a composite property was specified stand alone.");
                }
                if (dBRepositoryProperty.isComposite()) {
                    if (!bl) {
                        for (int j = 0; j < DAOHelper.types.length; ++j) {
                            blArray[j] = false;
                        }
                        bl = true;
                        stringBuffer2.append(dBRepositoryProperty.getPropId());
                    } else {
                        stringBuffer2.append(this.dao.getQuerySet().COMMA_AND_SPACE);
                        stringBuffer2.append(dBRepositoryProperty.getPropId());
                    }
                    this.appendCompositeProperty(dBRepositoryProperty, stringBuffer2, blArray);
                    continue;
                }
                String string3 = dBRepositoryProperty.getDataType();
                short s = DAOHelper.getDataTypeId(string3);
                switch (s) {
                    case 0: {
                        if (stringBuffer4 == null) {
                            stringBuffer4 = new StringBuffer(256);
                            ++n;
                            stringBuffer4.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer4.append(this.dao.getQuerySet().COMMA);
                        stringBuffer4.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    case 3: {
                        if (stringBuffer5 == null) {
                            stringBuffer5 = new StringBuffer(256);
                            ++n;
                            stringBuffer5.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer5.append(this.dao.getQuerySet().COMMA);
                        stringBuffer5.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    case 1: {
                        if (stringBuffer7 == null) {
                            stringBuffer7 = new StringBuffer(256);
                            ++n;
                            stringBuffer7.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer7.append(this.dao.getQuerySet().COMMA);
                        stringBuffer7.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    case 2: {
                        if (stringBuffer6 == null) {
                            stringBuffer6 = new StringBuffer(256);
                            ++n;
                            stringBuffer6.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer6.append(this.dao.getQuerySet().COMMA);
                        stringBuffer6.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    case 4: {
                        if (stringBuffer8 == null) {
                            stringBuffer8 = new StringBuffer(256);
                            ++n;
                            stringBuffer8.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer8.append(this.dao.getQuerySet().COMMA);
                        stringBuffer8.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    case 5: {
                        if (stringBuffer9 == null) {
                            stringBuffer9 = new StringBuffer(256);
                            ++n;
                            stringBuffer9.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer9.append(this.dao.getQuerySet().COMMA);
                        stringBuffer9.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    case 6: {
                        if (stringBuffer3.length() == 0) {
                            ++n;
                            stringBuffer3.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer3.append(this.dao.getQuerySet().COMMA);
                        stringBuffer3.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    default: {
                        throw new WIMApplicationException("INVALID_PROPERTY_DATA_TYPE", WIMMessageHelper.generateMsgParms(dBRepositoryProperty.getDataType()), CLASSNAME, "searchString(StringBuffer sql, String conditionWhere, List parameters, List returnPropDefs, DataObject returnRT)");
                    }
                }
            }
            stringBuffer.ensureCapacity((string.length() + 512) * n);
            stringBuffer.append(this.dao.getQuerySet().findLAEntityGeneral);
            stringBuffer.append(this.dao.getQuerySet().AND);
            stringBuffer.append(string);
            if (stringBuffer4 != null) {
                stringBuffer.append(this.dao.getQuerySet().UNION);
                stringBuffer.append(this.dao.getQuerySet().findStringPropertyForLAEntities);
                stringBuffer.append(this.dao.getQuerySet().findLAPropertyIdIn);
                stringBuffer.append(stringBuffer4);
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                stringBuffer.append(this.dao.getQuerySet().AND);
                stringBuffer.append(string);
                ++n2;
            }
            if (stringBuffer5 != null) {
                stringBuffer.append(this.dao.getQuerySet().UNION);
                stringBuffer.append(this.dao.getQuerySet().findIntegerPropertyForLAEntities);
                stringBuffer.append(this.dao.getQuerySet().findLAPropertyIdIn);
                stringBuffer.append(stringBuffer5);
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                stringBuffer.append(this.dao.getQuerySet().AND);
                stringBuffer.append(string);
                ++n2;
            }
            if (stringBuffer6 != null) {
                stringBuffer.append(this.dao.getQuerySet().UNION);
                stringBuffer.append(this.dao.getQuerySet().findDoublePropertyForLAEntities);
                stringBuffer.append(this.dao.getQuerySet().findLAPropertyIdIn);
                stringBuffer.append(stringBuffer6);
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                stringBuffer.append(this.dao.getQuerySet().AND);
                stringBuffer.append(string);
                ++n2;
            }
            if (stringBuffer7 != null) {
                stringBuffer.append(this.dao.getQuerySet().UNION);
                stringBuffer.append(this.dao.getQuerySet().findLongPropertyForLAEntities);
                stringBuffer.append(this.dao.getQuerySet().findLAPropertyIdIn);
                stringBuffer.append(stringBuffer7);
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                stringBuffer.append(this.dao.getQuerySet().AND);
                stringBuffer.append(string);
                ++n2;
            }
            if (stringBuffer8 != null) {
                stringBuffer.append(this.dao.getQuerySet().UNION);
                stringBuffer.append(this.dao.getQuerySet().findTimestampPropertyForLAEntities);
                stringBuffer.append(this.dao.getQuerySet().findLAPropertyIdIn);
                stringBuffer.append(stringBuffer8);
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                stringBuffer.append(this.dao.getQuerySet().AND);
                stringBuffer.append(string);
                ++n2;
            }
            if (stringBuffer9 != null) {
                stringBuffer.append(this.dao.getQuerySet().UNION);
                stringBuffer.append(this.dao.getQuerySet().findReferencePropertyForLAEntities);
                stringBuffer.append(this.dao.getQuerySet().findLAPropertyIdIn);
                stringBuffer.append(stringBuffer9);
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                stringBuffer.append(this.dao.getQuerySet().AND);
                stringBuffer.append(string);
                ++n2;
            }
            stringBuffer.append(this.dao.getQuerySet().findLASpecificPropertyForEntitiesOrderBy);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "searchString(StringBuffer sql, String conditionWhere, List parameters, List returnPropDefs, DataObject returnRT)");
        }
        return n2;
    }

    private StringBuffer buildGetPropertyQuery(short s, Integer n, int n2, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(256 + n2 * 8);
            stringBuffer.append(this.dao.getLAPropValuesByEntityQuery(s));
            stringBuffer.append(n);
        } else {
            stringBuffer.append(this.dao.getQuerySet().COMMA);
            stringBuffer.append(n);
        }
        return stringBuffer;
    }

    private void updateProperties(long l, DataObject dataObject, List list) throws WIMException {
        Object object;
        DBRepositoryProperty dBRepositoryProperty;
        Property property;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateProperties(long mbrId, DataObject entity)");
        }
        String string = this.schemaMgr.getQualifiedTypeName(dataObject.getType());
        Hashtable[] hashtableArray = new Hashtable[7];
        Hashtable[] hashtableArray2 = new Hashtable[7];
        Hashtable<Object, Object[]> hashtable = null;
        boolean bl = false;
        HashSet hashSet = this.propertyManager.getSupportedAttributes(string);
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        for (String string2 : hashSet) {
            property = this.schemaMgr.getProperty(string, string2);
            if (!dataObject.isSet(property)) continue;
            dBRepositoryProperty = this.propertyManager.getPropertyDefinition(string2);
            object = dBRepositoryProperty.getPropId();
            String string3 = dBRepositoryProperty.getDataType();
            short s = DAOHelper.getDataTypeId(string3);
            if (this.propertyManager.isCompositeProperty(string2)) {
                Object[] objectArray;
                if (hashtable == null) {
                    hashtable = new Hashtable<Object, Object[]>();
                }
                if (this.propertyManager.isMultivaluedProperty(string2)) {
                    objectArray = new Object[]{string2, dataObject.getList(property)};
                    hashtable.put(object, objectArray);
                    continue;
                }
                objectArray = new Object[]{string2, dataObject.get(property)};
                hashtable.put(object, objectArray);
                continue;
            }
            if (this.propertyManager.isMultivaluedProperty(string2)) {
                if (hashtableArray[s] == null) {
                    hashtableArray[s] = new Hashtable();
                }
                hashtableArray[s].put(object, dataObject.getList(property));
                bl = true;
                continue;
            }
            if (hashtableArray[s] == null) {
                hashtableArray[s] = new Hashtable();
            }
            hashtableArray[s].put(object, dataObject.get(property));
            bl = true;
        }
        if (bl) {
            this.dao.replaceProperties((short)1, l, hashtableArray, this.propertyManager.getMultiValuePropertyIds(), null);
        }
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                property = (Property)list.get(i);
                dBRepositoryProperty = this.propertyManager.getPropertyDefinition(property.getName());
                object = dBRepositoryProperty.getDataType();
                short s = DAOHelper.getDataTypeId((String)object);
                Integer n = dBRepositoryProperty.getPropId();
                if (hashtableArray2[s] == null) {
                    hashtableArray2[s] = new Hashtable();
                }
                hashtableArray2[s].put(n, property);
            }
            this.dao.deleteProperties((short)1, l, hashtableArray2, this.propertyManager.getMultiValuePropertyIds(), null);
        }
        if (hashtable != null) {
            this.replaceCompositeProperties(l, hashtable);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updateProperties(long mbrId, DataObject entity)");
        }
    }

    private void appendCompositeProperty(DBRepositoryProperty dBRepositoryProperty, StringBuffer stringBuffer, boolean[] blArray) {
        Set set;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "appendCompositeProperty(DBRepositoryProperty propDef, StringBuffer compositeQuery, boolean[] compositeTypes)");
        }
        if ((set = dBRepositoryProperty.getComponentPropertyNames()) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                DBRepositoryProperty dBRepositoryProperty2 = this.propertyManager.getPropertyDefinition((String)iterator.next());
                if (dBRepositoryProperty2.isComposite()) {
                    stringBuffer.append(this.dao.getQuerySet().COMMA_AND_SPACE);
                    stringBuffer.append(dBRepositoryProperty2.getPropId());
                    this.appendCompositeProperty(dBRepositoryProperty2, stringBuffer, blArray);
                    continue;
                }
                String string = dBRepositoryProperty2.getDataType();
                short s = DAOHelper.getDataTypeId(string);
                blArray[s] = true;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "appendCompositeProperty(DBRepositoryProperty propDef, StringBuffer compositeQuery, boolean[] compositeTypes)");
        }
    }

    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "dynamicUpdateConfig(String updateEvent, Map configData)");
        }
        if (string.equals("websphere.usermanager.serviceprovider.update.propertyextension.adminidpassword")) {
            byte[] byArray = (byte[])hashtable.get("DYNA_CONFIG_KEY_DB_ADMIN_PASSWORD");
            try {
                String string2 = new String(byArray, "UTF-8");
                this.dao.reload(string2);
            }
            catch (Exception exception) {
                throw new DynamicUpdateConfigException("REPOSITORY_CONNECTION_FAILED", WIMMessageHelper.generateMsgParms(this.reposId, "DYNA_CONFIG_KEY_DB_ADMIN_PASSWORD"), CLASSNAME, "dynamicUpdateConfig(String updateEvent, Map configData)");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "dynamicUpdateConfig(String updateEvent, Map configData)");
        }
    }
}

