/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.management;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.wim.exception.NetworkConfigSyncException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.util.Routines;
import com.ibm.ws.wim.management.EventDataWrapper;
import com.ibm.ws.wim.management.EventHandler;
import com.ibm.ws.wim.management.UserManagementProcess;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class DynamicReloadManager {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = DynamicReloadManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final Logger msgLogger = WIMLogger.getMessageLogger(CLASSNAME);
    private static boolean isDMgrMode;
    private static boolean isNodeAgentMode;
    private static boolean isManagedProcessMode;
    private static boolean isSingleServerMode;
    private static boolean isConnectionTypeNoneMode;
    private HashMap managedProcRegistrations;
    private HashMap mNodeLookupCache;
    private static DynamicReloadManager singletonObj;

    private DynamicReloadManager() {
        if (!isDMgrMode) {
            this.managedProcRegistrations = new HashMap();
            this.mNodeLookupCache = new HashMap();
        }
    }

    public static synchronized DynamicReloadManager singleton() {
        if (singletonObj == null) {
            singletonObj = new DynamicReloadManager();
        }
        return singletonObj;
    }

    private Vector getEventListeners(String string) {
        Routines.enterMethod(trcLogger, CLASSNAME, "getEventListeners", Level.FINE);
        Vector vector = null;
        if (this.mNodeLookupCache.containsKey(string)) {
            vector = (Vector)this.mNodeLookupCache.get(string);
        } else {
            HashMap hashMap = this.managedProcRegistrations;
            Iterator iterator = hashMap.keySet().iterator();
            HashMap<String, EventHandler> hashMap2 = new HashMap<String, EventHandler>();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.startsWith(string) && !string2.equalsIgnoreCase(string)) continue;
                Vector vector2 = (Vector)hashMap.get(string2);
                for (EventHandler eventHandler : vector2) {
                    String string3 = eventHandler.getClass().getName();
                    if (hashMap2.containsKey(string3)) continue;
                    hashMap2.put(string3, eventHandler);
                }
            }
            if (hashMap2.size() > 0) {
                vector = new Vector(hashMap2.values());
                this.mNodeLookupCache.put(string, vector);
            }
        }
        Routines.exitMethod(trcLogger, CLASSNAME, "getEventListeners", Level.FINE);
        return vector;
    }

    private static void determineWASRuntimeContext() {
        isDMgrMode = false;
        isNodeAgentMode = false;
        isManagedProcessMode = false;
        isSingleServerMode = false;
        isConnectionTypeNoneMode = false;
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService != null) {
            String string = adminService.getProcessType();
            if (string.equals("ManagedProcess")) {
                isManagedProcessMode = true;
            } else if (string.equals("DeploymentManager")) {
                isDMgrMode = true;
            } else if (string.equals("NodeAgent")) {
                isNodeAgentMode = true;
            } else if (string.equals("UnManagedProcess")) {
                isSingleServerMode = true;
            }
        } else {
            isConnectionTypeNoneMode = true;
        }
    }

    public static boolean isConnectionTypeNone() {
        return isConnectionTypeNoneMode;
    }

    public static boolean isNetworkDeploymentMode() {
        return isManagedProcessMode || isDMgrMode || isNodeAgentMode;
    }

    public static boolean isRunningOnDeploymentManager() {
        return isDMgrMode;
    }

    public static boolean isRunningOnNodeAgent() {
        return isNodeAgentMode;
    }

    public static boolean isRunningOnManagedProc() {
        return isManagedProcessMode;
    }

    public static boolean isRunningOnManagedProcOrNodeAgent() {
        return isManagedProcessMode || isNodeAgentMode;
    }

    public static boolean isRunningOnSingleServer() {
        return isSingleServerMode;
    }

    public static String getCellName() {
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string = adminService != null ? adminService.getCellName() : System.getProperty("local.cell");
        return string;
    }

    public void registerEventAtNode(String string, EventHandler eventHandler) {
        Routines.enterMethod(trcLogger, CLASSNAME, "registerEventAtNode", Level.FINEST);
        if (!DynamicReloadManager.isRunningOnManagedProcOrNodeAgent()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Registering eventType <").append(string).append("> ");
        stringBuffer.append(" with eventHandler <").append(eventHandler.getClass().getName()).append(">");
        Routines.logMessage(trcLogger, CLASSNAME, "registerEventAtNode", Level.CONFIG, stringBuffer.toString());
        if (this.managedProcRegistrations.containsKey(string)) {
            Vector vector = (Vector)this.managedProcRegistrations.get(string);
            Iterator iterator = vector.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                EventHandler eventHandler2 = (EventHandler)iterator.next();
                if (!eventHandler2.getClass().getName().equalsIgnoreCase(eventHandler.getClass().getName())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                vector.add(eventHandler);
            }
        } else {
            Vector<EventHandler> vector = new Vector<EventHandler>();
            vector.add(eventHandler);
            this.managedProcRegistrations.put(string.toLowerCase(), vector);
        }
        Routines.exitMethod(trcLogger, CLASSNAME, "registerEventAtNode", Level.FINEST);
    }

    public void broadcastEventAtDeploymentManager(String string, String string2, EventDataWrapper eventDataWrapper) throws NetworkConfigSyncException {
        Routines.enterMethod(trcLogger, CLASSNAME, "broadcastEventAtDeploymentManager", Level.FINEST);
        String string3 = "processEvent";
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"};
        Object[] objectArray = new Object[]{string, string2, eventDataWrapper};
        HashSet<ObjectName> hashSet = new HashSet<ObjectName>();
        if (!isDMgrMode) {
            return;
        }
        try {
            msgLogger.logp(Level.INFO, CLASSNAME, "broadcastEventAtDeploymentManager", "DYNAMIC_RELOAD_DMGR_BROADCAST_EVENT", new Object[]{string});
            this.logEventDetails(string, string2, eventDataWrapper, trcLogger);
            AdminService adminService = AdminServiceFactory.getAdminService();
            String string4 = "WebSphere:type=UserManagerMBean,*";
            Routines.logMessage(trcLogger, CLASSNAME, "broadcastEventAtDeploymentManager", Level.FINE, "Querying MBeans at managed nodes (" + string4 + ")...");
            ObjectName objectName = new ObjectName(string4);
            Set set = UserManagementProcess.suQueryNames(adminService, objectName, null);
            Routines.logMessage(trcLogger, CLASSNAME, "broadcastEventAtDeploymentManager", Level.FINE, "Found MBeans running on " + set.size() + " managed node(s)");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    objectName = (ObjectName)iterator.next();
                    Routines.logMessage(trcLogger, CLASSNAME, "broadcastEventAtDeploymentManager", Level.FINE, "Sending event to managed node MBean (" + objectName + ")");
                    Boolean bl = (Boolean)UserManagementProcess.suInvokeAdminService(adminService, objectName, string3, objectArray, stringArray);
                    if (!bl.equals(Boolean.TRUE)) continue;
                    hashSet.add(objectName);
                }
                catch (Exception exception) {
                    msgLogger.logp(Level.WARNING, CLASSNAME, "broadcastEventAtDeploymentManager", "DYNAMIC_RELOAD_EVENT_BROADCAST_ERROR");
                    Routines.logException(trcLogger, CLASSNAME, "broadcastEventAtDeploymentManager", Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        catch (Exception exception) {
            msgLogger.logp(Level.WARNING, CLASSNAME, "broadcastEventAtDeploymentManager", "DYNAMIC_RELOAD_EVENT_BROADCAST_ERROR");
            Routines.logException(trcLogger, CLASSNAME, "broadcastEventAtDeploymentManager", Level.SEVERE, exception.getMessage(), exception);
        }
        this.logFailedNotifications(string, hashSet);
        Routines.exitMethod(trcLogger, CLASSNAME, "broadcastEventAtDeploymentManager", Level.FINEST);
    }

    public void broadcastEventAtNode(String string, EventDataWrapper eventDataWrapper) {
        Routines.enterMethod(trcLogger, CLASSNAME, "broadcastEventAtNode", Level.FINEST);
        if (!DynamicReloadManager.isRunningOnManagedProcOrNodeAgent()) {
            return;
        }
        Vector vector = this.getEventListeners(string);
        if (vector != null) {
            for (EventHandler eventHandler : vector) {
                eventHandler.processEvent(string, eventDataWrapper);
            }
        }
        Routines.exitMethod(trcLogger, CLASSNAME, "broadcastEventAtNode", Level.FINEST);
    }

    public void logEventDetails(String string, String string2, EventDataWrapper eventDataWrapper, Logger logger) {
        Routines.enterMethod(logger, CLASSNAME, "logEventDetails", Level.FINEST);
        StringBuffer stringBuffer = new StringBuffer("Event Information\n");
        stringBuffer.append("\tEvent type: " + string).append("\n");
        stringBuffer.append("\tEvent message: " + string2).append("\n");
        if (eventDataWrapper != null) {
            stringBuffer.append("\tEvent data: \n");
            Object[] objectArray = eventDataWrapper.getObjects();
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = objectArray[i].getClass().getName();
                stringBuffer.append("\t\tObject[").append(i).append("] class: ").append(string3).append("\n");
                stringBuffer.append("\t\tObject[").append(i).append("] value: ").append(objectArray[i]).append("\n");
            }
        } else {
            stringBuffer.append("\tEvent data: (null)").append("\n");
        }
        Routines.logMessage(logger, CLASSNAME, "logEventDetails", Level.FINER, stringBuffer.toString());
        Routines.exitMethod(logger, CLASSNAME, "logEventDetails", Level.FINEST);
    }

    private boolean logFailedNotifications(String string, Set set) {
        Routines.enterMethod(trcLogger, CLASSNAME, "logFailedNotifications", Level.FINEST);
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Object object;
            Object object22;
            AdminService adminService = AdminServiceFactory.getAdminService();
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = new Session();
            String string2 = adminService.getCellName();
            ObjectName objectName = configService.resolve(session, "Cell=" + string2)[0];
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Node");
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                object22 = objectNameArray[i].getKeyProperty("_Websphere_Config_Data_Display_Name");
                object = ConfigServiceHelper.createObjectName(null, "Server");
                ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], (ObjectName)object, null);
                for (int j = 0; j < objectNameArray2.length; ++j) {
                    String string3 = objectNameArray2[j].getKeyProperty("_Websphere_Config_Data_Display_Name");
                    if (string2.equals(adminService.getCellName()) && ((String)object22).equals(adminService.getNodeName()) && string3.equals(adminService.getProcessName())) continue;
                    String string4 = "cell=" + string2 + "," + "node=" + (String)object22 + "," + "process=" + string3;
                    hashSet.add(string4);
                    Routines.logMessage(trcLogger, CLASSNAME, "logFailedNotifications", Level.FINE, "Discovered config repository node (" + string4 + ")");
                }
            }
            configService.discard(session);
            for (Object object22 : set) {
                object = "cell=" + ((ObjectName)object22).getKeyProperty("cell") + "," + "node=" + ((ObjectName)object22).getKeyProperty("node") + "," + "process=" + ((ObjectName)object22).getKeyProperty("process");
                hashSet.remove(object);
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                bl = true;
                object22 = (String)iterator.next();
                msgLogger.logp(Level.WARNING, CLASSNAME, "logFailedNotifications", "DYNAMIC_RELOAD_MANAGED_NODE_UNAVAILABLE", new Object[]{object22, string});
            }
        }
        catch (Exception exception) {
            bl = true;
            Routines.logException(trcLogger, CLASSNAME, "logFailedNotifications", Level.SEVERE, exception.getMessage(), exception);
        }
        Routines.exitMethod(trcLogger, CLASSNAME, "logFailedNotifications", Level.FINEST);
        return bl;
    }

    static {
        singletonObj = null;
        DynamicReloadManager.determineWASRuntimeContext();
    }
}

