/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.management;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.wim.ServiceProvider;
import com.ibm.websphere.wim.exception.NetworkConfigSyncException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.util.Routines;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.component.Component;
import com.ibm.ws.wim.management.DynamicReloadManager;
import com.ibm.ws.wim.management.UserManagerMBean;
import com.ibm.ws.wim.security.authz.AuthPrivilegedException;
import com.ibm.ws.wim.security.authz.ProfileSecurityManager;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class UserManagementProcess
implements Component,
NotificationListener {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = UserManagementProcess.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final Logger msgLogger = WIMLogger.getMessageLogger(CLASSNAME);
    private static ObjectName umMBean;
    private String componentState;

    public String getName() {
        return CLASSNAME;
    }

    public String getState() {
        return this.componentState;
    }

    public void start() throws RuntimeError, RuntimeWarning {
        this.componentState = "STARTING";
        this.componentState = "STARTED";
    }

    public void stop() {
        this.componentState = "STOPPING";
        this.componentState = "STOPPED";
    }

    public void destroy() {
        this.componentState = "DESTROYING";
        this.componentState = "DESTROYED";
    }

    private void registerNotificationListenerToNode() {
        Routines.enterMethod(trcLogger, CLASSNAME, "registerNotificationListenerToNode", Level.FINEST);
        DynamicReloadManager dynamicReloadManager = DynamicReloadManager.singleton();
        Routines.exitMethod(trcLogger, CLASSNAME, "registerNotificationListenerToNode", Level.FINEST);
    }

    private void registerUserManagerMBean() throws AdminException {
        Routines.enterMethod(trcLogger, CLASSNAME, "registerUserManagerMBean", Level.FINEST);
        MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
        try {
            UserManagerMBean userManagerMBean = UserManagerMBean.getInstance();
            umMBean = mBeanFactory.activateMBean("UserManagerMBean", userManagerMBean, "UserManagerMBeanID", "com/ibm/ws/wim/management/UserManagerMBean.xml");
            userManagerMBean.setObjectName(umMBean);
            Routines.logMessage(trcLogger, CLASSNAME, "registerUserManagerMBean", Level.FINE, "Activated UserManagerMBean (" + umMBean.toString() + ")");
        }
        catch (AdminException adminException) {
            if (adminException.getCause() instanceof InstanceAlreadyExistsException) {
                Routines.logMessage(trcLogger, CLASSNAME, "registerUserManagerMBean", Level.FINE, "Caught exception: UserManagerMBean has already been activated");
            }
            throw adminException;
        }
        Routines.exitMethod(trcLogger, CLASSNAME, "registerUserManagerMBean", Level.FINEST);
    }

    private void deregisterUserManagerMBean() throws AdminException {
        if (umMBean != null) {
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            mBeanFactory.deactivateMBean(umMBean);
        }
    }

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        this.componentState = "INITIALIZING";
        Routines.enterMethod(trcLogger, CLASSNAME, "initialize", Level.FINEST);
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (this.isNDProcessType(adminService.getProcessType())) {
            this.startBootstrapSequence();
        }
        this.componentState = "INITIALIZED";
        Routines.exitMethod(trcLogger, CLASSNAME, "initialize", Level.FINEST);
    }

    private boolean isNDProcessType(String string) {
        return string.equals("DeploymentManager") || string.equals("ManagedProcess") || string.equals("NodeAgent");
    }

    private void startBootstrapSequence() {
        Routines.enterMethod(trcLogger, CLASSNAME, "startBootstrapSequence", Level.FINEST);
        msgLogger.log(Level.INFO, "DYNAMIC_RELOAD_START_BOOTSTRAP");
        try {
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("j2ee.state.running");
            AdminService adminService = AdminServiceFactory.getAdminService();
            String string = "WebSphere:type=Server,node=" + adminService.getNodeName() + ",process=" + adminService.getProcessName() + ",*";
            ObjectName objectName = new ObjectName(string);
            Routines.logMessage(trcLogger, CLASSNAME, "startBootstrapSequence", Level.FINE, "Registering listener for local server MBean (" + string + ")");
            adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, null);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            msgLogger.logp(Level.SEVERE, CLASSNAME, "startBootstrapSequence", "DYNAMIC_RELOAD_INIT_FAILURE");
            Routines.logException(trcLogger, CLASSNAME, "startBootstrapSequence", Level.SEVERE, "DYNAMIC_RELOAD_INIT_FAILURE", malformedObjectNameException);
        }
        msgLogger.log(Level.INFO, "DYNAMIC_RELOAD_WAIT_NOTIF_SERVER_STARTED");
        Routines.exitMethod(trcLogger, CLASSNAME, "startBootstrapSequence", Level.FINEST);
    }

    public void handleNotification(Notification notification, Object object) {
        Routines.enterMethod(trcLogger, CLASSNAME, "handleNotification", Level.FINEST);
        if (notification.getType().equals("j2ee.state.running")) {
            msgLogger.log(Level.INFO, "DYNAMIC_RELOAD_RECEIVED_NOTIF_SERVER_STARTED");
            AdminService adminService = AdminServiceFactory.getAdminService();
            String string = adminService.getProcessType();
            if (WSSecurityHelper.isGlobalSecurityEnabled()) {
                Routines.logMessage(trcLogger, CLASSNAME, "handleNotification", Level.FINE, "Starting the component because global security is enabled");
                try {
                    ServiceProvider.singleton();
                    if (string.equals("ManagedProcess") || string.equals("NodeAgent")) {
                        this.registerNotificationListenerToNode();
                        this.registerUserManagerMBean();
                    }
                }
                catch (Exception exception) {
                    msgLogger.logp(Level.SEVERE, CLASSNAME, "handleNotification", "DYNAMIC_RELOAD_INIT_FAILURE");
                    Routines.logException(trcLogger, CLASSNAME, "handleNotification", Level.SEVERE, "DYNAMIC_RELOAD_INIT_FAILURE", exception);
                }
                msgLogger.log(Level.INFO, "DYNAMIC_RELOAD_INIT_SUCCESS");
            } else {
                Routines.logMessage(trcLogger, CLASSNAME, "handleNotification", Level.FINE, "Component will NOT be started because global security is disabled");
            }
        }
        Routines.exitMethod(trcLogger, CLASSNAME, "handleNotification", Level.FINEST);
    }

    static AdminClient getDeploymentManagerAdminClient() throws NetworkConfigSyncException {
        try {
            return (AdminClient)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    return adminService.getDeploymentManagerAdminClient();
                }
            });
        }
        catch (Exception exception) {
            Exception exception2;
            if (exception instanceof AuthPrivilegedException) {
                exception2 = (Exception)exception.getCause();
            }
            throw new NetworkConfigSyncException(exception2.getMessage(), Level.SEVERE, CLASSNAME, "getDeploymentManagerAdminClient", (Throwable)exception2);
        }
    }

    static void suAddNotificationListenerExtended(final AdminService adminService, final ObjectName objectName, final NotificationListener notificationListener, final NotificationFilter notificationFilter, final Object object) throws NetworkConfigSyncException {
        try {
            ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    adminService.addNotificationListenerExtended(objectName, notificationListener, notificationFilter, object);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            Exception exception2;
            if (exception instanceof AuthPrivilegedException) {
                exception2 = (Exception)exception.getCause();
            }
            throw new NetworkConfigSyncException(exception2.getMessage(), Level.SEVERE, CLASSNAME, "suAddNotificationListenerExtended", (Throwable)exception2);
        }
    }

    static Set suQueryNames(final AdminService adminService, final ObjectName objectName, final QueryExp queryExp) throws NetworkConfigSyncException {
        try {
            return (Set)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return adminService.queryNames(objectName, queryExp);
                }
            });
        }
        catch (Exception exception) {
            Exception exception2;
            if (exception instanceof AuthPrivilegedException) {
                exception2 = (Exception)exception.getCause();
            }
            throw new NetworkConfigSyncException(exception2.getMessage(), Level.SEVERE, CLASSNAME, "suQueryNames", (Throwable)exception2);
        }
    }

    static Object suInvokeAdminService(final AdminService adminService, final ObjectName objectName, final String string, final Object[] objectArray, final String[] stringArray) throws NetworkConfigSyncException {
        try {
            return ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return adminService.invoke(objectName, string, objectArray, stringArray);
                }
            });
        }
        catch (Exception exception) {
            Exception exception2;
            if (exception instanceof AuthPrivilegedException) {
                exception2 = (Exception)exception.getCause();
            }
            throw new NetworkConfigSyncException(exception2.getMessage(), Level.SEVERE, CLASSNAME, "suInvokeAdminService", (Throwable)exception2);
        }
    }

    static Object runAsSuper(final PrivilegedExceptionAction privilegedExceptionAction) throws Exception {
        try {
            return ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return privilegedExceptionAction.run();
                }
            });
        }
        catch (Exception exception) {
            Exception exception2;
            if (exception instanceof AuthPrivilegedException) {
                exception2 = (Exception)exception.getCause();
            }
            throw exception2;
        }
    }
}

