/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.management.commands;

import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.management.AttrHelpers.GroupAttrHolder;
import com.ibm.ws.wim.management.AttrHelpers.PersonAccountAttrHolder;
import com.ibm.ws.wim.management.helpers.GenericHelper;
import com.ibm.ws.wim.management.helpers.entityHelpers.EntityHelper;
import com.ibm.ws.wim.management.helpers.entityHelpers.EntityHelperFactory;
import com.ibm.ws.wim.management.repositoryhelpers.UMAssistant;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeleteCommandProvider
extends SimpleCommandProvider {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = DeleteCommandProvider.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public String deleteUser(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "deleteUser(AbstractAdminCommand cmd)";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        if (!GenericHelper.isWASUserRegistry("PersonAccount")) {
            throw new WIMApplicationException("WAS_USER_REGISTRY_NOT_SUPPORTED", Level.SEVERE, CLASSNAME, string);
        }
        String string2 = (String)abstractAdminCommand.getParameter("uniqueName");
        if (GenericHelper.isReferenceToLoggedInUser(string2)) {
            throw new WIMApplicationException("CANNOT_DELETE_LOGGED_IN_USER", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, string);
        }
        PersonAccountAttrHolder personAccountAttrHolder = new PersonAccountAttrHolder(string2);
        EntityHelper entityHelper = EntityHelperFactory.create(personAccountAttrHolder.getAttrHolderType());
        entityHelper.verifyType(personAccountAttrHolder);
        new UMAssistant().delete(personAccountAttrHolder);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return string2;
    }

    public String deleteGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "deleteGroup(AbstractAdminCommand cmd)";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        if (!GenericHelper.isWASUserRegistry("Group")) {
            throw new WIMApplicationException("WAS_USER_REGISTRY_NOT_SUPPORTED", Level.SEVERE, CLASSNAME, string);
        }
        String string2 = (String)abstractAdminCommand.getParameter("uniqueName");
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string2);
        EntityHelper entityHelper = EntityHelperFactory.create(groupAttrHolder.getAttrHolderType());
        entityHelper.verifyType(groupAttrHolder);
        new UMAssistant().delete(groupAttrHolder);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return string2;
    }
}

